<?xml version="1.0" encoding="UTF-8"?>
<!-- GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
	xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" 	
	xmlns:gml="http://www.opengis.net/gml/3.2" 
	xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" 
	xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" 
	xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="p1" select="//adv:profilkennung"/>
		<xsl:variable name="p2" select="//adv:antragsnummer"/>
		<xsl:choose>
		<xsl:when test="//adv:art='0600'"><!-- Grundstücksnachweis hat zwei Einstiegsparameter. 20.12.2007 -->
		<xsl:variable name="p3" select="//wfs:Query[@typeName='AX_Buchungsblatt']/ogc:Filter/ogc:PropertyIsEqualTo/ogc:Literal"/><!-- 20.12.2007 Gezielte Belegung von $p3 ist durch mehrere ogc:Literal notwendig! -->
		<xsl:variable name="p4" select="//wfs:Query[@typeName='AX_Buchungsstelle']/ogc:Filter/ogc:PropertyIsEqualTo/ogc:Literal"/><!-- 20.12.2007 Gezielte Belegung von $p3 ist durch mehrere ogc:Literal notwendig! -->
		</xsl:when>
		<xsl:otherwise>
		<xsl:variable name="p3" select="//ogc:literal"/>
		</xsl:otherwise>
		</xsl:choose>
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
				<!-- Ggf. werden mehrere Flurstücke gefunden. Für den Ausgabekopf reicht die Auswertung von einem. -->
				<wfs:Query typeName="AX_Flurstueck">
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>istGebucht/AX_Buchungsstelle/istBestandteilVon/AX_Buchungsblatt/buchungsblattkennzeichen</ogc:PropertyName>
							<ogc:Literal><xsl:value-of select="$p3"/></ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</wfs:Query>
				<!-- Besorge ausserdem alle Gemarkungen und Katasterämter mit deren Anschrift. -->
				<wfs:Query typeName="AX_Gemarkung"/>
				<wfs:Query typeName="AX_Dienststelle">
					<XlinkPropertyPath>hat</XlinkPropertyPath>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>stellenart</ogc:PropertyName>
							<ogc:Literal>1100</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</wfs:Query>
		<xsl:choose>
		<xsl:when test="//adv:art='0600'"><!-- Grundstücksnachweis hat zwei Einstiegsparameter. 20.12.2007 -->
				<wfs:Query typeName="AX_Buchungsstelle"><!-- Ergänzt am 20.12.2007, weil ein Grundstücksnachweis nur bezogen auf eine Buchungsstelle eindeutig sein kann. -->
					<ogc:Filter>
						<ogc:And>
							<ogc:PropertyIsEqualTo>
							 <ogc:PropertyName>laufendeNummer</ogc:PropertyName>
							 <ogc:Literal>$p4</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
							 <ogc:PropertyName>istBestandteilVon/AX_Buchungsblatt/buchungsblattkennzeichen</ogc:PropertyName>
							 <ogc:Literal>$p3</ogc:Literal>
							</ogc:PropertyIsEqualTo>				
						</ogc:And>
					</ogc:Filter>
				</wfs:Query>
		</xsl:when>
		<xsl:otherwise>
		</xsl:otherwise>
		</xsl:choose>
						
			</anforderungsmerkmale>
			<profilkennung><xsl:value-of select="$p1"/></profilkennung>
			<antragsnummer><xsl:value-of select="$p2"/></antragsnummer>			
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
