<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0"
		xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc"
		xmlns:gml="http://www.opengis.net/gml/3.2">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_FortfuehrungsmitteilungAnEigentuemer xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
			<erfolgreich>true</erfolgreich>
			<antragsnummer>
				<xsl:value-of select="document('AX_Benutzungsauftrag.xml')//adv:antragsnummer"/>
			</antragsnummer>
			<allgemeineAngaben>
				<AX_K_Benutzungsergebnis>
					<folgeverarbeitung>
						<AX_FOLGEVA>
							<datenformat>1000</datenformat>
						</AX_FOLGEVA>
					</folgeverarbeitung>
					<xsl:apply-templates select="document('AX_Benutzungsauftrag.xml')//adv:empfaenger" mode="copy-it"/>
				</AX_K_Benutzungsergebnis>
			</allgemeineAngaben>
			<titel>
				<AX_K_FM_Titel>
					<!-- Ausgabekopf aus Fortführungsnachweis-Deckblatt übernehmen -->
					<ausgabekopf>
						<AX_K_AUSGKOPF_Standard>
							<xsl:copy-of select="//adv:AX_FortfuehrungsnachweisDeckblatt/adv:ausgabekopf/*"/>
						</AX_K_AUSGKOPF_Standard>
					</ausgabekopf>
					<inGemarkung>
						<xsl:copy-of select="//adv:AX_FortfuehrungsnachweisDeckblatt/adv:inGemarkung/adv:AX_Gemarkung_Schluessel"/><!-- Falls AX_K_FM_Titel.inGemarkung per Revision Datentyp CharacterString erhält, dann bitte hier den entschlüsselten Wert eintragen.-->
					</inGemarkung>
				</AX_K_FM_Titel>
			</titel>
			<!-- sortiert nach Fortführungsfallnummer -->
			<xsl:for-each select="//adv:AX_Fortfuehrungsfall">
				<xsl:sort select="adv:fortfuehrungsfallnummer"/>
				<fortfuehrungsfall>
					<AX_K_Fortfuehrungsfall_FM>
						<fortfuehrungsfallnummer>
							<xsl:value-of select="adv:fortfuehrungsfallnummer"/>
						</fortfuehrungsfallnummer>
						<laufendeNummer>
							<xsl:value-of select="adv:laufendeNummer"/>
						</laufendeNummer>
						<xsl:copy-of select="adv:ueberschriftImFortfuehrungsnachweis"/>
						<xsl:if test="count(adv:anmerkungFuerDenNotar)=1">
							<anmerkungFuerDenNotar>
								<xsl:value-of select="adv:anmerkungFuerDenNotar"/>
							</anmerkungFuerDenNotar>
						</xsl:if>
						<xsl:if test="count(adv:bemerkung)=1">
							<bemerkung>
								<xsl:value-of select="adv:bemerkung"/>
							</bemerkung>
						</xsl:if>
						<xsl:for-each select="adv:zeigtAufAltesFlurstueck">
							<flurstueck_alt>
								<xsl:call-template name="AX_K_FLURST_F">
									<xsl:with-param name="flurstueck" select="//adv:AX_Flurstueck[adv:flurstueckskennzeichen=.]"/>
								</xsl:call-template>
							</flurstueck_alt>
						</xsl:for-each>
						<xsl:for-each select="adv:zeigtAufNeuesFlurstueck">
							<flurstueck_neu>
								<xsl:call-template name="AX_K_FLURST_F">
									<xsl:with-param name="flurstueck" select="//adv:AX_Flurstueck[adv:flurstueckskennzeichen=.]"/>
								</xsl:call-template>
							</flurstueck_neu>
						</xsl:for-each>
						<!-- Buchungsangaben nur für alte Flurstücke -->
						<xsl:for-each select="adv:zeigtAufAltesFlurstueck">
							<xsl:variable name="flurstueck" select="//adv:AX_Flurstueck[adv:flurstueckskennzeichen=.]"/>
							<buchung>
								<xsl:variable name="stelle" select="//adv:AX_Buchungsstelle[@gml:id=substring-after($flurstueck/adv:istGebucht/@xlink:href,'urn:adv:oid:')]"/>
								<xsl:call-template name="AX_K_BUCHUNGSANGABEN">
								  	<xsl:with-param name="blatt" select="//adv:AX_Buchungsblatt[@gml:id=substring-after($stelle/adv:istBestandteilVon/@xlink:href,'urn:adv:oid:')]"/> 
								  	<xsl:with-param name="lfdNr" select="$stelle/adv:laufendeNummer"/> 
								  	<xsl:with-param name="bart"  select="$stelle/adv:buchungsart"/> 
								</xsl:call-template>
							</buchung>
						</xsl:for-each>
						<veraenderungsanalyse>
							<xsl:call-template name="AX_K_FANALYSE">
								<xsl:with-param name="fortfuehrungsfall" select="."/>
							</xsl:call-template>
						</veraenderungsanalyse>
					</AX_K_Fortfuehrungsfall_FM>
				</fortfuehrungsfall>
			</xsl:for-each>
		</AX_FortfuehrungsmitteilungAnEigentuemer>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
