/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.Codelists;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class CodelistDictionaries
implements Target {
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private boolean printed = false;
    private final HashMap<String, Document> documentMap = new HashMap();

    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r) throws ShapeChangeAbortException {
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
    }

    protected void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    protected Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(2);
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            this.result.addFatalError(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        return document;
    }

    public void process(ClassInfo ci) {
        Element e1;
        int cat = ci.category();
        if (cat == 3) {
            String s = this.options.parameter(this.getClass().getName(), "enumerations");
            if (s == null) {
                return;
            }
            if (!s.equals("true")) {
                return;
            }
        } else if (cat != 2) {
            return;
        }
        Document cDocument = this.createDocument();
        ProcessingInstruction proci = null;
        if (this.options.gmlVersion.equals("3.2")) {
            proci = cDocument.createProcessingInstruction("xml-stylesheet", "type='text/xsl' href='./CodelistDictionary-v32.xsl'");
        } else if (this.options.gmlVersion.equals("3.1")) {
            proci = cDocument.createProcessingInstruction("xml-stylesheet", "type='text/xsl' href='./CodelistDictionary-v31.xsl'");
        }
        if (proci != null) {
            cDocument.appendChild(proci);
        }
        Element ec = cDocument.createElementNS(this.options.GML_NS, "Dictionary");
        cDocument.appendChild(ec);
        this.addAttribute(cDocument, ec, "xmlns:gml", this.options.GML_NS);
        this.addAttribute(cDocument, ec, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.addAttribute(cDocument, ec, "xsi:schemaLocation", String.valueOf(this.options.GML_NS) + " " + this.options.schemaLocationOfNamespace(this.options.GML_NS));
        this.addAttribute(cDocument, ec, "gml:id", ci.name());
        this.documentMap.put(ci.id(), cDocument);
        String s = ci.documentation();
        if (s != null && s.trim().length() > 0) {
            e1 = cDocument.createElementNS(this.options.GML_NS, "description");
            e1.appendChild(cDocument.createTextNode(s));
            ec.appendChild(e1);
        }
        if (this.options.gmlVersion.equals("3.2")) {
            e1 = cDocument.createElementNS(this.options.GML_NS, "identifier");
            this.addAttribute(cDocument, e1, "codeSpace", ci.pkg().targetNamespace());
            e1.appendChild(cDocument.createTextNode(ci.name()));
            ec.appendChild(e1);
        } else if (this.options.gmlVersion.equals("3.1")) {
            e1 = cDocument.createElementNS(this.options.GML_NS, "name");
            e1.appendChild(cDocument.createTextNode(ci.name()));
            ec.appendChild(e1);
        }
        for (PropertyInfo propi : ci.properties().values()) {
            Element e12 = this.createEntry(cDocument, ci, propi, true);
            if (e12 == null) continue;
            ec.appendChild(e12);
        }
    }

    private Element createEntry(Document lDocument, ClassInfo ci, PropertyInfo propi, boolean local) {
        Element e2;
        Element e = lDocument.createElementNS(this.options.GML_NS, "dictionaryEntry");
        Element e3 = lDocument.createElementNS(this.options.GML_NS, "Definition");
        this.addAttribute(lDocument, e3, "gml:id", propi.id());
        e.appendChild(e3);
        String s = propi.documentation();
        if (s != null && s.trim().length() > 0) {
            e2 = lDocument.createElementNS(this.options.GML_NS, "description");
            e2.appendChild(lDocument.createTextNode(s));
            e3.appendChild(e2);
        }
        e2 = this.options.gmlVersion.equals("3.2") ? lDocument.createElementNS(this.options.GML_NS, "identifier") : lDocument.createElementNS(this.options.GML_NS, "name");
        String codeSpace = ci.taggedValue("infoURL");
        if (codeSpace == null) {
            codeSpace = String.valueOf(ci.pkg().targetNamespace()) + "/" + ci.name();
        }
        this.addAttribute(lDocument, e2, "codeSpace", codeSpace);
        if (propi.initialValue() != null) {
            e2.appendChild(lDocument.createTextNode(propi.initialValue()));
        } else {
            e2.appendChild(lDocument.createTextNode(propi.name()));
        }
        e3.appendChild(e2);
        e2 = lDocument.createElementNS(this.options.GML_NS, "name");
        e2.appendChild(lDocument.createTextNode(propi.name()));
        e3.appendChild(e2);
        return e;
    }

    public int type() {
        return 4;
    }

    public void write() {
        if (this.printed) {
            return;
        }
        try {
            Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
            outputFormat.setProperty("indent", "yes");
            outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            outputFormat.setProperty("encoding", "UTF-8");
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            for (ClassInfo ci : this.model.classes(this.pi)) {
                Document cDocument = this.documentMap.get(ci.id());
                if (cDocument == null) continue;
                String dir = this.options.parameter(this.getClass().getName(), "outputDirectory");
                if (dir == null) {
                    dir = this.options.parameter("outputDirectory");
                }
                if (dir == null) {
                    dir = this.options.parameter(".");
                }
                FileWriter outputXML = new FileWriter(String.valueOf(dir) + "/" + ci.name() + ".xml");
                serializer.setWriter((Writer)outputXML);
                serializer.asDOMSerializer().serialize((Node)cDocument);
                outputXML.close();
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        this.printed = true;
    }
}

