/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.Options;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ShapeChangeResult {
    protected Document document = null;
    protected Element root = null;
    protected Element messages = null;
    protected Element xsdfiles = null;
    protected Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
    protected Options options = null;

    public ShapeChangeResult(Options o) {
        this.options = o;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(true);
            dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.document = db.newDocument();
            this.root = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "ShapeChangeResult");
            this.document.appendChild(this.root);
            this.root.setAttribute("resultCode", "0");
            this.root.setAttribute("xmlns", "http://www.interactive-instruments.de/ShapeChange/Result");
            this.root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.root.setAttribute("xsi:schemaLocation", "http://www.interactive-instruments.de/ShapeChange/Result http://www.interactive-instruments.de/ShapeChange/Result/ShapeChangeResult.xsd");
            this.messages = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "Messages");
            this.root.appendChild(this.messages);
            this.xsdfiles = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "XSDFiles");
            this.root.appendChild(this.xsdfiles);
        }
        catch (ParserConfigurationException e) {
            System.err.println("Bootstrap Error: XML parser was unable to be configured.");
            String m = e.getMessage();
            if (m != null) {
                System.err.println(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Bootstrap Error: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        this.outputFormat.setProperty("encoding", "UTF-8");
        this.outputFormat.setProperty("indent", "yes");
        this.outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
    }

    private String safe(String s) {
        if (s == null) {
            return "<null>";
        }
        return s;
    }

    public void addDebug(int mnr, String p1, String p2, String p3) {
        this.addDebug(this.message(mnr).replace("$1$", p1).replace("$2$", p2).replace("$3$", this.safe(p3)));
    }

    public void addDebug(int mnr, String p1, String p2) {
        this.addDebug(this.message(mnr).replace("$1$", p1).replace("$2$", p2));
    }

    public void addDebug(int mnr, String p1) {
        this.addDebug(this.message(mnr).replace("$1$", p1));
    }

    public void addDebug(int mnr) {
        this.addDebug(this.message(mnr));
    }

    public void addDebug(String m) {
        if (this.document == null || !this.options.parameter("reportLevel").equals("DEBUG")) {
            return;
        }
        System.err.println("D " + m);
        Element message = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "Debug");
        this.messages.appendChild(message);
        message.appendChild(this.document.createTextNode(m));
    }

    public void addInfo(int mnr, String p1, String p2, String p3) {
        this.addInfo(this.message(mnr).replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public void addInfo(int mnr, String p1, String p2) {
        this.addInfo(this.message(mnr).replace("$1$", p1).replace("$2$", p2));
    }

    public void addInfo(int mnr, String p1) {
        this.addInfo(this.message(mnr).replace("$1$", p1));
    }

    public void addInfo(int mnr) {
        this.addInfo(this.message(mnr));
    }

    public void addInfo(String m) {
        String l = this.options.parameter("reportLevel");
        if (this.document == null || !l.equals("DEBUG") && !l.equals("INFO")) {
            return;
        }
        System.err.println("I " + m);
        Element message = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "Info");
        this.messages.appendChild(message);
        message.appendChild(this.document.createTextNode(m));
    }

    public void addWarning(int mnr, String p1, String p2, String p3) {
        this.addWarning(this.message(mnr).replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public void addWarning(int mnr, String p1, String p2) {
        this.addWarning(this.message(mnr).replace("$1$", p1).replace("$2$", p2));
    }

    public void addWarning(int mnr, String p1) {
        this.addWarning(this.message(mnr).replace("$1$", p1));
    }

    public void addWarning(int mnr) {
        this.addWarning(this.message(mnr));
    }

    public void addWarning(String m) {
        String l = this.options.parameter("reportLevel");
        if (this.document == null || !l.equals("DEBUG") && !l.equals("INFO") && !l.equals("WARNING")) {
            return;
        }
        System.err.println("W " + m);
        Element message = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "Warning");
        this.messages.appendChild(message);
        message.appendChild(this.document.createTextNode(m));
    }

    public void addError(int mnr, String p1, String p2, String p3) {
        this.addError(this.message(mnr).replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public void addError(int mnr, String p1, String p2) {
        this.addError(this.message(mnr).replace("$1$", p1).replace("$2$", p2));
    }

    public void addError(int mnr, String p1) {
        this.addError(this.message(mnr).replace("$1$", p1));
    }

    public void addError(int mnr) {
        this.addError(this.message(mnr));
    }

    public void addError(String m) {
        if (this.document == null) {
            return;
        }
        System.err.println("E " + m);
        Element message = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "Error");
        this.messages.appendChild(message);
        message.appendChild(this.document.createTextNode(m));
    }

    public void addFatalError(int mnr, String p1, String p2, String p3) {
        this.addFatalError(this.message(mnr).replace("$1$", p1).replace("$2$", p2).replace("$3$", p3));
    }

    public void addFatalError(int mnr, String p1, String p2) {
        this.addFatalError(this.message(mnr).replace("$1$", p1).replace("$2$", p2));
    }

    public void addFatalError(int mnr, String p1) {
        this.addFatalError(this.message(mnr).replace("$1$", p1));
    }

    public void addFatalError(int mnr) {
        this.addFatalError(this.message(mnr));
        this.setResultCode(1);
    }

    public void addFatalError(String m) {
        if (this.document == null) {
            return;
        }
        System.err.println("F " + m);
        Element message = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "FatalError");
        this.messages.appendChild(message);
        message.appendChild(this.document.createTextNode(m));
    }

    public void addXSDFile(String dname, String fname, String ns) {
        if (this.document == null) {
            return;
        }
        Element xsdfile = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Result", "XSDFile");
        this.xsdfiles.appendChild(xsdfile);
        xsdfile.setAttribute("href", String.valueOf(dname) + "/" + fname);
        xsdfile.setAttribute("targetNamespace", ns);
        xsdfile.appendChild(this.document.createTextNode(fname));
    }

    public void setResultCode(int rc) {
        if (this.document == null) {
            return;
        }
        this.root.setAttribute("resultCode", Integer.toString(rc, 10));
    }

    public void toFile(String filename) {
        if (this.document == null) {
            return;
        }
        try {
            FileWriter outputXML = new FileWriter(filename);
            Serializer serializer = SerializerFactory.getSerializer((Properties)this.outputFormat);
            serializer.setWriter((Writer)outputXML);
            serializer.asDOMSerializer().serialize((Node)this.document);
            outputXML.close();
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public void toWriter(PrintWriter writer) {
        if (this.document == null) {
            return;
        }
        try {
            Serializer serializer = SerializerFactory.getSerializer((Properties)this.outputFormat);
            serializer.setWriter((Writer)writer);
            serializer.asDOMSerializer().serialize((Node)this.document);
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public void toOut() {
        if (this.document == null) {
            return;
        }
        try {
            Serializer serializer = SerializerFactory.getSerializer((Properties)this.outputFormat);
            serializer.setOutputStream((OutputStream)System.out);
            serializer.asDOMSerializer().serialize((Node)this.document);
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public Document asDOM() {
        return this.document;
    }

    protected String message(int mnr) {
        switch (mnr) {
            case 1: {
                return "Unable to get a document builder factory.";
            }
            case 2: {
                return "XML Parser was unable to be configured.";
            }
            case 3: {
                return "Invalid XMI file.";
            }
            case 4: {
                return "XMI version must be 1.0, found: $1$.";
            }
            case 5: {
                return "Exactly only element <XMI> expected.";
            }
            case 6: {
                return "Metamodel must be UML, found: $1$.";
            }
            case 7: {
                return "The UML version must be 1.3, found: $1$.";
            }
            case 8: {
                return "Exactly one element <XMI.metamodel> expected.";
            }
            case 9: {
                return "Class $1$ is not associated with a package.";
            }
            case 10: {
                return "Class $1$ in package $2$ is not associated with an XSD document.";
            }
            case 11: {
                return "Stereotype of class $1$ is not an allowed value: $2$";
            }
            case 12: {
                return "No application schema found.";
            }
            case 13: {
                return "Application schema $1$ not found.";
            }
            case 14: {
                return "No model has been loaded to convert.";
            }
            case 15: {
                return "Package $1$ not associated with any XML Schema document.";
            }
            case 16: {
                return "The XMI file is not associated with a DTD. The DTD is required for validating and processing the XMI file.";
            }
            case 30: {
                return "Enterprise Architect repository named '$2$' cannot be opened. EA message is: '$1$'";
            }
            case 31: {
                return "Enterprise Architect repository file named '$1$' not found";
            }
            case 100: {
                return "The $1$ with ID $2$ has no name. The ID is used instead.";
            }
            case 101: {
                return "Application schema $1$ with ID $2$ is not associated with an XML Schema document. A default name is used: $3$.";
            }
            case 102: {
                return "";
            }
            case 103: {
                return "The association with name '$1$' and ID '$2$' does not have 2 connections: $3$ connections. All Roles will be ignored.";
            }
            case 104: {
                return "The supertypes of class $1$ are of different categories or the stereotype of the class cannot be determined. This is not supported, the class is ignored.";
            }
            case 105: {
                return "The restriction of UML attribute $1$ in class $2$ is not legal. The lower multiplicity limit is smaller than in the supertype $3$.";
            }
            case 106: {
                return "The restriction of UML attribute $1$ in class $2$ is not legal. The upper multiplicity limit is higher than in the supertype $3$.";
            }
            case 107: {
                return "The property $1$ in class $2$ has a sequence number that is already in use for another property ($3$) which will be overwritten.";
            }
            case 108: {
                return "The class $1$ is modelled as a feature or data type, but has at least one supertype of a different category. The supertype is ignored.";
            }
            case 109: {
                return "The class $1$ is modelled as a feature or data type, but has more than one supertype of the same kind. All but one (arbitrary) supertypes are ignored.";
            }
            case 110: {
                return "Definitions could not be created for schema $1$ as a GML dictionary. This is supported only for GML version 3.2.";
            }
            case 111: {
                return "Missing argument to $1$ option.";
            }
            case 112: {
                return "Error in OCL constraint in class '$1$': target type '$2$' not found. At least parts of the OCL constraint cannot be processed: $3$.";
            }
            case 113: {
                return "Error in OCL constraint in class '$1$': property '$2$' not found. At least parts of the OCL constraint cannot be processed: $3$.";
            }
            case 114: {
                return "OCL constraint in class '$1$' is currently not supported: $2$";
            }
            case 115: {
                return "The class $1$ is modelled as an interface, but has supertypes that are instantiable. The supertype relationships are ignored.";
            }
            case 116: {
                return "Target object element(s) missing in property type for property '$1$'.";
            }
            case 117: {
                return "No XML Schema type for type $1$ is defined. Only object and data types are supported.";
            }
            case 118: {
                return "The type $1$ is neither part of the UML application schema nor does a mapping to a predefined type exist.";
            }
            case 119: {
                return "No element for type $1$ is defined. Only object and data types are represented by elements.";
            }
            case 120: {
                return "The type $1$ is neither part of the UML application schema nor does a mapping to a predefined type exist.";
            }
            case 121: {
                return "Base type $1$ could not be mapped. Missing base type in complex type $2$.";
            }
            case 122: {
                return "The type with the name $1$ has no tagged value 'base' or valid supertype and cannot be mapped to a basic type.";
            }
            case 123: {
                return "The type with the name $1$ has no ID and cannot be mapped to a basic type.";
            }
            case 124: {
                return "Failed to create basic type '$1$'.";
            }
            case 125: {
                return "The class $1$ is an enumeration. Generalization relationships are not supported for these classes. All such relationships are ignored.";
            }
            case 126: {
                return "Failed to create enumeration type '$1$'.";
            }
            case 127: {
                return "The class $1$ is a codelist. Generalization relationships are not supported for these classes. All such relationships are ignored.";
            }
            case 128: {
                return "The property '$1$' cannot be assigned a type as it is mapped to an XML attribute, but the type has complex content.";
            }
            case 129: {
                return "Union '$1$' as the value type of '$2$' could not be mapped as it does not contain the expected number of exactly one property to be encoded in the application schema.";
            }
            case 130: {
                return "No type can be provided for the property '$1$'.";
            }
            case 131: {
                return "The type of property '$1$' was not found.";
            }
            case 132: {
                return "The class $1$ is not part of any package nor is it mapped to a well-known XML Schema type. The class is ignored.";
            }
            case 133: {
                return "One or more errors encountered in OCL constraint in class $1$ : $2$ ...";
            }
            case 134: {
                return "Line/column(s) $1$: $2$";
            }
            case 135: {
                return "The type of property '$1$' was not found by id, only by name (fixed broken type definition).";
            }
            case 136: {
                return "The enumeration element with ID $1$ in class $2$ contains an empty string as value.";
            }
            case 1000: {
                return "Testing UML version 1.4.";
            }
            case 1001: {
                return "Class $1$ with ID $2$ cannot be identified as being part of any package. The package is probably ignored, for example, because it carries an unsupported stereotype. The ID of the missing package is: $3$";
            }
            case 1002: {
                return "Restriction of property $1$ in class $2$ from supertype $3$.";
            }
            case 1003: {
                return "The multiplicity value of '$1$' is neither a number nor a known string. '*' is used instead.";
            }
            case 1004: {
                return "Class $1$ skipped because it has an unknown category.";
            }
            case 1005: {
                return "Stereotype <<$1$>> not supported for UML model elements of type $2$.";
            }
            case 1006: {
                return "The $1$ '$2$' will be ignored.";
            }
            case 1007: {
                return "The discriminator for the UML generalization with ID $1$ is not blank. This genralization is ignored.";
            }
            case 1008: {
                return "Property $1$ with type of ID $2$ has hidden labels: $3$";
            }
            case 1009: {
                return "The property '$1$' is tagged as a metadata property. This is only possible for properties with complex content.";
            }
            case 1010: {
                return "Support for nilReason attributes was requested in property '$1$'. This is not possible for properties which have a local $2$ as their value.";
            }
            case 10000: {
                return "Added tagged value '$1$' for element with ID '$2$' with value: $3$.";
            }
            case 10001: {
                return "The package with ID $1$ and name '$2$' was created. Namespace: $3$.";
            }
            case 10002: {
                return "The association end with name '$1$' is the reverse property to '$2$'.";
            }
            case 10003: {
                return "Checked class $1$, category $2$, result $3$";
            }
            case 10004: {
                return "Checking overloading. Class = $1$; current class = $2$.";
            }
            case 10005: {
                return "Generating GML dictionaries with definitions for application schema $1$.";
            }
            case 10006: {
                return "Processing OCL constraint in class '$1$': $2$.";
            }
            case 10007: {
                return "Constraint is of type '$1$'.";
            }
            case 10008: {
                return "Target type: $1$.";
            }
            case 10009: {
                return "Property: $1$.";
            }
            case 10010: {
                return "Value condition: $1$ $2$ $3$";
            }
            case 10011: {
                return "The operation with ID $1$ and name '$2$' has the following parameter: $3$";
            }
            case 10012: {
                return "Generating XML Schema for application schema $1$.";
            }
            case 10013: {
                return "The $1$ with ID $2$ and name '$3$' was created.";
            }
            case 10014: {
                return "Processing class $1$.";
            }
            case 10015: {
                return "Class $1$ is a service.";
            }
            case 10016: {
                return "Processing class '$1$', rule '$2$'.";
            }
            case 10017: {
                return "Creating XSD document '$1$' for package $2$.";
            }
            case 10018: {
                return "Rose Bug Fix for Duplicate Global Data Types: DataType '$1$' replaced by '$2$'.";
            }
            case 10019: {
                return "Added stereotype '$1$' for element with ID '$2$'.";
            }
            case 10020: {
                return "Application schema found, package name: $1$";
            }
            case 10021: {
                return "Import to namespace '$1$' added.";
            }
            case 10022: {
                return "Found: $1$ - $2$";
            }
            case 10023: {
                return "Processing local properties of class $1$.";
            }
            case 10024: {
                return "OCL syntax tree: $1$";
            }
            case 10025: {
                return "OCL comment: $1$";
            }
        }
        return "(Unknown message)";
    }
}

