/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Ocl;

public class SourceReference {
    short lineNo;
    short colFrom;
    short colTo;
    short tokFrom;
    short tokTo;

    SourceReference(short lineNo, short colFrom, short colTo, short tokFrom, short tokTo) {
        this.lineNo = lineNo;
        this.colFrom = colFrom;
        this.colTo = colTo;
        this.tokFrom = tokFrom;
        this.tokTo = tokTo;
    }

    SourceReference(SourceReference sourceref) {
        this.lineNo = sourceref.lineNo;
        this.colFrom = sourceref.colFrom;
        this.colTo = sourceref.colTo;
        this.tokFrom = sourceref.tokFrom;
        this.tokTo = sourceref.tokTo;
    }

    public short getLineNumber() {
        return this.lineNo;
    }

    public short getColumnFrom() {
        return this.colFrom;
    }

    public short getColumnTo() {
        return this.colTo;
    }

    public short getTokenFrom() {
        return this.tokFrom;
    }

    public short getTokenTo() {
        return this.tokTo;
    }

    boolean canBeMerged(SourceReference toBeMerged, boolean byToken) {
        short pos = this.relativePosition(toBeMerged, byToken);
        return Math.abs(pos) <= 1;
    }

    short relativePosition(SourceReference toBeCompared, boolean byToken) {
        if (this.lineNo < toBeCompared.lineNo) {
            return 2;
        }
        if (this.lineNo > toBeCompared.lineNo) {
            return -2;
        }
        short[] lb = new short[2];
        short[] ub = new short[2];
        if (byToken) {
            lb[0] = this.tokFrom;
            lb[1] = toBeCompared.tokFrom;
            ub[0] = this.tokTo;
            ub[1] = toBeCompared.tokTo;
        } else {
            lb[0] = this.colFrom;
            lb[1] = toBeCompared.colFrom;
            ub[0] = this.colTo;
            ub[1] = toBeCompared.colTo;
        }
        int idx_small_lb = lb[0] < lb[1] ? 0 : 1;
        int dist = lb[1 - idx_small_lb] - ub[idx_small_lb];
        if (dist > 1) {
            return (short)(idx_small_lb == 0 ? 2 : -2);
        }
        if (dist == 1) {
            return (short)(idx_small_lb == 0 ? 1 : -1);
        }
        return 0;
    }

    void merge(SourceReference toBeMerged) {
        if (toBeMerged.colFrom < this.colFrom) {
            this.colFrom = toBeMerged.colFrom;
        }
        if (toBeMerged.colTo > this.colTo) {
            this.colTo = toBeMerged.colTo;
        }
        if (toBeMerged.tokFrom < this.tokFrom) {
            this.tokFrom = toBeMerged.tokFrom;
        }
        if (toBeMerged.tokTo > this.tokTo) {
            this.tokTo = toBeMerged.tokTo;
        }
    }

    SourceReference[] merge(SourceReference[] srl, boolean byToken) {
        int insert_before = srl.length;
        int merge_lo = -1;
        int merge_hi = -1;
        SourceReference[] res = srl;
        int i = 0;
        while (i < srl.length) {
            short relpos = this.relativePosition(srl[i], byToken);
            if (relpos >= -1) {
                if (relpos > 1) {
                    insert_before = i;
                    break;
                }
                if (merge_lo == -1) {
                    merge_lo = i;
                }
                merge_hi = i;
            }
            ++i;
        }
        if (merge_lo == -1) {
            res = new SourceReference[srl.length + 1];
            i = 0;
            int j = 0;
            while (i < srl.length) {
                if (i == insert_before) {
                    // empty if block
                }
                int n = ++j;
                ++j;
                res[n] = srl[i];
                ++i;
            }
            res[insert_before] = new SourceReference(this);
        } else if (merge_hi == merge_lo) {
            res[merge_lo].merge(this);
        } else {
            int n = merge_hi - merge_lo + 1;
            res = new SourceReference[srl.length - n + 1];
            SourceReference tomerge = new SourceReference(this);
            int i2 = 0;
            int j = 0;
            while (i2 < srl.length) {
                if (merge_lo <= i2 && i2 <= merge_hi) {
                    tomerge.merge(srl[i2]);
                    if (i2 == merge_hi) {
                        res[j++] = tomerge;
                    }
                } else {
                    res[j++] = srl[i2];
                }
                ++i2;
            }
        }
        return res;
    }

    static SourceReference[] merge(SourceReference[] srl1, SourceReference[] srl2, boolean byToken) {
        int i = 0;
        while (i < srl2.length) {
            srl1 = srl2[i].merge(srl1, byToken);
            ++i;
        }
        return srl1;
    }
}

