/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.Converter;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.Xmi10.Xmi10Document;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.UI.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.JFrame;

public class Main {
    public static void main(String[] argv) {
        Options options = new Options();
        ShapeChangeResult result = new ShapeChangeResult(options);
        Converter converter = new Converter(options, result);
        boolean dialog = false;
        String arg = null;
        int i = 0;
        while (i < argv.length) {
            arg = argv[i];
            if (arg.startsWith("-")) {
                String option = arg.substring(1);
                if (option.equals("h")) {
                    Main.printUsage();
                    System.exit(1);
                }
                if (option.equals("c")) {
                    if (++i == argv.length) {
                        result.addError(111, "-c");
                    } else {
                        options.configFile = argv[i];
                    }
                } else if (option.equals("x")) {
                    String x1 = null;
                    String x2 = null;
                    if (++i == argv.length) {
                        result.addError(111, "-x");
                    } else {
                        x1 = argv[i];
                        if (++i == argv.length) {
                            result.addError(111, "-x");
                        } else {
                            x2 = argv[i];
                        }
                    }
                    if (x2 != null) {
                        options.setReplaceValue(x1, x2);
                    }
                } else if (option.equals("d")) {
                    dialog = true;
                }
            }
            ++i;
        }
        if (dialog || argv.length == 0) {
            Main.createAndShowGUI(converter, options, result, arg);
        } else {
            Model m = null;
            try {
                options.loadConfiguration();
                String imt = options.parameter("inputModelType");
                String mdl = options.parameter("inputFile");
                if (imt.equals("EA7")) {
                    m = new EADocument(result, options, mdl);
                } else if (imt.equals("XMI10")) {
                    m = new Xmi10Document(result, options, mdl);
                } else {
                    result.addFatalError("Unknown input model type: " + imt);
                    throw new ShapeChangeAbortException();
                }
                converter.convert(m);
            }
            catch (ShapeChangeAbortException e) {
                System.exit(1);
            }
            if (m != null) {
                m.shutdown();
            }
        }
    }

    private static void createAndShowGUI(Converter c, Options o, ShapeChangeResult r, String xmi) {
        JFrame frame = new JFrame("ShapeChange");
        frame.setDefaultCloseOperation(3);
        Dialog newContentPane = new Dialog(c, o, r, xmi);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        int height = 400;
        int width = 600;
        frame.pack();
        Insets fI = frame.getInsets();
        frame.setSize(width + fI.right + fI.left, height + fI.top + fI.bottom);
        Dimension sD = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((sD.width - width) / 2, (sD.height - height) / 2);
        frame.setVisible(true);
    }

    protected static void printUsage() {
        System.err.println("ShapeChange command line interface");
        System.err.println("Version v1.1b1");
        System.err.println();
        System.err.println("ShapeChange takes a ISO 19109 Application Schema in UML");
        System.err.println("and translates it into a GML Application Schema.");
        System.err.println();
        System.err.println("usage: java -jar ShapeChange.jar (options) xmifile");
        System.err.println();
        System.err.println("options:");
        System.err.println(" -c cfgfile The location of the main configuration");
        System.err.println("            file. XInclude is supported and can be used");
        System.err.println("            to modularise the confguration. The default");
        System.err.println("            is ShapeChangeConfiguration.xml in the");
        System.err.println("            working directory.");
        System.err.println(" -x val rep If a configuration file contains a parameter");
        System.err.println("            with a value of 'val' then the value will be");
        System.err.println("            replaced by 'rep'. This option may occur multiple");
        System.err.println("            times.");
        System.err.println("            Example: -R '$dir$' './result/xsd' would replace.");
        System.err.println("            any parameter values '$dir$' in the configuration.");
        System.err.println("            file with './result/xsd'.");
        System.err.println(" -d         Invokes the user interface.");
        System.err.println(" -h         This help screen.");
        System.err.println();
    }
}

