/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Ocl;

import de.interactive_instruments.ShapeChange.Ocl.Lexer;
import de.interactive_instruments.ShapeChange.Ocl.MessageCollection;
import de.interactive_instruments.ShapeChange.Ocl.SourceReference;
import de.interactive_instruments.ShapeChange.Ocl.TempNode;
import de.interactive_instruments.ShapeChange.Ocl.Token;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TempParser {
    private Lexer inLex;
    private MessageCollection messages;
    private ArrayList<String> comments = new ArrayList(1);
    static InfixType mulType = new InfixType(null, EnumSet.of(Token.Type.ASTERISK, Token.Type.SLASH));
    static InfixType addType = new InfixType(mulType, EnumSet.of(Token.Type.PLUS, Token.Type.MINUS));
    static InfixType cmpType = new InfixType(addType, EnumSet.of(Token.Type.LESS, Token.Type.LESS_EQUAL, Token.Type.GREATER, Token.Type.GREATER_EQUAL));
    static InfixType idtType = new InfixType(cmpType, EnumSet.of(Token.Type.EQUAL, Token.Type.NOT_EQUAL));
    static InfixType logType = new InfixType(idtType, EnumSet.of(Token.Type.AND, Token.Type.OR, Token.Type.XOR));
    static InfixType impType = new InfixType(logType, EnumSet.of(Token.Type.IMPLIES));
    static InfixType refType = new InfixType(null, EnumSet.of(Token.Type.DOT, Token.Type.ARROW));
    static HashMap<Token.Type, Integer> pairedBrackets = new HashMap();

    static {
        pairedBrackets.put(Token.Type.O_BRACKET, 1);
        pairedBrackets.put(Token.Type.C_BRACKET, -1);
        pairedBrackets.put(Token.Type.O_SQ_BRACKET, 2);
        pairedBrackets.put(Token.Type.C_SQ_BRACKET, -2);
        pairedBrackets.put(Token.Type.O_CU_BRACKET, 3);
        pairedBrackets.put(Token.Type.C_CU_BRACKET, -3);
    }

    public TempParser(Readable inStream, MessageCollection messages) {
        this.inLex = new Lexer(inStream);
        this.messages = messages;
    }

    public int getNumberOfComments() {
        return this.comments.size();
    }

    public String[] getComments() {
        String[] ret = new String[this.comments.size()];
        return this.comments.toArray(ret);
    }

    public MessageCollection getMessageCollection() {
        return this.messages;
    }

    public TempNode.Expression parseExpression() {
        Token condtoken = this.getNextLegalToken();
        Token.Type cond = condtoken.getType();
        if (cond != Token.Type.INV && cond != Token.Type.PRE && cond != Token.Type.POST && cond != Token.Type.INIT && cond != Token.Type.DERIVE && cond != Token.Type.BODY) {
            MessageCollection messageCollection = this.messages;
            messageCollection.getClass();
            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(15);
            mess.substitute(1, condtoken.getDenotation());
            mess.addSourceReference(condtoken.getSourceReference());
        }
        Token token = this.getNextLegalToken();
        Token.Type type = token.getType();
        String name = null;
        if (type == Token.Type.IDENTIFIER) {
            name = ((Token.Identifier)token).getName();
        } else {
            this.inLex.unfetchToken(token);
        }
        token = this.getNextLegalToken();
        type = token.getType();
        if (type != Token.Type.COLON) {
            MessageCollection messageCollection = this.messages;
            messageCollection.getClass();
            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(16);
            mess.substitute(1, token.getDenotation());
            mess.addSourceReference(token.getSourceReference());
            this.inLex.unfetchToken(token);
        }
        TempNode expr = this.parsePureExpression();
        return new TempNode.Expression(cond, name, expr);
    }

    public TempNode parsePureExpression() {
        TempNode tempNode = this.parseInfix(impType);
        Token token = this.getNextLegalToken();
        if (token.getType() != Token.Type.END_OF_TEXT) {
            MessageCollection messageCollection = this.messages;
            messageCollection.getClass();
            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(14);
            mess.substitute(1, token.getDenotation());
            mess.addSourceReference(token.getSourceReference());
        }
        return tempNode;
    }

    TempNode parseInfix(InfixType itype) {
        InfixType itype1 = itype.nextStronger();
        TempNode operand1 = null;
        TempNode operand2 = null;
        Token operator = null;
        do {
            operand2 = itype1 != null ? this.parseInfix(itype1) : (itype == mulType ? this.parsePrefix() : this.parsePrimary());
            if (operator == null) {
                operand1 = operand2;
                continue;
            }
            operand1 = new TempNode.Infix(operator.getType(), operand1, operand2);
            operand1.addSourceReference(operator);
        } while (itype.includesOperator(operator = this.getNextLegalToken()));
        this.inLex.unfetchToken(operator);
        return operand1;
    }

    TempNode parsePrefix() {
        TempNode result = null;
        Token token = this.getNextLegalToken();
        Token.Type type = token.getType();
        if (type == Token.Type.MINUS || type == Token.Type.NOT) {
            TempNode rest = this.parsePrefix();
            result = new TempNode.Prefix(type, rest);
            result.addSourceReference(token);
            if (rest instanceof TempNode.Literal) {
                TempNode.Literal literal = (TempNode.Literal)rest;
                Object value = literal.getValue();
                TempNode.Literal<Constable> result2 = null;
                if (type == Token.Type.MINUS) {
                    if (value instanceof Long) {
                        result2 = new TempNode.Literal<Long>(-((Long)value).longValue());
                    } else if (value instanceof Double) {
                        result2 = new TempNode.Literal<Double>(-((Double)value).doubleValue());
                    }
                } else if (type == Token.Type.NOT && value instanceof Boolean) {
                    result2 = new TempNode.Literal<Boolean>((Boolean)value == false);
                }
                if (result2 != null) {
                    result2.addSourceReference(result);
                    result = result2;
                }
            }
        } else {
            this.inLex.unfetchToken(token);
            result = this.parseInfix(refType);
        }
        return result;
    }

    TempNode parsePrimary() {
        TempNode expression = null;
        Token token = this.getNextLegalToken();
        switch (token.getType()) {
            case IF: {
                this.inLex.unfetchToken(token);
                return this.parseIf();
            }
            case LET: {
                this.inLex.unfetchToken(token);
                return this.parseLet();
            }
            case O_BRACKET: {
                expression = this.parseInfix(impType);
                expression.addSourceReference(token);
                token = this.getNextLegalToken();
                if (token.getType() != Token.Type.C_BRACKET) {
                    MessageCollection messageCollection = this.messages;
                    messageCollection.getClass();
                    MessageCollection.Message mess = messageCollection.new MessageCollection.Message(2);
                    mess.substitute(1, token.getDenotation());
                    mess.addSourceReference(token.getSourceReference());
                    this.inLex.unfetchToken(token);
                } else {
                    expression.addSourceReference(token);
                }
                return expression;
            }
            case TEXT: 
            case NUMBER: {
                this.inLex.unfetchToken(token);
                return this.parseSimpleLiteral();
            }
            case IDENTIFIER: {
                Token.Identifier idtok = (Token.Identifier)token;
                String name = "$" + idtok.getName() + "$";
                this.inLex.unfetchToken(token);
                if ("$true$false$".indexOf(name) >= 0) {
                    return this.parseSimpleLiteral();
                }
                if ("$Set$Bag$Sequence$Collection$OrderedSet$Tuple$".indexOf(name) >= 0) {
                    return this.parseComplexLiteral();
                }
                if ("$Date$".indexOf(name) >= 0) {
                    return this.parseDateLiteral();
                }
                expression = this.parsePathName();
                token = this.getNextLegalToken();
                Token.Type type = token.getType();
                this.inLex.unfetchToken(token);
                TempNode argumentlist = null;
                if (type == Token.Type.O_BRACKET) {
                    argumentlist = this.parseArgumentList();
                }
                expression = new TempNode.Property(expression, argumentlist);
                return expression;
            }
        }
        MessageCollection messageCollection = this.messages;
        messageCollection.getClass();
        MessageCollection.Message mess = messageCollection.new MessageCollection.Message(3);
        mess.substitute(1, token.getDenotation());
        mess.addSourceReference(token.getSourceReference());
        expression = new TempNode.Invalid();
        expression.addSourceReference(token);
        return expression;
    }

    TempNode parseSimpleLiteral() {
        TempNode.Literal<Object> expression = null;
        Token token = this.getNextLegalToken();
        switch (token.getType()) {
            case TEXT: {
                expression = new TempNode.Literal<String>(((Token.Text)token).getValue());
                break;
            }
            case NUMBER: {
                Token.Number numtok = (Token.Number)token;
                if (numtok.isInteger()) {
                    expression = new TempNode.Literal<Long>((long)numtok.getValue());
                    break;
                }
                expression = new TempNode.Literal<Double>(numtok.getValue());
                break;
            }
            case IDENTIFIER: {
                Token.Identifier idtok = (Token.Identifier)token;
                String id = idtok.getName();
                Boolean t = id.equals("true");
                Boolean f = id.equals("false");
                if (t.booleanValue() || f.booleanValue()) {
                    expression = new TempNode.Literal<Boolean>(t);
                    break;
                }
            }
            default: {
                MessageCollection messageCollection = this.messages;
                messageCollection.getClass();
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
                mess.substitute(1, "SimpleLiteral failure at " + token.getDenotation());
                mess.addSourceReference(token.getSourceReference());
            }
        }
        if (expression != null) {
            expression.addSourceReference(token);
        }
        return expression;
    }

    TempNode parseComplexLiteral() {
        TempNode.Invalid result = null;
        MessageCollection.Message mess = null;
        Token token1 = this.inLex.fetchToken();
        Token.Type type = token1.getType();
        SourceReference sourceRef = token1.getSourceReference();
        String name = null;
        if (type == Token.Type.IDENTIFIER) {
            name = ((Token.Identifier)token1).getName();
            MessageCollection messageCollection = this.messages;
            messageCollection.getClass();
            mess = messageCollection.new MessageCollection.Message(8);
            mess.substitute(1, name);
            mess.addSourceReference(sourceRef);
            result = new TempNode.Invalid();
            result.addSourceReference(token1);
            this.skipPairedBrackets(Token.Type.O_CU_BRACKET);
            return result;
        }
        MessageCollection messageCollection = this.messages;
        messageCollection.getClass();
        mess = messageCollection.new MessageCollection.Message(0);
        mess.substitute(1, "Complex Literal starting with " + token1.getDenotation());
        mess.addSourceReference(sourceRef);
        result = new TempNode.Invalid();
        result.addSourceReference(token1);
        return result;
    }

    TempNode parseDateLiteral() {
        TempNode result = null;
        MessageCollection.Message mess = null;
        Token token1 = this.inLex.fetchToken();
        Token.Type type = token1.getType();
        SourceReference sourceRef = token1.getSourceReference();
        String name = null;
        if (type == Token.Type.IDENTIFIER) {
            name = ((Token.Identifier)token1).getName();
            if (!name.equals("Date")) {
                MessageCollection messageCollection = this.messages;
                messageCollection.getClass();
                mess = messageCollection.new MessageCollection.Message(8);
                mess.substitute(1, name);
                mess.addSourceReference(sourceRef);
                result = new TempNode.Invalid();
                result.addSourceReference(token1);
                this.skipPairedBrackets(Token.Type.O_CU_BRACKET);
                return result;
            }
        } else {
            MessageCollection messageCollection = this.messages;
            messageCollection.getClass();
            mess = messageCollection.new MessageCollection.Message(0);
            mess.substitute(1, "Complex Literal starting with " + token1.getDenotation());
            mess.addSourceReference(sourceRef);
            result = new TempNode.Invalid();
            result.addSourceReference(token1);
            return result;
        }
        Token token2 = this.getNextLegalToken();
        if (token2.getType() != Token.Type.O_BRACKET) {
            MessageCollection messageCollection = this.messages;
            messageCollection.getClass();
            mess = messageCollection.new MessageCollection.Message(9);
            mess.substitute(1, name);
            mess.addSourceReference(token2.getSourceReference());
            result = new TempNode.Invalid();
            result.addSourceReference(token1);
            this.inLex.unfetchToken(token2);
            return result;
        }
        Token token3 = this.getNextLegalToken();
        if (token3.getType() == Token.Type.C_BRACKET) {
            result = new TempNode.Literal<TempNode.CurrentDateTime>(new TempNode.CurrentDateTime());
            result.addSourceReference(token1);
            result.addSourceReference(token2);
            result.addSourceReference(token3);
        } else {
            String isodatetime;
            this.inLex.unfetchToken(token3);
            TempNode expr = this.parseInfix(impType);
            token3 = this.getNextLegalToken();
            if (token3.getType() != Token.Type.C_BRACKET) {
                MessageCollection messageCollection = this.messages;
                messageCollection.getClass();
                mess = messageCollection.new MessageCollection.Message(10);
                sourceRef = token3.getSourceReference();
                mess.substitute(1, token3.getDenotation());
                mess.addSourceReference(sourceRef);
                result = new TempNode.Invalid();
                result.addSourceReference(token1);
                result.addSourceReference(token2);
                result.addSourceReference(expr);
                this.inLex.unfetchToken(token3);
                return result;
            }
            if (!(expr instanceof TempNode.Literal) || !(((TempNode.Literal)expr).getValue() instanceof String)) {
                MessageCollection messageCollection = this.messages;
                messageCollection.getClass();
                mess = messageCollection.new MessageCollection.Message(11);
                SourceReference[] sourceRefs = expr.getSourceReferences();
                int i = 0;
                while (i < sourceRefs.length) {
                    mess.addSourceReference(sourceRefs[i]);
                    ++i;
                }
                result = new TempNode.Invalid();
                result.addSourceReference(token1);
                result.addSourceReference(token2);
                result.addSourceReference(expr);
                result.addSourceReference(token3);
                return result;
            }
            String regex = "^(\\d{4})(?:-(\\d{2})(?:-(\\d{2})(?:T(\\d{2})(?::(\\d{2})(?::(\\d{2})(?:\\.(\\d+))?)?)?(?:(?:(Z)|(\\+|-)(\\d{2}):(\\d{2})))?)?)?)?$";
            Pattern iso8601 = Pattern.compile(regex);
            Matcher matcher = iso8601.matcher(isodatetime = (String)((TempNode.Literal)expr).getValue());
            boolean matches = matcher.matches();
            if (!matches) {
                MessageCollection messageCollection = this.messages;
                messageCollection.getClass();
                mess = messageCollection.new MessageCollection.Message(11);
                SourceReference[] sourceRefs = expr.getSourceReferences();
                int i = 0;
                while (i < sourceRefs.length) {
                    mess.addSourceReference(sourceRefs[i]);
                    ++i;
                }
                result = new TempNode.Invalid();
                result.addSourceReference(token1);
                result.addSourceReference(token2);
                result.addSourceReference(expr);
                result.addSourceReference(token3);
                return result;
            }
            String year = matcher.group(1);
            String month = matcher.group(2);
            String day = matcher.group(3);
            String hour = matcher.group(4);
            String minute = matcher.group(5);
            String second = matcher.group(6);
            String fract = matcher.group(7);
            boolean zulu = matcher.group(8) != null;
            String sign = matcher.group(9);
            String offhour = matcher.group(10);
            String offmin = matcher.group(11);
            TimeZone zone = null;
            if (zulu) {
                zone = new SimpleTimeZone(0, "GMT+00:00");
            } else if (offhour != null) {
                int offs = Integer.parseInt(offhour) * 60;
                offs += Integer.parseInt(offmin);
                offs *= 60000;
                if (sign.equals("-")) {
                    offs = -offs;
                }
                zone = new SimpleTimeZone(offs, "GMT" + sign + offhour + ":" + offmin);
            } else {
                zone = TimeZone.getDefault();
            }
            TempNode.DateTime cal = new TempNode.DateTime();
            cal.clear();
            cal.setTimeZone(zone);
            cal.set(1, Integer.parseInt(year));
            if (month != null) {
                cal.set(2, Integer.parseInt(month) - 1);
            }
            if (day != null) {
                cal.set(5, Integer.parseInt(day));
            }
            if (hour != null) {
                cal.set(11, Integer.parseInt(hour));
            }
            if (minute != null) {
                cal.set(12, Integer.parseInt(minute));
            }
            if (second != null) {
                cal.set(13, Integer.parseInt(second));
            }
            if (fract != null) {
                double fr = Double.parseDouble("0." + fract);
                long milli = Math.round(fr * 1000.0);
                cal.set(14, (int)milli);
            }
            result = new TempNode.Literal<TempNode.DateTime>(cal);
            result.addSourceReference(token1);
            result.addSourceReference(token2);
            result.addSourceReference(expr);
            result.addSourceReference(token3);
        }
        return result;
    }

    TempNode parsePathName() {
        TempNode scopedId = null;
        Token token = null;
        Token tokenid = null;
        boolean first = true;
        do {
            tokenid = this.getNextLegalToken();
            String idname = null;
            boolean error = false;
            if (tokenid.getType() == Token.Type.IDENTIFIER) {
                idname = ((Token.Identifier)tokenid).getName();
            } else if (first) {
                error = true;
            } else if (this.inspectNextLegalToken().getType() == Token.Type.DOUBLE_COLON) {
                error = true;
            } else if (tokenid.getType() == Token.Type.TEXT) {
                idname = ((Token.Text)tokenid).getValue();
            } else if (tokenid.getType() == Token.Type.NUMBER) {
                Token.Number tn = (Token.Number)tokenid;
                if (tn.isInteger()) {
                    idname = tn.getStringValue();
                } else {
                    error = true;
                }
            } else {
                error = true;
            }
            first = false;
            if (error) {
                MessageCollection messageCollection = this.messages;
                messageCollection.getClass();
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(4);
                mess.substitute(1, tokenid.getDenotation());
                mess.addSourceReference(tokenid.getSourceReference());
                continue;
            }
            TempNode.Identifier lastId = scopedId;
            scopedId = new TempNode.Identifier(scopedId, idname);
            if (token != null) {
                scopedId.addSourceReference(lastId);
                scopedId.addSourceReference(token);
            }
            scopedId.addSourceReference(tokenid);
        } while ((token = this.getNextLegalToken()).getType() == Token.Type.DOUBLE_COLON);
        this.inLex.unfetchToken(token);
        if (scopedId == null) {
            scopedId = new TempNode.Invalid();
            scopedId.addSourceReference(token);
        }
        return scopedId;
    }

    TempNode parseIf() {
        TempNode result;
        block6: {
            result = null;
            Token token1 = null;
            Token token2 = null;
            Token token3 = null;
            Token token4 = null;
            try {
                token1 = this.inLex.fetchToken();
                if (token1.getType() != Token.Type.IF) {
                    throw new IllegalSyntax("if", token1);
                }
                TempNode condition = this.parseInfix(impType);
                token2 = this.getNextLegalToken();
                if (token2.getType() != Token.Type.THEN) {
                    throw new IllegalSyntax("then", token2);
                }
                TempNode thenpart = this.parseInfix(impType);
                token3 = this.getNextLegalToken();
                if (token3.getType() != Token.Type.ELSE) {
                    throw new IllegalSyntax("else", token3);
                }
                TempNode elsepart = this.parseInfix(impType);
                token4 = this.getNextLegalToken();
                if (token4.getType() != Token.Type.ENDIF) {
                    throw new IllegalSyntax("endif", token4);
                }
                result = new TempNode.IfClause(condition, thenpart, elsepart);
                result.addSourceReference(token1);
                result.addSourceReference(token2);
                result.addSourceReference(token3);
                result.addSourceReference(token4);
            }
            catch (IllegalSyntax ill) {
                result = new TempNode.Invalid();
                result.addSourceReference(token1);
                MessageCollection messageCollection = this.messages;
                messageCollection.getClass();
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(5);
                mess.substitute(1, ill.what);
                mess.substitute(2, ill.found.getDenotation());
                mess.addSourceReference(ill.found.getSourceReference());
                if (ill.found.getType() == Token.Type.END_OF_TEXT) break block6;
                this.skipToOperator(Token.Type.ENDIF);
            }
        }
        return result;
    }

    TempNode parseLet() {
        TempNode result = null;
        Token token1 = null;
        Token token2 = null;
        ArrayList<Token> tokList = new ArrayList<Token>(5);
        try {
            Token.Type type;
            token1 = this.inLex.fetchToken();
            if (token1.getType() != Token.Type.LET) {
                throw new IllegalSyntax("let", token1);
            }
            ArrayList<TempNode> declList = new ArrayList<TempNode>(4);
            do {
                TempNode decl;
                if ((decl = this.parseVarDecl()) != null) {
                    declList.add(decl);
                }
                if ((type = (token2 = this.getNextLegalToken()).getType()) == Token.Type.IN) break;
                tokList.add(token2);
            } while (type == Token.Type.COMMA && type != Token.Type.IN);
            if (type != Token.Type.IN) {
                throw new IllegalSyntax("in", token2);
            }
            TempNode expression = this.parseInfix(impType);
            TempNode[] declarations = new TempNode[declList.size()];
            declarations = declList.toArray(declarations);
            result = new TempNode.LetClause(declarations, expression);
            result.addSourceReference(token1);
            result.addSourceReference(token2);
            for (Token tok : tokList) {
                result.addSourceReference(tok);
            }
        }
        catch (IllegalSyntax ill) {
            MessageCollection messageCollection = this.messages;
            messageCollection.getClass();
            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(7);
            mess.substitute(1, ill.what);
            mess.substitute(2, ill.found.getDenotation());
            mess.addSourceReference(ill.found.getSourceReference());
            result = this.parseInfix(impType);
        }
        return result;
    }

    TempNode parseArgumentList() {
        TempNode.Arguments result = null;
        Token token1 = this.inLex.fetchToken();
        if (token1.getType() != Token.Type.O_BRACKET) {
            MessageCollection messageCollection = this.messages;
            messageCollection.getClass();
            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
            mess.substitute(1, "Argument list does not start with bracket.");
            mess.addSourceReference(token1.getSourceReference());
            return result;
        }
        Lexer.Checkpoint lexer_record = this.inLex.captureState();
        MessageCollection.Checkpoint mess_record = this.messages.captureState();
        Token token2 = null;
        ArrayList<Token> tokList = new ArrayList<Token>(20);
        ArrayList<TempNode> vardecls = new ArrayList<TempNode>(2);
        do {
            TempNode vardecl;
            if ((vardecl = this.parseVarDecl()) != null) {
                vardecls.add(vardecl);
            }
            token2 = this.getNextLegalToken();
            tokList.add(token2);
        } while (token2.getType() == Token.Type.COMMA);
        if (token2.getType() == Token.Type.BAR) {
            this.inLex.releaseState(lexer_record);
            this.messages.releaseState(mess_record);
        } else {
            this.inLex.restoreState(lexer_record);
            this.messages.restoreState(mess_record);
            vardecls = null;
            tokList.clear();
        }
        ArrayList<TempNode> arguments = new ArrayList<TempNode>(10);
        token2 = this.inLex.fetchToken();
        if (token2.getType() != Token.Type.C_BRACKET) {
            this.inLex.unfetchToken(token2);
            token2 = null;
            do {
                if (token2 != null) {
                    tokList.add(token2);
                }
                TempNode expression = this.parseInfix(impType);
                arguments.add(expression);
            } while ((token2 = this.getNextLegalToken()).getType() == Token.Type.COMMA);
        }
        if (token2.getType() != Token.Type.C_BRACKET) {
            MessageCollection messageCollection = this.messages;
            messageCollection.getClass();
            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(2);
            mess.substitute(1, token2.getDenotation());
            mess.addSourceReference(token2.getSourceReference());
            this.inLex.unfetchToken(token2);
            token2 = null;
        }
        TempNode[] vardeclA = null;
        if (vardecls != null) {
            vardeclA = new TempNode[vardecls.size()];
            vardeclA = vardecls.toArray(vardeclA);
        }
        TempNode[] argumentA = new TempNode[arguments.size()];
        argumentA = arguments.toArray(argumentA);
        result = new TempNode.Arguments(vardeclA, argumentA);
        result.addSourceReference(token1);
        if (token2 != null) {
            result.addSourceReference(token2);
        }
        for (Token tok : tokList) {
            result.addSourceReference(tok);
        }
        return result;
    }

    TempNode parseVarDecl() {
        Token identifier = this.getNextLegalToken();
        SourceReference idsource = identifier.getSourceReference();
        if (identifier.getType() != Token.Type.IDENTIFIER) {
            MessageCollection messageCollection = this.messages;
            messageCollection.getClass();
            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(13);
            mess.addSourceReference(idsource);
            mess.substitute(1, identifier.getDenotation());
            this.inLex.unfetchToken(identifier);
            return null;
        }
        Token token1 = this.getNextLegalToken();
        TempNode typename = null;
        if (token1.getType() == Token.Type.COLON) {
            typename = this.parsePathName();
        } else {
            this.inLex.unfetchToken(token1);
            token1 = null;
        }
        Token token2 = this.getNextLegalToken();
        TempNode initializer = null;
        if (token2.getType() == Token.Type.EQUAL) {
            initializer = this.parseInfix(impType);
        } else {
            this.inLex.unfetchToken(token2);
            token2 = null;
        }
        String idname = ((Token.Identifier)identifier).getName();
        TempNode.Declaration result = new TempNode.Declaration(idname, typename, initializer);
        result.addSourceReference(identifier);
        if (token1 != null) {
            result.addSourceReference(token1);
        }
        if (token2 != null) {
            result.addSourceReference(token2);
        }
        return result;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    Token getNextLegalToken() {
        Token token;
        MessageCollection.Message mess;
        String items;
        SourceReference oldSourceRef;
        block10: {
            Token.Type type;
            boolean first;
            block9: {
                oldSourceRef = null;
                items = "";
                mess = null;
                token = null;
                first = true;
                if (!true) break block9;
                token = this.inLex.fetchToken();
                if ((type = token.type) != Token.Type.ILLEGAL && type != Token.Type.COMMENT) break block10;
            }
            do {
                if (type == Token.Type.COMMENT) {
                    this.comments.add(((Token.Comment)token).getValue());
                } else {
                    if (first) {
                        MessageCollection messageCollection = this.messages;
                        messageCollection.getClass();
                        mess = messageCollection.new MessageCollection.Message(1);
                        first = false;
                    }
                    SourceReference sourceRef = token.getSourceReference();
                    String item = ((Token.Illegal)token).getItem();
                    if (oldSourceRef != null && oldSourceRef.canBeMerged(sourceRef, false)) {
                        oldSourceRef.merge(sourceRef);
                        items = String.valueOf(items) + item;
                    } else {
                        if (oldSourceRef != null) {
                            mess.addSourceReference(oldSourceRef);
                            items = String.valueOf(items) + " ";
                        }
                        oldSourceRef = new SourceReference(sourceRef);
                        items = String.valueOf(items) + item;
                    }
                }
                token = this.inLex.fetchToken();
            } while ((type = token.type) == Token.Type.ILLEGAL || type == Token.Type.COMMENT);
        }
        if (mess != null) {
            mess.addSourceReference(oldSourceRef);
            mess.substitute(1, items);
        }
        return token;
    }

    Token inspectNextLegalToken() {
        Token token = this.getNextLegalToken();
        this.inLex.unfetchToken(token);
        return token;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    void skipToOperator(Token.Type type) {
        Token token;
        block5: {
            block4: {
                if (!true) break block4;
                token = this.inLex.fetchToken();
                if (token.type == type || token.type != Token.Type.COMMENT || token.type == Token.Type.END_OF_TEXT) break block5;
            }
            do {
                if (token.type == Token.Type.COMMENT) {
                    this.comments.add(((Token.Comment)token).getValue());
                }
                token = this.inLex.fetchToken();
            } while (token.type != type && token.type == Token.Type.COMMENT && token.type != Token.Type.END_OF_TEXT);
        }
        if (token.type == Token.Type.END_OF_TEXT) {
            MessageCollection messageCollection = this.messages;
            messageCollection.getClass();
            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(6);
            SourceReference sourceRef = token.getSourceReference();
            mess.addSourceReference(sourceRef);
            this.inLex.unfetchToken(token);
        }
    }

    void skipPairedBrackets(Token.Type type) {
        Token token = this.getNextLegalToken();
        if (token.getType() != type) {
            this.inLex.unfetchToken(token);
            return;
        }
        int[] count = new int[4];
        do {
            Integer addind;
            if ((addind = pairedBrackets.get((Object)type)) == null) continue;
            if (addind > 0) {
                int n = addind;
                count[n] = count[n] + 1;
                continue;
            }
            int n = -addind.intValue();
            count[n] = count[n] - 1;
        } while ((count[1] != 0 || count[2] != 0 || count[3] != 0) && (type = (token = this.getNextLegalToken()).getType()) != Token.Type.END_OF_TEXT);
        if (token.type == Token.Type.END_OF_TEXT) {
            MessageCollection messageCollection = this.messages;
            messageCollection.getClass();
            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(12);
            SourceReference sourceRef = token.getSourceReference();
            mess.addSourceReference(sourceRef);
            this.inLex.unfetchToken(token);
        }
    }

    private class IllegalSyntax
    extends Exception {
        final String what;
        final Token found;

        IllegalSyntax(String what, Token found) {
            this.what = what;
            this.found = found;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InfixType {
        EnumSet<Token.Type> operators;
        InfixType nextStronger;

        InfixType(InfixType nextStronger, EnumSet<Token.Type> operators) {
            this.nextStronger = nextStronger;
            this.operators = operators;
        }

        InfixType nextStronger() {
            return this.nextStronger;
        }

        boolean includesOperator(Token tok) {
            return this.operators.contains((Object)tok.getType());
        }
    }
}

