/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.UI;

import de.interactive_instruments.ShapeChange.Converter;
import de.interactive_instruments.ShapeChange.Model.Xmi10.Xmi10Document;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class Dialog
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 3197452835574541123L;
    private JTextField xmiField;
    private JTextField cfgField;
    private JTextField outField;
    private JTextField asField;
    private JButton xmiButton;
    private JButton cfgButton;
    private JButton outButton;
    private JButton startButton;
    private JButton logButton;
    private JButton exitButton;
    private ButtonGroup reportGroup;
    private ButtonGroup ruleGroup;
    private JCheckBox docCB;
    private JCheckBox visCB;
    private JFileChooser fc = new JFileChooser();
    protected Converter converter = null;
    protected ShapeChangeResult result = null;
    protected Options options = null;
    protected String xmi = null;

    public Dialog(Converter c, Options o, ShapeChangeResult r, String x) {
        super(new BorderLayout());
        this.converter = c;
        this.options = o;
        this.result = r;
        this.xmi = x;
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Main options", this.createTab1());
        tabbedPane.addTab("Secondary options", this.createTab2());
        this.add(tabbedPane);
    }

    private Component createTab1() {
        JPanel xmiPanel = new JPanel();
        this.xmiField = new JTextField(40);
        this.xmiField.setText(this.xmi);
        xmiPanel.add(this.xmiField);
        this.xmiButton = new JButton("Select File");
        xmiPanel.add(this.xmiButton);
        this.xmiButton.setActionCommand("XMI");
        this.xmiButton.addActionListener(this);
        xmiPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "XMI file", 1, 2));
        JPanel cfgPanel = new JPanel();
        this.cfgField = new JTextField(40);
        this.cfgField.setText(this.options.configFile);
        cfgPanel.add(this.cfgField);
        this.cfgButton = new JButton("Select File");
        cfgPanel.add(this.cfgButton);
        this.cfgButton.setActionCommand("CFG");
        this.cfgButton.addActionListener(this);
        cfgPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Configuration file", 1, 2));
        JPanel outPanel = new JPanel();
        this.outField = new JTextField(40);
        String s = this.options.parameter("outputDirectory");
        if (s == null) {
            s = ".";
        }
        this.outField.setText(s);
        outPanel.add(this.outField);
        this.outButton = new JButton("Select File");
        outPanel.add(this.outButton);
        this.outButton.setActionCommand("OUT");
        this.outButton.addActionListener(this);
        outPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Output directory", 1, 2));
        JPanel startPanel = new JPanel();
        this.startButton = new JButton("Process XMI");
        this.startButton.setActionCommand("START");
        this.startButton.addActionListener(this);
        startPanel.add(this.startButton);
        this.logButton = new JButton("View Log");
        this.logButton.setActionCommand("LOG");
        this.logButton.addActionListener(this);
        this.logButton.setEnabled(false);
        startPanel.add(this.logButton);
        this.exitButton = new JButton("Exit");
        this.exitButton.setActionCommand("EXIT");
        this.exitButton.addActionListener(this);
        this.exitButton.setEnabled(true);
        startPanel.add(this.exitButton);
        Box fileBox = Box.createVerticalBox();
        fileBox.add(xmiPanel);
        fileBox.add(cfgPanel);
        fileBox.add(outPanel);
        fileBox.add(startPanel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)fileBox, "Center");
        return panel;
    }

    private JPanel createTab2() {
        JPanel reportPanel = new JPanel(new GridLayout(3, 1));
        this.reportGroup = new ButtonGroup();
        JRadioButton radioButton = new JRadioButton("Error", true);
        reportPanel.add(radioButton);
        radioButton.setActionCommand("ERROR");
        this.reportGroup.add(radioButton);
        radioButton = new JRadioButton("Warning");
        reportPanel.add(radioButton);
        radioButton.setActionCommand("WARNING");
        this.reportGroup.add(radioButton);
        radioButton = new JRadioButton("Info");
        reportPanel.add(radioButton);
        radioButton.setActionCommand("INFO");
        this.reportGroup.add(radioButton);
        reportPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Report options", 1, 2));
        JPanel rulePanel = new JPanel(new GridLayout(3, 1));
        this.ruleGroup = new ButtonGroup();
        radioButton = new JRadioButton("GML 3.2.1");
        rulePanel.add(radioButton);
        radioButton.setActionCommand("iso19136_2007");
        this.ruleGroup.add(radioButton);
        radioButton = new JRadioButton("GML 3.2.1 with ShapeChange 1.0 extensions");
        rulePanel.add(radioButton);
        radioButton.setActionCommand("iso19136_2007_ShapeChange_1.0_extensions");
        this.ruleGroup.add(radioButton);
        radioButton = new JRadioButton("GML 3.2.1 with INSPIRE extensions", true);
        rulePanel.add(radioButton);
        radioButton.setActionCommand("iso19136_2007_INSPIRE_Extensions");
        this.ruleGroup.add(radioButton);
        rulePanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Default encoding rule", 1, 2));
        JPanel asPanel = new JPanel();
        this.asField = new JTextField(40);
        String s = this.options.parameter("appSchemaName");
        if (s == null) {
            s = "";
        }
        this.asField.setText(s);
        asPanel.add(this.asField);
        asPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Application schema name (optional)", 1, 2));
        JPanel otherPanel = new JPanel(new GridLayout(2, 1));
        this.docCB = new JCheckBox("Include documentation", true);
        boolean b = true;
        s = this.options.parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "includeDocumentation");
        if (s != null && s.equals("false")) {
            b = false;
        }
        this.docCB.setSelected(b);
        otherPanel.add(this.docCB);
        this.visCB = new JCheckBox("Ignore visibility");
        b = true;
        s = this.options.parameter("publicOnly");
        if (s != null && s.equals("false")) {
            b = false;
        }
        this.visCB.setSelected(!b);
        otherPanel.add(this.visCB);
        otherPanel.setBorder(new TitledBorder(new LineBorder(Color.black), "Other options", 1, 2));
        Box innerBox = Box.createHorizontalBox();
        innerBox.add(reportPanel);
        innerBox.add(rulePanel);
        Box mainBox = Box.createVerticalBox();
        mainBox.add(innerBox);
        mainBox.add(asPanel);
        mainBox.add(otherPanel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)mainBox, "Center");
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.startButton == e.getSource()) {
            System.err.println("User chose PROCESS.");
            this.options.configFile = this.cfgField.getText();
            this.xmi = this.xmiField.getText();
            this.startButton.setEnabled(false);
            this.exitButton.setEnabled(false);
            try {
                this.options.loadConfiguration();
                this.options.setParameter("outputDirectory", this.outField.getText());
                this.options.setParameter("logFile", String.valueOf(this.outField.getText()) + "/ShapeChangeResult.xml");
                this.options.setParameter("appSchemaName", this.asField.getText());
                this.options.setParameter("reportLevel", this.reportGroup.getSelection().getActionCommand());
                this.options.setParameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "defaultEncodingRule", this.ruleGroup.getSelection().getActionCommand());
                if (this.docCB.isSelected()) {
                    this.options.setParameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "includeDocumentation", "true");
                } else {
                    this.options.setParameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "includeDocumentation", "false");
                }
                if (!this.visCB.isSelected()) {
                    this.options.setParameter("publicOnly", "true");
                } else {
                    this.options.setParameter("publicOnly", "false");
                }
                this.converter.convert(new Xmi10Document(this.result, this.options, this.xmi));
            }
            catch (ShapeChangeAbortException ex) {
                Toolkit.getDefaultToolkit().beep();
            }
            this.logButton.setEnabled(true);
            this.exitButton.setEnabled(true);
        } else if (e.getSource() == this.logButton) {
            try {
                Runtime.getRuntime().exec("cmd /c start " + this.options.parameter("logFile"));
            }
            catch (IOException e1) {
                e1.printStackTrace();
                System.exit(1);
            }
        } else if (e.getSource() == this.exitButton) {
            System.exit(0);
        } else if (e.getSource() == this.xmiButton) {
            int returnVal = this.fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = this.fc.getSelectedFile();
                this.xmiField.setText(file.getAbsolutePath());
            }
        } else if (e.getSource() == this.cfgButton) {
            int returnVal = this.fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = this.fc.getSelectedFile();
                this.cfgField.setText(file.getAbsolutePath());
            }
        } else if (e.getSource() == this.outButton) {
            this.fc.setFileSelectionMode(1);
            int returnVal = this.fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = this.fc.getSelectedFile();
                this.outField.setText(file.getAbsolutePath());
            }
        }
    }
}

