/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.ClassInfo;
import de.interactive_instruments.ShapeChange.Model;
import de.interactive_instruments.ShapeChange.OclConstraint;
import de.interactive_instruments.ShapeChange.OclConstraint_KindOf;
import de.interactive_instruments.ShapeChange.OclConstraint_Value;
import de.interactive_instruments.ShapeChange.OclConstraint_Xor;
import de.interactive_instruments.ShapeChange.PropertyInfo;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OclParser {
    private Model model = null;
    private ShapeChangeResult result = null;

    public OclParser(Model m, ShapeChangeResult r) {
        this.model = m;
        this.result = r;
    }

    public OclConstraint constraint(String exp, ClassInfo ci) {
        OclConstraint c;
        String prop;
        Matcher m2;
        this.result.addDebug("Processing OCL constraint in class '" + ci.name() + "': " + exp);
        Matcher m = Pattern.compile("\\w+\\.(oclIsKindOf|isKindOf)\\s*\\(\\s*(\\w+)\\s*\\)").matcher(exp);
        boolean f = m.find();
        if (f && (m2 = Pattern.compile("self\\.(\\w+)\\-\\>forAll\\s*\\(\\s*(\\w+)\\s*\\|").matcher(exp)).find()) {
            this.result.addDebug("Constraint is of type 'kind of'.");
            prop = m2.group(1).trim();
            PropertyInfo pi = ci.property(prop);
            if (pi != null) {
                OclConstraint_KindOf c2 = new OclConstraint_KindOf(exp, pi);
                this.result.addDebug("Property: " + pi.name());
                while (f) {
                    String type = m.group(2).trim();
                    ClassInfo ti = this.model.classByName(type);
                    if (ti != null) {
                        c2.addType(ti);
                        this.result.addDebug("Target type: " + ti.name());
                    } else {
                        this.result.addError("Error in OCL constraint in class '" + ci.name() + "': target type '" + type + "' not found");
                    }
                    f = m.find(m.end());
                }
                return c2;
            }
            this.result.addError("Error in OCL constraint in class '" + ci.name() + "': property '" + prop + "' not found");
        }
        if (f = (m = Pattern.compile("self\\.(\\w+)\\-\\>(notEmpty|empty)\\s*\\(\\s*\\)").matcher(exp)).find()) {
            c = new OclConstraint_Xor(exp);
            this.result.addDebug("Constraint is of type 'XOR'.");
            while (f) {
                prop = m.group(1).trim();
                String e = m.group(2).trim();
                PropertyInfo pi = ci.property(prop);
                if (pi != null) {
                    ((OclConstraint_Xor)c).addProperty(pi, e.equals("empty"));
                    this.result.addDebug("Property: " + pi.name());
                } else {
                    this.result.addError("Error in OCL constraint in class '" + ci.name() + "': property '" + prop + "' not found");
                }
                f = m.find(m.end());
            }
            return c;
        }
        m = Pattern.compile("self\\.(\\w+)\\s*([\\=\\>\\<]+)\\s*(\\w+)").matcher(exp);
        f = m.find();
        if (f) {
            c = new OclConstraint_Value(exp);
            this.result.addDebug("Constraint is of type 'value'.");
            while (f) {
                prop = m.group(1).trim();
                String op = m.group(2).trim();
                String val = m.group(3).trim();
                PropertyInfo pi = ci.property(prop);
                if (pi != null) {
                    ((OclConstraint_Value)c).addValue(pi, op, val);
                    this.result.addDebug("Value condition: " + pi.name() + " " + op + " " + val);
                } else {
                    this.result.addError("Error in OCL constraint in class '" + ci.name() + "': property '" + prop + "' not found");
                }
                f = m.find(m.end());
            }
            return c;
        }
        this.result.addError("OCL constraint in class '" + ci.name() + "' is currently not supported: " + exp);
        return null;
    }
}

