<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0"
		xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc"
		xmlns:gml="http://www.opengis.net/gml/3.2"
		xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="p1" select="document('AX_Benutzungsauftrag.xml')//adv:profilkennung"/>
		<xsl:variable name="p2" select="document('AX_Benutzungsauftrag.xml')//adv:antragsnummer"/>
		<xsl:variable name="p3" select="document('AX_Benutzungsauftrag.xml')//adv:formatangabe"/>
		<xsl:variable name="p4" select="document('AX_Benutzungsauftrag.xml')//adv:selektionsmassstab"/>
		
		<xsl:variable name="kommunalesGebiet" select="document('E2.xml')//adv:AX_KommunalesGebiet"/>
		<xsl:variable name="land" select="$kommunalesGebiet/adv:gemeindekennzeichen/adv:AX_Gemeindekennzeichen/adv:land"/>
		<xsl:variable name="regbez" select="$kommunalesGebiet/adv:gemeindekennzeichen/adv:AX_Gemeindekennzeichen/adv:regierungsbezirk"/>
		<xsl:variable name="kreis" select="$kommunalesGebiet/adv:gemeindekennzeichen/adv:AX_Gemeindekennzeichen/adv:kreis"/>
		<xsl:variable name="gemeinde" select="$kommunalesGebiet/adv:gemeindekennzeichen/adv:AX_Gemeindekennzeichen/adv:gemeinde"/>
		
		<xsl:variable name="IdAndDKKM">
			<ogc:And>
				<ogc:PropertyIsEqualTo>
					<ogc:PropertyName>modellart/AA_Modellart/advStandardModell</ogc:PropertyName>
					<xsl:choose>
						<xsl:when test="$p4='0500'">
							<ogc:Literal>DKKM500</ogc:Literal>
						</xsl:when>
						<xsl:when test="$p4='1000'">
							<ogc:Literal>DKKM1000</ogc:Literal>
						</xsl:when>
						<xsl:when test="$p4='2000'">
							<ogc:Literal>DKKM2000</ogc:Literal>
						</xsl:when>
						<xsl:otherwise>
							<ogc:Literal>DKKM1000</ogc:Literal>
						</xsl:otherwise>
					</xsl:choose>
				</ogc:PropertyIsEqualTo>
				<ogc:Or>
					<xsl:for-each select="//gml:featureMember/*/@gml:id">
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>dientZurDarstellungVon/@gml:id</ogc:PropertyName><!-- Hier stand vorher: dientZurDarstellungVon/*/@gml:id -->
							<ogc:Literal>
								<xsl:value-of select="."/>
							</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</xsl:for-each>
				</ogc:Or>
			</ogc:And>
		</xsl:variable>
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
				<!-- Selektion der relevanten Präsentationsobjekte -->
				<wfs:Query typeName="AP_PPO">
					<ogc:Filter>
						<xsl:copy-of select="$IdAndDKKM"/><!-- Hier copy-of statt value-of, ebenso bei den anderen. -->
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AP_LPO">
					<ogc:Filter>
						<xsl:copy-of select="$IdAndDKKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AP_FPO">
					<ogc:Filter>
						<xsl:copy-of select="$IdAndDKKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AP_PTO">
					<ogc:Filter>
						<xsl:copy-of select="$IdAndDKKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AP_LTO">
					<ogc:Filter>
						<xsl:copy-of select="$IdAndDKKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AP_Darstellung">
					<ogc:Filter>
						<xsl:copy-of select="$IdAndDKKM"/>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Regierungsbezirk">
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>schluesselGesamt</ogc:PropertyName>
							<ogc:Literal>
								<xsl:value-of select="concat($land,$regbez)"/>
							</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_KreisRegion">
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>schluesselGesamt</ogc:PropertyName>
							<ogc:Literal>
								<xsl:value-of select="concat($land,$regbez,$kreis)"/>
							</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Gemeinde">
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>schluesselGesamt</ogc:PropertyName>
							<ogc:Literal>
								<xsl:value-of select="concat($land,$regbez,$kreis,$gemeinde)"/>
							</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</wfs:Query>
				<!-- AX_LBezM/OHNr taucht ggf. mehrfach in E2.xml auf. Der Implementierung bleibt es vorbehalten, hier mehrfache Anfragen zu vermeiden. -->
				<xsl:for-each select="document('E2.xml')//adv:AX_LagebezeichnungMitHausnummer/adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:verschluesselt/adv:AX_VerschluesselteLagebezeichnung">
					<xsl:variable name="mH1" select="./adv:land"/>
					<xsl:variable name="mH2" select="./adv:regierungsbezirk"/>
					<xsl:variable name="mH3" select="./adv:kreis"/>
					<xsl:variable name="mH4" select="./adv:gemeinde"/>
					<xsl:variable name="mH5" select="./adv:lage"/>
					<xsl:variable name="schluesselGesamt_mH" select="concat($mH1,$mH2,$mH3,$mH4,$mH5)"/>
					<wfs:Query typeName="AX_LagebezeichnungKatalogeintrag"><!-- Danke, J. E. ! -->
						<ogc:Filter>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>schluesselGesamt</ogc:PropertyName>
								<ogc:Literal>
									<xsl:value-of select="$schluesselGesamt_mH"/>
								</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:Filter>
					</wfs:Query>
				</xsl:for-each>
				<xsl:for-each select="document('E2.xml')//adv:AX_LagebezeichnungOhneHausnummer/adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:verschluesselt/adv:AX_VerschluesselteLagebezeichnung">
					<xsl:variable name="oH1" select="./adv:land"/>
					<xsl:variable name="oH2" select="./adv:regierungsbezirk"/>
					<xsl:variable name="oH3" select="./adv:kreis"/>
					<xsl:variable name="oH4" select="./adv:gemeinde"/>
					<xsl:variable name="oH5" select="./adv:lage"/>
					<xsl:variable name="schluesselGesamt_oH" select="concat($oH1,$oH2,$oH3,$oH4,$oH5)"/>
					<wfs:Query typeName="AX_LagebezeichnungKatalogeintrag"><!-- Danke, J. E. ! -->
						<ogc:Filter>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>schluesselGesamt</ogc:PropertyName>
								<ogc:Literal>
									<xsl:value-of select="$schluesselGesamt_oH"/>
								</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:Filter>
					</wfs:Query>
				</xsl:for-each>
			</anforderungsmerkmale>
			<profilkennung>
				<xsl:value-of select="$p1"/>
			</profilkennung>
			<antragsnummer>
				<xsl:value-of select="$p2"/>
			</antragsnummer>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
