/*
 * Decompiled with CFR 0.152.
 */
package de.adv_online.aaa.modellarttool;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.PackageInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.PropertyInfoEA;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;

public class ModellartRep {
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private String modellart = "";
    private static String AAAZielVersion = "6.0.1";
    private boolean set = false;
    private HashSet<ClassInfo> processed = new HashSet();
    private HashSet<ClassInfo> written = new HashSet();
    private HashSet<Info> Members = new HashSet();

    public ModellartRep(PackageInfo p, Model m, Options o, ShapeChangeResult r, String ma) {
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        this.modellart = ma;
        for (ClassInfo ci : this.model.classes(this.pi)) {
            this.LoadClass(ci);
        }
        this.set = true;
    }

    private void LoadClass(ClassInfo ci) {
        int cat = ci.category();
        switch (cat) {
            case -1: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (this.processed.contains(ci)) break;
                this.processed.add(ci);
                if (!this.inModel((Info)ci)) break;
                this.Members.add((Info)ci);
                for (String st : ci.supertypes()) {
                    ClassInfo cis = this.model.classById(st);
                    if (cis == null || !cis.inSchema(this.pi) || this.processed.contains(cis)) continue;
                    this.LoadClass(cis);
                }
                for (PropertyInfo propi : ci.properties().values()) {
                    if (!this.inModel((Info)propi)) continue;
                    this.ClassRequired(propi.typeInfo().id);
                    this.Members.add((Info)propi);
                    PropertyInfo rpropi = propi.reverseProperty();
                    if (rpropi == null) continue;
                    this.Members.add((Info)rpropi);
                }
                break;
            }
            case 2: 
            case 3: {
                if (this.processed.contains(ci)) break;
                this.processed.add(ci);
                if (!this.inModel((Info)ci)) break;
                this.Members.add((Info)ci);
                for (PropertyInfo propi : ci.properties().values()) {
                    if (!this.inModel((Info)propi)) continue;
                    this.Members.add((Info)propi);
                }
                break;
            }
            default: {
                this.result.addWarning("Klasse mit unbekannter Art wurde nicht verarbeitet: " + ci.name());
            }
        }
    }

    private boolean inModel(Info i) {
        String[] sa;
        String s1 = i.taggedValue("AAA:Modellart");
        if (s1 == null || s1.trim().length() == 0) {
            return true;
        }
        for (String s2 : sa = s1.split(",")) {
            if (!s2.equals(this.name())) continue;
            return true;
        }
        return false;
    }

    private void addToModel(Info i) {
        PackageInfoEA iea;
        String[] sa;
        String s1 = i.taggedValue("AAA:Modellart");
        if (s1 == null || s1.trim().length() == 0) {
            return;
        }
        for (String s2 : sa = s1.split(",")) {
            if (!s2.equals(this.name())) continue;
            return;
        }
        if (i.getClass().getName().equals("de.interactive_instruments.ShapeChange.Model.EA.PackageInfoEA")) {
            iea = (PackageInfoEA)i;
            iea.taggedValue("AAA:Modellart", s1 + "," + this.name());
        } else if (i.getClass().getName().equals("de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA")) {
            iea = (ClassInfoEA)i;
            iea.taggedValue("AAA:Modellart", s1 + "," + this.name());
        } else if (i.getClass().getName().equals("de.interactive_instruments.ShapeChange.Model.EA.PropertyInfoEA")) {
            iea = (PropertyInfoEA)i;
            iea.taggedValue("AAA:Modellart", s1 + "," + this.name());
        } else {
            this.result.addInfo("Unsupported Java class: " + i.getClass().getName());
        }
    }

    private void removeFromModel(Info i) {
        PackageInfoEA iea;
        String s1 = i.taggedValue("AAA:Modellart");
        if (s1 == null || s1.trim().length() == 0) {
            return;
        }
        String[] sa = s1.split(",");
        s1 = "";
        for (String s2 : sa) {
            if (s2.equals(this.name())) continue;
            s1 = s1.length() == 0 ? s2 : s1 + "," + s2;
        }
        if (i.getClass().getName().equals("de.interactive_instruments.ShapeChange.Model.EA.PackageInfoEA")) {
            iea = (PackageInfoEA)i;
            iea.taggedValue("AAA:Modellart", s1);
        } else if (i.getClass().getName().equals("de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA")) {
            iea = (ClassInfoEA)i;
            iea.taggedValue("AAA:Modellart", s1);
        } else if (i.getClass().getName().equals("de.interactive_instruments.ShapeChange.Model.EA.PropertyInfoEA")) {
            iea = (PropertyInfoEA)i;
            iea.taggedValue("AAA:Modellart", s1);
        } else {
            this.result.addInfo("Unsupported Java class: " + i.getClass().getName());
        }
    }

    public boolean contains(Info i) {
        return this.Members.contains(i);
    }

    private void SetClass(ClassInfo ci) {
        int cat = ci.category();
        switch (cat) {
            case -1: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (this.processed.contains(ci)) break;
                this.processed.add(ci);
                this.Members.add((Info)ci);
                for (String st : ci.supertypes()) {
                    ClassInfo cis = this.model.classById(st);
                    if (cis == null || !cis.inSchema(this.pi) || this.processed.contains(cis)) continue;
                    this.SetClass(cis);
                }
                for (PropertyInfo propi : ci.properties().values()) {
                    this.SetProperty(propi, false, false);
                }
                break;
            }
            case 2: 
            case 3: {
                if (this.processed.contains(ci)) break;
                this.processed.add(ci);
                this.Members.add((Info)ci);
                for (PropertyInfo propi : ci.properties().values()) {
                    this.SetProperty(propi, false, true);
                }
                break;
            }
            default: {
                this.result.addWarning("Klasse mit unbekannter Art wurde nicht verarbeitet: " + ci.name());
            }
        }
    }

    private void ClassRequired(String classId) {
        ClassInfo ci = this.model.classById(classId);
        if (ci != null && ci.inSchema(this.pi)) {
            int cat = ci.category();
            switch (cat) {
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    this.SetClass(ci);
                    break;
                }
                default: {
                    this.result.addWarning("Klasse mit unbekannter Art wurde nicht verarbeitet: " + ci.name());
                }
            }
        }
    }

    private void SetProperty(PropertyInfo propi, boolean force, boolean codedValue) {
        boolean export;
        boolean bl = export = force || this.inModel((Info)propi);
        if (!codedValue) {
            export = export || propi.cardinality().minOccurs > 0;
        }
        boolean bl2 = export = export && propi.name().length() > 0;
        if (export) {
            this.Members.add((Info)propi);
            if (!codedValue) {
                PropertyInfo rpropi;
                this.ClassRequired(propi.typeInfo().id);
                if (!propi.isAttribute() && propi.isNavigable() && (rpropi = propi.reverseProperty()) != null) {
                    this.Members.add((Info)rpropi);
                }
            } else if (!this.Members.contains(propi.inClass())) {
                this.Members.add((Info)propi.inClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(String filename) {
        if (!this.set) {
            this.result.addError("Export der Datei nicht m\u00f6glich, da die Eintr\u00e4ge noch nicht definiert sind.");
            return;
        }
        try {
            PrintWriter out = null;
            this.written.clear();
            try {
                out = new PrintWriter(new FileWriter(filename));
                out.println("AFIS-ALKIS-ATKIS-Modellartinhalt");
                out.println("Version: " + AAAZielVersion);
                out.println("Name: " + this.modellart);
                out.println("#");
                HashSet classes = this.model.classes(this.pi);
                ClassInfo[] classesArr = new ClassInfo[classes.size()];
                classes.toArray(classesArr);
                Arrays.sort(classesArr, new Comparator<ClassInfo>(){

                    @Override
                    public int compare(ClassInfo ci1, ClassInfo ci2) {
                        return ci1.name().compareTo(ci2.name());
                    }
                });
                for (int cidx = 0; cidx < classesArr.length; ++cidx) {
                    ClassInfo k = classesArr[cidx];
                    this.DumpClass(out, k);
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
                this.result.addInfo("Schreiben der Datei abgeschlossen.");
            }
        }
        catch (IOException e) {
            this.result.addError("Problem beim Schreiben von Datei: " + filename);
            e.printStackTrace();
        }
    }

    private void AddEntry(PrintWriter out, ClassInfo i, boolean included) {
        String s = i.name() + " --- Objektart/Datentyp";
        if (!included) {
            s = "# " + s;
        }
        out.println(s);
        this.result.addDebug(s);
    }

    private void AddEntry(PrintWriter out, PropertyInfo i, boolean included, boolean codedValue) {
        String iv;
        String s = i.inClass().name() + "/";
        s = codedValue ? ((iv = i.initialValue()) != null && iv.trim().length() > 0 ? s + iv.trim() : s + i.name()) : s + i.name();
        int cat = i.inClass().category();
        s = cat == 3 || cat == 2 ? s + " --- Werteart" : (i.isAttribute() ? s + " --- Attributart" : s + " --- Relationsart");
        if (!included) {
            s = "# " + s;
        }
        out.println(s);
        this.result.addDebug(s);
    }

    private void DumpProperty(PrintWriter out, PropertyInfo propi, boolean codedValue) {
        if (propi.name().length() == 0) {
            return;
        }
        if (this.Members.contains(propi)) {
            this.AddEntry(out, propi, true, codedValue);
        } else {
            this.AddEntry(out, propi, false, codedValue);
        }
    }

    private void DumpClass(PrintWriter out, ClassInfo ci) {
        int cat = ci.category();
        switch (cat) {
            case -1: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (this.written.contains(ci)) break;
                if (this.Members.contains(ci)) {
                    this.AddEntry(out, ci, true);
                } else {
                    this.AddEntry(out, ci, false);
                }
                this.written.add(ci);
                for (PropertyInfo propi : ci.properties().values()) {
                    this.DumpProperty(out, propi, false);
                }
                break;
            }
            case 2: 
            case 3: {
                if (!this.written.contains(ci)) {
                    this.written.add(ci);
                    for (PropertyInfo propi : ci.properties().values()) {
                        this.DumpProperty(out, propi, true);
                    }
                    break;
                }
            }
            default: {
                this.result.addWarning("Klasse mit unbekannter Art wurde nicht verarbeitet: " + ci.name());
            }
        }
    }

    public void writeToModel() {
        if (!this.set) {
            this.result.addError("\u00dcbernahme in das Modell nicht m\u00f6glich, da die Eintr\u00e4ge noch nicht definiert worden sind.");
            return;
        }
        this.written.clear();
        HashSet classes = this.model.classes(this.pi);
        for (ClassInfo k : classes) {
            this.WriteClassToModel(k);
        }
    }

    private void WritePropertyToModel(PropertyInfo propi) {
        if (propi.name().length() == 0) {
            return;
        }
        if (this.Members.contains(propi)) {
            this.addToModel((Info)propi);
        } else {
            this.removeFromModel((Info)propi);
        }
        PropertyInfo rpropi = propi.reverseProperty();
        if (rpropi != null) {
            if (this.Members.contains(rpropi)) {
                this.addToModel((Info)rpropi);
            } else {
                this.removeFromModel((Info)rpropi);
            }
        }
    }

    private void WriteClassToModel(ClassInfo ci) {
        int cat = ci.category();
        switch (cat) {
            case -1: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (this.written.contains(ci)) break;
                if (this.Members.contains(ci)) {
                    this.addToModel((Info)ci);
                } else {
                    this.removeFromModel((Info)ci);
                }
                this.written.add(ci);
                for (PropertyInfo propi : ci.properties().values()) {
                    this.WritePropertyToModel(propi);
                }
                break;
            }
            case 2: 
            case 3: {
                if (!this.written.contains(ci)) {
                    if (this.Members.contains(ci)) {
                        this.addToModel((Info)ci);
                    } else {
                        this.removeFromModel((Info)ci);
                    }
                    this.written.add(ci);
                    for (PropertyInfo propi : ci.properties().values()) {
                        this.WritePropertyToModel(propi);
                    }
                    break;
                }
            }
            default: {
                this.result.addWarning("Klasse mit unbekannter Art wurde nicht verarbeitet: " + ci.name());
            }
        }
    }

    public void clearInModel() {
        HashSet classes = this.model.classes(this.pi);
        for (ClassInfo ci : classes) {
            this.removeFromModel((Info)ci);
            for (PropertyInfo propi : ci.properties().values()) {
                this.removeFromModel((Info)propi);
                PropertyInfo rpropi = propi.reverseProperty();
                if (rpropi == null) continue;
                this.removeFromModel((Info)rpropi);
            }
        }
    }

    public String name() {
        return this.modellart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModellartRep(PackageInfo p, Model m, Options o, ShapeChangeResult r, FileReader reader) {
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        try {
            BufferedReader input = new BufferedReader(reader);
            try {
                String line = null;
                line = input.readLine();
                if (line == null || !line.trim().contains("AFIS-ALKIS-ATKIS-Modellartinhalt")) {
                    this.result.addError("Die Datei beginnt nicht mit dem erwateten Wert 'AFIS-ALKIS-ATKIS-Modellartinhalt'. Der Ladevorgang wurde abgebrochen.");
                    input.close();
                    return;
                }
                line = input.readLine();
                if (line == null || !line.trim().startsWith("Version: ")) {
                    this.result.addError("Es wurde keine Version angegeben. Der Ladevorgang wurde abgebrochen.");
                    input.close();
                    return;
                }
                String[] s = line.trim().substring(9);
                if (!s.equals(AAAZielVersion)) {
                    this.result.addError("Die Version " + (String)s + " passt nicht zur erwarteten Version " + AAAZielVersion + ". Der Ladevorgang wurde abgebrochen.");
                    input.close();
                    return;
                }
                line = input.readLine();
                if (line == null || !line.trim().startsWith("Name: ")) {
                    this.result.addError("Es wurde kein Modellartname angegeben. Der Ladevorgang wurde abgebrochen.");
                    input.close();
                    return;
                }
                s = line.trim().substring(6);
                this.modellart = s.trim();
                for (ClassInfo ci : this.model.classes(this.pi)) {
                    this.LoadClass(ci);
                }
                this.processed.clear();
                while ((line = input.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#")) continue;
                    s = line.split(" --- ");
                    if (s.length != 2) {
                        this.result.addError("Zeile mit unerlaubter Syntax: '" + line + "'");
                        continue;
                    }
                    s[0] = s[0].trim();
                    s[1] = s[1].trim();
                    if (s[1].equals("Objektart/Datentyp")) {
                        ClassInfo cix = this.model.classByName(s[0]);
                        if (cix != null && cix.inSchema(this.pi)) {
                            this.SetClass(cix);
                            continue;
                        }
                        this.result.addError("Objektart/Datentyp " + s[0] + " kann der Modellart nicht zugeordnet werden, die Klasse wurde nicht im Anwendungsschema gefunden.");
                        continue;
                    }
                    if (!s[1].equals("Attributart") && !s[1].equals("Relationsart") && !s[1].equals("Werteart")) continue;
                    String[] s2 = s[0].split("/", 2);
                    if (s2.length != 2) {
                        this.result.addError("Zeile mit unerlaubter Syntax: '" + line + "'");
                        continue;
                    }
                    s2[0] = s2[0].trim();
                    s2[1] = s2[1].trim();
                    ClassInfo cix = this.model.classByName(s2[0]);
                    if (cix != null && cix.inSchema(this.pi)) {
                        this.SetClass(cix);
                        boolean found = false;
                        for (PropertyInfo propi : cix.properties().values()) {
                            String sx1 = propi.name();
                            String sx2 = propi.initialValue();
                            if (sx1 != null && sx1.toLowerCase().equals(s2[1].toLowerCase())) {
                                this.SetProperty(propi, true, false);
                                found = true;
                                break;
                            }
                            if (!s[1].equals("Werteart") || sx2 == null || !sx2.toLowerCase().equals(s2[1].toLowerCase())) continue;
                            this.SetProperty(propi, true, true);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        this.result.addError(s[1] + " " + s2[1] + " zu Objektart/Datentyp " + s2[0] + " kann der Modellart nicht zugeordnet werden, die Eigenschaft wurde nicht im Anwendungsschema gefunden.");
                        continue;
                    }
                    this.result.addError("Objektart/Datentyp " + s2[0] + " kann der Modellart nicht zugeordnet werden, die Klasse wurde nicht im Anwendungsschema gefunden.");
                }
            }
            finally {
                input.close();
                this.result.addInfo("Laden der Datei abgeschlossen.");
                this.set = true;
            }
        }
        catch (IOException e) {
            this.result.addError("Problem beim Lesen von Modellartdatei.");
            e.printStackTrace();
        }
    }
}

