/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.TargetHelper;

import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.OclConstraint;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Ocl.OclNode;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema;
import de.interactive_instruments.ShapeChange.TargetHelper.XpathConstraintNode;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XpathHelper
implements MessageSource {
    public HashMap<String, String> namespaces = new HashMap();
    private Options options = null;
    private String classname = null;
    private ShapeChangeResult result = null;
    private String currentOclConstraintName = null;
    private ClassInfo currentOclConstraintClass = null;
    String alpha = "#";
    String beta = "";
    HashMap<String, ExtensionFunctionTemplate> extensionFunctions = new HashMap();

    public XpathHelper(Options o, ShapeChangeResult r) {
        this.options = o;
        this.result = r;
        this.classname = XmlSchema.class.getName();
        String s = this.options.parameter(this.classname, "schematronXlinkHrefPrefix");
        if (s != null) {
            this.alpha = s;
        }
        if ((s = this.options.parameter(this.classname, "schematronXlinkHrefPostfix")) != null) {
            this.beta = s;
        }
        String pats = "^schematronExtension\\.(\\w+?)\\.function";
        String[] extdecls = this.options.parameterNamesByRegex(this.classname, pats);
        Pattern pat = Pattern.compile(pats);
        for (String ext : extdecls) {
            Matcher mat = pat.matcher(ext);
            mat.matches();
            String fctname = mat.group(1);
            String fcts = this.options.parameter(this.classname, ext);
            String nss = this.options.parameter(this.classname, "schematronExtension." + fctname + ".namespace");
            if (nss == null || nss.length() == 0) {
                nss = "java:java";
            }
            int col = nss.indexOf(":");
            String nspx = "java";
            String ns = nss;
            if (col >= 0) {
                nspx = nss.substring(0, col);
                ns = nss.substring(col + 1);
            }
            this.extensionFunctions.put(fctname, new ExtensionFunctionTemplate(nspx, ns, fcts));
        }
    }

    public void registerNamespace(String xmlns, String ns) {
        if (!this.namespaces.containsKey(xmlns)) {
            this.namespaces.put(xmlns, ns);
        }
    }

    public void registerNamespace(String xmlns) {
        if (!this.namespaces.containsKey(xmlns)) {
            String ns = this.options.fullNamespace(xmlns);
            this.registerNamespace(xmlns, ns);
        }
    }

    public String getAndRegisterXmlName(PropertyInfo pi) {
        String nspref = pi.inClass().pkg().xmlns();
        String proper = nspref + ":" + pi.name();
        this.registerNamespace(nspref, pi.inClass());
        return proper;
    }

    public String getAndRegisterXmlName(ClassInfo ci) {
        String nspref = null;
        String fulnam = null;
        MapEntry me = ci.options().elementMapEntry(ci.name(), ci.encodingRule("xsd"));
        if (me != null) {
            if (me.p1 == null || me.p1.length() == 0) {
                return null;
            }
            fulnam = me.p1;
            String[] parts = fulnam.split(":");
            if (parts.length > 1) {
                nspref = parts[0];
            }
            this.registerNamespace(nspref);
        } else {
            nspref = ci.pkg().xmlns();
            fulnam = nspref + ":" + ci.name();
            this.registerNamespace(nspref, ci);
        }
        return fulnam;
    }

    public void registerNamespace(String xmlns, ClassInfo ci) {
        if (!this.namespaces.containsKey(xmlns)) {
            String ns = ci.pkg().targetNamespace();
            if (ns == null || ns.length() == 0) {
                this.registerNamespace(xmlns);
            } else {
                this.registerNamespace(xmlns, ns);
            }
        }
    }

    public XpathConstraintNode.XpathFragment translateConstraintToXpath(ClassInfo ci, OclConstraint c) {
        if (c == null) {
            return null;
        }
        if (ci.isAbstract()) {
            return null;
        }
        this.currentOclConstraintName = c.name();
        this.currentOclConstraintClass = c.contextClass();
        OclNode.Expression oclex = c.syntaxTree();
        XpathConstraintNode scn = this.translateConstraintToSchematronNode(oclex, null, false);
        if (scn == null) {
            return null;
        }
        XpathConstraintNode.BindingContext ctx = new XpathConstraintNode.BindingContext(XpathConstraintNode.BindingContext.CtxState.ATCURRENT);
        XpathConstraintNode.XpathFragment xpath = scn.translate(ctx);
        if (this.checkErrorsInXpathFragment(xpath)) {
            return null;
        }
        return xpath;
    }

    protected XpathConstraintNode translateConstraintToSchematronNode(OclNode ocl, XpathConstraintNode enclosing, boolean negate) {
        XpathConstraintNode scn = null;
        if (ocl instanceof OclNode.Expression) {
            OclNode.Expression ex = (OclNode.Expression)ocl;
            scn = this.translateConstraintToSchematronNode(ex.expression, null, negate);
            if (scn.containsError()) {
                return null;
            }
        } else if (ocl instanceof OclNode.IterationCallExp) {
            OclNode.IterationCallExp iter = (OclNode.IterationCallExp)ocl;
            scn = this.translateConstraintIterationToSchematronNode(iter, enclosing, negate);
        } else if (ocl instanceof OclNode.OperationCallExp) {
            OclNode.OperationCallExp oper = (OclNode.OperationCallExp)ocl;
            scn = this.translateConstraintOperationToSchematronNode(oper, enclosing, negate);
        } else if (ocl instanceof OclNode.AttributeCallExp) {
            OclNode.AttributeCallExp attr = (OclNode.AttributeCallExp)ocl;
            scn = this.translateConstraintAttributeToSchematronNode(attr, enclosing, negate);
        } else if (ocl instanceof OclNode.LiteralExp) {
            OclNode.LiteralExp lit = (OclNode.LiteralExp)ocl;
            scn = this.translateConstraintLiteralToSchematronNode(lit, enclosing, negate);
        } else if (ocl instanceof OclNode.VariableExp) {
            OclNode.VariableExp var = (OclNode.VariableExp)ocl;
            scn = new XpathConstraintNode.Variable(this, var.declaration, negate);
            if (enclosing != null) {
                enclosing.addChild(scn);
            }
        } else if (ocl instanceof OclNode.IfExp) {
            OclNode.IfExp ifex = (OclNode.IfExp)ocl;
            scn = this.translateConstraintIfExpToSchematronNode(ifex, enclosing, negate);
        } else if (ocl instanceof OclNode.LetExp) {
            this.result.addError(this, 102, this.currentOclConstraintName, this.currentOclConstraintClass.name());
            scn = new XpathConstraintNode.Error(this);
        } else {
            String clname = ocl.getClass().getSimpleName();
            this.result.addError(this, 101, clname, this.currentOclConstraintName, this.currentOclConstraintClass.name());
            scn = new XpathConstraintNode.Error(this);
        }
        return scn;
    }

    protected XpathConstraintNode translateConstraintIterationToSchematronNode(OclNode.IterationCallExp iter, XpathConstraintNode enclosing, boolean negate) {
        String opname = iter.selector.name;
        if (opname.equals("exists") || opname.equals("forAll")) {
            boolean isForAll = opname.equals("forAll");
            XpathConstraintNode.Exists exists = new XpathConstraintNode.Exists(this, iter.declarations[0], negate ^ isForAll);
            exists.addChild(this.translateConstraintToSchematronNode(iter.object, null, false));
            exists.addChild(this.translateConstraintToSchematronNode(iter.arguments[0], null, isForAll));
            if (enclosing != null) {
                enclosing.addChild(exists);
            }
            return exists;
        }
        if (opname.equals("isUnique")) {
            XpathConstraintNode.Unique unique = new XpathConstraintNode.Unique(this, iter.declarations[0], false);
            unique.addChild(this.translateConstraintToSchematronNode(iter.object, null, false));
            unique.addChild(this.translateConstraintToSchematronNode(iter.arguments[0], null, false));
            if (enclosing != null) {
                enclosing.addChild(unique);
            }
            return unique;
        }
        if (opname.equals("select")) {
            XpathConstraintNode.Select select = new XpathConstraintNode.Select(this, iter.declarations[0]);
            select.addChild(this.translateConstraintToSchematronNode(iter.object, null, false));
            select.addChild(this.translateConstraintToSchematronNode(iter.arguments[0], null, false));
            if (enclosing != null) {
                enclosing.addChild(select);
            }
            return select;
        }
        this.result.addError(this, 103, opname, this.currentOclConstraintName, this.currentOclConstraintClass.name());
        return new XpathConstraintNode.Error(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected XpathConstraintNode translateConstraintOperationToSchematronNode(OclNode.OperationCallExp oper, XpathConstraintNode enclosing, boolean negate) {
        String name;
        block34: {
            String[] invops;
            String[] relops;
            String opname;
            block35: {
                block33: {
                    opname = oper.selector.name;
                    if (opname.equals("implies")) {
                        boolean passencl;
                        boolean and = false;
                        boolean neg1 = true;
                        boolean neg2 = false;
                        if (negate) {
                            and = !and;
                            neg1 = !neg1;
                            neg2 = !neg2;
                        }
                        boolean bl = passencl = enclosing != null && enclosing.isAndOrLogic(and);
                        XpathConstraintNode scn = passencl ? enclosing : new XpathConstraintNode.Logic(this, and ? XpathConstraintNode.Logic.LogicType.AND : XpathConstraintNode.Logic.LogicType.OR);
                        this.translateConstraintToSchematronNode(oper.object, scn, neg1);
                        this.translateConstraintToSchematronNode(oper.arguments[0], scn, neg2);
                        if (passencl) return scn;
                        if (enclosing == null) return scn;
                        enclosing.addChild(scn);
                        return scn;
                    }
                    if (opname.equals("and") || opname.equals("or")) {
                        boolean passencl;
                        boolean and = opname.equals("and");
                        boolean neg = false;
                        if (negate) {
                            and = !and;
                            neg = !neg;
                        }
                        boolean bl = passencl = enclosing != null && enclosing.isAndOrLogic(and);
                        XpathConstraintNode scn = passencl ? enclosing : new XpathConstraintNode.Logic(this, and ? XpathConstraintNode.Logic.LogicType.AND : XpathConstraintNode.Logic.LogicType.OR);
                        this.translateConstraintToSchematronNode(oper.object, scn, neg);
                        this.translateConstraintToSchematronNode(oper.arguments[0], scn, neg);
                        if (passencl) return scn;
                        if (enclosing == null) return scn;
                        enclosing.addChild(scn);
                        return scn;
                    }
                    if (opname.equals("xor")) {
                        XpathConstraintNode.Logic.LogicType xor = XpathConstraintNode.Logic.LogicType.XOR;
                        if (negate) {
                            xor = XpathConstraintNode.Logic.LogicType.EQV;
                        }
                        XpathConstraintNode.Logic fcn = new XpathConstraintNode.Logic(this, xor);
                        fcn.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                        fcn.addChild(this.translateConstraintToSchematronNode(oper.arguments[0], null, false));
                        if (enclosing == null) return fcn;
                        enclosing.addChild(fcn);
                        return fcn;
                    }
                    if (opname.equals("not")) {
                        boolean bl;
                        OclNode oclNode = oper.object;
                        if (!negate) {
                            bl = true;
                            return this.translateConstraintToSchematronNode(oclNode, enclosing, bl);
                        }
                        bl = false;
                        return this.translateConstraintToSchematronNode(oclNode, enclosing, bl);
                    }
                    if ("<>=<=".indexOf(opname) < 0) break block33;
                    relops = new String[]{"=", "<>", "<", "<=", ">", ">="};
                    invops = new String[]{"<>", "=", ">=", ">", "<=", "<"};
                    name = opname;
                    if (!negate) break block34;
                    break block35;
                }
                if (opname.equals("notEmpty") || opname.equals("isEmpty")) {
                    XpathConstraintNode.Empty empty = new XpathConstraintNode.Empty(this, opname.equals("notEmpty") ^ negate);
                    empty.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                    if (enclosing == null) return empty;
                    enclosing.addChild(empty);
                    return empty;
                }
                if (opname.equals("size")) {
                    boolean setoper = oper.selector.category == OclNode.PropertyCategory.SETOPER;
                    XpathConstraintNode.Size size = new XpathConstraintNode.Size(this, setoper);
                    size.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                    return size;
                }
                if (opname.equals("concat")) {
                    XpathConstraintNode.Concatenate concat = new XpathConstraintNode.Concatenate(this);
                    concat.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                    concat.addChild(this.translateConstraintToSchematronNode(oper.arguments[0], null, false));
                    return concat;
                }
                if (opname.equals("substring")) {
                    XpathConstraintNode.Substring substr = new XpathConstraintNode.Substring(this);
                    substr.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                    substr.addChild(this.translateConstraintToSchematronNode(oper.arguments[0], null, false));
                    substr.addChild(this.translateConstraintToSchematronNode(oper.arguments[1], null, false));
                    return substr;
                }
                if (opname.equals("matches")) {
                    if (this.extensionFunctions.get("matches") == null) {
                        this.result.addError(this, 107, opname, this.currentOclConstraintName, this.currentOclConstraintClass.name());
                        return new XpathConstraintNode.Error(this);
                    }
                    XpathConstraintNode.Matches matches = new XpathConstraintNode.Matches(this);
                    matches.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                    matches.addChild(this.translateConstraintToSchematronNode(oper.arguments[0], null, false));
                    return matches;
                }
                if (opname.equals("length") || opname.equals("area")) {
                    this.result.addError(this, 103, opname, this.currentOclConstraintName, this.currentOclConstraintClass.name());
                    return new XpathConstraintNode.Error(this);
                }
                if (opname.equals("toUpper") || opname.equals("toLower")) {
                    this.result.addError(this, 103, opname, this.currentOclConstraintName, this.currentOclConstraintClass.name());
                    return new XpathConstraintNode.Error(this);
                }
                if ("+-*/".indexOf(opname) >= 0) {
                    XpathConstraintNode.Arithmetic arith = new XpathConstraintNode.Arithmetic(this, opname);
                    arith.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                    if (oper.arguments.length <= 0) return arith;
                    arith.addChild(this.translateConstraintToSchematronNode(oper.arguments[0], null, false));
                    return arith;
                }
                if (opname.equals("oclIsKindOf") || opname.equals("oclIsTypeOf")) {
                    boolean exactType = opname.equals("oclIsTypeOf");
                    XpathConstraintNode.KindOf kindOf = new XpathConstraintNode.KindOf(this, exactType, negate);
                    kindOf.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                    XpathConstraintNode clex = this.translateConstraintToSchematronNode(oper.arguments[0], null, false);
                    boolean assumeError = true;
                    if (clex instanceof XpathConstraintNode.Literal) {
                        XpathConstraintNode.Literal cllit = (XpathConstraintNode.Literal)clex;
                        OclNode.LiteralExp lex = cllit.literal;
                        if (lex instanceof OclNode.ClassLiteralExp) {
                            OclNode.ClassLiteralExp lcl = (OclNode.ClassLiteralExp)lex;
                            ClassInfo ci = lcl.umlClass;
                            kindOf.setClass(ci);
                            assumeError = false;
                        }
                    }
                    kindOf.addChild(clex);
                    if (assumeError) {
                        this.result.addError(this, 104, this.currentOclConstraintName, this.currentOclConstraintClass.name(), "oclIsKindOf");
                        XpathConstraintNode.Error err = new XpathConstraintNode.Error(this);
                        if (enclosing == null) return err;
                        enclosing.addChild(err);
                        return err;
                    }
                    if (enclosing == null) return kindOf;
                    enclosing.addChild(kindOf);
                    return kindOf;
                }
                if (opname.equals("oclAsType")) {
                    XpathConstraintNode.Cast cast = new XpathConstraintNode.Cast(this);
                    cast.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
                    XpathConstraintNode clex = this.translateConstraintToSchematronNode(oper.arguments[0], null, false);
                    boolean assumeError = true;
                    if (clex instanceof XpathConstraintNode.Literal) {
                        XpathConstraintNode.Literal cllit = (XpathConstraintNode.Literal)clex;
                        OclNode.LiteralExp lex = cllit.literal;
                        if (lex instanceof OclNode.ClassLiteralExp) {
                            OclNode.ClassLiteralExp lcl = (OclNode.ClassLiteralExp)lex;
                            ClassInfo ci = lcl.umlClass;
                            cast.setClass(ci);
                            assumeError = false;
                        }
                    }
                    cast.addChild(clex);
                    if (assumeError) {
                        this.result.addError(this, 104, this.currentOclConstraintName, this.currentOclConstraintClass.name(), "oclAsType");
                        XpathConstraintNode.Error err = new XpathConstraintNode.Error(this);
                        if (enclosing == null) return err;
                        enclosing.addChild(err);
                        return err;
                    }
                    if (enclosing == null) return cast;
                    enclosing.addChild(cast);
                    return cast;
                }
                if (opname.equals("allInstances")) {
                    XpathConstraintNode clex = this.translateConstraintToSchematronNode(oper.object, null, false);
                    boolean assumeError = true;
                    ClassInfo ci = null;
                    if (clex instanceof XpathConstraintNode.Literal) {
                        XpathConstraintNode.Literal cllit = (XpathConstraintNode.Literal)clex;
                        OclNode.LiteralExp lex = cllit.literal;
                        if (lex instanceof OclNode.ClassLiteralExp) {
                            OclNode.ClassLiteralExp lcl = (OclNode.ClassLiteralExp)lex;
                            ci = lcl.umlClass;
                            if (ci != null) {
                                assumeError = false;
                            }
                        }
                    }
                    if (assumeError) {
                        this.result.addError(this, 105, this.currentOclConstraintName, this.currentOclConstraintClass.name());
                        XpathConstraintNode.Error err = new XpathConstraintNode.Error(this);
                        if (enclosing == null) return err;
                        enclosing.addChild(err);
                        return err;
                    }
                    XpathConstraintNode.AllInstances allinst = new XpathConstraintNode.AllInstances(this, ci, negate);
                    if (enclosing == null) return allinst;
                    enclosing.addChild(allinst);
                    return allinst;
                }
                if (!opname.startsWith("error_")) {
                    this.result.addError(this, 103, opname, this.currentOclConstraintName, this.currentOclConstraintClass.name());
                    return new XpathConstraintNode.Error(this);
                }
                XpathConstraintNode.MessageComment msgcom = new XpathConstraintNode.MessageComment(this, opname);
                OclNode[] arr$ = oper.arguments;
                int len$ = arr$.length;
                int i$ = 0;
                while (i$ < len$) {
                    OclNode arg = arr$[i$];
                    msgcom.addChild(this.translateConstraintToSchematronNode(arg, null, false));
                    ++i$;
                }
                return msgcom;
            }
            for (int i = 0; i < relops.length; ++i) {
                if (!relops[i].equals(opname)) continue;
                name = invops[i];
                break;
            }
        }
        XpathConstraintNode.Comparison scn = new XpathConstraintNode.Comparison(this, name);
        scn.addChild(this.translateConstraintToSchematronNode(oper.object, null, false));
        scn.addChild(this.translateConstraintToSchematronNode(oper.arguments[0], null, false));
        if (enclosing == null) return scn;
        enclosing.addChild(scn);
        return scn;
    }

    protected XpathConstraintNode translateConstraintAttributeToSchematronNode(OclNode.AttributeCallExp attr, XpathConstraintNode enclosing, boolean negate) {
        XpathConstraintNode objnode;
        PropertyInfo pi;
        boolean nilreason;
        String attrname = attr.selector.name;
        int absorptionType = 0;
        Info info = attr.selector.modelProperty;
        if (info instanceof PropertyInfo && (nilreason = (pi = (PropertyInfo)info).implementedByNilReason())) {
            absorptionType = 2;
        }
        if ((objnode = this.translateConstraintToSchematronNode(attr.object, null, false)) instanceof XpathConstraintNode.Variable || objnode instanceof XpathConstraintNode.AllInstances || objnode instanceof XpathConstraintNode.Select) {
            XpathConstraintNode.Attribute atn = objnode.generatingAttribute();
            if (atn != null && atn.isPropertyAbsorbing()) {
                if (absorptionType == 0) {
                    absorptionType = 1;
                }
                atn.appendAbsorbedAttribute(absorptionType, attr);
                return objnode;
            }
            atn = new XpathConstraintNode.Attribute(this, attr, negate);
            atn.addChild(objnode);
            if (enclosing != null) {
                enclosing.addChild(atn);
            }
            return atn;
        }
        if (objnode instanceof XpathConstraintNode.Attribute) {
            XpathConstraintNode.Attribute atn = (XpathConstraintNode.Attribute)objnode;
            if (atn.isPropertyAbsorbing()) {
                if (absorptionType == 0) {
                    absorptionType = 1;
                }
                atn.appendAbsorbedAttribute(absorptionType, attr);
            } else {
                atn.appendAttribute(attr);
            }
            if (enclosing != null) {
                enclosing.addChild(atn);
            }
            return atn;
        }
        this.result.addError(this, 106, attrname, this.currentOclConstraintName, this.currentOclConstraintClass.name());
        return new XpathConstraintNode.Error(this);
    }

    protected XpathConstraintNode translateConstraintLiteralToSchematronNode(OclNode.LiteralExp lit, XpathConstraintNode enclosing, boolean negate) {
        XpathConstraintNode.Literal litn = new XpathConstraintNode.Literal(this, lit, negate);
        if (enclosing != null) {
            enclosing.addChild(litn);
        }
        return litn;
    }

    protected XpathConstraintNode translateConstraintIfExpToSchematronNode(OclNode.IfExp ifex, XpathConstraintNode enclosing, boolean negate) {
        XpathConstraintNode.IfThenElse ifthenelse = new XpathConstraintNode.IfThenElse(this);
        ifthenelse.addChild(this.translateConstraintToSchematronNode(ifex.condition, null, false));
        OclNode[] branch = new OclNode[]{ifex.ifExpression, ifex.elseExpression};
        int is = negate ? 1 : 0;
        for (int i = 0; i < 2; ++i) {
            ifthenelse.addChild(this.translateConstraintToSchematronNode(branch[is], null, false));
            is = 1 - is;
        }
        if (enclosing != null) {
            enclosing.addChild(ifthenelse);
        }
        return ifthenelse;
    }

    private boolean checkErrorsInXpathFragment(XpathConstraintNode.XpathFragment xpath) {
        String allofit = "";
        if (xpath.lets != null) {
            for (String let : xpath.lets.values()) {
                allofit = allofit + let;
            }
        }
        allofit = allofit + xpath.fragment;
        Pattern p = Pattern.compile("\\*\\*\\*ERROR\\[(.*?)\\]\\*\\*\\*");
        Matcher m = p.matcher(allofit);
        int count = 0;
        while (m.find()) {
            ++count;
            String argsl = m.group(1);
            String[] args = argsl.split(",");
            int mnr = Integer.parseInt(args[0]);
            if (args.length == 1) {
                this.result.addError(this, mnr, this.currentOclConstraintName, this.currentOclConstraintClass.name());
                continue;
            }
            if (args.length < 2) continue;
            this.result.addError(this, mnr, this.currentOclConstraintName, this.currentOclConstraintClass.name(), args[1]);
        }
        return count > 0;
    }

    public String message(int mnr) {
        String mess = this.messageText(mnr);
        if (mess == null) {
            return null;
        }
        String prefix = "";
        if (mess.startsWith("??")) {
            prefix = "??";
            mess = mess.substring(2);
        }
        return prefix + "Xpath/Schematron Target: " + mess;
    }

    protected String messageText(int mnr) {
        switch (mnr) {
            case 101: {
                return "Failure to compile OCL constraint named \"$2$\" in class \"$3$\". Node class \"$1$\" not implemented.";
            }
            case 102: {
                return "Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\" assignment construct \"let\" not supported.";
            }
            case 103: {
                return "Failure to compile OCL constraint named \"$2$\" in class \"$3$\". Operation \"$1$\" not implemented.";
            }
            case 104: {
                return "Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\" argument to operator \"$3$\" must be class constant.";
            }
            case 105: {
                return "Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\" object of operator \"allInstances\" must be class constant.";
            }
            case 106: {
                return "Failure to compile OCL constraint named \"$2$\" in class \"$3$\". Attribute construct named \"$1$\" not implemented.";
            }
            case 107: {
                return "Failure to compile OCL constraint named \"$2$\" in class \"$3$\". Schematron extension operation \"$1$\" is not properly configured.";
            }
            case 121: {
                return "Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\" attribute access expressions in isUnique() bodies must not contain attributes with a cardinality > 1.";
            }
            case 122: {
                return "Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\" isUnique bodies must not contain expressions other than constants, identity or attribute access.";
            }
            case 123: {
                return "Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\" toUpper() or toLower() CharacterString operations are not supported by Xpath 1.0.";
            }
            case 124: {
                return "Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\" variable \"$3$\" used in nested iterator construct cannot be resolved due to limitations of Xpath 1.0.";
            }
            case 125: {
                return "Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\" 'current date' OCL extension cannot be expressed in Xpath 1.0.";
            }
            case 126: {
                return "Implementation restriction - in OCL constraint \"$1$\" in class \"$2$\" comparison between structured non-object types not supported.";
            }
        }
        return null;
    }

    public static class ExtensionFunctionTemplate {
        public String nsPrefix;
        public String namespace;
        public String function;

        public ExtensionFunctionTemplate(String nsp, String ns, String fct) {
            this.nsPrefix = nsp;
            this.namespace = ns;
            this.function = fct;
        }
    }
}

