/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.XmlSchema;

import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Ocl.OclNode;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.SchematronSchema;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema;
import de.interactive_instruments.ShapeChange.Type;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SchematronConstraintNode {
    protected ArrayList<SchematronConstraintNode> children = new ArrayList();
    protected boolean negated = false;
    protected SchematronConstraintNode parent = null;
    protected SchematronSchema schemaObject = null;

    public void addChild(SchematronConstraintNode child) {
        this.children.add(child);
        child.parent = this;
    }

    public boolean isAndOrLogic(boolean isAnd) {
        return false;
    }

    public boolean isDependentOn(OclNode.Declaration vardecl) {
        for (SchematronConstraintNode scn : this.children) {
            if (!scn.isDependentOn(vardecl)) continue;
            return true;
        }
        return false;
    }

    public boolean bindsVariable(OclNode.Declaration vardecl) {
        return false;
    }

    public boolean isVarOrAttribBased(OclNode.Declaration vardecl) {
        return false;
    }

    public Attribute generatingAttribute() {
        return null;
    }

    public boolean isMultiple() {
        return false;
    }

    public boolean hasSimpleType() {
        return true;
    }

    public boolean hasIdentity() {
        return false;
    }

    public boolean containsError() {
        if (this instanceof Error) {
            return true;
        }
        for (SchematronConstraintNode node : this.children) {
            if (!node.containsError()) continue;
            return true;
        }
        return false;
    }

    public abstract XpathFragment translate(BindingContext var1);

    public static class MessageComment
    extends SchematronConstraintNode {
        protected String name = null;

        public MessageComment(SchematronSchema schemaObject, String name) {
            this.schemaObject = schemaObject;
            this.name = name;
        }

        public String getErrorNumber() {
            return this.name.substring(6);
        }

        public String[] compileAsMessageArgumentList() {
            String[] arglist = new String[this.children.size()];
            int i = 0;
            for (SchematronConstraintNode arg : this.children) {
                XpathFragment sql = arg.translate(null);
                arglist[i++] = sql.fragment == null ? "*ERROR*" : sql.fragment;
            }
            return arglist;
        }

        public XpathFragment translate(BindingContext ctx) {
            return null;
        }
    }

    public static class Error
    extends SchematronConstraintNode {
        public Error(SchematronSchema schemaObject) {
            this.schemaObject = schemaObject;
        }

        public XpathFragment translate(BindingContext ctx) {
            return null;
        }
    }

    public static class Let
    extends SchematronConstraintNode {
        OclNode.Declaration[] vardecls;
        BindingContext letctx;

        public Let(SchematronSchema schemaObject, OclNode.Declaration[] vardecls) {
            this.schemaObject = schemaObject;
            this.vardecls = vardecls;
        }

        public boolean bindsVariable(OclNode.Declaration vardecl) {
            for (OclNode.Declaration dcl : this.vardecls) {
                if (dcl != vardecl) continue;
                return true;
            }
            return false;
        }

        public XpathFragment translate(BindingContext ctx) {
            SchematronConstraintNode body = (SchematronConstraintNode)this.children.get(this.children.size() - 1);
            this.letctx = ctx;
            XpathFragment xpt = body.translate(ctx);
            return xpt;
        }
    }

    public static class IfThenElse
    extends SchematronConstraintNode {
        public IfThenElse(SchematronSchema schemaObject) {
            this.schemaObject = schemaObject;
        }

        public boolean hasSimpleType() {
            return ((SchematronConstraintNode)this.children.get(1)).hasSimpleType() && ((SchematronConstraintNode)this.children.get(2)).hasSimpleType();
        }

        public XpathFragment translate(BindingContext ctx) {
            SchematronConstraintNode con = (SchematronConstraintNode)this.children.get(0);
            SchematronConstraintNode thn = (SchematronConstraintNode)this.children.get(1);
            SchematronConstraintNode els = (SchematronConstraintNode)this.children.get(2);
            XpathFragment xptthn = thn.translate(ctx);
            XpathFragment xptels = els.translate(ctx);
            XpathType thntype = xptthn.type;
            XpathType elstype = xptels.type;
            String elsepart = xptthn.merge(xptels);
            if (thntype == XpathType.NODESET && elstype == XpathType.NODESET) {
                XpathFragment xptcon = con.translate(xptthn.atEnd);
                String conpart = xptthn.merge(xptcon);
                String convar = xptthn.findOrAdd(conpart);
                xptthn.fragment = xptthn.fragment + "[$" + convar + "] | " + elsepart + "[not($" + convar + ")]";
                xptthn.priority = 8;
            } else {
                XpathFragment xptcon = con.translate(ctx);
                String conpart = xptthn.merge(xptcon);
                String convar = xptthn.findOrAdd(conpart);
                String thnvar = xptthn.findOrAdd(xptthn.fragment);
                String elsvar = xptthn.findOrAdd(elsepart);
                xptthn.fragment = "concat( substring($" + thnvar + "," + "number(not($" + convar + "))*" + "string-length($" + thnvar + ")+1), " + "substring($" + elsvar + "," + "number($" + convar + ")*" + "string-length($" + elsvar + ")+1)" + " )";
                xptthn.priority = 11;
                xptthn.atEnd.setState(BindingContext.CtxState.NONE);
                if (thntype == XpathType.NUMBER || elstype == XpathType.NUMBER) {
                    xptthn.fragment = "number( " + xptthn.fragment + " )";
                    xptthn.type = XpathType.NUMBER;
                } else if (thntype == XpathType.BOOLEAN || elstype == XpathType.BOOLEAN) {
                    xptthn.fragment = "boolean( " + xptthn.fragment + " )";
                    xptthn.type = XpathType.BOOLEAN;
                } else {
                    xptthn.type = XpathType.STRING;
                }
            }
            return xptthn;
        }
    }

    public static class Literal
    extends SchematronConstraintNode {
        OclNode.LiteralExp literal;

        public Literal(SchematronSchema schemaObject, OclNode.LiteralExp lit, boolean neg) {
            this.schemaObject = schemaObject;
            this.literal = lit;
            this.negated = neg;
        }

        public XpathFragment translate(BindingContext ctx) {
            String value = this.literal.asString();
            XpathType type = XpathType.STRING;
            if (this.literal instanceof OclNode.StringLiteralExp) {
                value = "'" + value + "'";
            } else if (this.literal instanceof OclNode.EnumerationLiteralExp) {
                OclNode.EnumerationLiteralExp litex = (OclNode.EnumerationLiteralExp)this.literal;
                ClassInfo ci = litex.dataType.umlClass;
                if (ci != null && ci.name().equals("Boolean")) {
                    boolean val = value.equalsIgnoreCase("TRUE");
                    if (this.negated) {
                        val = !val;
                    }
                    value = val ? "true()" : "false()";
                    type = XpathType.BOOLEAN;
                } else {
                    boolean iscodelist = ci != null && ci.category() == 2;
                    String clUri = "";
                    String clVPat = "{value}";
                    if (iscodelist) {
                        String vp;
                        String uri = ci.taggedValue("codeList");
                        if (uri != null && uri.length() > 0) {
                            clVPat = "{codeList}/{value}";
                            clUri = uri;
                        }
                        if ((vp = ci.taggedValue("codeListValuePattern")) != null && vp.length() > 0) {
                            clVPat = vp;
                        }
                    }
                    clVPat = clVPat.replace("{value}", value);
                    value = clVPat.replace("{codeList}", clUri);
                    value = "'" + value + "'";
                }
            } else if (this.literal instanceof OclNode.BooleanLiteralExp) {
                OclNode.BooleanLiteralExp lit = (OclNode.BooleanLiteralExp)this.literal;
                boolean val = lit.value;
                if (this.negated) {
                    val = !val;
                }
                value = val ? "true()" : "false()";
                type = XpathType.BOOLEAN;
            } else if (this.literal instanceof OclNode.IntegerLiteralExp || this.literal instanceof OclNode.RealLiteralExp) {
                type = XpathType.NUMBER;
            } else if (this.literal instanceof OclNode.DateTimeLiteralExp) {
                OclNode.DateTimeLiteralExp lt = (OclNode.DateTimeLiteralExp)this.literal;
                if (lt.current) {
                    value = "***ERROR[125]***";
                } else {
                    GregorianCalendar dt = lt.dateTime;
                    int y = dt.get(1);
                    int m = dt.get(2) + 1;
                    int d = dt.get(5);
                    value = String.format("'%04d-%02d-%02d'", y, m, d);
                }
                type = XpathType.BOOLEAN;
            } else if (this.literal instanceof OclNode.OclVoidLiteralExp) {
                value = "/*[false()]";
                type = XpathType.NODESET;
            }
            XpathFragment xpt = new XpathFragment(11, value, type);
            return xpt;
        }
    }

    public static class Attribute
    extends SchematronConstraintNode {
        protected AttrComp[] attributes;

        public Attribute(SchematronSchema schemaObject, OclNode.AttributeCallExp attr, boolean negated) {
            this.schemaObject = schemaObject;
            this.attributes = new AttrComp[]{new AttrComp(attr)};
            this.negated = negated;
        }

        public Attribute(SchematronSchema schemaObject, AttrComp atc, boolean negated) {
            this.schemaObject = schemaObject;
            this.attributes = new AttrComp[]{new AttrComp(atc)};
            this.negated = negated;
        }

        public void appendAttribute(OclNode.AttributeCallExp aex) {
            AttrComp[] attribs = new AttrComp[this.attributes.length + 1];
            for (int i = 0; i < this.attributes.length; ++i) {
                attribs[i] = this.attributes[i];
            }
            attribs[this.attributes.length] = new AttrComp(aex);
            this.attributes = attribs;
        }

        public void appendAttribute(AttrComp atc) {
            AttrComp[] attribs = new AttrComp[this.attributes.length + 1];
            for (int i = 0; i < this.attributes.length; ++i) {
                attribs[i] = this.attributes[i];
            }
            attribs[this.attributes.length] = new AttrComp(atc);
            this.attributes = attribs;
        }

        public void appendAbsorbedAttribute(int absorptionType, OclNode.AttributeCallExp attr) {
            int last = this.attributes.length - 1;
            this.attributes[last].absAttr = attr;
            this.attributes[last].absType = absorptionType;
        }

        public Attribute splitBefore(int at) {
            if (at < 0 || at >= this.attributes.length) {
                return null;
            }
            Attribute atrite = new Attribute(this.schemaObject, this.attributes[at], this.negated);
            for (int i = at + 1; i < this.attributes.length; ++i) {
                this.appendAttribute(this.attributes[i]);
            }
            if (at == 0) {
                atrite.addChild((SchematronConstraintNode)this.children.get(0));
            } else {
                Attribute atleft = new Attribute(this.schemaObject, this.attributes[0], this.negated);
                for (int i = 1; i < at; ++i) {
                    this.appendAttribute(this.attributes[i]);
                }
                atleft.addChild((SchematronConstraintNode)this.children.get(0));
                atrite.addChild(atleft);
            }
            return atrite;
        }

        public boolean isPropertyAbsorbing() {
            AttrComp ac = this.attributes[this.attributes.length - 1];
            OclNode.AttributeCallExp acex = ac.absType == 0 ? ac.main : ac.absAttr;
            PropertyInfo pi = (PropertyInfo)acex.selector.modelProperty;
            Type t = pi.typeInfo();
            ClassInfo ci = this.schemaObject.model.classById(t.id);
            return ci != null && ci.category() == 9;
        }

        public boolean isVarOrAttribBased(OclNode.Declaration vardecl) {
            return ((SchematronConstraintNode)this.children.get(0)).isVarOrAttribBased(vardecl);
        }

        public Attribute generatingAttribute() {
            return this;
        }

        public boolean isMultiple() {
            for (AttrComp at : this.attributes) {
                if (at.main.multMapping != OclNode.MultiplicityMapping.ONE2MANY && (at.absType != 1 || at.absAttr.multMapping != OclNode.MultiplicityMapping.ONE2MANY)) continue;
                return true;
            }
            return false;
        }

        public boolean hasSimpleType() {
            int last = this.attributes.length - 1;
            return this.hasSimpleType(last);
        }

        public boolean hasSimpleType(int idx) {
            boolean result = true;
            switch (this.attributes[idx].absType) {
                case 0: {
                    ClassInfo ci = this.attributes[idx].main.dataType.umlClass;
                    if (ci == null) break;
                    result = !XmlSchema.classHasObjectElement(ci);
                    break;
                }
                case 1: {
                    ClassInfo ci = this.attributes[idx].absAttr.dataType.umlClass;
                    if (ci == null) break;
                    result = !XmlSchema.classHasObjectElement(ci);
                    break;
                }
            }
            return result;
        }

        public boolean hasIdentity() {
            int last = this.attributes.length - 1;
            return this.hasIdentity(last);
        }

        public boolean hasIdentity(int idx) {
            boolean result = false;
            switch (this.attributes[idx].absType) {
                case 0: {
                    ClassInfo ci = this.attributes[idx].main.dataType.umlClass;
                    if (ci == null) break;
                    result = XmlSchema.classCanBeReferenced(ci);
                    break;
                }
                case 1: {
                    ClassInfo ci = this.attributes[idx].absAttr.dataType.umlClass;
                    if (ci == null) break;
                    result = XmlSchema.classCanBeReferenced(ci);
                    break;
                }
            }
            return result;
        }

        public XpathFragment translate(BindingContext ctx) {
            PropertyInfo[] props = new PropertyInfo[this.attributes.length];
            for (int i = 0; i < props.length; ++i) {
                props[i] = (PropertyInfo)this.attributes[i].main.selector.modelProperty;
            }
            XpathFragment obj = ((SchematronConstraintNode)this.children.get(0)).translate(ctx);
            String alpha = this.schemaObject.alpha;
            String beta = this.schemaObject.beta;
            boolean alphaEx = alpha != null && alpha.length() > 0;
            boolean betaEx = beta != null && beta.length() > 0;
            for (int idx = 0; idx < props.length; ++idx) {
                PropertyInfo pi = props[idx];
                int conCode = 0;
                String cid = pi.typeInfo().id;
                ClassInfo ci = null;
                if (cid != null) {
                    ci = pi.model().classById(cid);
                }
                if (this.attributes[idx].absType == 1) {
                    ci = this.attributes[idx].absAttr.dataType.umlClass;
                }
                if (!this.hasSimpleType(idx)) {
                    conCode = 1;
                    if (ci != null && XmlSchema.classCanBeReferenced(ci)) {
                        String ref = pi.inlineOrByReference();
                        if (ref == null) {
                            ref = "";
                        }
                        if (ref.equals("byreference")) {
                            conCode = 2;
                        } else if (!ref.equals("inline")) {
                            conCode = 3;
                        }
                    }
                }
                String proper = this.schemaObject.getAndRegisterXmlName(pi);
                if (conCode == 0) {
                    String clvp;
                    String v;
                    boolean atcurr;
                    if (obj.fragment.length() > 0) {
                        obj.fragment = obj.fragment + "/";
                        obj.priority = 9;
                    }
                    obj.fragment = obj.fragment + proper;
                    boolean is19139 = pi.matches("rule-xsd-all-naming-19139") || ci != null && ci.matches("rule-xsd-cls-standard-19139-property-types");
                    boolean iscodelist = ci != null && ci.category() == 2 && (ci.matches("rule-xsd-cls-codelist-asDictionaryGml33") && ci.asDictionaryGml33() || ci.matches("rule-xsd-cls-codelist-asDictionary") && ci.asDictionary());
                    String clvpat = "{value}";
                    int nsubst = 1;
                    if (ci != null && iscodelist && !this.schemaObject.options.matchesEncRule(pi.encodingRule("xsd"), "gml33") && !is19139) {
                        String vp;
                        String uri = ci.taggedValue("codeList");
                        if (uri != null && uri.length() > 0) {
                            clvpat = "{codeList}/{value}";
                        }
                        if ((vp = ci.taggedValue("codeListValuePattern")) != null && vp.length() > 0) {
                            clvpat = vp;
                        }
                        clvpat = clvpat.replace("{codeList}", "',{codeList},'");
                        if ((clvpat = clvpat.replace("{value}", "',{value},'")).startsWith("',")) {
                            clvpat = clvpat.substring(2);
                        }
                        if (clvpat.endsWith(",'")) {
                            clvpat = clvpat.substring(0, clvpat.length() - 2);
                        }
                        if (!clvpat.startsWith("{")) {
                            clvpat = "'" + clvpat;
                        }
                        if (!clvpat.endsWith("}")) {
                            clvpat = clvpat + "'";
                        }
                        if (!clvpat.equals("{value}")) {
                            clvpat = "concat(" + clvpat + ")";
                            nsubst = 2;
                        }
                    }
                    if (this.attributes[idx].absType == 2) {
                        if (is19139) {
                            obj.fragment = obj.fragment + "[not(*)]/@gco:nilReason";
                            this.schemaObject.registerNamespace("gco");
                        } else {
                            obj.fragment = obj.fragment + "[@xsi:nil='true']/@nilReason";
                            this.schemaObject.registerNamespace("xsi");
                        }
                        obj.priority = 9;
                    }
                    if (obj.atEnd != null) {
                        obj.atEnd.addStep();
                    }
                    boolean bl = atcurr = ctx.state == BindingContext.CtxState.ATCURRENT;
                    if (this.attributes[idx].absType != 0) continue;
                    if (is19139) {
                        obj.fragment = obj.fragment + "/*";
                        if (obj.atEnd != null) {
                            obj.atEnd.addStep();
                        }
                        if (!iscodelist) continue;
                        if (nsubst == 2 && atcurr) {
                            v = obj.findOrAdd(obj.fragment);
                            obj.fragment = "$" + v;
                        }
                        clvp = clvpat.replace("{codeList}", obj.fragment + "/@codeList");
                        obj.fragment = clvp.replace("{value}", obj.fragment + "/@codeListValue");
                        continue;
                    }
                    if (!iscodelist) continue;
                    if (!ci.matches("rule-xsd-cls-codelist-asDictionaryGml33")) {
                        clvp = clvpat.replace("{codeList}", obj.fragment + "/@codeSpace");
                        obj.fragment = clvp.replace("{value}", obj.fragment);
                        continue;
                    }
                    if (nsubst == 2 && atcurr) {
                        v = obj.findOrAdd(obj.fragment);
                        obj.fragment = "$" + v;
                    }
                    obj.fragment = obj.fragment + "/@xlink:href";
                    this.schemaObject.registerNamespace("xlink");
                    continue;
                }
                String frag_inl = null;
                String frag_ref = null;
                boolean isVar = false;
                if (conCode == 3 && obj.atEnd.state == BindingContext.CtxState.OTHER && obj.fragment.length() > 0 && !obj.fragment.startsWith(".")) {
                    String var = obj.findOrAdd(obj.fragment);
                    obj.fragment = "$" + var;
                    isVar = true;
                }
                if (conCode == 1 || conCode == 3) {
                    frag_inl = obj.fragment;
                    if (frag_inl.length() > 0) {
                        frag_inl = frag_inl + "/";
                    }
                    frag_inl = frag_inl + proper;
                    if (obj.atEnd != null) {
                        obj.atEnd.addStep();
                    }
                    frag_inl = frag_inl + "/*";
                    if (obj.atEnd != null) {
                        obj.atEnd.addStep();
                    }
                }
                if (conCode == 2 || conCode == 3) {
                    String attxlink;
                    if (!isVar) {
                        String frag;
                        BindingContext ctx1 = ctx.clone();
                        ctx1.setState(BindingContext.CtxState.OTHER);
                        XpathFragment obj1 = ((SchematronConstraintNode)this.children.get(0)).translate(ctx1);
                        obj.fragment = frag = obj.merge(obj1);
                    }
                    if ((attxlink = obj.fragment).length() > 0) {
                        attxlink = attxlink + "/";
                    }
                    attxlink = attxlink + proper;
                    attxlink = attxlink + "/@xlink:href";
                    frag_ref = "//*[";
                    if (alphaEx || betaEx) {
                        frag_ref = frag_ref + "concat(";
                        if (alphaEx) {
                            frag_ref = frag_ref + "'" + alpha + "',";
                        }
                        frag_ref = frag_ref + "@gml:id";
                        if (betaEx) {
                            frag_ref = frag_ref + ",'" + beta + "'";
                        }
                        frag_ref = frag_ref + ")";
                    } else {
                        frag_ref = frag_ref + "@gml:id";
                    }
                    frag_ref = frag_ref + "=" + attxlink + "]";
                    this.schemaObject.registerNamespace("xlink");
                    this.schemaObject.registerNamespace("gml");
                    if (obj.atEnd != null) {
                        obj.atEnd.setState(BindingContext.CtxState.OTHER);
                    }
                }
                if (conCode == 3) {
                    obj.fragment = frag_inl + " | " + frag_ref;
                    obj.priority = 8;
                    continue;
                }
                if (conCode == 1) {
                    obj.fragment = frag_inl;
                    obj.priority = 9;
                    continue;
                }
                obj.fragment = frag_ref;
                obj.priority = 10;
            }
            if (this.negated) {
                obj.fragment = "not(" + obj.fragment + ")";
                obj.priority = 11;
                obj.atEnd.setState(BindingContext.CtxState.NONE);
            }
            return obj;
        }

        protected static class AttrComp {
            protected OclNode.AttributeCallExp main = null;
            protected OclNode.AttributeCallExp absAttr = null;
            protected int absType = 0;

            protected AttrComp(OclNode.AttributeCallExp at) {
                this.main = at;
            }

            protected AttrComp(AttrComp atc) {
                this.main = atc.main;
                this.absAttr = atc.absAttr;
                this.absType = atc.absType;
            }
        }
    }

    public static class Variable
    extends SchematronConstraintNode {
        protected OclNode.Declaration vardecl;

        public Variable(SchematronSchema schemaObject, OclNode.Declaration vardecl, boolean neg) {
            this.schemaObject = schemaObject;
            this.vardecl = vardecl;
            this.negated = neg;
        }

        public String getName() {
            return this.vardecl.name;
        }

        public boolean isDependentOn(OclNode.Declaration vardecl) {
            return this.vardecl == vardecl;
        }

        public boolean isVarOrAttribBased(OclNode.Declaration vardecl) {
            return this.isDependentOn(vardecl);
        }

        public Attribute generatingAttribute() {
            SchematronConstraintNode binds = null;
            SchematronConstraintNode scn = this.parent;
            while (scn != null) {
                if (scn.bindsVariable(this.vardecl)) {
                    binds = scn;
                    break;
                }
                scn = scn.parent;
            }
            if (binds == null) {
                return null;
            }
            return binds.children.get(0).generatingAttribute();
        }

        public boolean hasSimpleType() {
            SchematronConstraintNode binds = null;
            SchematronConstraintNode scn = this.parent;
            while (scn != null) {
                if (scn.bindsVariable(this.vardecl)) {
                    binds = scn;
                    break;
                }
                scn = scn.parent;
            }
            if (binds == null) {
                return false;
            }
            return binds.children.get(0).hasSimpleType();
        }

        public boolean hasIdentity() {
            SchematronConstraintNode binds = null;
            SchematronConstraintNode scn = this.parent;
            while (scn != null) {
                if (scn.bindsVariable(this.vardecl)) {
                    binds = scn;
                    break;
                }
                scn = scn.parent;
            }
            if (binds == null) {
                return true;
            }
            return binds.children.get(0).hasIdentity();
        }

        public XpathFragment translate(BindingContext ctx) {
            XpathFragment xpt = new XpathFragment(11, "");
            SchematronConstraintNode binds = null;
            SchematronConstraintNode scn = this.parent;
            while (scn != null) {
                if (scn.bindsVariable(this.vardecl)) {
                    binds = scn;
                    break;
                }
                scn = scn.parent;
            }
            if (binds != null && binds instanceof Let) {
                Let let = (Let)binds;
                SchematronConstraintNode expr = null;
                for (int i = 0; i < let.children.size() - 1; ++i) {
                    if (let.vardecls[i] != this.vardecl) continue;
                    expr = (SchematronConstraintNode)let.children.get(i);
                    break;
                }
                if (let.letctx.state == BindingContext.CtxState.ATCURRENT) {
                    xpt = expr.translate(let.letctx);
                    String var = xpt.findOrAdd(xpt.fragment);
                    xpt.fragment = "$" + var;
                    xpt.priority = 11;
                } else {
                    xpt = expr.translate(ctx);
                }
            } else if (this.getName().equals("self")) {
                xpt.atEnd = new BindingContext(BindingContext.CtxState.ATCURRENT);
                if (ctx.state != BindingContext.CtxState.ATCURRENT) {
                    xpt.fragment = "current()";
                }
            } else if (ctx.state != BindingContext.CtxState.OTHER) {
                xpt.fragment = "***ERROR[124," + this.getName() + "]***";
            } else {
                int i;
                int steps = 0;
                boolean found = false;
                if (ctx.vars != null) {
                    for (i = ctx.vars.size() - 1; i >= 0; --i) {
                        BindingContext.CtxElmt ce = ctx.vars.get(i);
                        steps += ce.noOfSteps;
                        if (ce.vardecl != this.vardecl) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    xpt.fragment = "***ERROR[124," + this.getName() + "]***";
                } else {
                    if (steps > 0) {
                        xpt.fragment = "..";
                        for (i = 2; i <= steps; ++i) {
                            xpt.fragment = xpt.fragment + "/..";
                        }
                    }
                    if (steps > 1) {
                        xpt.priority = 9;
                    }
                }
                xpt.atEnd = new BindingContext(BindingContext.CtxState.OTHER);
            }
            return xpt;
        }
    }

    public static class Arithmetic
    extends SchematronConstraintNode {
        String operation;

        public Arithmetic(SchematronSchema schemaObject, String oper) {
            this.schemaObject = schemaObject;
            this.operation = oper;
        }

        public XpathFragment translate(BindingContext ctx) {
            XpathFragment xpt1 = ((SchematronConstraintNode)this.children.get(0)).translate(ctx);
            if (this.children.size() == 1) {
                if (xpt1.priority <= 7) {
                    xpt1.bracket();
                }
                xpt1.priority = 7;
            } else {
                XpathFragment xpt2 = ((SchematronConstraintNode)this.children.get(1)).translate(ctx);
                int prio = 5;
                if (this.operation.equals("*") || this.operation.equals("/")) {
                    prio = 6;
                }
                if (xpt1.priority < prio) {
                    xpt1.bracket();
                }
                if (this.operation.equals("/") || this.operation.equals("-")) {
                    if (xpt2.priority <= prio) {
                        xpt2.bracket();
                    }
                } else if (xpt2.priority < prio) {
                    xpt2.bracket();
                }
                xpt2.atEnd = null;
                String op2 = xpt1.merge(xpt2);
                xpt1.fragment = xpt1.fragment + " " + (this.operation.equals("/") ? "div" : this.operation) + " " + op2;
                xpt1.priority = prio;
            }
            xpt1.type = XpathType.NUMBER;
            xpt1.atEnd = new BindingContext(BindingContext.CtxState.NONE);
            return xpt1;
        }
    }

    public static class Matches
    extends SchematronConstraintNode {
        public Matches(SchematronSchema schemaObject) {
            this.schemaObject = schemaObject;
        }

        public XpathFragment translate(BindingContext ctx) {
            XpathFragment xptobj = ((SchematronConstraintNode)this.children.get(0)).translate(ctx);
            if (xptobj.fragment.length() == 0) {
                xptobj.fragment = ".";
            }
            XpathFragment xptpat = ((SchematronConstraintNode)this.children.get(1)).translate(ctx);
            if (xptpat.fragment.length() == 0) {
                xptpat.fragment = ".";
            }
            String patstring = xptobj.merge(xptpat);
            SchematronSchema.ExtensionFunctionTemplate eft = this.schemaObject.extensionFunctions.get("matches");
            if (eft == null) {
                return new XpathFragment(11, "***ERROR[123]***");
            }
            String fcall = eft.function.replace("$object$", xptobj.fragment).replace("$pattern$", patstring);
            xptobj.fragment = eft.nsPrefix + ":" + fcall;
            xptobj.type = XpathType.STRING;
            xptobj.priority = 11;
            xptobj.atEnd.setState(BindingContext.CtxState.NONE);
            this.schemaObject.registerNamespace(eft.nsPrefix, eft.namespace);
            return xptobj;
        }
    }

    public static class ChangeCase
    extends SchematronConstraintNode {
        protected String operation = null;

        public ChangeCase(SchematronSchema schemaObject, String oper) {
            this.schemaObject = schemaObject;
            this.operation = oper;
        }

        public XpathFragment translate(BindingContext ctx) {
            XpathFragment result = new XpathFragment(11, "***ERROR[123]***");
            return result;
        }
    }

    public static class Substring
    extends SchematronConstraintNode {
        public Substring(SchematronSchema schemaObject) {
            this.schemaObject = schemaObject;
        }

        public XpathFragment translate(BindingContext ctx) {
            XpathFragment xptobj = ((SchematronConstraintNode)this.children.get(0)).translate(ctx);
            if (xptobj.fragment.length() == 0) {
                xptobj.fragment = ".";
            }
            XpathFragment xptfr = ((SchematronConstraintNode)this.children.get(1)).translate(ctx);
            if (xptfr.fragment.length() == 0) {
                xptfr.fragment = ".";
            }
            XpathFragment xptto = ((SchematronConstraintNode)this.children.get(2)).translate(ctx);
            if (xptto.fragment.length() == 0) {
                xptto.fragment = ".";
            }
            String fr = xptobj.merge(xptfr);
            xptobj.fragment = "substring(" + xptobj.fragment + ", ";
            xptobj.fragment = xptobj.fragment + fr + ", ";
            if (xptto.priority < 5) {
                xptto.bracket();
            }
            if (xptfr.priority <= 5) {
                xptfr.bracket();
            }
            xptobj.fragment = xptobj.fragment + xptto.fragment + " - " + xptfr.fragment + " + 1)";
            xptobj.type = XpathType.STRING;
            xptobj.priority = 11;
            xptobj.atEnd.setState(BindingContext.CtxState.NONE);
            return xptobj;
        }
    }

    public static class Concatenate
    extends SchematronConstraintNode {
        public Concatenate(SchematronSchema schemaObject) {
            this.schemaObject = schemaObject;
        }

        public XpathFragment translate(BindingContext ctx) {
            XpathFragment result = null;
            for (SchematronConstraintNode arg : this.children) {
                XpathFragment xptarg = arg.translate(ctx);
                if (result == null) {
                    result = xptarg;
                    continue;
                }
                String a1 = result.merge(xptarg);
                result.fragment = result.fragment + ", " + a1;
            }
            result.fragment = "concat(" + result.fragment + ")";
            result.type = XpathType.STRING;
            result.priority = 11;
            result.atEnd.setState(BindingContext.CtxState.NONE);
            return result;
        }
    }

    public static class Size
    extends SchematronConstraintNode {
        boolean setoper = false;

        public Size(SchematronSchema schemaObject, boolean set) {
            this.schemaObject = schemaObject;
            this.setoper = set;
        }

        public XpathFragment translate(BindingContext ctx) {
            SchematronConstraintNode obj = (SchematronConstraintNode)this.children.get(0);
            XpathFragment xpt = obj.translate(ctx);
            if (xpt.fragment.length() == 0) {
                xpt.fragment = ".";
            }
            xpt.fragment = !this.setoper ? "string-length(" + xpt.fragment + ")" : "count(" + xpt.fragment + ")";
            xpt.type = XpathType.NUMBER;
            xpt.priority = 11;
            xpt.atEnd = new BindingContext(BindingContext.CtxState.NONE);
            return xpt;
        }
    }

    public static class Cast
    extends SchematronConstraintNode {
        protected ClassInfo argumentClass = null;
        protected String targetClassName;

        public Cast(SchematronSchema schemaObject) {
            this.schemaObject = schemaObject;
        }

        public void setClass(ClassInfo ci) {
            this.argumentClass = ci;
        }

        public boolean hasSimpleType() {
            return ((SchematronConstraintNode)this.children.get(0)).hasSimpleType();
        }

        public boolean hasIdentity() {
            return ((SchematronConstraintNode)this.children.get(0)).hasIdentity();
        }

        public XpathFragment translate(BindingContext ctx) {
            SchematronConstraintNode objnode = (SchematronConstraintNode)this.children.get(0);
            XpathFragment xptobj = objnode.translate(ctx);
            if (xptobj.fragment.length() == 0) {
                xptobj.fragment = "self::*";
                xptobj.priority = 10;
            }
            HashSet<String> subtypes = this.argumentClass.subtypes();
            HashSet<String> classnames = new HashSet<String>();
            for (String stid : subtypes) {
                ClassInfo ci = this.argumentClass.model().classById(stid);
                if (ci.isAbstract()) continue;
                classnames.add(this.schemaObject.getAndRegisterXmlName(ci));
            }
            if (!this.argumentClass.isAbstract()) {
                classnames.add(this.schemaObject.getAndRegisterXmlName(this.argumentClass));
            }
            boolean first = true;
            if (xptobj.priority < 9) {
                xptobj.bracket();
            }
            xptobj.fragment = xptobj.fragment + "[";
            for (String name : classnames) {
                if (!first) {
                    xptobj.fragment = xptobj.fragment + " or ";
                }
                first = false;
                xptobj.fragment = xptobj.fragment + "name()='" + name + "'";
            }
            if (first) {
                xptobj.fragment = xptobj.fragment + "false()";
            }
            xptobj.fragment = xptobj.fragment + "]";
            xptobj.priority = 10;
            if (this.argumentClass.category() == 2 && (this.argumentClass.matches("rule-xsd-all-naming-19139") || this.argumentClass.matches("rule-xsd-cls-codelist-asDictionaryGml33") && this.argumentClass.asDictionaryGml33() || this.argumentClass.matches("rule-xsd-cls-codelist-asDictionary") && this.argumentClass.asDictionary())) {
                String clvp;
                String v;
                boolean atcurr;
                Attribute att = objnode.generatingAttribute();
                PropertyInfo pip = (PropertyInfo)att.attributes[att.attributes.length - 1].main.selector.modelProperty;
                boolean is19139 = this.argumentClass.matches("rule-xsd-all-naming-19139");
                boolean isgml33 = pip != null && this.schemaObject.options.matchesEncRule(pip.encodingRule("xsd"), "gml33");
                String clvpat = "{value}";
                int nsubst = 1;
                if (!isgml33) {
                    String vp;
                    String uri = this.argumentClass.taggedValue("codeList");
                    if (uri != null && uri.length() > 0) {
                        clvpat = "{codeList}/{value}";
                    }
                    if ((vp = this.argumentClass.taggedValue("codeListValuePattern")) != null && vp.length() > 0) {
                        clvpat = vp;
                    }
                    clvpat = clvpat.replace("{codeList}", "',{codeList},'");
                    if ((clvpat = clvpat.replace("{value}", "',{value},'")).startsWith("',")) {
                        clvpat = clvpat.substring(2);
                    }
                    if (clvpat.endsWith(",'")) {
                        clvpat = clvpat.substring(0, clvpat.length() - 2);
                    }
                    if (!clvpat.startsWith("{")) {
                        clvpat = "'" + clvpat;
                    }
                    if (!clvpat.endsWith("}")) {
                        clvpat = clvpat + "'";
                    }
                    if (!clvpat.equals("{value}")) {
                        clvpat = "concat(" + clvpat + ")";
                        nsubst = 2;
                    }
                }
                boolean bl = atcurr = ctx.state == BindingContext.CtxState.ATCURRENT;
                if (is19139) {
                    if (nsubst == 2 && atcurr) {
                        v = xptobj.findOrAdd(xptobj.fragment);
                        xptobj.fragment = "$" + v;
                    }
                    clvp = clvpat.replace("{codeList}", xptobj.fragment + "/@codeList");
                    xptobj.fragment = clvp.replace("{value}", xptobj.fragment + "/@codeListValue");
                } else if (!isgml33) {
                    if (nsubst == 2 && atcurr) {
                        v = xptobj.findOrAdd(xptobj.fragment);
                        xptobj.fragment = "$" + v;
                    }
                    clvp = clvpat.replace("{codeList}", xptobj.fragment + "/@codeSpace");
                    xptobj.fragment = clvp.replace("{value}", xptobj.fragment);
                } else {
                    xptobj.fragment = xptobj.fragment + "/@xlink:href";
                    this.schemaObject.registerNamespace("xlink");
                }
            }
            return xptobj;
        }
    }

    public static class KindOf
    extends SchematronConstraintNode {
        protected ClassInfo argumentClass = null;
        protected boolean exact = false;

        public KindOf(SchematronSchema schemaObject, boolean exact, boolean neg) {
            this.schemaObject = schemaObject;
            this.exact = exact;
            this.negated = neg;
        }

        public void setClass(ClassInfo ci) {
            this.argumentClass = ci;
        }

        public XpathFragment translate(BindingContext ctx) {
            HashSet<String> subtypes;
            SchematronConstraintNode objnode = (SchematronConstraintNode)this.children.get(0);
            XpathFragment xptobj = objnode.translate(ctx);
            boolean emptyobject = xptobj.fragment.length() == 0;
            HashSet<String> classnames = new HashSet<String>();
            if (!this.exact && (subtypes = this.argumentClass.subtypes()) != null) {
                for (String stid : subtypes) {
                    ClassInfo ci = this.argumentClass.model().classById(stid);
                    if (ci.isAbstract()) continue;
                    classnames.add(this.schemaObject.getAndRegisterXmlName(ci));
                }
            }
            if (!this.argumentClass.isAbstract()) {
                classnames.add(this.schemaObject.getAndRegisterXmlName(this.argumentClass));
            }
            if (classnames.size() == 0) {
                xptobj.fragment = this.negated ? "true()" : "false()";
                xptobj.priority = 11;
                xptobj.type = XpathType.BOOLEAN;
                xptobj.atEnd.setState(BindingContext.CtxState.NONE);
            } else {
                boolean first = true;
                if (xptobj.priority < 9) {
                    xptobj.bracket();
                    xptobj.priority = 11;
                }
                if (!emptyobject) {
                    xptobj.fragment = xptobj.fragment + "[";
                }
                for (String name : classnames) {
                    if (!first) {
                        xptobj.fragment = xptobj.fragment + (this.negated ? "and" : " or ");
                    }
                    first = false;
                    xptobj.fragment = xptobj.fragment + "name()" + (this.negated ? "!=" : "=") + "'" + name + "'";
                }
                xptobj.priority = 3;
                if (classnames.size() > 1) {
                    int n = xptobj.priority = this.negated ? 2 : 1;
                }
                if (!emptyobject) {
                    xptobj.fragment = xptobj.fragment + "]";
                    xptobj.priority = 10;
                }
            }
            return xptobj;
        }
    }

    public static class AllInstances
    extends SchematronConstraintNode {
        protected ClassInfo objectClass;

        public AllInstances(SchematronSchema schemaObject, ClassInfo ci, boolean negated) {
            this.schemaObject = schemaObject;
            this.objectClass = ci;
            this.negated = negated;
        }

        public boolean isMultiple() {
            return true;
        }

        public boolean hasSimpleType() {
            return false;
        }

        public boolean hasIdentity() {
            return XmlSchema.classCanBeReferenced(this.objectClass);
        }

        public XpathFragment translate(BindingContext ctx) {
            HashSet<String> subtypes = this.objectClass.subtypes();
            HashSet<String> classnames = new HashSet<String>();
            if (subtypes != null) {
                for (String stid : subtypes) {
                    ClassInfo ci = this.objectClass.model().classById(stid);
                    if (ci.isAbstract()) continue;
                    classnames.add(this.schemaObject.getAndRegisterXmlName(ci));
                }
            }
            if (!this.objectClass.isAbstract()) {
                classnames.add(this.schemaObject.getAndRegisterXmlName(this.objectClass));
            }
            String fragment = "";
            if (classnames.size() == 0) {
                fragment = "/*[false()]";
            } else {
                for (String name : classnames) {
                    if (fragment.length() != 0) {
                        fragment = fragment + " | ";
                    }
                    fragment = fragment + "//" + name;
                }
            }
            XpathFragment xpt = new XpathFragment(classnames.size() > 1 ? 8 : 9, fragment);
            xpt.atEnd = new BindingContext(BindingContext.CtxState.OTHER);
            return xpt;
        }
    }

    public static class Select
    extends SchematronConstraintNode {
        protected OclNode.Declaration vardecl;
        protected SchematronConstraintNode generatorBody = null;

        public Select(SchematronSchema schemaObject, OclNode.Declaration vardecl) {
            this.schemaObject = schemaObject;
            this.vardecl = vardecl;
        }

        public boolean bindsVariable(OclNode.Declaration vardecl) {
            return this.vardecl == vardecl;
        }

        public Attribute generatingAttribute() {
            return ((SchematronConstraintNode)this.children.get(0)).generatingAttribute();
        }

        public boolean isMultiple() {
            return true;
        }

        public boolean hasSimpleType() {
            return ((SchematronConstraintNode)this.children.get(0)).hasSimpleType();
        }

        public boolean hasIdentity() {
            return ((SchematronConstraintNode)this.children.get(0)).hasIdentity();
        }

        public XpathFragment translate(BindingContext ctx) {
            SchematronConstraintNode obj = (SchematronConstraintNode)this.children.get(0);
            XpathFragment xpt = obj.translate(ctx);
            BindingContext bodyctx = xpt.atEnd.clone();
            bodyctx.pushDeclaration(this.vardecl);
            SchematronConstraintNode pred = (SchematronConstraintNode)this.children.get(1);
            XpathFragment prd = pred.translate(bodyctx);
            prd.atEnd = null;
            String filter = xpt.merge(prd);
            if (xpt.priority < 10) {
                xpt.bracket();
            }
            xpt.fragment = xpt.fragment + "[" + filter + "]";
            xpt.priority = 10;
            return xpt;
        }
    }

    public static class Unique
    extends SchematronConstraintNode {
        OclNode.Declaration vardecl;

        public Unique(SchematronSchema schemaObject, OclNode.Declaration vardecl, boolean neg) {
            this.schemaObject = schemaObject;
            this.negated = neg;
            this.vardecl = vardecl;
        }

        public boolean bindsVariable(OclNode.Declaration vardecl) {
            return this.vardecl == vardecl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public XpathFragment translate(BindingContext ctx) {
            boolean neg = this.negated;
            SchematronConstraintNode obj = (SchematronConstraintNode)this.children.get(0);
            XpathFragment xpt = obj.translate(ctx);
            SchematronConstraintNode expr = (SchematronConstraintNode)this.children.get(1);
            if (!expr.isDependentOn(this.vardecl)) {
                xpt.fragment = "count(" + xpt.fragment + ") " + (neg ? ">" : "<=") + " 1";
                neg = false;
                xpt.priority = 4;
                xpt.type = XpathType.BOOLEAN;
                xpt.atEnd.setState(BindingContext.CtxState.NONE);
            } else if (expr.isVarOrAttribBased(this.vardecl) && expr instanceof Variable) {
                boolean simple = false;
                Attribute obat = null;
                if (obj instanceof Attribute) {
                    obat = (Attribute)obj;
                } else if (obj instanceof Variable) {
                    obat = obj.generatingAttribute();
                }
                if (obat != null) {
                    ClassInfo ci = obat.attributes[obat.attributes.length - 1].main.dataType.umlClass;
                    if (ci != null) {
                        simple = !XmlSchema.classHasObjectElement(ci);
                    } else {
                        String tname = obat.attributes[obat.attributes.length - 1].main.dataType.name;
                        String er = this.schemaObject.currentOclConstraintClass.encodingRule("xsd");
                        MapEntry me = this.schemaObject.options.typeMapEntry(tname, er);
                        if (me != null) {
                            simple = me.p2.equalsIgnoreCase("simple");
                        }
                    }
                }
                if (simple) {
                    String var = null;
                    var = xpt.fragment.matches("^\\$[A-Z]+$") ? xpt.fragment : "$" + xpt.findOrAdd(xpt.fragment);
                    xpt.fragment = var + "[. = (preceding::*|ancestor::*)[count(.|" + var + ")=count(" + var + ")]]";
                    xpt.priority = 10;
                    neg = !neg;
                } else {
                    xpt.fragment = neg ? "false()" : "true()";
                    neg = false;
                    xpt.priority = 11;
                    xpt.type = XpathType.BOOLEAN;
                    xpt.atEnd.setState(BindingContext.CtxState.NONE);
                }
            } else {
                if (!expr.isVarOrAttribBased(this.vardecl)) return new XpathFragment(11, "***ERROR[122]***");
                if (expr.isMultiple()) return new XpathFragment(11, "***ERROR[121]***");
                Attribute exat = (Attribute)expr;
                Attribute exat1 = exat.splitBefore(1);
                if (exat1 == null) {
                    if (!exat.hasSimpleType()) {
                        SchematronConstraintNode sv = (SchematronConstraintNode)exat.children.get(0);
                        exat.children.set(0, this.children.get(0));
                        XpathFragment xpta = exat.translate(ctx);
                        xpt.merge(xpta);
                        xpt.fragment = "count(" + xpt.fragment + ") " + (neg ? "!=" : "=") + " count(" + xpta.fragment + ")";
                        neg = false;
                        xpt.priority = 4;
                        xpt.type = XpathType.BOOLEAN;
                        xpt.atEnd.setState(BindingContext.CtxState.NONE);
                        exat.children.set(0, sv);
                    } else {
                        boolean is19139;
                        String var = null;
                        var = xpt.fragment.matches("^\\$[A-Z]+$") ? xpt.fragment : "$" + xpt.findOrAdd(xpt.fragment);
                        PropertyInfo pi = (PropertyInfo)exat.attributes[0].main.selector.modelProperty;
                        String prop = this.schemaObject.getAndRegisterXmlName(pi);
                        String cid = pi.typeInfo().id;
                        ClassInfo ci = null;
                        if (cid != null) {
                            ci = pi.model().classById(cid);
                        }
                        boolean iscodelist = ci != null && ci.category() == 2;
                        boolean bl = is19139 = ci != null && ci.matches("rule-xsd-all-naming-19139");
                        if (exat.attributes[0].absType == 0) {
                            if (is19139) {
                                prop = prop + "/*";
                                if (iscodelist) {
                                    prop = prop + "/@codeListValue";
                                }
                            } else if (iscodelist && ci.matches("rule-xsd-cls-codelist-asDictionaryGml33") && !is19139) {
                                prop = prop + "/@xlink:href";
                                this.schemaObject.registerNamespace("xlink");
                            }
                        }
                        String nil = "";
                        if (exat.attributes[0].absType == 2) {
                            if (is19139) {
                                nil = "[not(*)]/@gco:nilReason";
                                this.schemaObject.registerNamespace("gco");
                            } else {
                                nil = "[@xsi:nil='true']/@nilReason";
                                this.schemaObject.registerNamespace("xsi");
                            }
                        }
                        xpt.fragment = var + "[" + prop + nil + " = (preceding::*|ancestor::*)[count(.|" + var + ")=count(" + var + ")]/" + prop + nil + "]";
                        xpt.priority = 10;
                        neg = !neg;
                    }
                } else {
                    boolean savednegated = this.negated;
                    this.negated = false;
                    this.children.set(1, exat1.children.get(0));
                    XpathFragment xpt1 = this.translate(ctx);
                    Attribute exat0 = (Attribute)exat1.children.get(0);
                    Variable v0 = (Variable)exat0.children.get(0);
                    exat0.children.set(0, this.children.get(0));
                    exat1.children.set(0, v0);
                    this.children.set(0, exat0);
                    this.children.set(1, exat1);
                    XpathFragment xpt2 = this.translate(ctx);
                    String frag2 = xpt1.merge(xpt2);
                    if (xpt1.priority < 2) {
                        xpt1.bracket();
                    }
                    if (xpt2.priority < 2) {
                        frag2 = "(" + frag2 + ")";
                    }
                    xpt1.fragment = xpt1.fragment + " and " + frag2;
                    xpt1.priority = 2;
                    xpt1.type = XpathType.BOOLEAN;
                    xpt1.atEnd.setState(BindingContext.CtxState.NONE);
                    xpt = xpt1;
                    this.children.set(0, obj);
                    this.children.set(1, expr);
                    this.negated = savednegated;
                }
            }
            if (!neg) return xpt;
            xpt.fragment = "not(" + xpt.fragment + ")";
            xpt.type = XpathType.BOOLEAN;
            xpt.priority = 11;
            xpt.atEnd.setState(BindingContext.CtxState.NONE);
            return xpt;
        }
    }

    public static class Exists
    extends SchematronConstraintNode {
        OclNode.Declaration vardecl;

        public Exists(SchematronSchema schemaObject, OclNode.Declaration vardecl, boolean neg) {
            this.schemaObject = schemaObject;
            this.negated = neg;
            this.vardecl = vardecl;
        }

        public boolean bindsVariable(OclNode.Declaration vardecl) {
            return this.vardecl == vardecl;
        }

        public XpathFragment translate(BindingContext ctx) {
            SchematronConstraintNode obj = (SchematronConstraintNode)this.children.get(0);
            XpathFragment xpt = obj.translate(ctx);
            BindingContext bodyctx = xpt.atEnd.clone();
            bodyctx.pushDeclaration(this.vardecl);
            SchematronConstraintNode pred = (SchematronConstraintNode)this.children.get(1);
            XpathFragment prd = pred.translate(bodyctx);
            prd.atEnd = null;
            String filter = xpt.merge(prd);
            if (xpt.priority < 10) {
                xpt.bracket();
            }
            xpt.fragment = xpt.fragment + "[" + filter + "]";
            xpt.priority = 10;
            if (this.negated) {
                xpt.fragment = "not(" + xpt.fragment + ")";
                xpt.type = XpathType.BOOLEAN;
                xpt.priority = 11;
                xpt.atEnd.setState(BindingContext.CtxState.NONE);
            }
            return xpt;
        }
    }

    public static class Empty
    extends SchematronConstraintNode {
        public Empty(SchematronSchema schemaObject, boolean neg) {
            this.schemaObject = schemaObject;
            this.negated = neg;
        }

        public XpathFragment translate(BindingContext ctx) {
            SchematronConstraintNode obj = (SchematronConstraintNode)this.children.get(0);
            XpathFragment xpt = obj.translate(ctx);
            if (xpt.fragment.length() == 0) {
                xpt.fragment = ".";
            }
            if (!this.negated) {
                xpt.fragment = "not(" + xpt.fragment + ")";
                xpt.type = XpathType.BOOLEAN;
                xpt.priority = 11;
                xpt.atEnd.setState(BindingContext.CtxState.NONE);
            }
            return xpt;
        }
    }

    public static class Comparison
    extends SchematronConstraintNode {
        String opname;

        public Comparison(SchematronSchema schemaObject, String name) {
            this.schemaObject = schemaObject;
            this.opname = name.equals("<>") ? "!=" : name;
        }

        public XpathFragment translate(BindingContext ctx) {
            int refprio = 4;
            if (this.opname.equals("=") || this.opname.equals("!=")) {
                refprio = 3;
            }
            XpathFragment[] child_xpt = new XpathFragment[2];
            for (int i = 0; i < 2; ++i) {
                SchematronConstraintNode child = (SchematronConstraintNode)this.children.get(i);
                if (!child.hasSimpleType() && !child.hasIdentity()) {
                    return new XpathFragment(11, "***ERROR[126]***");
                }
                child_xpt[i] = child.translate(ctx);
                if (child.hasIdentity()) {
                    child_xpt[i].fragment = "generate-id(" + child_xpt[i].fragment + ")";
                    child_xpt[i].priority = 11;
                }
                if (child_xpt[i].fragment.length() == 0) {
                    child_xpt[i].fragment = ".";
                }
                if (child_xpt[i].priority <= refprio) {
                    child_xpt[i].bracket();
                }
                child_xpt[i].atEnd.setState(BindingContext.CtxState.NONE);
            }
            String op2 = child_xpt[0].merge(child_xpt[1]);
            child_xpt[0].fragment = child_xpt[0].fragment + " " + this.opname + " " + op2;
            child_xpt[0].type = XpathType.BOOLEAN;
            child_xpt[0].priority = refprio;
            return child_xpt[0];
        }
    }

    public static class Logic
    extends SchematronConstraintNode {
        protected LogicType logic;

        public Logic(SchematronSchema schemaObject, LogicType logic) {
            this.schemaObject = schemaObject;
            this.logic = logic;
        }

        public boolean isAndOrLogic(boolean isAnd) {
            if (this.logic == LogicType.XOR || this.logic == LogicType.EQV) {
                return false;
            }
            return this.logic == LogicType.AND == isAnd;
        }

        public XpathFragment translate(BindingContext ctx) {
            if (this.children.size() == 1) {
                return ((SchematronConstraintNode)this.children.get(0)).translate(ctx);
            }
            String particle = null;
            int refprio = -1;
            if (this.logic == LogicType.AND) {
                particle = "and";
                refprio = 2;
            } else if (this.logic == LogicType.OR) {
                particle = "or";
                refprio = 1;
            } else if (this.logic == LogicType.XOR) {
                particle = "!=";
                refprio = 3;
            } else {
                particle = "=";
                refprio = 3;
            }
            XpathFragment result = null;
            for (SchematronConstraintNode ocn : this.children) {
                XpathFragment child_xpt = ocn.translate(ctx);
                if ((this.logic == LogicType.XOR || this.logic == LogicType.EQV) && child_xpt.type != XpathType.BOOLEAN) {
                    child_xpt.fragment = "boolean(" + child_xpt.fragment + ")";
                    child_xpt.type = XpathType.BOOLEAN;
                    child_xpt.priority = 11;
                } else if (child_xpt.priority < refprio) {
                    child_xpt.bracket();
                }
                child_xpt.atEnd.setState(BindingContext.CtxState.NONE);
                if (result == null) {
                    result = child_xpt;
                    continue;
                }
                String mrge = result.merge(child_xpt);
                result.fragment = result.fragment + " " + particle + " ";
                result.fragment = result.fragment + mrge;
            }
            result.priority = refprio;
            result.type = XpathType.BOOLEAN;
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static enum LogicType {
            AND,
            OR,
            XOR,
            EQV;

        }
    }

    protected static class XpathFragment {
        public int priority;
        public String fragment;
        public XpathType type;
        public TreeMap<String, String> lets = null;
        public BindingContext atEnd = new BindingContext(BindingContext.CtxState.NONE);

        public XpathFragment(int p, String f, XpathType t) {
            this.priority = p;
            this.fragment = f;
            this.type = t;
        }

        public XpathFragment(int p, String f) {
            this.priority = p;
            this.fragment = f;
            this.type = XpathType.NODESET;
        }

        public void bracket() {
            this.fragment = "(" + this.fragment + ")";
            this.priority = 11;
        }

        public String merge(XpathFragment xf) {
            xf.replace("\\$(\\w*)", "%$1");
            if (xf.lets != null) {
                for (Map.Entry<String, String> ve : xf.lets.entrySet()) {
                    String vn = ve.getKey();
                    String ex = ve.getValue();
                    String vnew = this.findOrAdd(ex);
                    xf.replace("%" + vn, "\\$" + vnew);
                }
            }
            if (this.atEnd != null) {
                this.atEnd.merge(xf.atEnd);
            }
            return xf.fragment;
        }

        public String findOrAdd(String ex) {
            if (this.lets == null) {
                this.lets = new TreeMap();
            }
            for (Map.Entry<String, String> ve : this.lets.entrySet()) {
                if (!ve.getValue().equals(ex)) continue;
                return ve.getKey();
            }
            String newkey = "A";
            if (!this.lets.isEmpty()) {
                String last = this.lets.lastKey();
                String lc = last.substring(last.length() - 1);
                if (lc.equals("Z")) {
                    newkey = last + "A";
                } else {
                    try {
                        byte[] bytes = lc.getBytes("US-ASCII");
                        bytes[0] = (byte)(bytes[0] + 1);
                        newkey = last.substring(0, last.length() - 1) + new String(bytes, "US-ASCII");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.lets.put(newkey, ex);
            return newkey;
        }

        private void replace(String from, String to) {
            Pattern pat = Pattern.compile(from);
            if (this.lets != null) {
                for (Map.Entry<String, String> ve : this.lets.entrySet()) {
                    String ex = ve.getValue();
                    Matcher matcher = pat.matcher(ex);
                    ve.setValue(matcher.replaceAll(to));
                }
            }
            Matcher matcher = pat.matcher(this.fragment);
            this.fragment = matcher.replaceAll(to);
        }
    }

    public static class BindingContext {
        public CtxState state;
        ArrayList<CtxElmt> vars = null;

        BindingContext(CtxState state) {
            this.state = state;
        }

        public BindingContext clone() {
            BindingContext copy = new BindingContext(this.state);
            if (this.vars != null) {
                for (CtxElmt ce : this.vars) {
                    copy.pushDeclaration(ce.vardecl);
                    copy.vars.get((int)(copy.vars.size() - 1)).noOfSteps = ce.noOfSteps;
                }
            }
            return copy;
        }

        public void setState(CtxState state) {
            this.state = state;
            this.vars = null;
        }

        public void pushDeclaration(OclNode.Declaration vd) {
            if (this.vars == null) {
                this.vars = new ArrayList();
            }
            this.vars.add(new CtxElmt(vd));
            this.state = CtxState.OTHER;
        }

        public void addStep() {
            if (this.vars == null || this.vars.size() == 0) {
                return;
            }
            ++this.vars.get((int)(this.vars.size() - 1)).noOfSteps;
        }

        public void popDeclaration() {
            if (this.vars == null || this.vars.size() == 0) {
                return;
            }
            this.vars.remove(this.vars.size() - 1);
        }

        public void merge(BindingContext ctx) {
            if (ctx == null) {
                return;
            }
            if (this.state == CtxState.NONE) {
                return;
            }
            if (ctx.state == CtxState.NONE) {
                this.setState(CtxState.NONE);
                return;
            }
            if (ctx.state == CtxState.ATCURRENT && this.state == CtxState.ATCURRENT) {
                return;
            }
            if (ctx.state == CtxState.OTHER && this.state == CtxState.OTHER) {
                int thissize = this.vars == null ? 0 : this.vars.size();
                int ctxsize = ctx.vars == null ? 0 : ctx.vars.size();
                int i = thissize - 1;
                for (int j = ctxsize - 1; i >= 0 && j >= 0; --i, --j) {
                    CtxElmt cei = this.vars.get(i);
                    CtxElmt cej = ctx.vars.get(j);
                    if (cei.vardecl != cej.vardecl || cei.noOfSteps != cej.noOfSteps) break;
                }
                while (i >= 0) {
                    this.vars.remove(i--);
                }
                if (this.vars != null && this.vars.size() == 0) {
                    this.vars = null;
                }
            } else {
                this.state = CtxState.OTHER;
                this.vars = null;
            }
        }

        public class CtxElmt {
            public OclNode.Declaration vardecl;
            public int noOfSteps = 0;

            CtxElmt(OclNode.Declaration vd) {
                this.vardecl = vd;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum CtxState {
            NONE,
            ATCURRENT,
            OTHER;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum XpathType {
        BOOLEAN,
        NUMBER,
        STRING,
        NODESET;

    }
}

