/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.KML;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSLT
implements Target {
    public static final int TARGET_KMLXSLT = 6;
    private static final String NS_XSL = "http://www.w3.org/1999/XSL/Transform";
    private static final String NS_FN = "http://www.w3.org/2005/xpath-functions";
    private static final String NS_KML = "http://www.opengis.net/kml/2.2";
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private boolean printed = false;
    private Document document = null;
    private Document kmlDocument = null;
    private Document ruledoc = null;
    private Element root = null;
    private Element kmldoc = null;
    private Comment schemaAnchor = null;
    private Comment callAnchor = null;
    private String outputDirectory = null;
    private int maxLevel = 0;
    private boolean withSchema = true;
    private boolean withEmptyProps = false;
    private HashMap<PackageInfo, Element> folderMapElement = new HashMap();
    private HashMap<PackageInfo, String> folderMapFeatureTypes = new HashMap();
    private String north = "90.0";
    private String south = "-90.0";
    private String west = "-180.0";
    private String east = "-180.0";
    private String minLod = "2048";
    private String href = "http://services.interactive-instruments.de/ows7-kml/kml2/wfskml_regions.php";

    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        String s;
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        this.outputDirectory = this.options.parameter(this.getClass().getName(), "outputDirectory");
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter("outputDirectory");
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter(".");
        }
        if ((s = this.options.parameter(this.getClass().getName(), "withSchema")) != null && s.equals("false")) {
            this.withSchema = false;
        }
        if ((s = this.options.parameter(this.getClass().getName(), "withEmptyProps")) != null && s.equals("true")) {
            this.withEmptyProps = true;
        }
        if ((s = this.options.parameter(this.getClass().getName(), "maxFolderLevel")) != null && s.length() > 0) {
            this.maxLevel = new Integer(s);
        }
        if ((s = this.options.parameter(this.getClass().getName(), "north")) != null && s.length() > 0) {
            this.north = s.trim();
        }
        if ((s = this.options.parameter(this.getClass().getName(), "south")) != null && s.length() > 0) {
            this.south = s.trim();
        }
        if ((s = this.options.parameter(this.getClass().getName(), "east")) != null && s.length() > 0) {
            this.east = s.trim();
        }
        if ((s = this.options.parameter(this.getClass().getName(), "west")) != null && s.length() > 0) {
            this.west = s.trim();
        }
        if ((s = this.options.parameter(this.getClass().getName(), "href")) != null && s.length() > 0) {
            this.href = s.trim();
        }
        if ((s = this.options.parameter(this.getClass().getName(), "minLodPixels")) != null && s.length() > 0) {
            this.minLod = s.trim();
        }
        this.result.addDebug(null, 10005, this.pi.name());
        this.document = this.createDocument();
        this.root = this.document.createElementNS(NS_XSL, "stylesheet");
        this.document.appendChild(this.root);
        this.addAttribute(this.document, this.root, "version", "2.0");
        this.addAttribute(this.document, this.root, "xmlns:gml", this.options.GML_NS);
        this.addAttribute(this.document, this.root, "xmlns:xsl", NS_XSL);
        this.addAttribute(this.document, this.root, "xmlns:kml", NS_KML);
        this.addAttribute(this.document, this.root, "xmlns:fn", NS_FN);
        this.addAttribute(this.document, this.root, "xmlns:xlink", this.options.fullNamespace("xlink"));
        this.addAttribute(this.document, this.root, "xmlns:xs", "http://www.w3.org/2001/XMLSchema");
        this.addAttribute(this.document, this.root, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        s = this.options.parameter(this.getClass().getName(), "nsDef");
        if (s != null && s.trim().length() > 0) {
            String[] sl;
            for (String ns : sl = s.split(" ")) {
                String[] nsdef = ns.split("=");
                if (nsdef.length != 2 || nsdef[0] == null || nsdef[0].trim().length() <= 0 || nsdef[1] == null || nsdef[1].trim().length() <= 0) continue;
                this.addAttribute(this.document, this.root, nsdef[0], nsdef[1]);
            }
        }
        this.addAttribute(this.document, this.root, "xmlns:" + this.pi.xmlns(), this.pi.targetNamespace());
        Element e1 = this.document.createElementNS(NS_XSL, "output");
        this.root.appendChild(e1);
        this.addAttribute(this.document, e1, "method", "xml");
        this.addAttribute(this.document, e1, "indent", "yes");
        s = this.options.parameter(this.getClass().getName(), "borisSpecial");
        if (s != null && s.equalsIgnoreCase("true")) {
            e1 = this.document.createElementNS(NS_XSL, "param");
            this.root.appendChild(e1);
            this.addAttribute(this.document, e1, "name", "dir");
            this.addAttribute(this.document, e1, "as", "xs:string");
            this.addAttribute(this.document, e1, "required", "yes");
            e1 = this.document.createElementNS(NS_XSL, "variable");
            this.root.appendChild(e1);
            this.addAttribute(this.document, e1, "name", "umretab_pfad");
            this.addAttribute(this.document, e1, "select", "'umretabs'");
        }
        e1 = this.document.createElementNS(NS_XSL, "template");
        this.root.appendChild(e1);
        this.addAttribute(this.document, e1, "match", "/");
        s = this.options.parameter(this.getClass().getName(), "borisSpecial");
        if (s != null && s.equalsIgnoreCase("true")) {
            Element e2 = this.document.createElementNS(NS_XSL, "variable");
            e1.appendChild(e2);
            this.addAttribute(this.document, e2, "name", "fname_prae");
            this.addAttribute(this.document, e2, "select", "'boriskmlout_'");
            e2 = this.document.createElementNS(NS_XSL, "variable");
            e1.appendChild(e2);
            this.addAttribute(this.document, e2, "name", "stage");
            this.addAttribute(this.document, e2, "select", "//boris:BR_Bodenrichtwert[1]/boris:stichtag");
            e2 = this.document.createElementNS(NS_XSL, "variable");
            e1.appendChild(e2);
            this.addAttribute(this.document, e2, "name", "stag");
            this.addAttribute(this.document, e2, "select", "$stage[1]");
            e2 = this.document.createElementNS(NS_XSL, "variable");
            e1.appendChild(e2);
            this.addAttribute(this.document, e2, "name", "jahr");
            this.addAttribute(this.document, e2, "select", "substring(format-date($stag,'[Y]', 'en', 'AD', 'UK'),3)");
            e2 = this.document.createElementNS(NS_XSL, "variable");
            e1.appendChild(e2);
            this.addAttribute(this.document, e2, "name", "fname");
            this.addAttribute(this.document, e2, "select", "concat($dir, '/', $fname_prae, $jahr, '.kml')");
            e2 = this.document.createElementNS(NS_XSL, "result-document");
            e1.appendChild(e2);
            this.addAttribute(this.document, e2, "href", "{$fname}");
            Element e4 = this.document.createElementNS(NS_XSL, "call-template");
            e2.appendChild(e4);
            this.addAttribute(this.document, e4, "name", "alle");
            e2 = this.document.createElementNS(NS_XSL, "for-each");
            e1.appendChild(e2);
            this.addAttribute(this.document, e2, "select", "//boris:BR_Umrechnungstabelle");
            e4 = this.document.createElementNS(NS_XSL, "result-document");
            e2.appendChild(e4);
            this.addAttribute(this.document, e4, "href", "{$dir}/{$umretab_pfad}/{@gml:id}.htm");
            Element e5 = this.document.createElementNS(NS_XSL, "value-of");
            e4.appendChild(e5);
            this.addAttribute(this.document, e5, "select", "boris:umrechnungstabelleDokument");
            e1 = this.document.createElementNS(NS_XSL, "template");
            this.root.appendChild(e1);
            this.addAttribute(this.document, e1, "name", "alle");
        }
        Element e2 = this.document.createElementNS(NS_KML, "kml");
        e1.appendChild(e2);
        this.kmldoc = this.document.createElementNS(NS_KML, "Document");
        e2.appendChild(this.kmldoc);
        Element e4 = this.document.createElementNS(NS_KML, "open");
        e4.appendChild(this.document.createTextNode("0"));
        this.kmldoc.appendChild(e4);
        this.schemaAnchor = this.document.createComment("Call styling template for each feature type");
        this.kmldoc.appendChild(this.schemaAnchor);
        this.callAnchor = this.document.createComment("Styling templates for each feature type");
        this.kmldoc.appendChild(this.callAnchor);
        s = this.options.parameter(this.getClass().getName(), "portrayalRuleDocument");
        if (s != null && !s.isEmpty()) {
            DocumentBuilder builder = null;
            try {
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                factory.setFeature("http://apache.org/xml/features/validation/schema", false);
                factory.setIgnoringElementContentWhitespace(true);
                factory.setIgnoringComments(true);
                factory.setXIncludeAware(true);
                factory.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
                builder = factory.newDocumentBuilder();
                this.ruledoc = builder.parse(s);
            }
            catch (Exception e) {
                System.err.println("Error with portrayal rules document.");
            }
        }
        this.kmlDocument = this.createDocument();
        Element e0 = this.kmlDocument.createElementNS(NS_KML, "kml");
        this.kmlDocument.appendChild(e0);
        e1 = this.kmlDocument.createElementNS(NS_KML, "Document");
        e0.appendChild(e1);
        e2 = this.kmlDocument.createElementNS(NS_KML, "name");
        s = this.pi.taggedValue("name");
        if (s != null && s.length() > 0) {
            e2.appendChild(this.kmlDocument.createTextNode(s.trim()));
        } else {
            e2.appendChild(this.kmlDocument.createTextNode(this.pi.name()));
        }
        e1.appendChild(e2);
        e2 = this.kmlDocument.createElementNS(NS_KML, "visibility");
        e2.appendChild(this.kmlDocument.createTextNode("1"));
        e1.appendChild(e2);
        e2 = this.kmlDocument.createElementNS(NS_KML, "open");
        e2.appendChild(this.kmlDocument.createTextNode("1"));
        e1.appendChild(e2);
        e2 = this.kmlDocument.createElementNS(NS_KML, "description");
        s = this.pi.taggedValue("description");
        if (s != null && s.length() > 0) {
            e2.appendChild(this.kmlDocument.createTextNode(s.trim()));
        } else {
            e2.appendChild(this.kmlDocument.createTextNode(this.pi.documentation()));
        }
        e1.appendChild(e2);
        e2 = this.kmlDocument.createElementNS(NS_KML, "Snippet");
        this.addAttribute(this.kmlDocument, e2, "maxLines", "0");
        e1.appendChild(e2);
        if (this.maxLevel == 0) {
            this.addNetworkLink(this.pi, e1);
        } else {
            try {
                for (PackageInfo sub : this.pi.containedPackages()) {
                    this.createFolders(sub, e1, 1);
                }
            }
            catch (Exception e) {
                this.result.addError("Cannot access sub-packages of package " + this.pi.name() + " during KML generation.");
                e.printStackTrace();
            }
        }
    }

    protected boolean createFolders(PackageInfo pix, Element e, int level) throws Exception {
        String sss = pix.name();
        this.result.addDebug("!!! " + sss + " - " + level);
        if (level > this.maxLevel) {
            return true;
        }
        Element e1 = this.kmlDocument.createElementNS(NS_KML, "Folder");
        Element e2 = this.kmlDocument.createElementNS(NS_KML, "name");
        String s = pix.taggedValue("name");
        if (s != null && s.length() > 0) {
            e2.appendChild(this.kmlDocument.createTextNode(s.trim()));
        } else {
            e2.appendChild(this.kmlDocument.createTextNode(pix.name()));
        }
        e1.appendChild(e2);
        e2 = this.kmlDocument.createElementNS(NS_KML, "visibility");
        e2.appendChild(this.kmlDocument.createTextNode("1"));
        e1.appendChild(e2);
        e2 = this.kmlDocument.createElementNS(NS_KML, "open");
        e2.appendChild(this.kmlDocument.createTextNode("0"));
        e1.appendChild(e2);
        e2 = this.kmlDocument.createElementNS(NS_KML, "description");
        s = pix.taggedValue("description");
        if (s != null && s.length() > 0) {
            e2.appendChild(this.kmlDocument.createTextNode(s.trim()));
        } else {
            e2.appendChild(this.kmlDocument.createTextNode(pix.documentation()));
        }
        e1.appendChild(e2);
        e2 = this.kmlDocument.createElementNS(NS_KML, "Snippet");
        this.addAttribute(this.kmlDocument, e2, "maxLines", "0");
        e1.appendChild(e2);
        boolean empty = true;
        HashSet<PackageInfo> subs = pix.containedPackages();
        if (subs.size() == 0 || level >= this.maxLevel) {
            for (ClassInfo cix : this.model.classes(pix)) {
                if (cix.pkg() != pix) continue;
                String ssss = cix.name();
                this.result.addDebug("!!! " + ssss);
                if (!this.testProcess(cix)) continue;
                empty = false;
                break;
            }
            if (!empty) {
                this.addNetworkLink(pix, e1);
            }
        } else {
            for (PackageInfo sub : subs) {
                boolean empty2 = this.createFolders(sub, e1, level + 1);
                empty = empty && empty2;
            }
        }
        if (!empty) {
            e.appendChild(e1);
        }
        this.result.addDebug("--- " + sss + " - " + empty);
        return empty;
    }

    private void addNetworkLink(PackageInfo pix, Element e1) {
        Element e3 = this.kmlDocument.createElementNS(NS_KML, "NetworkLink");
        e1.appendChild(e3);
        Element e4 = this.kmlDocument.createElementNS(NS_KML, "name");
        e4.appendChild(this.kmlDocument.createTextNode("Tiles"));
        e3.appendChild(e4);
        e4 = this.kmlDocument.createElementNS(NS_KML, "visibility");
        e4.appendChild(this.kmlDocument.createTextNode("1"));
        e3.appendChild(e4);
        e4 = this.kmlDocument.createElementNS(NS_KML, "open");
        e4.appendChild(this.kmlDocument.createTextNode("0"));
        e3.appendChild(e4);
        e4 = this.kmlDocument.createElementNS(NS_KML, "refreshVisibility");
        e4.appendChild(this.kmlDocument.createTextNode("0"));
        e3.appendChild(e4);
        e4 = this.kmlDocument.createElementNS(NS_KML, "flyToView");
        e4.appendChild(this.kmlDocument.createTextNode("0"));
        e3.appendChild(e4);
        e4 = this.kmlDocument.createElementNS(NS_KML, "Region");
        e3.appendChild(e4);
        Element e5 = this.kmlDocument.createElementNS(NS_KML, "LatLonAltBox");
        e4.appendChild(e5);
        Element e6 = this.kmlDocument.createElementNS(NS_KML, "north");
        e6.appendChild(this.kmlDocument.createTextNode(this.north));
        e5.appendChild(e6);
        e6 = this.kmlDocument.createElementNS(NS_KML, "south");
        e6.appendChild(this.kmlDocument.createTextNode(this.south));
        e5.appendChild(e6);
        e6 = this.kmlDocument.createElementNS(NS_KML, "east");
        e6.appendChild(this.kmlDocument.createTextNode(this.east));
        e5.appendChild(e6);
        e6 = this.kmlDocument.createElementNS(NS_KML, "west");
        e6.appendChild(this.kmlDocument.createTextNode(this.west));
        e5.appendChild(e6);
        e5 = this.kmlDocument.createElementNS(NS_KML, "Lod");
        e4.appendChild(e5);
        e6 = this.kmlDocument.createElementNS(NS_KML, "minLodPixels");
        e6.appendChild(this.kmlDocument.createTextNode(this.minLod));
        e5.appendChild(e6);
        e6 = this.kmlDocument.createElementNS(NS_KML, "maxLodPixels");
        e6.appendChild(this.kmlDocument.createTextNode("-1"));
        e5.appendChild(e6);
        e4 = this.kmlDocument.createElementNS(NS_KML, "Link");
        e3.appendChild(e4);
        e5 = this.kmlDocument.createElementNS(NS_KML, "href");
        e5.appendChild(this.kmlDocument.createTextNode(this.href));
        e4.appendChild(e5);
        e5 = this.kmlDocument.createElementNS(NS_KML, "viewRefreshMode");
        e5.appendChild(this.kmlDocument.createTextNode("onRegion"));
        e4.appendChild(e5);
        e5 = this.kmlDocument.createElementNS(NS_KML, "viewFormat");
        e5.appendChild(this.kmlDocument.createTextNode("BBOX=[bboxWest],[bboxSouth],[bboxEast],[bboxNorth]&LOOKAT=[lookatLon],[lookatLat],[lookatRange],[lookatTilt],[lookatHeading]&CAMERA=[cameraLon],[cameraLat],[cameraAlt]&LOOKATTERR=[lookatTerrainLon],[lookatTerrainLat],[lookatTerrainAlt]&VIEW=[horizFov],[vertFov],[horizPixels],[vertPixels],[terrainEnabled]"));
        e4.appendChild(e5);
        e5 = this.kmlDocument.createElementNS(NS_KML, "httpQuery");
        e4.appendChild(e5);
        this.folderMapElement.put(pix, e5);
        this.folderMapFeatureTypes.put(pix, "");
    }

    protected void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    protected Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(null, 2);
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            this.result.addFatalError(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        return document;
    }

    private String kmlReference(ClassInfo ci) {
        String s = ci.taggedValue("kmlReference");
        if (s == null || s.length() == 0) {
            s = this.options.parameter(this.getClass().getName(), "defaultReference");
        }
        if (s != null && s.length() > 0) {
            return s.trim();
        }
        return null;
    }

    private String kmlStyleUrl(ClassInfo ci) {
        String s = ci.taggedValue("kmlStyleUrl");
        if (s != null && s.length() > 0) {
            return s.trim();
        }
        return this.kmlStyleUrl(ci, ci.pkg());
    }

    private String defaultKmlStyleUrl(ClassInfo ci) {
        String s = this.options.parameter(this.getClass().getName(), "defaultStyleUrl(" + ci.name() + ")");
        if (s != null && s.length() > 0) {
            return s.trim();
        }
        s = this.options.parameter(this.getClass().getName(), "defaultStyleUrl");
        if (s != null && s.length() > 0) {
            return s.trim();
        }
        return null;
    }

    private String kmlStyleUrl(ClassInfo ci, PackageInfo pi) {
        if (pi == null) {
            return this.defaultKmlStyleUrl(ci);
        }
        String s = pi.taggedValue("kmlStyleUrl");
        if (s != null && s.length() > 0) {
            return s.trim();
        }
        if (pi == null || pi.isAppSchema() || pi.owner() == null) {
            return this.defaultKmlStyleUrl(ci);
        }
        return this.kmlStyleUrl(ci, pi.owner());
    }

    private CDATASection cdataType(ClassInfo ci) {
        CDATASection cd = null;
        String s = this.kmlReference(ci);
        String sn = this.stringType(ci);
        if (ci.qname().equals("cp:CadastralParcel")) {
            s = "http://inspire-registry.jrc.ec.europa.eu/registers/FCD/items/275";
        }
        String s2 = ci.documentation().trim().replace("'", "").replace("\"", "");
        cd = s != null && s2 != null ? this.document.createCDATASection("<a href='" + s + "' title='" + s2 + "'><big><b><i>" + sn + "</i></b></big></a>") : (s != null ? this.document.createCDATASection("<a href='" + s + "'><big><b><i>" + sn + "</i></b></big></a>") : (s2 != null ? this.document.createCDATASection("<div title='" + s2 + "'><big><b><i>" + sn + "</i></b></big></div>") : this.document.createCDATASection("<big><b><i>" + sn + "</i></b></big>")));
        return cd;
    }

    private String stringType(ClassInfo ci) {
        String s = ci.taggedValue("name");
        if (s != null && s.length() > 0) {
            return s.trim();
        }
        return ci.name();
    }

    private String stringProperty(PropertyInfo propi) {
        String s = propi.taggedValue("name");
        if (s != null && s.length() > 0) {
            return s.trim();
        }
        return propi.name();
    }

    private boolean testProcess(ClassInfo ci) {
        int cat = ci.category();
        if (cat != 1) {
            return false;
        }
        if (ci.isAbstract()) {
            return false;
        }
        return ci.name().startsWith("RoadGeo") || ci.name().startsWith("NamedLocationGeo") || ci.name().startsWith("BuildingGeo") || ci.name().startsWith("RailwayGeo") || ci.name().startsWith("PowerStationGeo") || ci.name().startsWith("CemeteryGeo") || ci.name().startsWith("SteepTerrainFaceGeo") || ci.name().startsWith("CampGeo");
    }

    public void process(ClassInfo ci) {
        Element schemaData;
        Element e7;
        Element e6;
        Element e5;
        Element e4;
        Element e3;
        Element e2;
        Element e1;
        Element schema;
        if (!this.testProcess(ci)) {
            return;
        }
        if (this.withSchema) {
            Element e0 = this.document.createElementNS(NS_XSL, "if");
            this.addAttribute(this.document, e0, "test", "//" + ci.pkg().xmlns() + ":" + ci.name());
            this.kmldoc.insertBefore(e0, this.schemaAnchor);
            schema = this.document.createElementNS(NS_KML, "Schema");
            this.addAttribute(this.document, schema, "id", ci.name() + "Schema");
            e0.appendChild(schema);
            e1 = this.document.createElementNS(NS_KML, "SimpleField");
            this.addAttribute(this.document, e1, "type", "string");
            this.addAttribute(this.document, e1, "name", "type");
            schema.appendChild(e1);
            e2 = this.document.createElementNS(NS_KML, "displayName");
            this.addAttribute(this.document, e1, "type", "string");
            CDATASection cd = this.cdataType(ci);
            e2.appendChild(cd);
            e1.appendChild(e2);
        } else {
            schema = null;
        }
        if (this.options.parameter(this.getClass().getName(), "groupInFolder") != null && this.options.parameter(this.getClass().getName(), "groupInFolder").equalsIgnoreCase("true")) {
            e3 = this.document.createElementNS(NS_XSL, "if");
            this.addAttribute(this.document, e3, "test", "//" + ci.pkg().xmlns() + ":" + ci.name());
            this.kmldoc.insertBefore(e3, this.callAnchor);
            e4 = this.document.createElementNS(NS_KML, "Folder");
            e3.appendChild(e4);
            e5 = this.document.createElementNS(NS_KML, "name");
            e5.appendChild(this.document.createTextNode(ci.name()));
            e4.appendChild(e5);
            e1 = this.document.createElementNS(NS_XSL, "for-each");
            this.addAttribute(this.document, e1, "select", "//" + ci.pkg().xmlns() + ":" + ci.name());
            e4.appendChild(e1);
        } else {
            e1 = this.document.createElementNS(NS_XSL, "for-each");
            this.addAttribute(this.document, e1, "select", "//" + ci.pkg().xmlns() + ":" + ci.name());
            this.kmldoc.insertBefore(e1, this.callAnchor);
        }
        e2 = this.document.createElementNS(NS_XSL, "call-template");
        this.addAttribute(this.document, e2, "name", ci.name());
        e1.appendChild(e2);
        e1 = this.document.createElementNS(NS_XSL, "template");
        this.root.appendChild(e1);
        this.addAttribute(this.document, e1, "name", ci.name());
        e2 = this.document.createElementNS(NS_KML, "Placemark");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_XSL, "attribute");
        e2.appendChild(e3);
        this.addAttribute(this.document, e3, "name", "id");
        e4 = this.document.createElementNS(NS_XSL, "value-of");
        e3.appendChild(e4);
        this.addAttribute(this.document, e4, "select", "@gml:id");
        e3 = this.document.createElementNS(NS_XSL, "choose");
        e2.appendChild(e3);
        String s = this.getTaggedProperty(ci, "kmlName");
        if (s != null) {
            e4 = this.document.createElementNS(NS_XSL, "when");
            e3.appendChild(e4);
            this.addAttribute(this.document, e4, "test", s);
            e5 = this.document.createElementNS(NS_KML, "name");
            e4.appendChild(e5);
            e6 = this.document.createElementNS(NS_XSL, "value-of");
            e5.appendChild(e6);
            this.addAttribute(this.document, e6, "select", "./" + s + "[1]");
        }
        e4 = this.document.createElementNS(NS_XSL, "when");
        e3.appendChild(e4);
        this.addAttribute(this.document, e4, "test", "gml:name");
        e5 = this.document.createElementNS(NS_KML, "name");
        e4.appendChild(e5);
        e6 = this.document.createElementNS(NS_XSL, "value-of");
        e5.appendChild(e6);
        this.addAttribute(this.document, e6, "select", "./gml:name[1]");
        e4 = this.document.createElementNS(NS_XSL, "otherwise");
        e3.appendChild(e4);
        e5 = this.document.createElementNS(NS_KML, "name");
        e4.appendChild(e5);
        s = ci.taggedValue("name");
        if (s != null && s.length() > 0) {
            e5.appendChild(this.document.createTextNode(s));
        } else {
            e6 = this.document.createElementNS(NS_XSL, "value-of");
            e5.appendChild(e6);
            this.addAttribute(this.document, e6, "select", "@gml:id");
        }
        e3 = this.document.createElementNS(NS_KML, "visibility");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode("1"));
        s = this.getTaggedProperty(ci, "kmlTimeStamp");
        if (s != null) {
            e4 = this.document.createElementNS(NS_XSL, "if");
            e2.appendChild(e4);
            this.addAttribute(this.document, e4, "test", s);
            e5 = this.document.createElementNS(NS_KML, "TimeStamp");
            e4.appendChild(e5);
            e6 = this.document.createElementNS(NS_KML, "when");
            e5.appendChild(e6);
            e7 = this.document.createElementNS(NS_XSL, "value-of");
            e6.appendChild(e7);
            this.addAttribute(this.document, e7, "select", "./" + s + "[1]");
        } else {
            s = this.getTaggedProperty(ci, "kmlTimeSpanBegin");
            String s2 = this.getTaggedProperty(ci, "kmlTimeSpanEnd");
            if (s != null && s2 != null) {
                e4 = this.document.createElementNS(NS_XSL, "if");
                e2.appendChild(e4);
                this.addAttribute(this.document, e4, "test", s + " or " + s2);
                e5 = this.document.createElementNS(NS_KML, "TimeSpan");
                e4.appendChild(e5);
                e6 = this.document.createElementNS(NS_XSL, "if");
                e5.appendChild(e6);
                this.addAttribute(this.document, e6, "test", s);
                e7 = this.document.createElementNS(NS_KML, "begin");
                e6.appendChild(e7);
                Element e8 = this.document.createElementNS(NS_XSL, "value-of");
                e7.appendChild(e8);
                this.addAttribute(this.document, e8, "select", "./" + s + "[1]");
                e6 = this.document.createElementNS(NS_XSL, "if");
                e5.appendChild(e6);
                this.addAttribute(this.document, e6, "test", s2);
                e7 = this.document.createElementNS(NS_KML, "end");
                e6.appendChild(e7);
                e8 = this.document.createElementNS(NS_XSL, "value-of");
                e7.appendChild(e8);
                this.addAttribute(this.document, e8, "select", "./" + s2 + "[1]");
            } else if (s != null) {
                e4 = this.document.createElementNS(NS_XSL, "if");
                e2.appendChild(e4);
                this.addAttribute(this.document, e4, "test", s);
                e5 = this.document.createElementNS(NS_KML, "TimeSpan");
                e4.appendChild(e5);
                e6 = this.document.createElementNS(NS_KML, "begin");
                e5.appendChild(e6);
                e7 = this.document.createElementNS(NS_XSL, "value-of");
                e6.appendChild(e7);
                this.addAttribute(this.document, e7, "select", "./" + s + "[1]");
            } else if (s2 != null) {
                e4 = this.document.createElementNS(NS_XSL, "if");
                e2.appendChild(e4);
                this.addAttribute(this.document, e4, "test", s2);
                e5 = this.document.createElementNS(NS_KML, "TimeSpan");
                e4.appendChild(e5);
                e6 = this.document.createElementNS(NS_KML, "end");
                e5.appendChild(e6);
                e7 = this.document.createElementNS(NS_XSL, "value-of");
                e6.appendChild(e7);
                this.addAttribute(this.document, e7, "select", "./" + s2 + "[1]");
            }
        }
        if (this.ruledoc != null) {
            e4 = null;
            String def = null;
            try {
                NodeList styles = XPathAPI.selectNodeList((Node)this.ruledoc, (String)("/*/se:FeatureTypeStyle[se:FeatureTypeName=\"" + ci.qname() + "\"]/se:Rule"), (Node)this.ruledoc.getDocumentElement());
                for (int i = styles.getLength() - 1; i >= 0; --i) {
                    Node style = styles.item(i);
                    NodeList filters = XPathAPI.selectNodeList((Node)style, (String)"ogc:Filter", (Node)this.ruledoc.getDocumentElement());
                    if (filters.getLength() > 0) {
                        Node filter = filters.item(0);
                        String test = "";
                        NodeList preds = filter.getChildNodes();
                        for (int j = 0; j < preds.getLength(); ++j) {
                            Node pred = preds.item(j);
                            test = test + this.getString(pred);
                        }
                        if (e4 == null) {
                            e4 = this.document.createElementNS(NS_XSL, "choose");
                            e2.appendChild(e4);
                        }
                        e5 = this.document.createElementNS(NS_XSL, "when");
                        e4.appendChild(e5);
                        this.addAttribute(this.document, e5, "test", test);
                        NodeList symbols = XPathAPI.selectNodeList((Node)style, (String)"se:OnlineResource/@xlink:href", (Node)this.ruledoc.getDocumentElement());
                        if (symbols.getLength() <= 0) continue;
                        String sym = symbols.item(0).getTextContent();
                        String id = sym.split("Symbol=")[1].trim();
                        e6 = this.document.createElementNS(NS_KML, "styleUrl");
                        e5.appendChild(e6);
                        e6.appendChild(this.document.createTextNode(sym.replace("&", "%26") + "%26Encoding=application/vnd.google-earth.kml+xml#" + id));
                        continue;
                    }
                    NodeList symbols = XPathAPI.selectNodeList((Node)style, (String)"se:OnlineResource/@xlink:href", (Node)this.ruledoc.getDocumentElement());
                    if (symbols.getLength() <= 0) continue;
                    String sym = symbols.item(0).getTextContent();
                    String id = sym.split("Symbol=")[1].trim();
                    def = sym.replace("&", "%26") + "%26Encoding=application/vnd.google-earth.kml+xml#" + id;
                }
            }
            catch (TransformerException e) {
                this.result.addError("Xpath error while processing portrayal rule document in target KML: " + e.getMessage());
            }
            if (def != null) {
                if (e4 != null) {
                    e5 = this.document.createElementNS(NS_XSL, "otherwise");
                    e4.appendChild(e5);
                } else {
                    e5 = e2;
                }
                e6 = this.document.createElementNS(NS_KML, "styleUrl");
                e5.appendChild(e6);
                e6.appendChild(this.document.createTextNode(def));
            }
        } else {
            s = this.kmlStyleUrl(ci);
            if (s != null) {
                e3 = this.document.createElementNS(NS_KML, "styleUrl");
                e2.appendChild(e3);
                e3.appendChild(this.document.createTextNode(s));
            }
        }
        e3 = this.document.createElementNS(NS_KML, "ExtendedData");
        e2.appendChild(e3);
        if (this.withSchema) {
            schemaData = this.document.createElementNS(NS_KML, "SchemaData");
            e3.appendChild(schemaData);
            this.addAttribute(this.document, schemaData, "schemaUrl", "#" + ci.name() + "Schema");
            e4 = this.document.createElementNS(NS_KML, "SimpleData");
            schemaData.appendChild(e4);
            this.addAttribute(this.document, e4, "name", "type");
        } else {
            schemaData = e3;
            e3 = this.document.createElementNS(NS_KML, "Data");
            schemaData.appendChild(e3);
            this.addAttribute(this.document, e3, "name", this.stringType(ci));
            e4 = this.document.createElementNS(NS_KML, "displayName");
            CDATASection cd = this.cdataType(ci);
            e4.appendChild(cd);
            e3.appendChild(e4);
            e4 = this.document.createElementNS(NS_KML, "value");
            e3.appendChild(e4);
        }
        e5 = this.document.createElementNS(NS_XSL, "choose");
        e4.appendChild(e5);
        e6 = this.document.createElementNS(NS_XSL, "when");
        e5.appendChild(e6);
        this.addAttribute(this.document, e6, "test", "gml:description");
        e7 = this.document.createElementNS(NS_XSL, "value-of");
        e6.appendChild(e7);
        this.addAttribute(this.document, e7, "select", "./gml:description");
        e6 = this.document.createElementNS(NS_XSL, "otherwise");
        e5.appendChild(e6);
        s = ci.taggedValue("description");
        if (s != null && s.length() > 0) {
            e6.appendChild(this.document.createTextNode(s));
        } else {
            s = ci.documentation();
            if (s != null && (s = s.replace("-- Definition --", "")).contains("-- Description --")) {
                int end = s.indexOf("-- Description --");
                if (end == -1) {
                    end = s.length();
                }
                s = s.substring(0, end).trim();
            }
            e6.appendChild(this.document.createTextNode(s));
        }
        e3 = this.document.createElementNS(NS_XSL, "apply-templates");
        e2.appendChild(e3);
        this.addAttribute(this.document, e3, "select", "*/gml:Polygon|*/gml:LineString|*/gml:Point");
        this.createAllPropertyDefinitions(this.pi, ci, true, schema, schemaData);
        PackageInfo pix = this.getFolderPackage(ci);
        if (pix != null && (s = this.folderMapFeatureTypes.get(pix)) != null) {
            if (s.length() == 0) {
                this.folderMapFeatureTypes.put(pix, ci.qname());
            } else {
                this.folderMapFeatureTypes.put(pix, s + "," + ci.qname());
            }
        }
    }

    private String getString(Node pred) {
        String test = "";
        if (pred.getLocalName().equals("Or") || pred.getLocalName().equals("And") || pred.getLocalName().equals("Not")) {
            NodeList preds2 = pred.getChildNodes();
            test = test + " (";
            for (int k = 0; k < preds2.getLength(); ++k) {
                Node pred2 = preds2.item(k);
                if (k > 0) {
                    if (pred.getLocalName().equals("Or")) {
                        test = test + " or ";
                    } else if (pred.getLocalName().equals("And")) {
                        test = test + " and ";
                    }
                }
                if (k == 0 && pred.getLocalName().equals("Not")) {
                    test = test + "not ";
                }
                test = test + this.getString(pred2);
            }
            test = test + ") ";
        } else if (pred.getLocalName().startsWith("PropertyIs")) {
            NodeList preds2 = pred.getChildNodes();
            for (int k = 0; k < preds2.getLength(); ++k) {
                Node pred2 = preds2.item(k);
                String s = this.getString(pred2);
                if (k > 0) {
                    if (pred.getLocalName().equals("PropertyIsEqualTo")) {
                        test = test + " = ";
                    } else if (pred.getLocalName().equals("PropertyIsNotEqualTo")) {
                        test = test + " != ";
                    } else if (pred.getLocalName().equals("PropertyIsLessThan")) {
                        test = test + " &lt; ";
                        s = s.replace("'", "");
                    } else if (pred.getLocalName().equals("PropertyIsLessThanOrEqualTo")) {
                        test = test + " &lt;= ";
                        s = s.replace("'", "");
                    } else if (pred.getLocalName().equals("PropertyIsGreaterThan")) {
                        test = test + " &gt; ";
                        s = s.replace("'", "");
                    } else if (pred.getLocalName().equals("PropertyIsGreaterThanOrEqualTo")) {
                        test = test + " &gt;= ";
                        s = s.replace("'", "");
                    } else {
                        test = test + " !!!" + pred.getLocalName() + " ";
                    }
                }
                test = test + s;
            }
        } else {
            test = pred.getLocalName().equals("PropertyName") ? test + pred.getTextContent() : (pred.getLocalName().equals("Literal") ? test + "'" + pred.getTextContent() + "'" : test + " !!!" + pred.getLocalName() + " ");
        }
        return test;
    }

    private PackageInfo getFolderPackage(ClassInfo ci) {
        PackageInfo pi = ci.pkg();
        if (pi == null) {
            return null;
        }
        if (this.folderMapElement.containsKey(pi)) {
            return pi;
        }
        return this.getFolderPackage(pi.owner());
    }

    private PackageInfo getFolderPackage(PackageInfo pi) {
        if (pi == null) {
            return null;
        }
        if (this.folderMapElement.containsKey(pi)) {
            return pi;
        }
        return this.getFolderPackage(pi.owner());
    }

    private String getTaggedProperty(ClassInfo ci, String tag) {
        String s;
        if (ci == null) {
            return null;
        }
        if (ci.pkg() == null) {
            this.result.addError(null, 139, ci.name());
            return null;
        }
        for (PropertyInfo propi : ci.properties().values()) {
            s = propi.taggedValue(tag);
            if (s != null && s.toLowerCase().equals("true")) {
                return propi.qname();
            }
            if (!tag.equals("kmlName") || (s = this.options.parameter(this.getClass().getName(), "kmlName(" + propi.name() + ")")) == null || !s.toLowerCase().equals("true")) continue;
            return propi.qname();
        }
        HashSet<String> st = ci.supertypes();
        if (st != null) {
            Iterator<String> i = st.iterator();
            while (i.hasNext()) {
                s = this.getTaggedProperty(this.model.classById(i.next()), tag);
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    private int createAllPropertyDefinitions(PackageInfo asi, ClassInfo ci, boolean local, Element schema, Element schemaData) {
        if (ci == null) {
            return 0;
        }
        if (ci.pkg() == null) {
            this.result.addError(null, 139, ci.name());
            return 0;
        }
        int ct = 0;
        HashSet<String> st = ci.supertypes();
        if (st != null) {
            Iterator<String> i = st.iterator();
            while (i.hasNext()) {
                ct += this.createAllPropertyDefinitions(asi, this.model.classById(i.next()), false, schema, schemaData);
            }
        }
        for (PropertyInfo propi : ci.properties().values()) {
            ct += this.createPropertyDefinition(asi, ci, propi, local, schema, schemaData);
        }
        return ct;
    }

    private CDATASection cdataProperty(ClassInfo ci, PropertyInfo propi) {
        String s = this.kmlReference(ci);
        String s2 = propi.documentation().trim().replace("'", "").replace("\"", "");
        String s3 = "<b><i>" + this.stringProperty(propi) + "</i></b>";
        CDATASection cd = null;
        if (s != null && s2 != null) {
            cd = this.document.createCDATASection("<a href='" + s + "' title='" + s2 + "'>" + s3 + "</a>");
        } else if (s != null) {
            cd = this.document.createCDATASection("<a href='" + s + "'>" + s3 + "</a>");
        } else if (s2 != null) {
            cd = this.document.createCDATASection("<div title='" + s2 + "'>" + s3 + "</div>");
        }
        return cd;
    }

    private int createPropertyDefinition(PackageInfo asi, ClassInfo ci, PropertyInfo propi, boolean local, Element schema, Element schemaData) {
        CDATASection cd;
        Element e2;
        Element e1;
        if (!propi.isNavigable()) {
            return 0;
        }
        if (propi.isRestriction()) {
            return 0;
        }
        ClassInfo vi = this.model.classById(propi.typeInfo().id);
        if (vi == null) {
            return 0;
        }
        String t = vi.name();
        int cat = vi.category();
        if (t.startsWith("GM_")) {
            return 0;
        }
        if (this.withSchema) {
            e1 = this.document.createElementNS(NS_KML, "SimpleField");
            this.addAttribute(this.document, e1, "type", "string");
            this.addAttribute(this.document, e1, "name", propi.name());
            schema.appendChild(e1);
            e2 = this.document.createElementNS(NS_KML, "displayName");
            e1.appendChild(e2);
            this.addAttribute(this.document, e1, "type", "string");
            cd = this.cdataProperty(ci, propi);
            if (cd != null) {
                e2.appendChild(cd);
            }
        }
        e1 = this.document.createElementNS(NS_XSL, "if");
        if (!this.withEmptyProps) {
            schemaData.appendChild(e1);
            this.addAttribute(this.document, e1, "test", "(count(" + propi.qname() + ") - count(" + propi.qname() + "[@xsi:nil='true']))>0");
        }
        if (this.withSchema) {
            e2 = this.document.createElementNS(NS_KML, "SimpleData");
            if (!this.withEmptyProps) {
                e1.appendChild(e2);
            } else {
                schemaData.appendChild(e2);
            }
            if (this.options.parameter(this.getClass().getName(), "propNameCase") != null && this.options.parameter(this.getClass().getName(), "propNameCase").equalsIgnoreCase("capitalized")) {
                this.addAttribute(this.document, e2, "name", propi.name().substring(0, 1).toUpperCase().concat(propi.name().substring(1)));
            } else {
                this.addAttribute(this.document, e2, "name", propi.name());
            }
        } else {
            Element e0 = this.document.createElementNS(NS_KML, "Data");
            if (!this.withEmptyProps) {
                e1.appendChild(e0);
            } else {
                schemaData.appendChild(e0);
            }
            String sn = this.stringProperty(propi);
            if (this.options.parameter(this.getClass().getName(), "propNameCase") != null && this.options.parameter(this.getClass().getName(), "propNameCase").equalsIgnoreCase("capitalized")) {
                this.addAttribute(this.document, e0, "name", sn.substring(0, 1).toUpperCase().concat(sn.substring(1)));
            } else {
                this.addAttribute(this.document, e0, "name", sn);
            }
            e2 = this.document.createElementNS(NS_KML, "displayName");
            e0.appendChild(e2);
            cd = this.cdataProperty(ci, propi);
            if (cd != null) {
                e2.appendChild(cd);
            }
            e2 = this.document.createElementNS(NS_KML, "value");
            e0.appendChild(e2);
        }
        Element e3 = this.document.createElementNS(NS_XSL, "for-each");
        e2.appendChild(e3);
        this.addAttribute(this.document, e3, "select", propi.qname());
        Element e4 = this.document.createElementNS(NS_XSL, "if");
        e3.appendChild(e4);
        this.addAttribute(this.document, e4, "test", "position()>1");
        cd = this.document.createCDATASection("<hr/>");
        e4.appendChild(cd);
        if (t.equals("CharacterString") || t.equals("Integer") || t.equals("Real") || t.equals("Number") || t.equals("Character")) {
            e4 = this.document.createElementNS(NS_XSL, "value-of");
            e3.appendChild(e4);
            this.addAttribute(this.document, e4, "select", ".");
        } else if (t.equals("Date")) {
            e4 = this.document.createElementNS(NS_XSL, "value-of");
            e3.appendChild(e4);
            this.addAttribute(this.document, e4, "select", "format-date(., '[D]-[M]-[Y]', 'en', 'AD', 'UK')");
        } else if (t.equals("Time")) {
            e4 = this.document.createElementNS(NS_XSL, "value-of");
            e3.appendChild(e4);
            this.addAttribute(this.document, e4, "select", "format-time(.,'[H01]:[m01]:[s01]', 'en', 'AD', 'UK')");
        } else if (t.equals("DateTime")) {
            e4 = this.document.createElementNS(NS_XSL, "value-of");
            e3.appendChild(e4);
            this.addAttribute(this.document, e4, "select", "format-dateTime(.,'[D]-[M]-[Y] at [H01]:[m01]:[s01]', 'en', 'AD', 'UK')");
        } else if (t.equals("Measure") || t.equals("Length") || t.equals("Distance") || t.equals("Area") || t.equals("Volume")) {
            e4 = this.document.createElementNS(NS_XSL, "value-of");
            e3.appendChild(e4);
            this.addAttribute(this.document, e4, "select", ".");
            e4 = this.document.createElementNS(NS_XSL, "text");
            e3.appendChild(e4);
            e4.appendChild(this.document.createTextNode(" "));
            e4 = this.document.createElementNS(NS_XSL, "value-of");
            e3.appendChild(e4);
            this.addAttribute(this.document, e4, "select", "@uom");
        } else if (cat == 2) {
            e4 = this.document.createElementNS(NS_XSL, "choose");
            e3.appendChild(e4);
            Element e5 = this.document.createElementNS(NS_XSL, "when");
            e4.appendChild(e5);
            this.addAttribute(this.document, e5, "test", "@codeSpace");
            cd = this.document.createCDATASection("<a href='");
            e5.appendChild(cd);
            Element e6 = this.document.createElementNS(NS_XSL, "value-of");
            e5.appendChild(e6);
            this.addAttribute(this.document, e6, "select", "@codeSpace");
            cd = this.document.createCDATASection("'>");
            e5.appendChild(cd);
            e6 = this.document.createElementNS(NS_XSL, "value-of");
            e5.appendChild(e6);
            this.addAttribute(this.document, e6, "select", ".");
            cd = this.document.createCDATASection("</a>");
            e5.appendChild(cd);
            e5 = this.document.createElementNS(NS_XSL, "otherwise");
            e4.appendChild(e5);
            e6 = this.document.createElementNS(NS_XSL, "value-of");
            e5.appendChild(e6);
            this.addAttribute(this.document, e6, "select", ".");
        } else if (cat == 3) {
            e4 = this.document.createElementNS(NS_XSL, "value-of");
            e3.appendChild(e4);
            this.addAttribute(this.document, e4, "select", ".");
        } else if (cat == 1) {
            Element e5;
            e4 = this.document.createElementNS(NS_XSL, "choose");
            e3.appendChild(e4);
            if (this.options.parameter(this.getClass().getName(), "hrefPropOnlyId") != null && this.options.parameter(this.getClass().getName(), "hrefPropOnlyId").equalsIgnoreCase("true")) {
                e5 = this.document.createElementNS(NS_XSL, "when");
                e4.appendChild(e5);
                this.addAttribute(this.document, e5, "test", "@xlink:href");
                Element e6 = this.document.createElementNS(NS_XSL, "value-of");
                e5.appendChild(e6);
                this.addAttribute(this.document, e6, "select", "reverse(tokenize(@xlink:href,':'))[1]");
            } else {
                e5 = this.document.createElementNS(NS_XSL, "when");
                e4.appendChild(e5);
                this.addAttribute(this.document, e5, "test", "@xlink:href");
                cd = this.document.createCDATASection("<a href='");
                e5.appendChild(cd);
                Element e6 = this.document.createElementNS(NS_XSL, "value-of");
                e5.appendChild(e6);
                this.addAttribute(this.document, e6, "select", "@xlink:href");
                cd = this.document.createCDATASection("'>Placemark (");
                e5.appendChild(cd);
                e6 = this.document.createElementNS(NS_XSL, "value-of");
                e5.appendChild(e6);
                this.addAttribute(this.document, e6, "select", "@xlink:href");
                cd = this.document.createCDATASection(")</a>");
                e5.appendChild(cd);
            }
            e5 = this.document.createElementNS(NS_XSL, "otherwise");
            e4.appendChild(e5);
            cd = this.document.createCDATASection("Placemark");
            e5.appendChild(cd);
        } else if (cat == 5) {
            e4 = this.document.createElementNS(NS_XSL, "call-template");
            e3.appendChild(e4);
            this.addAttribute(this.document, e4, "name", "DataType");
        } else {
            e4 = this.document.createElementNS(NS_XSL, "value-of");
            e3.appendChild(e4);
            this.addAttribute(this.document, e4, "select", ".");
            this.result.addError("Unsupported type in KML encoding rule: " + t);
        }
        return 1;
    }

    public void write() {
        if (this.printed) {
            return;
        }
        Element e1 = this.document.createElementNS(NS_XSL, "template");
        this.addAttribute(this.document, e1, "name", "DataType");
        this.root.appendChild(e1);
        CDATASection cd = this.document.createCDATASection("<table>");
        e1.appendChild(cd);
        Element e7 = this.document.createElementNS(NS_XSL, "for-each");
        e1.appendChild(e7);
        this.addAttribute(this.document, e7, "select", "*/*");
        Element e2 = this.document.createElementNS(NS_XSL, "if");
        e7.appendChild(e2);
        this.addAttribute(this.document, e2, "test", "count(@xsi:nil)=0 or @xsi:nil!='true'");
        cd = this.document.createCDATASection("<tr><td><small><i>");
        e2.appendChild(cd);
        Element e3 = this.document.createElementNS(NS_XSL, "value-of");
        e2.appendChild(e3);
        if (this.options.parameter(this.getClass().getName(), "propNameCase") != null && this.options.parameter(this.getClass().getName(), "propNameCase").equalsIgnoreCase("capitalized")) {
            this.addAttribute(this.document, e3, "select", "concat(upper-case(substring(local-name(.),1,1)),substring(local-name(.),2))");
        } else {
            this.addAttribute(this.document, e3, "select", "local-name(.)");
        }
        cd = this.document.createCDATASection("</i></small></td><td>");
        e2.appendChild(cd);
        e3 = this.document.createElementNS(NS_XSL, "choose");
        e2.appendChild(e3);
        Element e4 = this.document.createElementNS(NS_XSL, "when");
        e3.appendChild(e4);
        this.addAttribute(this.document, e4, "test", "*/*");
        Element e5 = this.document.createElementNS(NS_XSL, "call-template");
        e4.appendChild(e5);
        this.addAttribute(this.document, e5, "name", "DataType");
        e4 = this.document.createElementNS(NS_XSL, "otherwise");
        e3.appendChild(e4);
        e5 = this.document.createElementNS(NS_XSL, "value-of");
        e4.appendChild(e5);
        this.addAttribute(this.document, e5, "select", ".");
        cd = this.document.createCDATASection("</td></tr>");
        e2.appendChild(cd);
        cd = this.document.createCDATASection("</table>");
        e1.appendChild(cd);
        Element e0 = this.document.createElementNS(NS_XSL, "template");
        this.addAttribute(this.document, e0, "match", "gml:Polygon");
        this.root.appendChild(e0);
        e1 = this.document.createElementNS(NS_KML, "MultiGeometry");
        e0.appendChild(e1);
        e2 = this.document.createElementNS(NS_KML, "Point");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_KML, "coordinates");
        e2.appendChild(e3);
        e4 = this.document.createElementNS(NS_XSL, "variable");
        e3.appendChild(e4);
        this.addAttribute(this.document, e4, "name", "ord");
        this.addAttribute(this.document, e4, "select", "fn:tokenize(gml:exterior/gml:LinearRing/gml:posList, ' ', 'm')");
        e4 = this.document.createElementNS(NS_XSL, "variable");
        e3.appendChild(e4);
        this.addAttribute(this.document, e4, "name", "lat");
        this.addAttribute(this.document, e4, "as", "xs:double*");
        e5 = this.document.createElementNS(NS_XSL, "for-each");
        e4.appendChild(e5);
        this.addAttribute(this.document, e5, "select", "$ord");
        Element e6 = this.document.createElementNS(NS_XSL, "if");
        e5.appendChild(e6);
        this.addAttribute(this.document, e6, "test", "position() mod 2 = 1");
        e7 = this.document.createElementNS(NS_XSL, "sequence");
        e6.appendChild(e7);
        this.addAttribute(this.document, e7, "select", "xs:double(.)");
        e4 = this.document.createElementNS(NS_XSL, "variable");
        e3.appendChild(e4);
        this.addAttribute(this.document, e4, "name", "long");
        this.addAttribute(this.document, e4, "as", "xs:double*");
        e5 = this.document.createElementNS(NS_XSL, "for-each");
        e4.appendChild(e5);
        this.addAttribute(this.document, e5, "select", "$ord");
        e6 = this.document.createElementNS(NS_XSL, "if");
        e5.appendChild(e6);
        this.addAttribute(this.document, e6, "test", "position() mod 2 = 0");
        e7 = this.document.createElementNS(NS_XSL, "sequence");
        e6.appendChild(e7);
        this.addAttribute(this.document, e7, "select", "xs:double(.)");
        e4 = this.document.createElementNS(NS_XSL, "value-of");
        e3.appendChild(e4);
        this.addAttribute(this.document, e4, "select", "avg($long)");
        e4 = this.document.createElementNS(NS_XSL, "text");
        e3.appendChild(e4);
        e4.appendChild(this.document.createTextNode(","));
        e4 = this.document.createElementNS(NS_XSL, "value-of");
        e3.appendChild(e4);
        this.addAttribute(this.document, e4, "select", "avg($lat)");
        e2 = this.document.createElementNS(NS_KML, "Polygon");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_KML, "tessellate");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode("1"));
        e3 = this.document.createElementNS(NS_KML, "altitudeMode");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode("clampToGround"));
        e3 = this.document.createElementNS(NS_KML, "outerBoundaryIs");
        e2.appendChild(e3);
        e4 = this.document.createElementNS(NS_XSL, "apply-templates");
        e3.appendChild(e4);
        this.addAttribute(this.document, e4, "select", "gml:exterior/gml:LinearRing");
        e3 = this.document.createElementNS(NS_XSL, "for-each");
        e2.appendChild(e3);
        this.addAttribute(this.document, e3, "select", "gml:interior");
        e4 = this.document.createElementNS(NS_KML, "innerBoundaryIs");
        e3.appendChild(e4);
        e5 = this.document.createElementNS(NS_XSL, "apply-templates");
        e4.appendChild(e5);
        this.addAttribute(this.document, e5, "select", "gml:LinearRing");
        e1 = this.document.createElementNS(NS_XSL, "template");
        this.addAttribute(this.document, e1, "match", "gml:LinearRing");
        this.root.appendChild(e1);
        e2 = this.document.createElementNS(NS_KML, "LinearRing");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_XSL, "apply-templates");
        e2.appendChild(e3);
        this.addAttribute(this.document, e3, "select", "gml:posList");
        e0 = this.document.createElementNS(NS_XSL, "template");
        this.addAttribute(this.document, e0, "match", "gml:LineString");
        this.root.appendChild(e0);
        e1 = this.document.createElementNS(NS_KML, "MultiGeometry");
        e0.appendChild(e1);
        e2 = this.document.createElementNS(NS_KML, "Point");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_KML, "coordinates");
        e2.appendChild(e3);
        e4 = this.document.createElementNS(NS_XSL, "variable");
        e3.appendChild(e4);
        this.addAttribute(this.document, e4, "name", "ord");
        this.addAttribute(this.document, e4, "select", "fn:tokenize(gml:posList, ' ', 'm')");
        e4 = this.document.createElementNS(NS_XSL, "variable");
        e3.appendChild(e4);
        this.addAttribute(this.document, e4, "name", "lat");
        this.addAttribute(this.document, e4, "as", "xs:double*");
        e5 = this.document.createElementNS(NS_XSL, "for-each");
        e4.appendChild(e5);
        this.addAttribute(this.document, e5, "select", "$ord");
        e6 = this.document.createElementNS(NS_XSL, "if");
        e5.appendChild(e6);
        this.addAttribute(this.document, e6, "test", "position() mod 2 = 1");
        e7 = this.document.createElementNS(NS_XSL, "sequence");
        e6.appendChild(e7);
        this.addAttribute(this.document, e7, "select", "xs:double(.)");
        e4 = this.document.createElementNS(NS_XSL, "variable");
        e3.appendChild(e4);
        this.addAttribute(this.document, e4, "name", "long");
        this.addAttribute(this.document, e4, "as", "xs:double*");
        e5 = this.document.createElementNS(NS_XSL, "for-each");
        e4.appendChild(e5);
        this.addAttribute(this.document, e5, "select", "$ord");
        e6 = this.document.createElementNS(NS_XSL, "if");
        e5.appendChild(e6);
        this.addAttribute(this.document, e6, "test", "position() mod 2 = 0");
        e7 = this.document.createElementNS(NS_XSL, "sequence");
        e6.appendChild(e7);
        this.addAttribute(this.document, e7, "select", "xs:double(.)");
        e4 = this.document.createElementNS(NS_XSL, "value-of");
        e3.appendChild(e4);
        this.addAttribute(this.document, e4, "select", "avg($long)");
        e4 = this.document.createElementNS(NS_XSL, "text");
        e3.appendChild(e4);
        e4.appendChild(this.document.createTextNode(","));
        e4 = this.document.createElementNS(NS_XSL, "value-of");
        e3.appendChild(e4);
        this.addAttribute(this.document, e4, "select", "avg($lat)");
        e2 = this.document.createElementNS(NS_KML, "LineString");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_KML, "tessellate");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode("1"));
        e3 = this.document.createElementNS(NS_KML, "altitudeMode");
        e2.appendChild(e3);
        e3.appendChild(this.document.createTextNode("clampToGround"));
        e3 = this.document.createElementNS(NS_XSL, "apply-templates");
        e2.appendChild(e3);
        this.addAttribute(this.document, e3, "select", "gml:posList");
        e0 = this.document.createElementNS(NS_XSL, "template");
        this.addAttribute(this.document, e0, "match", "gml:Point");
        this.root.appendChild(e0);
        e1 = this.document.createElementNS(NS_KML, "Point");
        e0.appendChild(e1);
        e2 = this.document.createElementNS(NS_KML, "altitudeMode");
        e1.appendChild(e2);
        e2.appendChild(this.document.createTextNode("clampToGround"));
        e2 = this.document.createElementNS(NS_XSL, "apply-templates");
        e1.appendChild(e2);
        this.addAttribute(this.document, e2, "select", "gml:pos");
        e1 = this.document.createElementNS(NS_XSL, "template");
        this.addAttribute(this.document, e1, "match", "gml:posList|gml:pos");
        this.root.appendChild(e1);
        e2 = this.document.createElementNS(NS_KML, "coordinates");
        e1.appendChild(e2);
        e3 = this.document.createElementNS(NS_XSL, "variable");
        e2.appendChild(e3);
        this.addAttribute(this.document, e3, "name", "ord");
        this.addAttribute(this.document, e3, "select", "fn:tokenize(., ' ', 'm')");
        e3 = this.document.createElementNS(NS_XSL, "for-each");
        e2.appendChild(e3);
        this.addAttribute(this.document, e3, "select", "$ord");
        e4 = this.document.createElementNS(NS_XSL, "choose");
        e3.appendChild(e4);
        e5 = this.document.createElementNS(NS_XSL, "when");
        e4.appendChild(e5);
        this.addAttribute(this.document, e5, "test", "position() mod 2 = 1");
        e6 = this.document.createElementNS(NS_XSL, "variable");
        e5.appendChild(e6);
        this.addAttribute(this.document, e6, "name", "pos");
        this.addAttribute(this.document, e6, "select", "fn:number(position()+1)");
        e6 = this.document.createElementNS(NS_XSL, "value-of");
        e5.appendChild(e6);
        this.addAttribute(this.document, e6, "select", "$ord[$pos]");
        e6 = this.document.createElementNS(NS_XSL, "text");
        e5.appendChild(e6);
        e6.appendChild(this.document.createTextNode(","));
        e6 = this.document.createElementNS(NS_XSL, "value-of");
        e5.appendChild(e6);
        this.addAttribute(this.document, e6, "select", ".");
        e5 = this.document.createElementNS(NS_XSL, "otherwise");
        e4.appendChild(e5);
        e6 = this.document.createElementNS(NS_XSL, "if");
        e5.appendChild(e6);
        this.addAttribute(this.document, e6, "test", "not(position()=last())");
        e7 = this.document.createElementNS(NS_XSL, "text");
        e6.appendChild(e7);
        e7.appendChild(this.document.createTextNode(" "));
        for (PackageInfo pix : this.folderMapElement.keySet()) {
            e1 = this.folderMapElement.get(pix);
            String s = this.folderMapFeatureTypes.get(pix);
            if (e1 == null || s == null) continue;
            e1.appendChild(this.kmlDocument.createTextNode("CLIENTINFO=[clientVersion];[kmlVersion];[clientName];[language]&TYPENAME=" + s));
        }
        Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        outputFormat.setProperty("indent", "yes");
        outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        outputFormat.setProperty("encoding", "UTF-8");
        try {
            File file = new File(this.outputDirectory + "/" + this.pi.name() + "_gml2kml.xsl");
            FileWriter outputXML = new FileWriter(file);
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            serializer.setWriter((Writer)outputXML);
            serializer.asDOMSerializer().serialize((Node)this.document);
            outputXML.close();
            this.result.addResult(this.getTargetID(), this.outputDirectory, this.pi.name() + "_gml2kml.xsl", this.pi.targetNamespace());
            file = new File(this.outputDirectory + "/" + this.pi.name() + "_root.kml");
            outputXML = new FileWriter(file);
            serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            serializer.setWriter((Writer)outputXML);
            serializer.asDOMSerializer().serialize((Node)this.kmlDocument);
            outputXML.close();
            this.result.addResult(this.getTargetID(), this.outputDirectory, this.pi.name() + "_root.kml", this.pi.targetNamespace());
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        this.printed = true;
    }

    public int getTargetID() {
        return 6;
    }
}

