/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic;

import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfoImpl;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.OperationInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericClassInfo
extends ClassInfoImpl {
    protected Options options = null;
    protected ShapeChangeResult result = null;
    protected GenericModel model = null;
    protected String id = null;
    protected String name = null;
    protected String stereotype = null;
    protected HashMap<String, String> taggedValues = null;
    protected boolean includePropertyType = true;
    protected boolean includeByValuePropertyType = false;
    protected boolean isCollection = false;
    protected boolean asDictionary = false;
    protected boolean asGroup = false;
    protected boolean asCharacterString = false;
    protected boolean hasNilReason = false;
    protected PackageInfo pkg = null;
    protected boolean isAbstract = false;
    protected boolean isLeaf = false;
    protected AssociationInfo assocClass = null;
    protected HashSet<String> supertypes = new HashSet();
    protected HashSet<String> subtypes = new HashSet();
    protected ClassInfo baseClass = null;
    protected TreeMap<StructuredNumber, PropertyInfo> properties = null;
    protected Vector<Constraint> constraints = new Vector();
    protected boolean suppressed = false;
    protected boolean asDictionaryGml33 = true;
    protected String xmlSchemaType = null;

    public GenericClassInfo(GenericModel model, String id, String name, int category) {
        this.model = model;
        this.options = model.options();
        this.result = model.result();
        this.id = id;
        this.name = name;
        this.category = category;
        switch (category) {
            case 1: {
                this.stereotype = "featuretype";
            }
            case 2: {
                this.stereotype = "codelist";
            }
            case 3: {
                this.stereotype = "enumeration";
            }
            case 5: {
                this.stereotype = "datatype";
            }
            case 6: {
                this.stereotype = "type";
            }
            case 7: {
                this.stereotype = "basictype";
            }
            case 8: {
                this.stereotype = "union";
            }
            case 9: {
                this.stereotype = "union";
            }
        }
        this.stereotype = "";
    }

    public void setXmlSchemaType(String xmlSchemaType) {
        this.xmlSchemaType = xmlSchemaType;
    }

    public void setIncludePropertyType(boolean includePropertyType) {
        this.includePropertyType = includePropertyType;
    }

    public void setIncludeByValuePropertyType(boolean includeByValuePropertyType) {
        this.includeByValuePropertyType = includeByValuePropertyType;
    }

    public void setIsCollection(boolean isCollection) {
        this.isCollection = isCollection;
    }

    public void setAsDictionary(boolean asDictionary) {
        this.asDictionary = asDictionary;
    }

    public void setAsGroup(boolean asGroup) {
        this.asGroup = asGroup;
    }

    public void setAsCharacterString(boolean asCharacterString) {
        this.asCharacterString = asCharacterString;
    }

    public void setHasNilReason(boolean hasNilReason) {
        this.hasNilReason = hasNilReason;
    }

    public void setPkg(PackageInfo pkg) {
        this.pkg = pkg;
    }

    public void setIsAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setIsLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public void setAssocInfo(AssociationInfo assocClass) {
        this.assocClass = assocClass;
    }

    public void setSupertypes(HashSet<String> supertypes) {
        this.supertypes = supertypes;
    }

    public void setSubtypes(HashSet<String> subtypes) {
        this.subtypes = subtypes;
    }

    public void setBaseClass(ClassInfo baseClass) {
        this.baseClass = baseClass;
    }

    public void setProperties(TreeMap<StructuredNumber, PropertyInfo> properties) {
        this.properties = properties;
    }

    public void setConstraints(Vector<Constraint> constraints) {
        this.constraints = constraints;
    }

    public void setSuppressed(boolean suppressed) {
        this.suppressed = suppressed;
    }

    public void setAsDictionaryGml33(boolean asDictionaryGml33) {
        this.asDictionaryGml33 = asDictionaryGml33;
    }

    @Override
    public String stereotype() {
        return this.stereotype;
    }

    @Override
    public String aliasName() {
        return this.aliasName;
    }

    @Override
    public String documentation() {
        return this.documentation;
    }

    @Override
    public String fullName() {
        if (this.pkg != null && this.name != null) {
            return this.pkg.fullName() + "::" + this.name;
        }
        return null;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Model model() {
        return this.model;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Options options() {
        return this.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.result;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
        this.definition = null;
        this.description = null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setModel(GenericModel model) {
        this.model = model;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public void setResult(ShapeChangeResult result) {
        this.result = result;
    }

    public void setStereotype(String stereotype) {
        this.stereotype = stereotype;
    }

    public void setTaggedValues(HashMap<String, String> taggedValues) {
        this.taggedValues = taggedValues;
    }

    @Override
    public boolean hasNilReason() {
        return this.hasNilReason;
    }

    @Override
    public PackageInfo pkg() {
        return this.pkg;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public AssociationInfo isAssocClass() {
        return this.assocClass;
    }

    @Override
    public HashSet<String> supertypes() {
        return this.supertypes;
    }

    @Override
    public HashSet<String> subtypes() {
        return this.subtypes;
    }

    public boolean hasSupertypes() {
        return this.supertypes != null && this.supertypes.size() > 0;
    }

    public boolean hasSubtypes() {
        return this.subtypes != null && this.subtypes.size() > 0;
    }

    @Override
    public ClassInfo baseClass() {
        return this.baseClass;
    }

    @Override
    public TreeMap<StructuredNumber, PropertyInfo> properties() {
        return this.properties;
    }

    @Override
    public Vector<Constraint> constraints() {
        return this.constraints;
    }

    @Override
    public PropertyInfo property(String name) {
        PropertyInfo pi;
        for (PropertyInfo pi2 : this.properties.values()) {
            if (!pi2.name().equals(name)) continue;
            return pi2;
        }
        if (this.baseClass != null && (pi = this.baseClass.property(name)) != null) {
            return pi;
        }
        return null;
    }

    @Override
    public OperationInfo operation(String name, String[] types) {
        return null;
    }

    @Override
    public String taggedValue(String tag) {
        if (this.taggedValues == null) {
            return null;
        }
        return this.taggedValues.get(tag);
    }

    @Override
    public HashMap<String, String> taggedValues() {
        return this.taggedValues;
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        String[] tags = tagList.split(",");
        HashMap<String, String> res = new HashMap<String, String>(tags.length);
        for (String tag : tags) {
            String t = tag.trim();
            String v = this.taggedValues.get(t);
            if (v == null) continue;
            res.put(t, v);
        }
        return res;
    }

    @Override
    public String xmlSchemaType() {
        return this.xmlSchemaType;
    }

    @Override
    public boolean includeByValuePropertyType() {
        return this.includeByValuePropertyType;
    }

    @Override
    public boolean includePropertyType() {
        return this.includePropertyType;
    }

    @Override
    public boolean isCollection() {
        return this.isCollection;
    }

    @Override
    public boolean asDictionary() {
        return this.asDictionary;
    }

    @Override
    public boolean asDictionaryGml33() {
        return this.asDictionaryGml33;
    }

    @Override
    public boolean asGroup() {
        return this.asGroup;
    }

    @Override
    public boolean asCharacterString() {
        return this.asCharacterString;
    }

    @Override
    public boolean suppressed() {
        return this.suppressed;
    }

    public String toString(String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(indent + this.name + "\n");
        sb.append(indent + indent + "properties:\n");
        for (PropertyInfo property : this.properties.values()) {
            sb.append(((GenericPropertyInfo)property).toString(indent + indent));
        }
        return sb.toString();
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public void removeSubtype(String subtypeId) {
        this.subtypes.remove(subtypeId);
    }

    public void removeSupertype(String supertypeId) {
        if (this.supertypes == null || this.supertypes.size() == 0 || supertypeId == null) {
            return;
        }
        this.supertypes.remove(supertypeId);
    }

    public void addProperty(GenericPropertyInfo newProperty, GenericModel.PropertyCopyDuplicatBehaviorIndicator duplicateHandling) {
        PropertyInfo existingPropWithSameName;
        if (this.properties == null) {
            this.properties = new TreeMap();
        }
        if ((existingPropWithSameName = this.propertyByName(newProperty.name())) == null || duplicateHandling == GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD) {
            this.properties.put(newProperty.sequenceNumber(), newProperty);
        } else if (duplicateHandling != GenericModel.PropertyCopyDuplicatBehaviorIndicator.IGNORE && duplicateHandling == GenericModel.PropertyCopyDuplicatBehaviorIndicator.OVERWRITE) {
            this.properties.remove(existingPropWithSameName).sequenceNumber();
            this.properties.put(newProperty.sequenceNumber(), newProperty);
        }
    }

    public StructuredNumber getNextSequenceNumber() {
        int maxSequenceNumber = Integer.MIN_VALUE;
        if (this.properties == null || this.properties.isEmpty()) {
            maxSequenceNumber = 0;
        } else {
            Set<StructuredNumber> enumSeqNumbers = this.properties.keySet();
            for (StructuredNumber strucNum : enumSeqNumbers) {
                if (strucNum.components[0] <= maxSequenceNumber) continue;
                maxSequenceNumber = strucNum.components[0];
            }
        }
        int result = maxSequenceNumber + 1;
        return new StructuredNumber(result);
    }

    public void addConstraints(Vector<Constraint> newConstraints) {
        if (newConstraints == null || newConstraints.isEmpty()) {
            return;
        }
        if (this.constraints == null) {
            this.constraints = new Vector();
        }
        this.constraints.addAll(newConstraints);
    }

    public void remove(GenericPropertyInfo genPi) {
        if (genPi != null) {
            this.properties.remove(genPi.sequenceNumber);
        }
    }

    public void updateSubtypeName(String currentName, String newName) {
        if (this.subtypes != null && this.subtypes.contains(currentName)) {
            this.subtypes.remove(currentName);
            this.subtypes.add(newName);
        }
    }

    public void updateSupertypeName(String currentName, String newName) {
        if (this.supertypes != null && this.supertypes.contains(currentName)) {
            this.supertypes.remove(currentName);
            this.supertypes.add(newName);
        }
    }

    public GenericClassInfo createCopy(String copyId, String copyName, int copyCategory) {
        GenericClassInfo copy = new GenericClassInfo(this.model, copyId, copyName, copyCategory);
        copy.setAliasName(this.aliasName);
        copy.setDocumentation(this.documentation);
        copy.setStereotype(this.stereotype);
        copy.setTaggedValues((HashMap)this.taggedValues.clone());
        copy.setIncludePropertyType(this.includePropertyType);
        copy.setIncludeByValuePropertyType(this.includeByValuePropertyType);
        copy.setIsCollection(this.isCollection);
        copy.setAsDictionary(this.asDictionary);
        copy.setAsGroup(this.asGroup);
        copy.setAsCharacterString(this.asCharacterString);
        copy.setHasNilReason(this.hasNilReason);
        copy.setPkg(this.pkg);
        copy.setIsAbstract(this.isAbstract);
        copy.setIsLeaf(this.isLeaf);
        copy.setAssocInfo(this.assocClass);
        copy.setSupertypes((HashSet)this.supertypes.clone());
        copy.setSubtypes((HashSet)this.subtypes.clone());
        copy.setBaseClass(this.baseClass);
        TreeMap<StructuredNumber, PropertyInfo> copyProperties = new TreeMap<StructuredNumber, PropertyInfo>();
        for (PropertyInfo propI : this.properties.values()) {
            GenericPropertyInfo genProp = (GenericPropertyInfo)propI;
            GenericPropertyInfo propCopy = genProp.createCopy(genProp.id() + "_copyFor" + copyId);
            propCopy.setSequenceNumber(propI.sequenceNumber().createCopy());
            copyProperties.put(propCopy.sequenceNumber(), propCopy);
        }
        copy.setProperties(copyProperties);
        copy.setConstraints(this.constraints);
        copy.setSuppressed(this.suppressed);
        copy.setAsDictionaryGml33(this.asDictionaryGml33);
        copy.setXmlSchemaType(this.xmlSchemaType);
        return copy;
    }

    public void removeByStructuredNumber(StructuredNumber sn) {
        StructuredNumber keyFound = null;
        for (StructuredNumber key : this.properties.keySet()) {
            if (!key.equals(sn)) continue;
            keyFound = key;
        }
        if (keyFound != null) {
            this.properties.remove(keyFound);
        }
    }

    public void addPropertiesAtTop(List<GenericPropertyInfo> newProps, GenericModel.PropertyCopyDuplicatBehaviorIndicator duplicateHandling) {
        if (newProps == null || newProps.size() == 0) {
            return;
        }
        if (this.properties == null || this.properties.size() == 0) {
            this.properties = new TreeMap();
            for (GenericPropertyInfo newProp : newProps) {
                this.addProperty(newProp, duplicateHandling);
            }
        } else {
            int minMajorComponentExistingProps = Integer.MAX_VALUE;
            int maxMajorComponentNewProps = Integer.MIN_VALUE;
            for (GenericPropertyInfo newProp : newProps) {
                StructuredNumber snNewProp = newProp.sequenceNumber();
                if (snNewProp.components[0] <= maxMajorComponentNewProps) continue;
                maxMajorComponentNewProps = snNewProp.components[0];
            }
            for (StructuredNumber snExistingProp : this.properties.keySet()) {
                if (snExistingProp.components[0] >= minMajorComponentExistingProps) continue;
                minMajorComponentExistingProps = snExistingProp.components[0];
            }
            if (maxMajorComponentNewProps >= minMajorComponentExistingProps) {
                int shift = maxMajorComponentNewProps - minMajorComponentExistingProps + 1;
                for (StructuredNumber snOfExistingProp : this.properties.keySet()) {
                    snOfExistingProp.components[0] = snOfExistingProp.components[0] + shift;
                }
            }
            for (GenericPropertyInfo newProp : newProps) {
                this.addProperty(newProp, duplicateHandling);
            }
        }
    }

    public PropertyInfo propertyByName(String name) {
        if (this.properties == null || this.properties.isEmpty()) {
            return null;
        }
        for (PropertyInfo pi : this.properties.values()) {
            if (!pi.name().equals(name)) continue;
            return pi;
        }
        return null;
    }

    public void addPropertiesInSequence(List<GenericPropertyInfo> newProps, GenericModel.PropertyCopyDuplicatBehaviorIndicator duplicateHandling) {
        if (newProps == null || newProps.size() == 0) {
            return;
        }
        if (this.properties == null) {
            this.properties = new TreeMap();
        }
        for (GenericPropertyInfo newProp : newProps) {
            this.addProperty(newProp, duplicateHandling);
        }
    }

    public void addPropertiesAtBottom(List<GenericPropertyInfo> newProps, GenericModel.PropertyCopyDuplicatBehaviorIndicator duplicateHandling) {
        if (newProps == null || newProps.size() == 0) {
            return;
        }
        if (this.properties == null || this.properties.size() == 0) {
            this.properties = new TreeMap();
            for (GenericPropertyInfo newProp : newProps) {
                this.addProperty(newProp, duplicateHandling);
            }
        } else {
            int minMajorComponentNewProps = Integer.MAX_VALUE;
            int maxMajorComponentExistingProps = Integer.MIN_VALUE;
            for (GenericPropertyInfo newProp : newProps) {
                StructuredNumber snNewProp = newProp.sequenceNumber();
                if (snNewProp.components[0] >= minMajorComponentNewProps) continue;
                minMajorComponentNewProps = snNewProp.components[0];
            }
            for (StructuredNumber snExistingProp : this.properties.keySet()) {
                if (snExistingProp.components[0] <= maxMajorComponentExistingProps) continue;
                maxMajorComponentExistingProps = snExistingProp.components[0];
            }
            if (minMajorComponentNewProps <= maxMajorComponentExistingProps) {
                int shift = maxMajorComponentExistingProps - minMajorComponentNewProps + 1;
                for (GenericPropertyInfo newProp : newProps) {
                    StructuredNumber snNewProp = newProp.sequenceNumber();
                    snNewProp.components[0] = snNewProp.components[0] + shift;
                }
            }
            for (GenericPropertyInfo newProp : newProps) {
                this.addProperty(newProp, duplicateHandling);
            }
        }
    }
}

