/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfoImpl;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.sparx.Collection;
import org.sparx.Connector;
import org.sparx.Element;
import org.sparx.Package;
import org.sparx.TaggedValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageInfoEA
extends PackageInfoImpl
implements PackageInfo {
    protected boolean aliasAccessed = false;
    protected boolean connectorsAccessed = false;
    protected boolean documentationAccessed = false;
    protected Collection<Connector> conns = null;
    protected EADocument document = null;
    protected PackageInfoEA parentPI = null;
    protected HashSet<PackageInfoEA> childPI = new HashSet();
    protected HashSet<ClassInfoEA> childCI = new HashSet();
    protected Package eaPackage = null;
    protected int eaPackageId = 0;
    protected Element eaPackageElmt = null;
    protected int eaPackageElmtId = 0;
    protected String eaName = null;
    protected HashMap<String, String> taggedValuesCache = null;
    protected HashSet<String> stereotypesCache = null;
    protected HashSet<String> supplierIds = null;

    public Package getEaPackageObj() {
        return this.eaPackage;
    }

    public PackageInfoEA(EADocument doc, PackageInfoEA ppi, Package pack, Element packelmt) {
        this.document = doc;
        this.parentPI = ppi;
        if (ppi != null) {
            ppi.childPI.add(this);
        }
        this.eaPackage = pack;
        this.eaPackageId = this.eaPackage.GetPackageID();
        this.eaName = this.eaPackage.GetName().trim();
        this.eaPackageElmt = packelmt;
        if (this.eaPackageElmt != null) {
            this.eaPackageElmtId = this.eaPackageElmt.GetElementID();
        }
    }

    @Override
    public Model model() {
        return this.document;
    }

    @Override
    public Options options() {
        return this.document.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.document.result;
    }

    @Override
    public HashSet<PackageInfo> containedPackages() {
        return (HashSet)this.childPI.clone();
    }

    private void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            String sts = this.eaPackage.GetStereotypeEx();
            String[] stereotypes = sts.split("\\,");
            this.stereotypesCache = new HashSet(stereotypes.length);
            for (String stereotype : stereotypes) {
                String st = this.document.options.normalizeStereotype(stereotype.trim());
                if (st == null) continue;
                for (String s : Options.packageStereotypes) {
                    if (!st.toLowerCase().equals(s)) continue;
                    this.stereotypesCache.add(s);
                }
            }
        }
    }

    @Override
    public String stereotype() {
        this.validateStereotypesCache();
        Iterator<String> i$ = this.stereotypesCache.iterator();
        if (i$.hasNext()) {
            String st = i$.next();
            return st;
        }
        String st = this.document.options.normalizeStereotype("");
        return st != null ? st : "";
    }

    @Override
    public boolean isAppSchema() {
        this.validateStereotypesCache();
        return this.stereotypesCache.contains("application schema");
    }

    @Override
    public PackageInfo owner() {
        return this.parentPI;
    }

    @Override
    public PackageInfo rootPackage() {
        PackageInfoEA pi = this;
        while (pi != null && !pi.isSchema()) {
            pi = pi.parentPI;
        }
        return pi;
    }

    @Override
    public HashSet<String> supplierIds() {
        if (this.supplierIds == null) {
            this.supplierIds = new HashSet();
            if (!this.connectorsAccessed) {
                this.conns = this.eaPackage.GetConnectors();
                this.connectorsAccessed = true;
            }
            if (this.conns != null) {
                for (Connector conn : this.conns) {
                    PackageInfoEA suppPack;
                    String suppPackId;
                    String type = conn.GetType();
                    if (!type.equals("Dependency") && !type.equals("Package")) continue;
                    int suppId = conn.GetSupplierID();
                    String suppIdS = Integer.toString(suppId);
                    if (suppId == this.eaPackageElmtId || (suppPackId = (suppPack = this.document.fPackageByElmtId.get(suppIdS)).id()) == null) continue;
                    this.supplierIds.add(suppPackId);
                }
            }
        }
        return this.supplierIds;
    }

    @Override
    public String documentation() {
        if (!this.documentationAccessed) {
            this.documentationAccessed = true;
            String s = super.documentation();
            if ((s == null || s.length() == 0) && (s = this.eaPackage.GetNotes()) != null) {
                this.documentation = s = EADocument.removeSpuriousEA75EntitiesFromStrings(s);
            }
            this.documentation = s != null ? s : "";
        }
        return this.documentation;
    }

    @Override
    public String id() {
        return new Integer(this.eaPackageId).toString();
    }

    @Override
    public String name() {
        if (this.eaName == null || this.eaName.equals("")) {
            this.eaName = this.id();
            ShapeChangeResult.MessageContext mc = this.document.result.addWarning(null, 100, "package", this.eaName);
            if (mc != null) {
                mc.addDetail(null, 400, "Package", this.owner().fullName());
            }
        }
        return this.eaName;
    }

    @Override
    public String aliasName() {
        if (!this.aliasAccessed) {
            this.aliasAccessed = true;
            String a = super.aliasName();
            if (a == null || a.length() == 0) {
                this.aliasName = a = this.eaPackage.GetAlias();
            }
        }
        return this.aliasName;
    }

    private void validateTaggedValuesCache() {
        if (this.taggedValuesCache == null) {
            Collection tvs = null;
            int ntvs = 0;
            if (this.eaPackageElmt != null) {
                tvs = this.eaPackageElmt.GetTaggedValues();
                ntvs = tvs.GetCount();
            }
            this.taggedValuesCache = new HashMap(ntvs);
            if (tvs != null) {
                for (TaggedValue tv : tvs) {
                    String t = tv.GetName();
                    if ((t = this.document.normalizeTaggedValue(t)) == null) continue;
                    String v = tv.GetValue();
                    if (v.equals("<memo>")) {
                        v = tv.GetNotes();
                    }
                    this.taggedValuesCache.put(t, v);
                }
            }
        }
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        this.validateTaggedValuesCache();
        String[] tags = tagList.split(",");
        HashMap<String, String> res = new HashMap<String, String>(tags.length);
        for (String tag : tags) {
            String t = tag.trim();
            String v = this.taggedValuesCache.get(t);
            if (v == null) continue;
            res.put(t, v);
        }
        return res;
    }

    @Override
    public String taggedValue(String tag) {
        this.validateTaggedValuesCache();
        return this.taggedValuesCache.get(tag);
    }

    public void taggedValue(String tag, String value) {
        Collection cTV = this.eaPackageElmt.GetTaggedValues();
        TaggedValue tv = (TaggedValue)cTV.GetByName(tag);
        if (tv == null && value != null) {
            tv = (TaggedValue)cTV.AddNew(tag, value);
            tv.Update();
        } else if (tv != null) {
            if (value == null) {
                value = "";
            }
            if (!tv.GetValue().equals(value)) {
                tv.SetValue(value);
                tv.Update();
            }
        }
        this.taggedValuesCache = null;
    }

    @Override
    public HashMap<String, String> taggedValues() {
        return this.taggedValuesCache;
    }
}

