<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!-- 

     Version 1.0 - 12.05.2001
     Version 1.2 - 28.07.2001
     Version 1.5 - 03.01.2002
     Version 1.6 - 30.12.2002
     Version 1.7 - 30.03.2003
     Version 1.8 - 01.08.2004
     Version 1.10 - 29.07.2005
     Version 1.11 - 12.08.2008

     (c) 2001-2005 interactive instruments GmbH, Bonn
     im Auftrag der AdV, Arbeitsgemeinschaft der Vermessungsverwaltungen der
     Lnder der Bundesrepublik Deutschland

	  http://www.adv-online.de/

  -->
<xsl:output method="html"/>
<xsl:template match="/">
 <xsl:variable name="version" select="FC_FeatureCatalogue/versionNumber" />
 <html>
  <head>
    <title>Objektartenkatalog: <xsl:value-of select="FC_FeatureCatalogue/name"/></title>
  </head>
  <body>
    <h1>
     <xsl:value-of select="FC_FeatureCatalogue/name"/>
    </h1>
    <P><b>Versionsnummer:</b></P> 
    <P STYLE="margin-left:20px"><xsl:value-of select="$version"/></P>
    <P><b>Stand:</b></P>
    <P STYLE="margin-left:20px"><xsl:value-of select="FC_FeatureCatalogue/versionDate"/></P>
    <P><b>Anwendungsgebiet:</b></P>
    <P STYLE="margin-left:20px"><xsl:value-of select="FC_FeatureCatalogue/scope"/></P>
    <P><b>Verantwortliche Institution:</b></P>
    <P STYLE="margin-left:20px"><xsl:value-of select="FC_FeatureCatalogue/producer/CI_ResponsibleParty/CI_MandatoryParty/organisationName"/></P>
    <xsl:variable name="nft" select="count(FC_FeatureCatalogue/producer/CI_ResponsibleParty/responsibility)" />
    
     <xsl:if test="$nft >= 1">
      <P><b>Verantwortlichkeiten (siehe ISO 19115):</b></P>
      <ul>
       <xsl:for-each select="FC_FeatureCatalogue/producer/CI_ResponsibleParty/responsibility"> 
        <P STYLE="margin-left:20px"><LI><xsl:value-of select="."/></LI></P>
       </xsl:for-each>
      </ul>
     </xsl:if>
    
     <a> 
      <xsl:attribute name="name">uebersicht</xsl:attribute>
      <h2>Liste der Objektartenbereiche und Objektartengruppen mit ihren Objektarten und Datentypen</h2>
    </a> 
    <TABLE  BORDER="0" cellpadding="3" cellspacing="5">
      <TR>
        <TH width="64%" bgcolor="#F0F0F0"><i>Bezeichnung</i></TH>
        <TH width="18%" bgcolor="#F0F0F0"><i>Objekttyp</i></TH>
        <TH width="18%" bgcolor="#F0F0F0"><i>Modellart</i></TH>
      </TR>
      <xsl:for-each select="FC_FeatureCatalogue/AC_Objektartengruppe|FC_FeatureCatalogue/AC_Objektbereich">
        <xsl:sort select="./code"/>
        <xsl:variable name="objektart" select="." />

        <xsl:variable name="nftx" select="count(/FC_FeatureCatalogue/AC_FeatureType/Objektartengruppenzugehoerigkeit[attribute::idref=$objektart/@id])" />
        <xsl:if test="$nftx >= 0">
        <DIV>
          <TR>
            <TD bgcolor="#F0F0F0">
              <b>
		<xsl:choose>
			<xsl:when test="count($objektart/Objektbereichzugehoerigkeit)=1"><xsl:text>Objektartengruppe:</xsl:text></xsl:when>
			<xsl:otherwise><xsl:text>Objektartenbereich:</xsl:text></xsl:otherwise>
		</xsl:choose>
		 <a>                  
               <xsl:attribute name="href">#<xsl:value-of select="@id"/></xsl:attribute>
               <xsl:value-of select="name"/>
              </a>
              </b>
            </TD>
          </TR>
          <xsl:for-each select="/FC_FeatureCatalogue/AC_FeatureType/Objektartengruppenzugehoerigkeit[attribute::idref=$objektart/@id]">
            <xsl:sort select="../code"/>
            <xsl:variable name="featuretype" select=".." />
             <TR>
              <TD bgcolor="#F0F0F0">
                      <a>                  
                        <xsl:attribute name="href">#<xsl:value-of select="$featuretype/@id"/></xsl:attribute>
                        <xsl:value-of select="$featuretype/name"/>
                      </a>
              	<xsl:if test="$version=$featuretype/letzteAenderungVersion"><xsl:text> </xsl:text><small><font color="red"><b>Gendert <xsl:if test="count($featuretype/letzteAenderungRevisionsnummer)=1">(Revisionsnummer: <xsl:value-of select="$featuretype/letzteAenderungRevisionsnummer"/>)</xsl:if></b></font></small></xsl:if>
                    </TD>
                    <td bgcolor="#F0F0F0">
                      <xsl:variable name="nft" select="count($featuretype/wirdTypisiertDurch)" />
							 <xsl:choose>
                      <xsl:when test="$nft = 1">
                        <xsl:value-of select="$featuretype/wirdTypisiertDurch"/>
                      </xsl:when>
							 <xsl:otherwise>
                        <xsl:value-of select="$featuretype/bedeutung"/>
							 </xsl:otherwise>
							 </xsl:choose>
                    </td>
                    <td bgcolor="#F0F0F0">
                      <xsl:variable name="nft" select="count($featuretype/modellart)" />
                      <xsl:if test="$nft >= 1">
                        <xsl:for-each select="$featuretype/modellart"> 
                          <xsl:value-of select="."/><br/>
                        </xsl:for-each>
                      </xsl:if>
                    </td>
                    </TR>
          </xsl:for-each>
        </DIV>	
		  </xsl:if>
      </xsl:for-each>
    </TABLE>
    <xsl:for-each select="FC_FeatureCatalogue/AC_Objektartengruppe|FC_FeatureCatalogue/AC_Objektbereich">
    <xsl:sort select="./code"/>
    <xsl:variable name="objektart" select="." />
    <xsl:variable name="nftx" select="count(/FC_FeatureCatalogue/AC_FeatureType/Objektartengruppenzugehoerigkeit[attribute::idref=$objektart/@id])" />
    <xsl:if test="$nftx >= 0">
      <HR/> 
      <H2>
        <A>
          <xsl:attribute name="name">
            <xsl:value-of select="@id"/>
          </xsl:attribute>
		<xsl:choose>
			<xsl:when test="count($objektart/Objektbereichzugehoerigkeit)=1"><xsl:text>Objektartengruppe:</xsl:text></xsl:when>
			<xsl:otherwise><xsl:text>Objektartenbereich:</xsl:text></xsl:otherwise>
		</xsl:choose>
          <xsl:value-of select="name"/>
        </A>
      </H2>
      <DIV>
        <xsl:variable name="nft" select="count(definition)" />
            <xsl:if test="$nft >= 1">
              <b>Bezeichnung, Definition</b><br/>  
              <xsl:for-each select="definition"> 
                <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
              </xsl:for-each>
          </xsl:if>
      </DIV>
      <DIV>
        <xsl:variable name="nft" select="count(note)" />
            <xsl:if test="$nft >= 1">
              <b>Anmerkungen, Konsistenzregeln:</b><br/> 
              <table>
               <tr>
                <td width="20">
                 <BR/>
                </td>
                <td>
                 <xsl:for-each select="note">
                  <PRE> 
                  <xsl:value-of select="."/>
                  </PRE>
                 </xsl:for-each>
                </td>
               </tr>
              </table>
          </xsl:if>
      </DIV>
      <DIV>
        <xsl:variable name="nft" select="count(diagram)" />
          <xsl:if test="$nft >= 1">
           <P><b><a>
            <xsl:attribute name="href"><xsl:value-of select="diagram/@src"/></xsl:attribute>
            Diagramm
           </a></b></P>
          </xsl:if>
      </DIV>
      <table>
        <tr>
          <td width="100%">
            <p align="right">
              <small>
                <a href="#uebersicht">zurck zur bersicht ber die Objektarten und Datentypen</a>
              </small>
            </p>
          </td>
          <td>
            <BR/>
          </td>
        </tr>
      </table>
      <xsl:for-each select="/FC_FeatureCatalogue/AC_FeatureType/Objektartengruppenzugehoerigkeit[attribute::idref=$objektart/@id]">
        <xsl:sort select="../code"/>
        <xsl:variable name="featuretype" select=".." />
              <BR/>
                <a> 
                  <xsl:attribute name="name">
                    <xsl:value-of select="$featuretype/@id"/>
                  </xsl:attribute>
                  <TABLE>
                    <TR>
                      <TD width="100%" bgcolor="#D0D0D0">
                        <big><b>
                         <xsl:variable name="nft" select="count($featuretype/bedeutung)" />
                         <xsl:if test="$nft = 1">
                           <xsl:value-of select="$featuretype/bedeutung"/>: 
                         </xsl:if>
                         <xsl:value-of select="$featuretype/name"/>
                        </b></big>
              	<xsl:if test="$version=$featuretype/letzteAenderungVersion"><xsl:text> </xsl:text><small><font color="red"><b>Gendert <xsl:if test="count($featuretype/letzteAenderungRevisionsnummer)=1">(Revisionsnummer: <xsl:value-of select="$featuretype/letzteAenderungRevisionsnummer"/>)</xsl:if></b></font></small></xsl:if>
                      </TD>
                      <td>
     					      <br/>
                      </td>
                    </TR>
                  </TABLE>
                </a>
                <DIV>
                  <xsl:variable name="nft" select="count($featuretype/definition)" />
                  
                    <xsl:if test="$nft >= 1">
                      <P><b>Definition:</b></P>
                      <xsl:for-each select="$featuretype/definition"> 
                        <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                      </xsl:for-each>
                    </xsl:if>
                  
                </DIV>
                <DIV>
                  <xsl:variable name="nft" select="count($featuretype/code)" />
                  
                    <xsl:if test="$nft >= 1">
                      <P><b>Kennung:</b></P>
                      <xsl:for-each select="$featuretype/code"> 
                        <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                      </xsl:for-each>
                    </xsl:if>
                  
                </DIV>
                <DIV>
                  <xsl:variable name="nft" select="count($featuretype/subtypeOf)" />
                  
                    <xsl:if test="$nft >= 1">
                      <P><b>Abgeleitet aus:</b></P>
                      <xsl:for-each select="$featuretype/subtypeOf">
                        <xsl:variable name="st" select="." />
                        <xsl:variable name="nft2" select="count(/child::FC_FeatureCatalogue/child::AC_FeatureType[child::name=$st])" />
                       	<xsl:choose>
                          <xsl:when test="$nft2 = 0">
                             <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
								  </xsl:when>
                          <xsl:otherwise>
                             <xsl:for-each select="/FC_FeatureCatalogue/AC_FeatureType[child::name=$st]">
                               <P STYLE="margin-left:20px">
                                 <a>                  
                                 <xsl:attribute name="href">#<xsl:value-of select="./@id"/></xsl:attribute>
                                 <xsl:value-of select="$st"/>
                                 </a>
              	<xsl:if test="$version=./letzteAenderungVersion"><xsl:text> </xsl:text><small><font color="red"><b>Gendert <xsl:if test="count(./letzteAenderungRevisionsnummer)=1">(Revisionsnummer: <xsl:value-of select="./letzteAenderungRevisionsnummer"/>)</xsl:if></b></font></small></xsl:if>
                               </P>
                             </xsl:for-each>
                           </xsl:otherwise>
                       	 </xsl:choose>
                      </xsl:for-each>
                    </xsl:if>
                </DIV>
                <DIV>
                  <xsl:variable name="nft" select="count($featuretype/wirdTypisiertDurch)" />
                  
                    <xsl:if test="$nft >= 1">
                      <P><b>Wird typisiert durch:</b></P> 
                      <table>
                        <tr>
                          <td width="20">
                            <BR/>
                          </td>
                          <td>
                            <xsl:value-of select="$featuretype/wirdTypisiertDurch"/>
                          </td>
                        </tr>
                      </table>
                    </xsl:if>
                  
                </DIV>
                <DIV>
                  <xsl:variable name="nft" select="count($featuretype/modellart)" />
                    <xsl:if test="$nft >= 1">
                      <P><b>Modellart:</b></P> 
                      <xsl:for-each select="$featuretype/modellart"> 
                        <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                      </xsl:for-each>
                    </xsl:if>
                </DIV>
                <DIV>
                  <xsl:variable name="nft" select="count($featuretype/grunddatenbestand)" />
                    <xsl:if test="$nft >= 1">
                      <P><b>Grunddatenbestand:</b></P> 
                      <xsl:for-each select="$featuretype/grunddatenbestand"> 
                        <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                      </xsl:for-each>
                    </xsl:if>
                </DIV>
                <DIV>
                  <xsl:variable name="nft" select="count($featuretype/themen)" />
                    <xsl:if test="$nft >= 1">
                      <P><b>Themen:</b></P> 
                      <xsl:for-each select="$featuretype/themen"> 
                        <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                      </xsl:for-each>
                    </xsl:if>
                </DIV>
                <DIV>
                  <xsl:variable name="nft" select="count($featuretype/Konsistenzbedingung)" />
                  
                    <xsl:if test="$nft >= 1">
                      <P><b>Konsistenzbedingung:</b></P> 
                      <xsl:for-each select="$featuretype/Konsistenzbedingung"> 
                        <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                      </xsl:for-each>
                    </xsl:if>
                  
                </DIV>
                <DIV>
                  <xsl:variable name="nft" select="count($featuretype/Bildungsregel)" />
                  
                    <xsl:if test="$nft >= 1">
                      <P><b>Bildungsregel:</b></P> 
                      <xsl:for-each select="$featuretype/Bildungsregel"> 
                        <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                      </xsl:for-each>
                    </xsl:if>
                  
                </DIV>
                <DIV>
                  <xsl:variable name="nft" select="count($featuretype/Erfassungskriterium)" />
                  
                    <xsl:if test="$nft >= 1">
                      <P><b>Erfassungskriterium:</b></P> 
                      <xsl:for-each select="$featuretype/Erfassungskriterium"> 
                        <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                      </xsl:for-each>
                    </xsl:if>
                  
                </DIV>
                <DIV>
                  <xsl:variable name="nft" select="count($featuretype/Lebenszeitintervall)" />
                  
                    <xsl:if test="$nft >= 1">
                      <P><b>Lebenszeitintervall:</b></P> 
                      <xsl:for-each select="$featuretype/Lebenszeitintervall"> 
                        <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                      </xsl:for-each>
                    </xsl:if>
                  
                </DIV>
					 <DIV>
                  <xsl:variable name="nft" select="count(/FC_FeatureCatalogue/FC_FeatureAttribute[attribute::id=$featuretype/characterizedBy/@idref])" />
   
                    <P><b>Attributarten:</b></P>
                    <xsl:choose>
                    <xsl:when test="$nft >= 1">
                        <UL>  
                          <xsl:for-each select="/FC_FeatureCatalogue/FC_FeatureAttribute[attribute::id=$featuretype/characterizedBy/@idref]">
                          <xsl:variable name="featureAtt" select="." />
                            
                                  <LI>
                                    <a>                  
                                      <xsl:attribute name="href">#<xsl:value-of select="$featuretype/@id"/>-<xsl:value-of select="$featureAtt/@id"/></xsl:attribute>
                                      <xsl:value-of select="$featureAtt/name"/><xsl:if test="count($featureAtt/grunddatenbestand) >= 1"> (Grunddatenbestand)</xsl:if>
                                    </a>
              	<xsl:if test="$version=$featureAtt/letzteAenderungVersion"><xsl:text> </xsl:text><small><font color="red"><b>Gendert <xsl:if test="count($featureAtt/letzteAenderungRevisionsnummer)=1">(Revisionsnummer: <xsl:value-of select="$featureAtt/letzteAenderungRevisionsnummer"/>)</xsl:if></b></font></small></xsl:if>
                                  </LI>
                            
                          </xsl:for-each>
                        </UL>
						  </xsl:when>
						  <xsl:otherwise>
						    <P STYLE="margin-left:20px">keine</P>
						  </xsl:otherwise>
						  </xsl:choose>

                </DIV>

                <DIV>
                  <xsl:variable name="nft" select="count(/FC_FeatureCatalogue/FC_RelationshipRole[attribute::id=$featuretype/characterizedBy/@idref])" />
                  
                    <P><b>Relationsarten:</b></P>  
                    <xsl:choose>
                    <xsl:when test="$nft >= 1">
                        <UL>  
                        <xsl:for-each select="/FC_FeatureCatalogue/FC_RelationshipRole[attribute::id=$featuretype/characterizedBy/@idref]">
                          <xsl:variable name="featureRel" select="." />
                               <LI>
                                 <a>                  
                                    <xsl:attribute name="href">#<xsl:value-of select="$featuretype/@id"/>-<xsl:value-of select="$featureRel/@id"/></xsl:attribute>
                                    <xsl:value-of select="$featureRel/name"/><xsl:if test="count($featureRel/grunddatenbestand) >= 1"> (Grunddatenbestand)</xsl:if>
                                  </a>
              	<xsl:if test="$version=$featureRel/letzteAenderungVersion"><xsl:text> </xsl:text><small><font color="red"><b>Gendert <xsl:if test="count($featureRel/letzteAenderungRevisionsnummer)=1">(Revisionsnummer: <xsl:value-of select="$featureRel/letzteAenderungRevisionsnummer"/>)</xsl:if></b></font></small></xsl:if>
                               </LI>
                        </xsl:for-each>
                      </UL>
						  </xsl:when>
						  <xsl:otherwise>
						    <P STYLE="margin-left:20px">keine</P>
						  </xsl:otherwise>
						  </xsl:choose>

				    </DIV>
                <DIV>
                  <xsl:variable name="nft" select="count(/FC_FeatureCatalogue/FC_FeatureOperation[attribute::id=$featuretype/characterizedBy/@idref])" />
                  
                    <P><b>Methoden:</b></P>  
                    <xsl:choose>
                    <xsl:when test="$nft >= 1">
                        <UL> 
                          <xsl:for-each select="/FC_FeatureCatalogue/FC_FeatureOperation[attribute::id=$featuretype/characterizedBy/@idref]">
                            <xsl:variable name="featureOpr" select="." />
                                 <LI>
                                   <a>                  
                                      <xsl:attribute name="href">#<xsl:value-of select="$featuretype/@id"/>-<xsl:value-of select="$featureOpr/@id"/></xsl:attribute>
                                      <xsl:value-of select="$featureOpr/name"/>
                                    </a>
              	<xsl:if test="$version=$featureOpr/letzteAenderungVersion"><xsl:text> </xsl:text><small><font color="red"><b>Gendert <xsl:if test="count($featureOpr/letzteAenderungRevisionsnummer)=1">(Revisionsnummer: <xsl:value-of select="$featureOpr/letzteAenderungRevisionsnummer"/>)</xsl:if></b></font></small></xsl:if>
                                 </LI>
                          </xsl:for-each>
                        </UL>
						  </xsl:when>
						  <xsl:otherwise>
						    <P STYLE="margin-left:20px">keine</P>
						  </xsl:otherwise>
						  </xsl:choose>

                </DIV>
                  
                  <DIV>
                    <xsl:variable name="nft" select="count($featuretype/note)" />
                      
                        <xsl:if test="$nft >= 1">
                          <b>Anmerkungen, Konsistenzregeln:</b><br/> 
                          <table>
                           <tr>
                            <td width="20">
                             <BR/>
                            </td>
                            <td>
                             <xsl:for-each select="$featuretype/note">
                              <PRE> 
                              <xsl:value-of select="."/>
                              </PRE>
                             </xsl:for-each>
                            </td>
                           </tr>
                          </table>
                      </xsl:if>
                    
                  </DIV>
                <DIV>
                  <xsl:variable name="nft" select="count($featuretype/diagram)" />
                  
                    <xsl:if test="$nft >= 1">
                      <xsl:for-each select="$featuretype/diagram">
	                    	<P><b><a>
                          <xsl:attribute name="href"><xsl:value-of select="./@src"/></xsl:attribute>
				Diagramm (<xsl:value-of select="./@src"/>)
   	                   </a></b></P>
                      </xsl:for-each>
                    </xsl:if>
                  
                </DIV>
                  <table>
                    <tr>
                      <td width="100%">
                        <p align="right">
                          <small>
                            <A>
                              <xsl:attribute name="href">#<xsl:value-of select="$objektart/@id"/></xsl:attribute>
                              zurck zur Objektartengruppe/zum Objektartenbereich:
                              <xsl:value-of select="$objektart/name"/>
                            </A>
                          </small>
                        </p>
                      </td>
                      <td>
                        <BR/>
                      </td>
                    </tr>
                  </table>
                <DIV>
                  <xsl:for-each select="/FC_FeatureCatalogue/FC_FeatureAttribute[attribute::id=$featuretype/characterizedBy/@idref]">
                    <xsl:variable name="featureAtt" select="." />
                          <A> 
                            <xsl:attribute name="name">
                              <xsl:value-of select="$featuretype/@id"/>-<xsl:value-of select="$featureAtt/@id"/>
                            </xsl:attribute>
                            <table>
                              <tr>
                                <td width="100%" bgcolor="#F0F0F0">
                                <b>
                                  Attributart: 
                                  <xsl:value-of select="$featureAtt/name"/>
                                </b>
              	<xsl:if test="$version=$featureAtt/letzteAenderungVersion"><xsl:text> </xsl:text><small><font color="red"><b>Gendert <xsl:if test="count($featureAtt/letzteAenderungRevisionsnummer)=1">(Revisionsnummer: <xsl:value-of select="$featureAtt/letzteAenderungRevisionsnummer"/>)</xsl:if></b></font></small></xsl:if>
                                </td>
                                <td>
										    <br/>
                                </td>
                              </tr>
                            </table>
                          </A>
                          <BR/>
								  <DIV>
                          <xsl:variable name="nft" select="count($featureAtt/definition)" />
                            
                              <xsl:if test="$nft >= 1">
                                <P><b>Definition:</b></P>

                                <xsl:for-each select="$featureAtt/definition"> 
                                  <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                                </xsl:for-each>

                                <xsl:if test="count($featureAtt/objektbildend) > 0">
                                  <P STYLE="margin-left:20px">Diese Attributart ist objektbildend.</P>
                               </xsl:if>

                              </xsl:if>
                            
								  </DIV>
								  <DIV>
                          <xsl:variable name="nft" select="count($featureAtt/code)" />
                            
                              <xsl:if test="$nft >= 1">
                                <P><b>Kennung:</b></P>

                                <xsl:for-each select="$featureAtt/code"> 
                                  <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                                </xsl:for-each>

                              </xsl:if>
                            
								  </DIV>
								  <DIV>
                          <xsl:variable name="nft" select="count($featureAtt/cardinality)" />
                            
                              <xsl:if test="$nft >= 1">
                                <P><b>Kardinalitaet:</b></P>
                                <xsl:for-each select="$featureAtt/cardinality"> 
                                  <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                                </xsl:for-each>
                              </xsl:if>
                            
								  </DIV>
                          <DIV>
                          <xsl:variable name="nft" select="count($featureAtt/ValueDataType)" />
                            
                              <xsl:if test="$nft >= 1">
                                <P><b>Datentyp:</b></P>
                                <xsl:for-each select="$featureAtt/ValueDataType"> 

                                  <xsl:variable name="dt" select="." />
                                  <xsl:variable name="nft2" select="count(/child::FC_FeatureCatalogue/child::AC_FeatureType[attribute::id=$dt/@idref])" />
                                  	<xsl:choose>
                                    <xsl:when test="$nft2 = 0">
                                     <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
												</xsl:when>
                                    <xsl:otherwise>
                                     <xsl:for-each select="/FC_FeatureCatalogue/AC_FeatureType">
                                      
                                       <xsl:if test=" @id = $dt/@idref">
                                        <P STYLE="margin-left:20px"><a>                  
                                         <xsl:attribute name="href">#<xsl:value-of select="$dt/@idref"/></xsl:attribute>
                                         <xsl:value-of select="$dt"/>
              	<xsl:if test="$version=./letzteAenderungVersion"><xsl:text> </xsl:text><small><font color="red"><b>Gendert <xsl:if test="count(./letzteAenderungRevisionsnummer)=1">(Revisionsnummer: <xsl:value-of select="./letzteAenderungRevisionsnummer"/>)</xsl:if></b></font></small></xsl:if>
                                        </a></P>
                                       </xsl:if>
                                     
                                    </xsl:for-each>
                                   </xsl:otherwise>
                                	</xsl:choose>
											 
                              
                                </xsl:for-each>
                              </xsl:if>
                            
                          
                            <xsl:if test=" $featureAtt/ValueDomainType = 1">
                              <P><b>Wertearten:</b></P>
                              <TABLE>
                                <TR>
                                 <td width="20">
                                  <BR/>
                                 </td>
                                 <TD>Bezeichner</TD>
                                 <TD>Wert</TD>
                                </TR>
                                <xsl:for-each select="/FC_FeatureCatalogue/FC_Value[attribute::id=$featureAtt/enumeratedBy/@idref]">
                                <xsl:variable name="fcvalue" select="." />
                                        <TR>
                                          <td width="20">
                                            <BR/>
                                          </td>
                                          <TD valign="top"><xsl:value-of select="$fcvalue/label"/>              	<xsl:if test="$version=$fcvalue/letzteAenderungVersion"><xsl:text> </xsl:text><small><font color="red"><b>Gendert <xsl:if test="count($fcvalue/letzteAenderungRevisionsnummer)=1">(Revisionsnummer: <xsl:value-of select="$fcvalue/letzteAenderungRevisionsnummer"/>)</xsl:if></b></font></small></xsl:if>
<xsl:if test="count($fcvalue/definition)=1"><table><tr><td width="20">&#160;</td><td><small><xsl:value-of select="$fcvalue/definition"/></small></td></tr></table></xsl:if></TD>
                                          <TD valign="top"><xsl:value-of select="$fcvalue/code"/><xsl:if test="count($fcvalue/grunddatenbestand) >= 1"> (G)</xsl:if></TD>
                                        </TR>
                                </xsl:for-each>
                              </TABLE>
                            </xsl:if>
                          
								  </DIV>
                            <table>
                              <tr>
                                <td width="100%">
                                  <p align="right">
                                    <small>
                                      <A>
                                        <xsl:attribute name="href">#<xsl:value-of select="$featuretype/@id"/></xsl:attribute>
                                        zurck zu:
                                        <xsl:value-of select="$featuretype/name"/>
                                      </A>
                                    </small>
                                  </p>
                                </td>
                                <td>
                                  <BR/>
                                </td>
                              </tr>
                            </table>
                  </xsl:for-each>
                </DIV>
                <DIV>
                  <xsl:for-each select="/FC_FeatureCatalogue/FC_RelationshipRole[attribute::id=$featuretype/characterizedBy/@idref]">
                  <xsl:variable name="featureRel" select="." />
                          <A> 
                            <xsl:attribute name="name">
                              <xsl:value-of select="$featuretype/@id"/>-<xsl:value-of select="$featureRel/@id"/>
                            </xsl:attribute>
                            <table>
                              <tr>
                                <td width="100%" bgcolor="#F0F0F0">
                                <b>
                                  Relationsart: 
                                  <xsl:value-of select="$featureRel/name"/>
                                </b>
              	<xsl:if test="$version=$featureRel/letzteAenderungVersion"><xsl:text> </xsl:text><small><font color="red"><b>Gendert <xsl:if test="count($featureRel/letzteAenderungRevisionsnummer)=1">(Revisionsnummer: <xsl:value-of select="$featureRel/letzteAenderungRevisionsnummer"/>)</xsl:if></b></font></small></xsl:if>
                                </td>
										  <td>
										    <br/>
                                </td>
                              </tr>
                            </table>
                          </A>
                          <BR/> 
                          <DIV>
                                <xsl:for-each select="/FC_FeatureCatalogue/FC_FeatureRelationship[attribute::id=$featureRel/relation/@idref]">
                                  
				                          <xsl:variable name="nft" select="count(definition)" />
				                            
            				                  <xsl:if test="$nft >= 1">
				                                <P><b>Definition:</b></P>
            					                    <xsl:for-each select="definition"> 
					                                  <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
               					                 </xsl:for-each>
	                                      </xsl:if>
                                 
  	                            </xsl:for-each>
								  </DIV>
                          <DIV>
                          <xsl:variable name="nft" select="count($featureRel/definition)" />
                            
                              <xsl:if test="$nft >= 1">
                                <P><b>Anmerkung:</b></P>
                                <xsl:for-each select="$featureRel/definition"> 
                                  <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                                </xsl:for-each>
                              </xsl:if>

                                <xsl:if test="count($featureRel/objektbildend) > 0">
                                  <P STYLE="margin-left:20px">Diese Relationsart ist objektbildend.</P>
                               </xsl:if>
                            
								  </DIV>
                          <DIV>
                          <xsl:variable name="nft" select="count($featureRel/code)" />
                            
                              <xsl:if test="$nft >= 1">
                                <P><b>Kennung:</b></P>
                                <xsl:for-each select="$featureRel/code"> 
                                  <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                                </xsl:for-each>
                              </xsl:if>
                            
								  </DIV>
                          <P><b>Kardinalitaet:</b></P>
                          <table>
                            <tr>
                              <td width="20">
                                <BR/>
                              </td>
                              <td>
                                <xsl:value-of select="$featureRel/cardinality"/>
                                
                                  <xsl:if test="$featureRel/orderIndicator = 1">
                                    (geordnet)
                                  </xsl:if>
                                
                              </td>
                            </tr>
                          </table>
                          <P><b>Objektart des Relationspartners:</b></P>
                          <UL>
                            <xsl:for-each select="$featureRel/FeatureTypeIncluded">
                              <xsl:variable name="ftinc" select="." />
                              <LI>
                                  <xsl:variable name="nft" select="count(/child::FC_FeatureCatalogue/child::AC_FeatureType[attribute::id=$ftinc/@idref])" />
                                  	<xsl:choose>
                                    <xsl:when test="$nft = 0">
                                      <xsl:value-of select="$ftinc/@name"/>
												</xsl:when>
                                    <xsl:otherwise>
                                     <xsl:for-each select="/FC_FeatureCatalogue/AC_FeatureType[attribute::id=$ftinc/@idref]">
                                      
                                        <a>                  
                                         <xsl:attribute name="href">#<xsl:value-of select="$ftinc/@idref"/></xsl:attribute>
                                         <xsl:value-of select="$ftinc/@name"/>
                                        </a>
              	<xsl:if test="$version=./letzteAenderungVersion"><xsl:text> </xsl:text><small><font color="red"><b>Gendert <xsl:if test="count(./letzteAenderungRevisionsnummer)=1">(Revisionsnummer: <xsl:value-of select="./letzteAenderungRevisionsnummer"/>)</xsl:if></b></font></small></xsl:if>
                                     
                                    </xsl:for-each>
                                   </xsl:otherwise>
                                   </xsl:choose>
											 
                              </LI>  
                            <xsl:for-each select="$featureRel/InverseRole">
                              <xsl:variable name="ir" select="." />
                                  <xsl:for-each select="/FC_FeatureCatalogue/FC_RelationshipRole[attribute::id=$ir/@idref]">
                                    
      		                          <BR/>inverse Relationsrichtung zu 
            		                    <a>
                                        <xsl:attribute name="href">#<xsl:value-of select="$ftinc/@idref"/>-<xsl:value-of select="@id"/></xsl:attribute>
                                        <xsl:value-of select="name"/>
		                                </a>   
              	<xsl:if test="$version=./letzteAenderungVersion"><xsl:text> </xsl:text><small><font color="red"><b>Gendert <xsl:if test="count(./letzteAenderungRevisionsnummer)=1">(Revisionsnummer: <xsl:value-of select="./letzteAenderungRevisionsnummer"/>)</xsl:if></b></font></small></xsl:if>
                                    
                                  </xsl:for-each>
                            </xsl:for-each>
                            </xsl:for-each>
                          </UL>
                          <table>
                            <tr>
                              <td width="100%">
                                <p align="right">
                                  <small>
                                    <A>
                                      <xsl:attribute name="href">#<xsl:value-of select="$featuretype/@id"/></xsl:attribute>
                                      zurck zu:
                                      <xsl:value-of select="$featuretype/name"/>
                                    </A>
                                  </small>
                                </p>
                              </td>
                              <td>
                                <BR/>
                              </td>
                            </tr>
                          </table>
                  </xsl:for-each>
                </DIV>
                <DIV>
                  <xsl:for-each select="/FC_FeatureCatalogue/FC_FeatureOperation[attribute::id=$featuretype/characterizedBy/@idref]">
                    <xsl:variable name="featureOpr" select="." />
                          <A> 
                            <xsl:attribute name="name">
                              <xsl:value-of select="$featuretype/@id"/>-<xsl:value-of select="$featureOpr/@id"/>
                            </xsl:attribute>
                            <table>
                              <tr>
                                <td width="100%" bgcolor="#F0F0F0">
                                <b>
                                  Methode: 
                                  <xsl:value-of select="$featureOpr/name"/>
                                </b>
              	<xsl:if test="$version=$featureOpr/letzteAenderungVersion"><xsl:text> </xsl:text><small><font color="red"><b>Gendert <xsl:if test="count($featureOpr/letzteAenderungRevisionsnummer)=1">(Revisionsnummer: <xsl:value-of select="$featureOpr/letzteAenderungRevisionsnummer"/>)</xsl:if></b></font></small></xsl:if>
                                </td>
                                <td>
                                  <BR/>
                                </td>
                              </tr>
                            </table>
                          </A>
                          <xsl:variable name="nft" select="count($featureOpr/definition)" />
                          
                            <xsl:if test="$nft >= 1">
                              <P><b>Definition:</b></P>
                              <xsl:for-each select="$featureOpr/definition"> 
                                <P STYLE="margin-left:20px"><xsl:value-of select="."/></P>
                              </xsl:for-each>
                            </xsl:if>
                          
                            <table>
                              <tr>
                                <td width="100%">
                                  <p align="right">
                                    <small>
                                      <A>
                                        <xsl:attribute name="href">#<xsl:value-of select="$featuretype/@id"/></xsl:attribute>
                                        zurck zu:
                                        <xsl:value-of select="$featuretype/name"/>
                                      </A>
                                    </small>
                                  </p>
                                </td>
                                <td>
                                  <BR/>
                                </td>
                              </tr>
                            </table>
                  </xsl:for-each>
                </DIV> 
          
      </xsl:for-each>
     </xsl:if>
    </xsl:for-each>
  </body>
</html>
</xsl:template>
</xsl:stylesheet>
