/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.EA;

import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.EA.AssociationInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.EADocument;
import de.interactive_instruments.ShapeChange.Model.EA.OclConstraintEA;
import de.interactive_instruments.ShapeChange.Model.EA.TextConstraintEA;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfoImpl;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import org.sparx.Attribute;
import org.sparx.AttributeConstraint;
import org.sparx.AttributeTag;
import org.sparx.Collection;
import org.sparx.ConnectorEnd;
import org.sparx.RoleTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyInfoEA
extends PropertyInfoImpl
implements PropertyInfo {
    protected boolean aliasAccessed = false;
    protected boolean documentationAccessed = false;
    protected EADocument document = null;
    protected ClassInfoEA classInfo = null;
    protected String eaPropertyId = null;
    protected String eaName = null;
    protected Type typeInfo = new Type();
    protected ClassInfoEA typeClassInfo = null;
    protected Attribute eaAttribute = null;
    AssociationInfoEA associationInfo = null;
    boolean reversedAssoc = false;
    ConnectorEnd eaConnectorEnd = null;
    protected StructuredNumber sequenceNumber = new StructuredNumber(Integer.MIN_VALUE);
    protected Multiplicity multiplicity = new Multiplicity();
    protected String initialValueCache = null;
    protected Boolean isDerivedCache = null;
    protected Boolean isNavigableCache = null;
    protected String aggregationTypeCache = null;
    protected Boolean isOrderedCache = null;
    protected HashSet<String> stereotypesCache = null;
    protected HashMap<String, String> taggedValuesCache = null;
    protected Vector<Constraint> constraintsCache = null;

    public PropertyInfoEA(EADocument doc, ClassInfoEA ci, Attribute attr) {
        String s;
        this.document = doc;
        this.classInfo = ci;
        this.eaAttribute = attr;
        this.eaPropertyId = ci.id();
        this.eaPropertyId = this.eaPropertyId + "_";
        this.eaPropertyId = this.eaPropertyId + new Integer(this.eaAttribute.GetAttributeID()).toString();
        this.eaName = this.eaAttribute.GetName();
        if (this.eaName != null) {
            this.eaName = this.eaName.trim();
        }
        if ((s = this.taggedValue("sequenceNumber")) != null && s.length() > 0 && s.matches("[0-9\\.]*")) {
            this.sequenceNumber = new StructuredNumber(s);
        } else {
            int pos = this.eaAttribute.GetPos();
            PropertyInfo piTemp = this.classInfo.properties().get(new StructuredNumber(Integer.MIN_VALUE + pos));
            if (piTemp != null) {
                while (piTemp != null) {
                    this.sequenceNumber = new StructuredNumber(this.document.globalSequenceNumber++ + -1073741824);
                    piTemp = this.classInfo.properties().get(this.sequenceNumber);
                }
            } else {
                this.sequenceNumber = new StructuredNumber(Integer.MIN_VALUE + pos);
            }
        }
        int typeid = this.eaAttribute.GetClassifierID();
        this.typeInfo.id = String.valueOf(typeid);
        this.typeInfo.name = this.eaAttribute.GetType().trim();
        this.typeClassInfo = this.document.fClassById.get(this.typeInfo.id);
        if (this.typeClassInfo == null) {
            this.typeClassInfo = this.document.fClassByName.get(this.typeInfo.name);
        }
        if (this.typeClassInfo != null) {
            this.typeInfo.name = this.typeClassInfo.name();
            this.typeInfo.id = this.typeClassInfo.id();
        }
        String[] bounds = new String[]{this.eaAttribute.GetLowerBound().trim(), this.eaAttribute.GetUpperBound().trim()};
        int[] mult = new int[]{0, 0};
        for (int i = 0; i < 2; ++i) {
            if (bounds[i].length() == 0) {
                mult[i] = 1;
                continue;
            }
            if (bounds[i].equals("*")) {
                mult[i] = i == 0 ? 0 : Integer.MAX_VALUE;
                continue;
            }
            try {
                mult[i] = Integer.parseInt(bounds[i]);
                continue;
            }
            catch (NumberFormatException e) {
                ShapeChangeResult.MessageContext mc = this.document.result.addWarning(null, 1003, bounds[i]);
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", this.inClass().fullName());
                }
                mult[i] = 1;
            }
        }
        this.multiplicity.minOccurs = mult[0];
        this.multiplicity.maxOccurs = mult[1];
        this.document.result.addDebug(null, 10013, "property", this.id(), this.name());
    }

    public PropertyInfoEA(EADocument doc, ClassInfoEA ci, AssociationInfoEA ai, boolean reversed, ConnectorEnd eaCE, ClassInfoEA tci) {
        this.document = doc;
        this.classInfo = ci;
        this.associationInfo = ai;
        this.reversedAssoc = reversed;
        this.eaConnectorEnd = eaCE;
        this.eaPropertyId = (reversed ? "S" : "T") + new Integer(ai.eaConnectorId).toString();
        this.eaName = eaCE.GetRole();
        if (this.eaName == null || this.eaName.length() == 0) {
            this.eaName = "role_" + this.eaPropertyId;
        }
        this.eaName = this.eaName.trim();
        this.typeClassInfo = tci;
        this.typeInfo.id = tci.id();
        this.typeInfo.name = tci.name();
        String s = this.taggedValue("sequenceNumber");
        this.sequenceNumber = s != null && s.length() > 0 ? new StructuredNumber(s) : new StructuredNumber(this.document.globalSequenceNumber++);
        String card = this.eaConnectorEnd.GetCardinality();
        String[] ranges = card.split(",");
        int minv = Integer.MAX_VALUE;
        int maxv = Integer.MIN_VALUE;
        for (int i = 0; i < ranges.length; ++i) {
            int upper;
            int lower;
            if (ranges[i].indexOf("..") > 0) {
                String[] minmax = ranges[i].split("\\.\\.", 2);
                lower = Integer.parseInt(minmax[0]);
                if (minmax[1].equals("*") || minmax[1].length() == 0) {
                    upper = Integer.MAX_VALUE;
                } else {
                    try {
                        upper = Integer.parseInt(minmax[1]);
                    }
                    catch (NumberFormatException e) {
                        ShapeChangeResult.MessageContext mc = this.document.result.addWarning(null, 1003, minmax[1]);
                        if (mc != null) {
                            mc.addDetail(null, 400, "Class", this.inClass().fullName());
                        }
                        upper = Integer.MAX_VALUE;
                    }
                }
            } else if (ranges[i].length() == 0 || ranges[i].equals("*")) {
                lower = 0;
                upper = Integer.MAX_VALUE;
            } else {
                try {
                    upper = lower = Integer.parseInt(ranges[i]);
                }
                catch (NumberFormatException e) {
                    ShapeChangeResult.MessageContext mc = this.document.result.addWarning(null, 1003, ranges[i]);
                    if (mc != null) {
                        mc.addDetail(null, 400, "Class", this.inClass().fullName());
                    }
                    lower = 0;
                    upper = Integer.MAX_VALUE;
                }
            }
            if (lower < minv && lower >= 0) {
                minv = lower;
            }
            if (upper < 0) {
                maxv = Integer.MAX_VALUE;
            }
            if (upper <= maxv) continue;
            maxv = upper;
        }
        this.multiplicity.minOccurs = minv;
        this.multiplicity.maxOccurs = maxv;
        this.document.result.addDebug(null, 10013, "property", this.id(), this.name());
    }

    @Override
    public Model model() {
        return this.document;
    }

    @Override
    public Options options() {
        return this.document.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.document.result;
    }

    @Override
    public Multiplicity cardinality() {
        return this.multiplicity;
    }

    @Override
    public String defaultCodeSpace() {
        String s = this.taggedValue("defaultCodeSpace");
        return s != null ? s : "";
    }

    @Override
    public ClassInfo inClass() {
        return this.classInfo;
    }

    @Override
    public void inClass(ClassInfo ci) {
        this.classInfo = (ClassInfoEA)ci;
    }

    @Override
    public String initialValue() {
        if (this.initialValueCache == null && this.isAttribute()) {
            this.initialValueCache = this.eaAttribute.GetDefault();
            if (this.initialValueCache.equals("")) {
                this.initialValueCache = null;
            }
            if (this.initialValueCache != null) {
                this.initialValueCache = this.initialValueCache.trim();
                String iv = this.initialValueCache.toLowerCase();
                if (iv.equals("true")) {
                    this.initialValueCache = "true";
                }
                if (iv.equals("false")) {
                    this.initialValueCache = "false";
                }
            }
        }
        return this.initialValueCache;
    }

    @Override
    public String inlineOrByReference() {
        String s = this.taggedValue("inlineOrByReference");
        if (s == null) {
            s = "";
        }
        if (s.length() == 0) {
            String cont = null;
            cont = this.isAttribute() ? this.eaAttribute.GetContainment() : this.eaConnectorEnd.GetContainment();
            if (cont != null) {
                if (cont.equals("By Reference")) {
                    s = "byreference";
                } else if (cont.equals("By Value")) {
                    s = "inline";
                }
            }
        }
        return s.toLowerCase();
    }

    private void validateAggregationType() {
        if (this.aggregationTypeCache == null) {
            int cat;
            int n = cat = this.typeClassInfo == null ? 6 : this.typeClassInfo.category();
            if (this.isAttribute()) {
                this.aggregationTypeCache = "composite";
            } else {
                ConnectorEnd otherEnd = ((PropertyInfoEA)this.reverseProperty()).eaConnectorEnd;
                int agt = otherEnd.GetAggregation();
                if (agt == 1) {
                    this.aggregationTypeCache = "shared";
                } else if (agt == 2) {
                    this.aggregationTypeCache = "composite";
                }
            }
            if (this.aggregationTypeCache == null) {
                this.aggregationTypeCache = "none";
            }
        }
    }

    @Override
    public boolean isAggregation() {
        this.validateAggregationType();
        return this.aggregationTypeCache.equals("shared");
    }

    @Override
    public boolean isAttribute() {
        return this.eaAttribute != null;
    }

    @Override
    public boolean isComposition() {
        this.validateAggregationType();
        return this.aggregationTypeCache.equals("composite");
    }

    @Override
    public boolean isDerived() {
        if (this.isDerivedCache == null) {
            this.isDerivedCache = new Boolean(this.isAttribute() ? this.eaAttribute.GetIsDerived() : this.eaConnectorEnd.GetDerived());
        }
        return this.isDerivedCache;
    }

    @Override
    public boolean isNavigable() {
        if (this.isNavigableCache == null) {
            this.isNavigableCache = new Boolean(true);
            if (!this.isAttribute()) {
                boolean nav = this.eaConnectorEnd.GetIsNavigable();
                if (!nav) {
                    boolean bl = nav = this.associationInfo.navigability == 0;
                }
                if (nav) {
                    String sn = this.eaConnectorEnd.GetStereotype();
                    if (sn != null) {
                        sn = this.options().normalizeStereotype(sn);
                    }
                    if (sn != null && sn.length() > 0) {
                        boolean found = false;
                        for (String st : Options.propertyStereotypes) {
                            if (!sn.equals(st)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            ShapeChangeResult.MessageContext mc = this.document.result.addWarning(null, 1005, sn, "AssociationEnd");
                            if (mc != null) {
                                mc.addDetail(null, 400, "Property", this.fullName());
                            }
                            nav = false;
                        }
                    }
                }
                if (nav) {
                    for (RoleTag rt : this.eaConnectorEnd.GetTaggedValues()) {
                        if (!rt.GetTag().equals("xsdEncodingRule") || !rt.GetValue().toLowerCase().equals(Options.NOT_ENCODED)) continue;
                        nav = false;
                    }
                }
                if (this.eaName == null || this.eaName.substring(0, this.eaName.length() < 5 ? this.eaName.length() : 5).compareTo("role_") == 0) {
                    nav = false;
                }
                this.isNavigableCache = nav;
            }
        }
        return this.isNavigableCache;
    }

    @Override
    public boolean isOrdered() {
        if (this.isOrderedCache == null) {
            this.isOrderedCache = new Boolean(false);
            if (this.isAttribute()) {
                this.isOrderedCache = this.eaAttribute.GetIsOrdered();
            } else {
                int ordering = this.eaConnectorEnd.GetOrdering();
                if (ordering != 0) {
                    this.isOrderedCache = true;
                }
            }
        }
        return this.isOrderedCache;
    }

    @Override
    public PropertyInfo reverseProperty() {
        if (this.isAttribute()) {
            return null;
        }
        return this.associationInfo.properties[this.reversedAssoc ? 1 : 0];
    }

    @Override
    public StructuredNumber sequenceNumber() {
        return this.sequenceNumber;
    }

    private void validateStereotypesCache() {
        if (this.stereotypesCache == null) {
            String sts = this.isAttribute() ? this.eaAttribute.GetStereotypeEx() : this.eaConnectorEnd.GetStereotypeEx();
            String[] stereotypes = sts.split("\\,");
            this.stereotypesCache = new HashSet(stereotypes.length);
            for (String stereotype : stereotypes) {
                String st = this.document.options.normalizeStereotype(stereotype.trim());
                if (st == null) continue;
                for (String s : Options.propertyStereotypes) {
                    if (!st.toLowerCase().equals(s)) continue;
                    this.stereotypesCache.add(s);
                }
            }
        }
    }

    @Override
    public String stereotype() {
        this.validateStereotypesCache();
        Iterator<String> i$ = this.stereotypesCache.iterator();
        if (i$.hasNext()) {
            String st = i$.next();
            return st;
        }
        String st = this.document.options.normalizeStereotype("");
        return st != null ? st : "";
    }

    private void validateTaggedValuesCache() {
        block6: {
            if (this.taggedValuesCache != null) break block6;
            if (this.isAttribute()) {
                Collection tvs = this.eaAttribute.GetTaggedValues();
                short ntvs = tvs.GetCount();
                this.taggedValuesCache = new HashMap(ntvs);
                for (AttributeTag tv : tvs) {
                    String t = tv.GetName();
                    if ((t = this.document.normalizeTaggedValue(t)) == null) continue;
                    String v = tv.GetValue();
                    if (v.equals("<memo>")) {
                        v = tv.GetNotes();
                    }
                    this.taggedValuesCache.put(t, v);
                }
            } else {
                Collection tvs = this.eaConnectorEnd.GetTaggedValues();
                short ntvs = tvs.GetCount();
                this.taggedValuesCache = new HashMap(ntvs);
                for (RoleTag tv : tvs) {
                    String t = tv.GetTag();
                    if ((t = this.document.normalizeTaggedValue(t)) == null) continue;
                    String v = tv.GetValue();
                    if (v.length() > 16 && v.substring(0, 6).equals("<memo>")) {
                        v = v.substring(16);
                    }
                    this.taggedValuesCache.put(t, v);
                }
            }
        }
    }

    @Override
    public HashMap<String, String> taggedValues() {
        this.validateTaggedValuesCache();
        return this.taggedValuesCache;
    }

    @Override
    public String taggedValue(String tag) {
        this.validateTaggedValuesCache();
        return this.taggedValuesCache.get(tag);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void taggedValue(String tag, String value) {
        if (this.isAttribute()) {
            boolean upd = false;
            for (AttributeTag tv : this.eaAttribute.GetTaggedValues()) {
                if (!tv.GetName().equals(tag)) continue;
                if (value == null) {
                    value = "";
                }
                if (tv.GetValue().equals(value)) {
                    return;
                }
                tv.SetValue(value);
                tv.Update();
                return;
            }
            if (upd) return;
            if (value == null) return;
            AttributeTag tv = (AttributeTag)this.eaAttribute.GetTaggedValues().AddNew(tag, value);
            tv.Update();
        } else {
            boolean upd = false;
            for (RoleTag tv : this.eaConnectorEnd.GetTaggedValues()) {
                if (!tv.GetTag().equals(tag)) continue;
                if (value == null) {
                    value = "";
                }
                if (tv.GetValue().equals(value)) {
                    return;
                }
                tv.SetValue(value);
                tv.Update();
                return;
            }
            if (upd) return;
            if (value == null) return;
            RoleTag tv = (RoleTag)this.eaConnectorEnd.GetTaggedValues().AddNew(tag, value);
            tv.Update();
        }
        this.taggedValuesCache = null;
    }

    @Override
    public Type typeInfo() {
        return this.typeInfo;
    }

    @Override
    public boolean voidable() {
        String s;
        this.validateStereotypesCache();
        boolean res = this.stereotypesCache.contains("voidable");
        if (!res && (s = this.taggedValue("nillable")) != null) {
            res = s.equalsIgnoreCase("true");
        }
        return res;
    }

    @Override
    public String documentation() {
        if (!this.documentationAccessed) {
            this.documentationAccessed = true;
            String s = super.documentation();
            if ((s == null || s.length() == 0) && (s = this.isAttribute() ? this.eaAttribute.GetNotes() : this.eaConnectorEnd.GetRoleNote()) != null) {
                this.documentation = s = EADocument.removeSpuriousEA75EntitiesFromStrings(s);
            }
            if (s == null || s.isEmpty()) {
                String thisNameLowerCase = this.name().trim().toLowerCase(Locale.ENGLISH);
                String cixNameLowerCase = null;
                for (String cid : this.classInfo.supplierIds()) {
                    ClassInfoEA cix = this.document.fClassById.get(cid);
                    if (cix == null) continue;
                    cixNameLowerCase = cix.name().trim().toLowerCase(Locale.ENGLISH);
                    if (cixNameLowerCase.equals(thisNameLowerCase)) {
                        if (this.classInfo.category() == 3 || !cix.stereotype().equalsIgnoreCase("attributeconcept")) continue;
                        this.documentation = s = cix.documentation();
                        break;
                    }
                    if (!cixNameLowerCase.endsWith(thisNameLowerCase) || this.classInfo.category() != 3 || !cix.stereotype().equalsIgnoreCase("valueconcept")) continue;
                    this.documentation = s = cix.documentation();
                    break;
                }
            }
            this.documentation = s != null ? s : "";
        }
        return this.documentation;
    }

    @Override
    public String id() {
        return this.eaPropertyId;
    }

    @Override
    public String name() {
        if (this.eaName == null || this.eaName.equals("")) {
            if (this.classInfo == null || this.classInfo.category() != 2 && this.classInfo.category() != 3) {
                this.eaName = this.id();
                ShapeChangeResult.MessageContext mc = this.document.result.addWarning(null, 100, "property", this.eaName);
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", this.classInfo.fullName());
                }
            } else {
                ShapeChangeResult.MessageContext mc = this.document.result.addWarning(null, 136, this.id(), this.classInfo.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", this.classInfo.fullName());
                }
            }
        }
        return this.eaName;
    }

    @Override
    public String aliasName() {
        if (!this.aliasAccessed) {
            this.aliasAccessed = true;
            String a = super.aliasName();
            if (a == null || a.length() == 0) {
                a = this.isAttribute() ? this.eaAttribute.GetStyle() : this.eaConnectorEnd.GetAlias();
                this.aliasName = a;
            }
        }
        return this.aliasName;
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        this.validateTaggedValuesCache();
        String[] tags = tagList.split(",");
        HashMap<String, String> res = new HashMap<String, String>(tags.length);
        for (String tag : tags) {
            String t = tag.trim();
            String v = this.taggedValuesCache.get(t);
            if (v == null) continue;
            res.put(t, v);
        }
        return res;
    }

    private void validateConstraintsCache() {
        if (this.constraintsCache == null) {
            Collection constrs;
            this.constraintsCache = new Vector();
            String check = this.document.options.parameter("checkingConstraints");
            if (check != null && check.equalsIgnoreCase("disabled")) {
                return;
            }
            if (!this.document.options.isConstraintCreationForProperties()) {
                return;
            }
            if (this.isAttribute() && (constrs = this.eaAttribute.GetConstraints()) != null) {
                String types = this.document.options.parameter("oclConstraintTypeRegex");
                for (AttributeConstraint constr : constrs) {
                    OclConstraintEA ocl;
                    String type = constr.GetType();
                    Constraint oc = types.length() > 0 && type.matches(types) ? ((ocl = new OclConstraintEA(this.document, this, constr)).syntaxTree() == null ? new TextConstraintEA(this.document, this, constr) : ocl) : new TextConstraintEA(this.document, this, constr);
                    this.constraintsCache.add(oc);
                }
            }
        }
    }

    @Override
    public Vector<Constraint> constraints() {
        this.validateConstraintsCache();
        return this.constraintsCache;
    }

    @Override
    public AssociationInfo association() {
        return this.associationInfo;
    }
}

