/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.XmlSchema;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Ocl_OLD.OclConstraint_OLD;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchematronSchema {
    Model model;
    Options options;
    ShapeChangeResult result;
    PackageInfo pi;
    Document document;
    Element pattern;
    Element root;
    boolean printed = false;
    boolean assertion = false;

    public SchematronSchema(Model mdl, Options o, ShapeChangeResult r, PackageInfo p) {
        this.model = mdl;
        this.pi = p;
        this.options = o;
        this.result = r;
        this.document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.document = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.result.addFatalError(2);
            String m = e.getMessage();
            if (m != null) {
                this.result.addFatalError(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            this.result.addFatalError(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        this.root = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "schema");
        this.document.appendChild(this.root);
        this.addAttribute(this.document, this.root, "xmlns:sch", "http://purl.oclc.org/dsdl/schematron");
        Element e1 = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "title");
        this.root.appendChild(e1);
        e1.appendChild(this.document.createTextNode("Schematron constraints for schema '" + this.pi.name() + "'"));
        e1 = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "ns");
        this.root.appendChild(e1);
        this.addAttribute(this.document, e1, "prefix", "sch");
        this.addAttribute(this.document, e1, "uri", "http://purl.oclc.org/dsdl/schematron");
        e1 = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "ns");
        this.root.appendChild(e1);
        this.addAttribute(this.document, e1, "prefix", this.pi.xmlns());
        this.addAttribute(this.document, e1, "uri", this.pi.targetNamespace());
        this.pattern = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "pattern");
        this.root.appendChild(this.pattern);
    }

    private void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    protected void addAssertion(ClassInfo ci, OclConstraint_OLD c) {
        if (c == null) {
            return;
        }
        String sch = c.schematron();
        if (sch == null) {
            return;
        }
        Element rule = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "rule");
        this.pattern.appendChild(rule);
        this.addAttribute(this.document, rule, "context", ci.qname());
        Element ass = this.document.createElementNS("http://purl.oclc.org/dsdl/schematron", "assert");
        rule.appendChild(ass);
        this.addAttribute(this.document, ass, "test", sch);
        ass.appendChild(this.document.createTextNode(c.text()));
        this.assertion = true;
    }

    public void write(String outputDirectory) {
        if (this.printed || !this.assertion) {
            return;
        }
        Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        outputFormat.setProperty("indent", "yes");
        outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        outputFormat.setProperty("encoding", "UTF-8");
        try {
            File file = new File(String.valueOf(outputDirectory) + "/" + this.pi.xsdDocument() + "_SchematronSchema.xml");
            FileWriter outputXML = new FileWriter(file);
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            serializer.setWriter((Writer)outputXML);
            serializer.asDOMSerializer().serialize((Node)this.document);
            outputXML.close();
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        this.printed = true;
    }
}

