<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="p1" select="//adv:profilkennung"/>
		<xsl:variable name="p2" select="//adv:antragsnummer"/>
		<xsl:variable name="p3" select="//ogc:Intersects"/>
		<xsl:variable name="p4" select="//adv:koordinatenreferenzsystem"/>
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<xsl:if test="count($p4)=1">
				<koordinatenreferenzsystem>
					<xsl:value-of select="$p4"/>
				</koordinatenreferenzsystem>
			</xsl:if>
			<anforderungsmerkmale>
				<!-- Punkte, die Teil von AX_PunktortAU sind -->
				<wfs:Query typeName="AX_PunktortAU">
					<adv:XlinkPropertyPath>istTeilVon/AA_ZUSO</adv:XlinkPropertyPath>
					<ogc:Filter>
						<ogc:And>
							<ogc:Or>
								<!-- Aufnahmepunkte -->
								<PropertyIsOfType>
									<ogc:PropertyName>istTeilVon</ogc:PropertyName>
									<ogc:Literal>AX_Aufnahmepunkt</ogc:Literal>
								</PropertyIsOfType>
								<!-- Sicherungspunkte -->
								<PropertyIsOfType>
									<ogc:PropertyName>istTeilVon</ogc:PropertyName>
									<ogc:Literal>AX_Sicherungspunkt</ogc:Literal>
								</PropertyIsOfType>
								<!-- Sonstige Vermessungspunkte -->
								<PropertyIsOfType>
									<ogc:PropertyName>istTeilVon</ogc:PropertyName>
									<ogc:Literal>AX_SonstigerVermessungspunkt</ogc:Literal>
								</PropertyIsOfType>
								<!-- Besondere Gebäudepunkte -->
								<PropertyIsOfType>
									<ogc:PropertyName>istTeilVon</ogc:PropertyName>
									<ogc:Literal>AX_BesondererGebaeudepunkt</ogc:Literal>
								</PropertyIsOfType>
								<!-- Besondere Bauwerkspunkte -->
								<PropertyIsOfType>
									<ogc:PropertyName>istTeilVon</ogc:PropertyName>
									<ogc:Literal>AX_BesondererBauwerkspunkt</ogc:Literal>
								</PropertyIsOfType>
								<!-- Besondere topographische Punkte -->
								<PropertyIsOfType>
									<ogc:PropertyName>istTeilVon</ogc:PropertyName>
									<ogc:Literal>AX_BesondererTopographischerPunkt</ogc:Literal>
								</PropertyIsOfType>
								<!-- Lagefestpunkte -->
								<PropertyIsOfType>
									<ogc:PropertyName>istTeilVon</ogc:PropertyName>
									<ogc:Literal>AX_Lagefestpunkt</ogc:Literal>
								</PropertyIsOfType>
							</ogc:Or>
							<xsl:apply-templates select="$p3" mode="copy-it"/>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>koordinatenstatus</ogc:PropertyName>
								<ogc:Literal>1000</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsNull>
								<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
							</ogc:PropertyIsNull>
						</ogc:And>
					</ogc:Filter>
				</wfs:Query>
				<!-- Grenzpunkte -->
				<wfs:Query typeName="AX_PunktortTA">
					<adv:XlinkPropertyPath>istTeilVon/AX_Grenzpunkt</adv:XlinkPropertyPath>
					<ogc:Filter>
						<ogc:And>
							<xsl:apply-templates select="$p3" mode="copy-it"/>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>koordinatenstatus</ogc:PropertyName>
								<ogc:Literal>1000</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsNull>
								<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
							</ogc:PropertyIsNull>
						</ogc:And>
					</ogc:Filter>
				</wfs:Query>
				<!-- indirekt abgemarkten Grenzpunkte: Separat zu obigen Grenzpunkten, um im Filter aktuelles LZI parken zu können. -->
				<wfs:Query typeName="AX_PunktortTA">
					<!-- nur Ziel des Pfades selektieren -->
					<adv:XlinkPropertyPath leafOnly="true">istTeilVon/AX_Grenzpunkt/zeigtAuf/AX_Grenzpunkt</adv:XlinkPropertyPath>
					<ogc:Filter>
						<ogc:And>
							<xsl:apply-templates select="$p3" mode="copy-it"/>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>koordinatenstatus</ogc:PropertyName>
								<ogc:Literal>1000</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsNull>
								<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
							</ogc:PropertyIsNull>
							<!-- zeitliche Betrachtung auf Zielobjekt -->
							<ogc:PropertyIsNull>
								<ogc:PropertyName>istTeilVon/AX_Grenzpunkt/zeigtAuf/AX_Grenzpunkt/lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
							</ogc:PropertyIsNull>
						</ogc:And>
					</ogc:Filter>
				</wfs:Query>
				<!-- zu den indirekt abgemarkten Grenzpunkte die zugehörigen AX_PunktortAU -->
				<wfs:Query typeName="AX_PunktortTA">
					<!-- nur Ziel des Pfades selektieren -->
					<adv:XlinkPropertyPath leafOnly="true">istTeilVon/AX_Grenzpunkt/zeigtAuf/AX_Grenzpunkt/bestehtAus/AX_PunktortAU</adv:XlinkPropertyPath>
					<ogc:Filter>
						<ogc:And>
							<xsl:apply-templates select="$p3" mode="copy-it"/>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>koordinatenstatus</ogc:PropertyName>
								<ogc:Literal>1000</ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsNull>
								<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
							</ogc:PropertyIsNull>
							<!-- zeitliche Betrachtung auf Zielobjekt -->
							<ogc:PropertyIsNull>
								<ogc:PropertyName>istTeilVon/AX_Grenzpunkt/zeigtAuf/AX_Grenzpunkt/bestehtAus/AX_PunktortAU/lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
							</ogc:PropertyIsNull>
						</ogc:And>
					</ogc:Filter>
				</wfs:Query>
				<!-- Besorge ausserdem alle Bundesländer, Gemeinden und Katasterämter mit deren Anschrift
					 zur Befüllung des AX_K_AUSGKOPF_Standard. Am einfachsten kann hier der Kopf dadurch gefüllt werden, 
					 indem der erzeugenden Komponente entsprechende Informationen hinterlegt werden.
				     Hinweis: Dies ist natürlich keine realistische Vorgehensweise bei Produktionsdatenbeständen. 
					 Das Ziel dieser Dokumentation liegt in der Beschreibung der formalen Regeln bei der Ableitung
				     der Standardausgaben - nicht in der Vorgabe einer algorithmischen Umsetzung dieser. -->
				<wfs:Query typeName="AX_Gemeinde"/>
				<wfs:Query typeName="AX_Bundesland"/>
				<wfs:Query typeName="AX_Dienststelle">
					<XlinkPropertyPath>hat/AX_Anschrift</XlinkPropertyPath>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>stellenart</ogc:PropertyName>
							<ogc:Literal>1100</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</wfs:Query>
			</anforderungsmerkmale>
			<profilkennung>
				<xsl:value-of select="$p1"/>
			</profilkennung>
			<antragsnummer>
				<xsl:value-of select="$p2"/>
			</antragsnummer>
			<folgeverarbeitung>
				<AX_FOLGEVA>
					<datenformat>1000</datenformat>
				</AX_FOLGEVA>
			</folgeverarbeitung>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
