/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ProcessMode;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeErrorHandler;
import de.interactive_instruments.ShapeChange.Target.Target;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.SystemUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String W3C_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String W3C_RDFS = "http://www.w3.org/2000/01/rdf-schema#";
    public static final String W3C_OWL = "http://www.w3.org/2002/07/owl#";
    public static final String W3C_OWL2XML = "http://www.w3.org/2006/12/owl2-xml#";
    public static final String DC = "http://purl.org/dc/elements/1.1/";
    public static final String OGC_GEOSPARQL = "http://www.opengis.net/geosparql#";
    public static final String W3C_SKOS = "http://www.w3.org/2004/02/skos/core#";
    public static final String SCRS_NS = "http://www.interactive-instruments.de/ShapeChange/Result";
    public static final String SCAI_NS = "http://www.interactive-instruments.de/ShapeChange/AppInfo";
    public static final String SCHEMATRON_NS = "http://purl.oclc.org/dsdl/schematron";
    public static final String DEF_NS = "http://www.interactive-instruments.de/ShapeChange/Definitions/0.5";
    public static final String XTRASERVER_NS = "http://www.interactive-instruments.de/namespaces/XtraServer";
    public static final String GDBDOC_NS = "http://www.interactive-instruments.de/namespaces/GdbDoc";
    public static final String TargetXmlSchemaClass = "de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema";
    public static final String TargetJsonSchemaClass = "de.interactive_instruments.ShapeChange.Target.JSON.JsonSchema";
    public static final String TargetFeatureCatalogueClass = " de.interactive_instruments.ShapeChange.Target.FeatureCatalogue.FeatureCatalogue";
    public static final String TargetRDFClass = "de.interactive_instruments.ShapeChange.Target.Ontology.RDF";
    public static final String ISO19136_2007 = "iso19136_2007".toLowerCase();
    public static final String ISO19139_2007 = "iso19139_2007".toLowerCase();
    public static final String ISO19136_2007_SHAPECHANGE_1_0 = "iso19136_2007_ShapeChange_1.0_Extensions".toLowerCase();
    public static final String ISO19136_2007_INSPIRE = "iso19136_2007_INSPIRE_Extensions".toLowerCase();
    public static final String ISO19136_2007_NO_GML = "iso19136_2007_NoGmlBaseTypes".toLowerCase();
    public static final String SWECOMMON2 = "ogcSweCommon2".toLowerCase();
    public static final String NOT_ENCODED = "notEncoded".toLowerCase();
    public static final String GSIP_ENC = "gsip".toLowerCase();
    public static final String[] classStereotypes = new String[]{"codelist", "enumeration", "datatype", "featuretype", "type", "basictype", "interface", "union", "abstract", "fachid", "schluesseltabelle", "adeelement", "featureconcept", "attributeconcept", "valueconcept"};
    public static final String[] assocStereotypes = new String[]{"disjoint"};
    public static final String[] propertyStereotypes = new String[]{"voidable", "identifier", "version", "property"};
    public static final String[] packageStereotypes = new String[]{"application schema", "bundle", "leaf"};
    public static final String[] depStereotypes = new String[]{"import", "include"};
    public static final String CRLF = "\r\n";
    public static final int XMI10 = 1;
    public static final int EA7 = 2;
    public static final int GSIP = 3;
    public static final int NONE = 0;
    public static final int ORACLE10 = 2;
    public static final int POSTGIS = 3;
    public static final int GDB = 4;
    public static final int GLOBAL = 1;
    public static final int LOCAL = 2;
    public static final int UNKNOWN = -1;
    public static final int FEATURE = 1;
    public static final int CODELIST = 2;
    public static final int ENUMERATION = 3;
    public static final int MIXIN = 4;
    public static final int DATATYPE = 5;
    public static final int OBJECT = 6;
    public static final int GMLOBJECT = 6;
    public static final int BASICTYPE = 7;
    public static final int UNION = 8;
    public static final int UNIONDIRECT = 9;
    public static final int OKSTRAKEY = 11;
    public static final int OKSTRAFID = 12;
    public static final int FEATURECONCEPT = 13;
    public static final int ATTRIBUTECONCEPT = 14;
    public static final int VALUECONCEPT = 15;
    public String xmlNamespaceDefault = "FIXME";
    public String xmlNamespaceAbbreviationDefault = "FIXME";
    public String appSchemaVersion = "unknown";
    public String configFile = null;
    public String GML_NS = "http://www.opengis.net/gml/3.2";
    public static String GMLEXR_NS = "http://www.opengis.net/gml/3.3/exr";
    public String gmlVersion = "3.2";
    public boolean sortedSchemaOutput = false;
    public boolean roseBugFixDuplicateGlobalDataTypes = true;
    public boolean eaBugFixWrongID = true;
    public boolean eaBugFixPublicPackagesAreMarkedAsPrivate = true;
    public boolean eaIncludeExtentsions = true;
    public boolean argoBugFixMissingDOCTYPE = false;
    protected HashMap<String, String> fTargets = new HashMap();
    protected HashMap<String, String> fParameters = new HashMap();
    protected HashMap<String, String> fReplace = new HashMap();
    protected HashMap<String, MapEntry> fTypeMap = new HashMap();
    protected HashMap<String, MapEntry> fBaseMap = new HashMap();
    protected HashMap<String, MapEntry> fElementMap = new HashMap();
    protected HashMap<String, MapEntry> fAttributeMap = new HashMap();
    protected HashMap<String, MapEntry> fAttributeGroupMap = new HashMap();
    protected HashMap<String, HashMap<String, MapEntry>> fTargetTypeMap = new HashMap();
    protected HashMap<String, String> fStereotypeAliases = new HashMap();
    protected HashMap<String, MapEntry> fNamespaces = new HashMap();
    protected HashMap<String, MapEntry> fPackages = new HashMap();
    protected HashMap<String, String> fSchemaLocations = new HashMap();
    protected HashSet<String> fAllRules = new HashSet();
    protected HashSet<String> fRulesInEncRule = new HashSet();
    protected HashMap<String, String> fExtendsEncRule = new HashMap();
    protected List<TransformerConfiguration> transformerConfigurations = null;
    protected boolean constraintCreationForProperties = true;
    protected HashSet<Integer> classTypesToCreateConstraintsFor = null;

    public boolean isConstraintCreationForProperties() {
        return this.constraintCreationForProperties;
    }

    public boolean isClassTypeToCreateConstraintsFor(int classCategory) {
        if (this.classTypesToCreateConstraintsFor == null) {
            return true;
        }
        return this.classTypesToCreateConstraintsFor.contains(new Integer(classCategory));
    }

    public List<TransformerConfiguration> getTransformerConfigurations() {
        return this.transformerConfigurations;
    }

    protected void addTypeMapEntry(String k1, String k2, String s1, String s2) {
        this.fTypeMap.put(k1 + "#" + k2, new MapEntry(s1, s2));
    }

    protected void addTypeMapEntry(String k1, String k2, String s1, String s2, String s3) {
        this.fTypeMap.put(k1 + "#" + k2, new MapEntry(s1, s2, s3));
    }

    protected void addTypeMapEntry(String k1, String k2, String s1, String s2, String s3, String s4) {
        this.fTypeMap.put(k1 + "#" + k2, new MapEntry(s1, s2, s3, s4));
    }

    public MapEntry typeMapEntry(String k1, String k2) {
        String rule = k2;
        MapEntry me = null;
        while (me == null && rule != null) {
            me = this.fTypeMap.get(k1 + "#" + rule);
            rule = this.extendsEncRule(rule);
        }
        return me;
    }

    public void addTargetTypeMapEntry(String cls, String type, String rule, String ttype, String param) {
        HashMap<String, MapEntry> fclass = this.fTargetTypeMap.get(cls);
        if (fclass == null) {
            fclass = new HashMap();
            this.fTargetTypeMap.put(cls, fclass);
        }
        fclass.put(type + "#" + rule, new MapEntry(rule, ttype, param));
    }

    public MapEntry targetTypeMapEntry(String cls, String type, String rule) {
        HashMap<String, MapEntry> fclass = this.fTargetTypeMap.get(cls);
        if (fclass == null) {
            return null;
        }
        MapEntry me = null;
        while (me == null && rule != null) {
            me = fclass.get(type + "#" + rule);
            rule = this.extendsEncRule(rule);
        }
        return me;
    }

    protected void addBaseMapEntry(String k1, String k2, String s1, String s2) {
        this.fBaseMap.put(k1 + "#" + k2, new MapEntry(s1, s2));
    }

    protected void addBaseMapEntry(String k1, String k2, String s1, String s2, String s3) {
        this.fBaseMap.put(k1 + "#" + k2, new MapEntry(s1, s2, s3));
    }

    public MapEntry baseMapEntry(String k1, String k2) {
        String rule = k2;
        MapEntry me = null;
        while (me == null && rule != null) {
            me = this.fBaseMap.get(k1 + "#" + rule);
            rule = this.extendsEncRule(rule);
        }
        return me;
    }

    protected void addElementMapEntry(String k1, String k2, String s1, String s2) {
        this.fElementMap.put(k1 + "#" + k2, new MapEntry(s1, s2));
    }

    protected void addElementMapEntry(String k1, String k2, String s1, String s2, String s3) {
        this.fElementMap.put(k1 + "#" + k2, new MapEntry(s1, s2, s3));
    }

    public MapEntry elementMapEntry(String k1, String k2) {
        String rule = k2;
        MapEntry me = null;
        while (me == null && rule != null) {
            me = this.fElementMap.get(k1 + "#" + rule);
            rule = this.extendsEncRule(rule);
        }
        return me;
    }

    protected void addAttributeMapEntry(String k1, String k2, String s1) {
        this.fAttributeMap.put(k1 + "#" + k2, new MapEntry(s1));
    }

    public MapEntry attributeMapEntry(String k1, String k2) {
        String rule = k2;
        MapEntry me = null;
        while (me == null && rule != null) {
            me = this.fAttributeMap.get(k1 + "#" + rule);
            rule = this.extendsEncRule(rule);
        }
        return me;
    }

    protected void addAttributeGroupMapEntry(String k1, String k2, String s1) {
        this.fAttributeGroupMap.put(k1 + "#" + k2, new MapEntry(s1));
    }

    public MapEntry attributeGroupMapEntry(String k1, String k2) {
        String rule = k2;
        MapEntry me = null;
        while (me == null && rule != null) {
            me = this.fAttributeGroupMap.get(k1 + "#" + rule);
            rule = this.extendsEncRule(rule);
        }
        return me;
    }

    protected void addTarget(String k1, String k2) {
        this.fTargets.put(k1, k2);
    }

    public Vector<String> targets() {
        Vector<String> res = new Vector<String>();
        for (String t : this.fTargets.keySet()) {
            res.add(t);
        }
        return res;
    }

    public String targetMode(String tn) {
        if (tn == null) {
            return "disabled";
        }
        String s = this.fTargets.get(tn);
        if (s == null) {
            return "disabled";
        }
        return s;
    }

    public String setTargetMode(String tn, String mode) {
        return this.fTargets.put(tn, mode);
    }

    public String parameter(String k1) {
        return this.fParameters.get(k1);
    }

    public String parameter(String t, String k1) {
        return this.fParameters.get(t + "::" + k1);
    }

    public String[] parameterNamesByRegex(String t, String regex) {
        HashSet<String> pnames = new HashSet<String>();
        int lt2 = t.length() + 2;
        for (Map.Entry<String, String> e : this.fParameters.entrySet()) {
            String key = e.getKey();
            if (!key.startsWith(t + "::") || !Pattern.matches(regex, key.substring(lt2))) continue;
            pnames.add(key.substring(lt2));
        }
        return pnames.toArray(new String[0]);
    }

    public void setParameter(String k1, String s1) {
        String s = this.replaceValue(s1);
        if (s != null) {
            this.fParameters.put(k1, s);
        } else {
            this.fParameters.put(k1, s1);
        }
    }

    public void setParameter(String t, String k1, String s1) {
        String s = this.replaceValue(s1);
        if (s != null) {
            this.fParameters.put(t + "::" + k1, s);
        } else {
            this.fParameters.put(t + "::" + k1, s1);
        }
    }

    public String replaceValue(String k1) {
        return this.fReplace.get(k1);
    }

    public void setReplaceValue(String k1, String s1) {
        this.fReplace.put(k1, s1);
    }

    protected void addStereotypeAlias(String k1, String s1) {
        this.fStereotypeAliases.put(k1, s1);
    }

    public String stereotypeAlias(String k1) {
        return this.fStereotypeAliases.get(k1);
    }

    protected void addNamespace(String k1, String s1, String s2) {
        this.fNamespaces.put(k1, new MapEntry(s1, s2));
    }

    protected void addRule(String rule) {
        this.fAllRules.add(rule.toLowerCase());
    }

    public boolean hasRule(String rule) {
        return this.fAllRules.contains(rule.toLowerCase());
    }

    protected void addRule(String rule, String encRule) {
        this.fRulesInEncRule.add(rule.toLowerCase() + "#" + encRule.toLowerCase());
    }

    public boolean hasRule(String rule, String encRule) {
        boolean res = false;
        while (!res && encRule != null) {
            res = this.fRulesInEncRule.contains(rule.toLowerCase() + "#" + encRule.toLowerCase());
            encRule = this.extendsEncRule(encRule);
        }
        return res;
    }

    public boolean matchesEncRule(String encRule, String baseRule) {
        while (encRule != null) {
            if (encRule.equalsIgnoreCase(baseRule)) {
                return true;
            }
            encRule = this.extendsEncRule(encRule);
        }
        return false;
    }

    protected void addExtendsEncRule(String rule1, String rule2) {
        this.fExtendsEncRule.put(rule1.toLowerCase(), rule2.toLowerCase());
    }

    protected String extendsEncRule(String rule1) {
        return this.fExtendsEncRule.get(rule1.toLowerCase());
    }

    protected void addPackage(String k1, String s1, String s2, String s3, String s4) {
        this.fPackages.put(k1, new MapEntry(s1, s2, s3, s4));
    }

    public void addSchemaLocation(String k1, String s1) {
        if (!this.fSchemaLocations.containsKey(k1)) {
            this.fSchemaLocations.put(k1, s1);
        }
    }

    protected MapEntry namespace(String k1) {
        MapEntry me = this.fNamespaces.get(k1);
        return me;
    }

    public String fullNamespace(String k1) {
        MapEntry me = this.fNamespaces.get(k1);
        if (me != null) {
            return me.rule;
        }
        return null;
    }

    public String nsOfPackage(String k1) {
        MapEntry me = this.fPackages.get(k1);
        if (me != null) {
            return me.rule;
        }
        return null;
    }

    public String nsabrOfPackage(String k1) {
        MapEntry me = this.fPackages.get(k1);
        if (me != null) {
            return me.p1;
        }
        return null;
    }

    public String xsdOfPackage(String k1) {
        MapEntry me = this.fPackages.get(k1);
        if (me != null) {
            return me.p2;
        }
        return null;
    }

    public String versionOfPackage(String k1) {
        MapEntry me = this.fPackages.get(k1);
        if (me != null) {
            return me.p3;
        }
        return null;
    }

    public String schemaLocationOfNamespace(String k1) {
        String loc = this.fSchemaLocations.get(k1);
        if (loc == null) {
            loc = "FIXME";
        }
        return loc;
    }

    public String nameOfTarget(int targetId) {
        switch (targetId) {
            case 0: {
                return "-reserved-";
            }
            case 1: {
                return "XML Schema";
            }
            case 2: {
                return "-reserved-";
            }
            case 3: {
                return "RDF";
            }
            case 4: {
                return "Definitions";
            }
            case 5: {
                return "Excel Mapping";
            }
            case 6: {
                return "KML XSLT";
            }
            case 7: {
                return "JSON Schema";
            }
            case 8: {
                return "Code List Dictionary";
            }
            case 9: {
                return "Feature Catalogue";
            }
            case 10: {
                return "Decoder";
            }
            case 401: {
                return "Objektartenkatalog";
            }
            case 402: {
                return "AAA-Profil (3AP)";
            }
            case 404: {
                return "AAA-Modellart (3AM)";
            }
        }
        return "Unknown (" + targetId + ")";
    }

    public void loadConfiguration() throws ShapeChangeAbortException {
        File file;
        InputStream configStream = null;
        if (this.configFile == null) {
            this.configFile = "/config/minimal.xml";
            configStream = this.getClass().getResourceAsStream(this.configFile);
            if (configStream == null) {
                this.configFile = "src/main/resources" + this.configFile;
                file = new File(this.configFile);
                if (file.exists()) {
                    try {
                        configStream = new FileInputStream(file);
                    }
                    catch (FileNotFoundException e1) {
                        throw new ShapeChangeAbortException("Minimal configuration file not found: " + this.configFile);
                    }
                } else {
                    String configURL = "http://shapechange.net/resources/config/minimal.xml";
                    try {
                        URL url = new URL(configURL);
                        configStream = url.openStream();
                    }
                    catch (MalformedURLException e) {
                        throw new ShapeChangeAbortException("Minimal configuration file not accessible from: " + configURL + " (malformed URL)");
                    }
                    catch (IOException e) {
                        throw new ShapeChangeAbortException("Minimal configuration file not accessible from: " + configURL + " (IO error)");
                    }
                }
            }
        } else {
            file = new File(this.configFile);
            if (file == null || !file.exists()) {
                try {
                    configStream = new URL(this.configFile).openStream();
                }
                catch (MalformedURLException e) {
                    throw new ShapeChangeAbortException("No configuration file found at " + this.configFile + " (malformed URL)");
                }
                catch (IOException e) {
                    throw new ShapeChangeAbortException("No configuration file found at " + this.configFile + " (IO exception)");
                }
            }
            try {
                configStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new ShapeChangeAbortException("No configuration file found at " + this.configFile);
            }
            if (configStream == null) {
                throw new ShapeChangeAbortException("No configuration file found at " + this.configFile);
            }
        }
        DocumentBuilder builder = null;
        ShapeChangeErrorHandler handler = null;
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            factory.setFeature("http://apache.org/xml/features/validation/schema", true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            factory.setXIncludeAware(true);
            factory.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
            builder = factory.newDocumentBuilder();
            handler = new ShapeChangeErrorHandler();
            builder.setErrorHandler(handler);
        }
        catch (FactoryConfigurationError e) {
            throw new ShapeChangeAbortException("Unable to get a document builder factory.");
        }
        catch (ParserConfigurationException e) {
            throw new ShapeChangeAbortException("XML Parser was unable to be configured.");
        }
        try {
            String constraintCreationForProperties;
            String nam;
            String loc;
            String ns;
            String nsAbbrev;
            String type;
            int j;
            String mode;
            String cls;
            Element e;
            int j2;
            Document document = builder.parse(configStream);
            if (handler.errorsFound()) {
                throw new ShapeChangeAbortException("Invalid configuration file.");
            }
            NodeList nl = document.getElementsByTagName("parameter");
            for (j2 = 0; j2 < nl.getLength(); ++j2) {
                e = (Element)nl.item(j2);
                String key = e.getAttribute("name");
                String val = e.getAttribute("value");
                this.setParameter(key, val);
            }
            nl = document.getElementsByTagName("targetParameter");
            for (j2 = 0; j2 < nl.getLength(); ++j2) {
                e = (Element)nl.item(j2);
                cls = ((Element)e.getParentNode()).getAttribute("class");
                String key = e.getAttribute("name");
                String val = e.getAttribute("value");
                this.setParameter(cls, key, val);
            }
            nl = document.getElementsByTagName("Target");
            for (j2 = 0; j2 < nl.getLength(); ++j2) {
                e = (Element)nl.item(j2);
                cls = e.getAttribute("class");
                mode = e.getAttribute("mode");
                this.addTarget(cls, mode);
            }
            nl = document.getElementsByTagName("TargetXmlSchema");
            for (j2 = 0; j2 < nl.getLength(); ++j2) {
                e = (Element)nl.item(j2);
                cls = e.getAttribute("class");
                mode = e.getAttribute("mode");
                this.addTarget(cls, mode);
            }
            String s = this.parameter(TargetXmlSchemaClass, "gmlVersion");
            if (s != null) {
                if (s.equals("3.3") || s.equals("3.2") || s.equals("3.1") || s.equals("2.1")) {
                    this.gmlVersion = s;
                } else {
                    throw new ShapeChangeAbortException("Unknown value for gmlVersion: " + s);
                }
            }
            nl = document.getElementsByTagName("XsdMapEntry");
            for (j = 0; j < nl.getLength(); ++j) {
                String xmlTypeNilReason;
                String xmlTypeContent;
                e = (Element)nl.item(j);
                type = e.getAttribute("type");
                String rules = e.getAttribute("xsdEncodingRules");
                if (rules != null) {
                    rules = rules.toLowerCase();
                }
                String[] vv = rules.split("\\s");
                String xmlType = e.getAttribute("xmlType");
                String xmlTypeType = e.getAttribute("xmlTypeType");
                if (xmlTypeType.equals("")) {
                    xmlTypeType = "complex";
                }
                if ((xmlTypeContent = e.getAttribute("xmlTypeContent")).equals("")) {
                    xmlTypeContent = "complex";
                }
                if ((xmlTypeNilReason = e.getAttribute("xmlTypeNilReason")).equals("")) {
                    xmlTypeNilReason = xmlTypeType.equals("simple") ? "false" : "true";
                }
                String xmlElement = e.getAttribute("xmlElement");
                String xmlAttribute = e.getAttribute("xmlAttribute");
                String xmlAttributeGroup = e.getAttribute("xmlAttributeGroup");
                String xmlPropertyType = e.getAttribute("xmlPropertyType");
                for (int i = 0; i < vv.length; ++i) {
                    if (xmlPropertyType != null) {
                        if (xmlPropertyType.equals("_P_") && xmlElement != null) {
                            this.addTypeMapEntry(type, vv[i], "propertyType", xmlElement);
                        } else if (xmlPropertyType.equals("_MP_") && xmlElement != null) {
                            this.addTypeMapEntry(type, vv[i], "metadataPropertyType", xmlElement);
                        } else {
                            this.addTypeMapEntry(type, vv[i], "direct", xmlPropertyType, xmlTypeContent, xmlTypeNilReason);
                        }
                    }
                    if (xmlElement != null) {
                        this.addElementMapEntry(type, vv[i], "direct", xmlElement);
                    }
                    if (xmlType != null) {
                        this.addBaseMapEntry(type, vv[i], "direct", xmlType, xmlTypeType + "/" + xmlTypeContent);
                    }
                    if (xmlAttribute != null) {
                        this.addAttributeMapEntry(type, vv[i], xmlAttribute);
                    }
                    if (xmlAttributeGroup == null) continue;
                    this.addAttributeGroupMapEntry(type, vv[i], xmlAttributeGroup);
                }
            }
            nl = document.getElementsByTagName("MapEntry");
            for (j = 0; j < nl.getLength(); ++j) {
                e = (Element)nl.item(j);
                type = e.getAttribute("type");
                String rule = e.getAttribute("rule");
                String targetType = e.getAttribute("targetType");
                String param = e.getAttribute("param");
                String cls2 = ((Element)e.getParentNode().getParentNode()).getAttribute("class");
                this.addTargetTypeMapEntry(cls2, type, rule, targetType, param);
            }
            nl = document.getElementsByTagName("XmlNamespace");
            for (j = 0; j < nl.getLength(); ++j) {
                e = (Element)nl.item(j);
                nsAbbrev = e.getAttribute("nsabr");
                ns = e.getAttribute("ns");
                loc = e.getAttribute("location");
                this.addNamespace(nsAbbrev, ns, loc);
                if (loc == null) continue;
                this.addSchemaLocation(ns, loc);
            }
            nl = document.getElementsByTagName("PackageInfo");
            for (j = 0; j < nl.getLength(); ++j) {
                e = (Element)nl.item(j);
                nam = e.getAttribute("packageName");
                nsAbbrev = e.getAttribute("nsabr");
                ns = e.getAttribute("ns");
                loc = e.getAttribute("xsdDocument");
                String v = e.getAttribute("version");
                this.addPackage(nam, ns, nsAbbrev, loc, v);
            }
            nl = document.getElementsByTagName("StereotypeAlias");
            for (j = 0; j < nl.getLength(); ++j) {
                e = (Element)nl.item(j);
                String wkn = e.getAttribute("wellknown");
                String alias = e.getAttribute("alias");
                this.addStereotypeAlias(alias, wkn);
            }
            this.addStandardRules();
            nl = document.getElementsByTagName("EncodingRule");
            for (j = 0; j < nl.getLength(); ++j) {
                e = (Element)nl.item(j);
                nam = e.getAttribute("name");
                String ext = e.getAttribute("extends");
                if (ext != null && ext.length() > 0) {
                    this.addExtendsEncRule(nam, ext);
                } else {
                    this.addExtendsEncRule(nam, "*");
                }
                NodeList nl2 = e.getElementsByTagName("rule");
                for (int k = 0; k < nl2.getLength(); ++k) {
                    Element e2 = (Element)nl2.item(k);
                    String id = e2.getAttribute("name");
                    if (!this.hasRule(id)) {
                        throw new ShapeChangeAbortException("Error while loading configuration file: Rule '" + id + "' is unknown, but referenced from the configuration.");
                    }
                    this.addRule(id, nam);
                }
            }
            this.loadTransformerConfigurations(document);
            String classTypesToCreateConstraintsFor = this.parameter("classTypesToCreateConstraintsFor");
            if (classTypesToCreateConstraintsFor != null && (classTypesToCreateConstraintsFor = classTypesToCreateConstraintsFor.trim()).length() > 0) {
                String[] stereotypes = classTypesToCreateConstraintsFor.split("\\W*,\\W*");
                this.classTypesToCreateConstraintsFor = new HashSet();
                for (String stereotype : stereotypes) {
                    String sForCons = stereotype.toLowerCase();
                    if (sForCons.equals("enumeration")) {
                        this.classTypesToCreateConstraintsFor.add(new Integer(3));
                        continue;
                    }
                    if (sForCons.equals("codelist")) {
                        this.classTypesToCreateConstraintsFor.add(new Integer(2));
                        continue;
                    }
                    if (sForCons.equals("schluesseltabelle")) {
                        this.classTypesToCreateConstraintsFor.add(new Integer(11));
                        continue;
                    }
                    if (sForCons.equals("fachid")) {
                        this.classTypesToCreateConstraintsFor.add(new Integer(12));
                        continue;
                    }
                    if (sForCons.equals("datatype")) {
                        this.classTypesToCreateConstraintsFor.add(new Integer(5));
                        continue;
                    }
                    if (sForCons.equals("union")) {
                        this.classTypesToCreateConstraintsFor.add(new Integer(8));
                        continue;
                    }
                    if (sForCons.equals("featureconcept")) {
                        this.classTypesToCreateConstraintsFor.add(new Integer(13));
                        continue;
                    }
                    if (sForCons.equals("attributeconcept")) {
                        this.classTypesToCreateConstraintsFor.add(new Integer(14));
                        continue;
                    }
                    if (sForCons.equals("valueconcept")) {
                        this.classTypesToCreateConstraintsFor.add(new Integer(15));
                        continue;
                    }
                    if (sForCons.equals("interface")) {
                        this.classTypesToCreateConstraintsFor.add(new Integer(4));
                        continue;
                    }
                    if (sForCons.equals("basictype")) {
                        this.classTypesToCreateConstraintsFor.add(new Integer(7));
                        continue;
                    }
                    if (sForCons.equals("adeelement")) {
                        this.classTypesToCreateConstraintsFor.add(new Integer(1));
                        continue;
                    }
                    if (sForCons.equals("featuretype")) {
                        this.classTypesToCreateConstraintsFor.add(new Integer(1));
                        continue;
                    }
                    if (sForCons.equals("type")) {
                        this.classTypesToCreateConstraintsFor.add(new Integer(6));
                        continue;
                    }
                    this.classTypesToCreateConstraintsFor.add(new Integer(-1));
                }
            }
            if ((constraintCreationForProperties = this.parameter("constraintCreationForProperties")) != null && constraintCreationForProperties.trim().equalsIgnoreCase("false")) {
                this.constraintCreationForProperties = false;
            }
        }
        catch (SAXException e) {
            String m = e.getMessage();
            if (m != null) {
                throw new ShapeChangeAbortException("Error while loading configuration file: " + System.getProperty("line.separator") + m);
            }
            e.printStackTrace(System.err);
            throw new ShapeChangeAbortException("Error while loading configuration file: " + System.getProperty("line.separator") + System.err);
        }
        catch (IOException e) {
            String m = e.getMessage();
            if (m != null) {
                throw new ShapeChangeAbortException("Error while loading configuration file: " + System.getProperty("line.separator") + m);
            }
            e.printStackTrace(System.err);
            throw new ShapeChangeAbortException("Error while loading configuration file: " + System.getProperty("line.separator") + System.err);
        }
        MapEntry nsme = this.namespace("gml");
        if (nsme != null) {
            this.GML_NS = nsme.rule;
        }
    }

    private void loadTransformerConfigurations(Document configurationDocument) {
        NodeList trfsNl = configurationDocument.getElementsByTagName("transformers");
        for (int i = 0; i < trfsNl.getLength(); ++i) {
            Node trfsN = trfsNl.item(i);
            NodeList trfNl = trfsN.getChildNodes();
            for (int j = 0; j < trfNl.getLength(); ++j) {
                int k;
                Node trfN = trfNl.item(j);
                if (trfN.getNodeType() != 1) continue;
                Element trfE = (Element)trfN;
                if (this.transformerConfigurations == null) {
                    this.transformerConfigurations = new ArrayList<TransformerConfiguration>();
                }
                String trfConfigName = trfE.getAttribute("class");
                ProcessMode trfMode = null;
                if (trfE.hasAttribute("mode")) {
                    trfMode = ProcessMode.fromString(trfE.getAttribute("mode"));
                }
                HashMap<String, String> processParameters = null;
                NodeList processParametersNl = trfE.getElementsByTagName("ProcessParameter");
                if (processParametersNl != null && processParametersNl.getLength() != 0) {
                    for (k = 0; k < processParametersNl.getLength(); ++k) {
                        Node processParameterN = processParametersNl.item(k);
                        if (processParameterN.getNodeType() != 1) continue;
                        if (processParameters == null) {
                            processParameters = new HashMap<String, String>();
                        }
                        Element processParameterE = (Element)processParameterN;
                        processParameters.put(processParameterE.getAttribute("name"), processParameterE.getAttribute("value"));
                    }
                }
                HashMap<String, ProcessRuleSet> processRuleSets = null;
                NodeList processRuleSetsNl = trfE.getElementsByTagName("ProcessRuleSet");
                if (processRuleSetsNl != null && processRuleSetsNl.getLength() != 0) {
                    for (k = 0; k < processRuleSetsNl.getLength(); ++k) {
                        String extendedRuleName;
                        Node processRuleSetN = processRuleSetsNl.item(k);
                        if (processRuleSetN.getNodeType() != 1) continue;
                        if (processRuleSets == null) {
                            processRuleSets = new HashMap<String, ProcessRuleSet>();
                        }
                        Element processRuleSetE = (Element)processRuleSetN;
                        String processRuleSetName = processRuleSetE.getAttribute("name");
                        extendedRuleName = processRuleSetE.hasAttribute("extends") ? (extendedRuleName = processRuleSetE.getAttribute("extends")) : null;
                        HashSet<String> ruleSetRules = null;
                        NodeList processRuleSetRulesNl = processRuleSetE.getElementsByTagName("rule");
                        if (processRuleSetRulesNl != null && processRuleSetRulesNl.getLength() != 0) {
                            for (int l = 0; l < processRuleSetRulesNl.getLength(); ++l) {
                                Node processRuleSetRuleN = processRuleSetRulesNl.item(l);
                                if (processRuleSetRuleN.getNodeType() != 1) continue;
                                Element processRuleSetRuleE = (Element)processRuleSetRuleN;
                                if (ruleSetRules == null) {
                                    ruleSetRules = new HashSet<String>();
                                }
                                ruleSetRules.add(processRuleSetRuleE.getAttribute("name"));
                            }
                        }
                        processRuleSets.put(processRuleSetName, new ProcessRuleSet(processRuleSetName, extendedRuleName, ruleSetRules));
                    }
                }
                HashMap<String, ProcessMapEntry> processMapEntries = null;
                NodeList processMapEntriesNl = trfE.getElementsByTagName("ProcessMapEntry");
                if (processMapEntriesNl != null && processMapEntriesNl.getLength() != 0) {
                    for (k = 0; k < processMapEntriesNl.getLength(); ++k) {
                        Node processMapEntryN = processMapEntriesNl.item(k);
                        if (processMapEntryN.getNodeType() != 1) continue;
                        if (processMapEntries == null) {
                            processMapEntries = new HashMap<String, ProcessMapEntry>();
                        }
                        Element processMapEntryE = (Element)processMapEntryN;
                        String processMapEntryType = processMapEntryE.getAttribute("type");
                        String processMapEntryRule = processMapEntryE.getAttribute("rule");
                        String processMapEntryTargetType = processMapEntryE.hasAttribute("targetType") ? processMapEntryE.getAttribute("targetType") : null;
                        String processMapEntryParam = processMapEntryE.hasAttribute("param") ? processMapEntryE.getAttribute("param") : null;
                        processMapEntries.put(processMapEntryType, new ProcessMapEntry(processMapEntryType, processMapEntryRule, processMapEntryTargetType, processMapEntryParam));
                    }
                }
                TransformerConfiguration trfConfig = new TransformerConfiguration(trfConfigName, trfMode, processParameters, processRuleSets, processMapEntries);
                this.transformerConfigurations.add(trfConfig);
            }
        }
    }

    private void addStandardRules() {
        this.addRule("req-xsd-pkg-xsdDocument-unique");
        this.addRule("req-xsd-cls-name-unique");
        this.addRule("req-xsd-cls-ncname");
        this.addRule("req-xsd-prop-data-type");
        this.addRule("req-xsd-prop-value-type-exists");
        this.addRule("req-xsd-prop-ncname");
        this.addRule("rule-xsd-pkg-contained-packages");
        this.addRule("rule-xsd-pkg-dependencies");
        this.addRule("rule-xsd-cls-union-as-choice");
        this.addRule("rule-xsd-cls-unknown-as-object");
        this.addRule("rule-xsd-cls-sequence");
        this.addRule("rule-xsd-cls-object-element");
        this.addRule("rule-xsd-cls-type");
        this.addRule("rule-xsd-cls-property-type");
        this.addRule("rule-xsd-cls-local-properties");
        this.addRule("req-xsd-pkg-xsdDocument-unique", "*");
        this.addRule("req-xsd-cls-name-unique", "*");
        this.addRule("req-xsd-cls-ncname", "*");
        this.addRule("req-xsd-prop-data-type", "*");
        this.addRule("req-xsd-prop-value-type-exists", "*");
        this.addRule("req-xsd-prop-ncname", "*");
        this.addRule("rule-xsd-pkg-contained-packages", "*");
        this.addRule("rule-xsd-pkg-dependencies", "*");
        this.addRule("rule-xsd-cls-unknown-as-object", "*");
        this.addRule("rule-xsd-cls-object-element", "*");
        this.addRule("rule-xsd-cls-type", "*");
        this.addRule("rule-xsd-cls-property-type", "*");
        this.addRule("rule-xsd-cls-local-properties", "*");
        this.addRule("rule-xsd-cls-union-as-choice", "*");
        this.addRule("rule-xsd-cls-sequence", "*");
        this.addRule("req-xsd-cls-generalization-consistent");
        this.addRule("rule-xsd-all-naming-gml");
        this.addRule("rule-xsd-cls-global-enumeration");
        this.addRule("rule-xsd-cls-codelist-asDictionary");
        this.addRule("rule-xsd-cls-noPropertyType");
        this.addRule("rule-xsd-cls-byValuePropertyType");
        this.addRule("rule-xsd-cls-standard-gml-property-types");
        this.addRule("rule-xsd-pkg-gmlProfileSchema");
        this.addRule("rule-xsd-prop-defaultCodeSpace");
        this.addRule("rule-xsd-prop-inlineOrByReference");
        this.addRule("rule-xsd-prop-reverseProperty");
        this.addRule("rule-xsd-prop-targetElement");
        this.addExtendsEncRule("iso19136_2007", "*");
        this.addRule("req-xsd-cls-generalization-consistent", "iso19136_2007");
        this.addRule("rule-xsd-all-naming-gml", "iso19136_2007");
        this.addRule("rule-xsd-cls-global-enumeration", "iso19136_2007");
        this.addRule("rule-xsd-cls-codelist-asDictionary", "iso19136_2007");
        this.addRule("rule-xsd-cls-standard-gml-property-types", "iso19136_2007");
        this.addRule("rule-xsd-cls-noPropertyType", "iso19136_2007");
        this.addRule("rule-xsd-cls-byValuePropertyType", "iso19136_2007");
        this.addRule("rule-xsd-pkg-gmlProfileSchema", "iso19136_2007");
        this.addRule("rule-xsd-prop-targetElement", "iso19136_2007");
        this.addRule("rule-xsd-prop-reverseProperty", "iso19136_2007");
        this.addRule("rule-xsd-prop-defaultCodeSpace", "iso19136_2007");
        this.addRule("rule-xsd-prop-inlineOrByReference", "iso19136_2007");
        this.addRule("rule-xsd-cls-codelist-asDictionaryGml33");
        this.addRule("rule-xsd-rel-association-classes");
        this.addExtendsEncRule("gml33", "*");
        this.addRule("req-xsd-cls-generalization-consistent", "gml33");
        this.addRule("rule-xsd-all-naming-gml", "gml33");
        this.addRule("rule-xsd-cls-global-enumeration", "gml33");
        this.addRule("rule-xsd-cls-codelist-asDictionaryGml33", "gml33");
        this.addRule("rule-xsd-cls-standard-gml-property-types", "gml33");
        this.addRule("rule-xsd-cls-noPropertyType", "gml33");
        this.addRule("rule-xsd-cls-byValuePropertyType", "gml33");
        this.addRule("rule-xsd-pkg-gmlProfileSchema", "gml33");
        this.addRule("rule-xsd-prop-targetElement", "gml33");
        this.addRule("rule-xsd-prop-reverseProperty", "gml33");
        this.addRule("rule-xsd-prop-defaultCodeSpace", "gml33");
        this.addRule("rule-xsd-prop-inlineOrByReference", "gml33");
        this.addRule("rule-xsd-rel-association-classes", "gml33");
        this.addRule("rule-xsd-all-naming-19139");
        this.addRule("rule-xsd-cls-standard-19139-property-types");
        this.addRule("rule-xsd-cls-enum-object-element");
        this.addRule("rule-xsd-cls-enum-property-type");
        this.addExtendsEncRule("iso19139_2007", "*");
        this.addRule("rule-xsd-cls-enum-object-element", "iso19139_2007");
        this.addRule("rule-xsd-cls-enum-property-type", "iso19139_2007");
        this.addRule("rule-xsd-cls-global-enumeration", "iso19139_2007");
        this.addRule("rule-xsd-cls-standard-19139-property-types", "iso19139_2007");
        this.addRule("rule-xsd-all-naming-19139", "iso19139_2007");
        this.addRule("rule-xsd-all-naming-swe");
        this.addRule("rule-xsd-prop-xsdAsAttribute");
        this.addRule("rule-xsd-prop-soft-typed");
        this.addRule("rule-xsd-cls-union-as-group-property-type");
        this.addRule("rule-xsd-cls-standard-swe-property-types");
        this.addRule("rule-xsd-prop-initialValue");
        this.addExtendsEncRule("ogcSweCommon2", "*");
        this.addRule("req-xsd-cls-generalization-consistent", "ogcSweCommon2");
        this.addRule("rule-xsd-all-naming-swe", "ogcSweCommon2");
        this.addRule("rule-xsd-cls-global-enumeration", "ogcSweCommon2");
        this.addRule("rule-xsd-cls-codelist-asDictionary", "ogcSweCommon2");
        this.addRule("rule-xsd-cls-standard-swe-property-types", "ogcSweCommon2");
        this.addRule("rule-xsd-cls-noPropertyType", "ogcSweCommon2");
        this.addRule("rule-xsd-cls-byValuePropertyType", "ogcSweCommon2");
        this.addRule("rule-xsd-pkg-gmlProfileSchema", "ogcSweCommon2");
        this.addRule("rule-xsd-prop-targetElement", "ogcSweCommon2");
        this.addRule("rule-xsd-prop-reverseProperty", "ogcSweCommon2");
        this.addRule("rule-xsd-prop-defaultCodeSpace", "ogcSweCommon2");
        this.addRule("rule-xsd-prop-inlineOrByReference", "ogcSweCommon2");
        this.addRule("rule-xsd-prop-xsdAsAttribute", "ogcSweCommon2");
        this.addRule("rule-xsd-prop-soft-typed", "ogcSweCommon2");
        this.addRule("rule-xsd-cls-union-as-group-property-type", "ogcSweCommon2");
        this.addRule("rule-xsd-prop-initialValue", "ogcSweCommon2");
        this.addRule("req-all-all-documentation");
        this.addRule("req-xsd-pkg-targetNamespace");
        this.addRule("req-xsd-pkg-xmlns");
        this.addRule("req-xsd-pkg-namespace-schema-only");
        this.addRule("rec-xsd-pkg-version");
        this.addRule("req-xsd-pkg-xsdDocument");
        this.addRule("req-xsd-pkg-dependencies");
        this.addRule("req-xsd-cls-codelist-asDictionary-true");
        this.addRule("req-xsd-cls-codelist-extensibility-values");
        this.addRule("req-xsd-cls-codelist-extensibility-vocabulary");
        this.addRule("req-xsd-cls-codelist-no-supertypes");
        this.addRule("req-xsd-cls-datatype-noPropertyType");
        this.addRule("req-xsd-cls-enum-no-supertypes");
        this.addRule("req-xsd-cls-mixin-supertypes");
        this.addRule("req-xsd-cls-objecttype-byValuePropertyType");
        this.addRule("req-xsd-cls-objecttype-noPropertyType");
        this.addRule("req-xsd-cls-suppress-no-properties");
        this.addRule("req-xsd-cls-suppress-subtype");
        this.addRule("req-xsd-cls-suppress-supertype");
        this.addRule("req-xsd-prop-codelist-obligation");
        this.addRule("rule-xsd-all-notEncoded");
        this.addRule("rule-xsd-cls-adeelement");
        this.addRule("rule-xsd-cls-basictype");
        this.addRule("rule-xsd-cls-codelist-constraints");
        this.addRule("rule-xsd-cls-enum-subtypes");
        this.addRule("rule-xsd-cls-enum-supertypes");
        this.addRule("rule-xsd-cls-mixin-classes-as-group");
        this.addRule("rule-xsd-cls-mixin-classes");
        this.addRule("rule-xsd-cls-no-abstract-classes");
        this.addRule("rule-xsd-cls-no-base-class");
        this.addRule("rule-xsd-cls-no-gml-types");
        this.addRule("rule-xsd-cls-okstra-fid");
        this.addRule("rule-xsd-cls-okstra-lifecycle");
        this.addRule("rule-xsd-cls-okstra-schluesseltabelle");
        this.addRule("rule-xsd-cls-suppress");
        this.addRule("rule-xsd-cls-union-asCharacterString");
        this.addRule("rule-xsd-cls-union-asGroup");
        this.addRule("rule-xsd-cls-union-direct");
        this.addRule("rule-xsd-prop-att-map-entry");
        this.addRule("rule-xsd-prop-exclude-derived");
        this.addRule("rule-xsd-prop-length-size-pattern");
        this.addRule("rule-xsd-prop-nillable");
        this.addRule("rule-xsd-prop-nilReasonAllowed");
        this.addRule("rule-xsd-all-no-documentation");
        this.addRule("rule-xsd-cls-local-enumeration");
        this.addRule("rule-xsd-cls-local-basictype");
        this.addRule("rule-xsd-pkg-schematron");
        this.addRule("rule-xsd-all-tagged-values");
        this.addExtendsEncRule("geoservices", "*");
        this.addExtendsEncRule("geoservices_extended", "*");
        this.addRule("rule-rdf-prop-parent");
    }

    public String normalizeStereotype(String stereotype) {
        String s = this.stereotypeAlias(stereotype.trim());
        if (s != null) {
            return s;
        }
        return stereotype;
    }

    public boolean skipSchema(Target target, PackageInfo pi) {
        String name = pi.name();
        String ns = pi.targetNamespace();
        String schemaFilter = target == null ? this.parameter("appSchemaName") : this.parameter(target.getClass().getName(), "appSchemaName");
        if (schemaFilter != null && schemaFilter.length() > 0 && !schemaFilter.equals(name)) {
            return true;
        }
        String appSchemaNameRegex = target == null ? this.parameter("appSchemaNameRegex") : this.parameter(target.getClass().getName(), "appSchemaNameRegex");
        if (appSchemaNameRegex != null && appSchemaNameRegex != null && appSchemaNameRegex.length() > 0 && !name.matches(appSchemaNameRegex)) {
            return true;
        }
        String appSchemaNamespaceRegex = target == null ? this.parameter("appSchemaNamespaceRegex") : this.parameter(target.getClass().getName(), "appSchemaNamespaceRegex");
        return appSchemaNamespaceRegex != null && appSchemaNamespaceRegex.length() > 0 && !ns.matches(appSchemaNamespaceRegex);
    }

    public String targetClassName(String rule) {
        String[] ra = rule.toLowerCase().split("-", 4);
        if (ra.length != 4) {
            return null;
        }
        if (ra[1].equals("xsd")) {
            return TargetXmlSchemaClass;
        }
        if (ra[1].equals("json")) {
            return TargetJsonSchemaClass;
        }
        if (ra[1].equals("fc")) {
            return TargetFeatureCatalogueClass;
        }
        if (ra[1].equals("rdf")) {
            return TargetRDFClass;
        }
        return null;
    }

    public Options() {
        this.setParameter("reportLevel", "INFO");
        this.setParameter("xsltFile", "src/main/resources/xslt/result.xsl");
        this.setParameter("appSchemaName", "");
        this.setParameter("appSchemaNameRegex", "");
        this.setParameter("appSchemaNamespaceRegex", "");
        this.setParameter("publicOnly", "true");
        this.setParameter("inputFile", "http://shapechange.net/resources/test/test.xmi");
        this.setParameter("inputModelType", "XMI10");
        this.setParameter("logFile", "log.xml");
        this.setParameter("representTaggedValues", "");
        this.setParameter("addTaggedValues", "");
        this.setParameter("outputDirectory", SystemUtils.getUserDir().getPath());
        this.setParameter("sortedSchemaOutput", "true");
        this.setParameter("sortedOutput", "true");
        this.setParameter("oclConstraintTypeRegex", "(OCL|Invariant)");
        this.setParameter(TargetXmlSchemaClass, "defaultEncodingRule", ISO19136_2007);
        this.setParameter(TargetXmlSchemaClass, "gmlVersion", "3.2");
    }
}

