/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeErrorHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String SCRS_NS = "http://www.interactive-instruments.de/ShapeChange/Result";
    public static final String SCAI_NS = "http://www.interactive-instruments.de/ShapeChange/AppInfo";
    public static final String SCHEMATRON_NS = "http://purl.oclc.org/dsdl/schematron";
    public static final String WSDL_NS = "http://schemas.xmlsoap.org/wsdl/";
    public static final String SOAP_NS = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String DEF_NS = "http://www.interactive-instruments.de/ShapeChange/Definitions/0.5";
    public static final String XTRASERVER_NS = "http://www.interactive-instruments.de/namespaces/XtraServer";
    public static final String TargetXmlSchemaClass = "de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema";
    public static final String ISO19136_2007 = "iso19136_2007";
    public static final String ISO19139_2007 = "iso19139_2007";
    public static final String ISO19136_2007_SHAPECHANGE_1_0 = "iso19136_2007_ShapeChange_1.0_Extensions";
    public static final String ISO19136_2007_INSPIRE = "iso19136_2007_INSPIRE_Extensions";
    public static final String ISO19136_2007_NO_GML = "iso19136_2007_NoGmlBaseTypes";
    public static final String NOT_ENCODED = "notEncoded";
    public static final String[] classStereotypes = new String[]{"codelist", "enumeration", "datatype", "featuretype", "objecttype", "type", "basictype", "interface", "union", "abstract"};
    public static final String[] assocStereotypes = new String[]{"disjoint"};
    public static final String[] propertyStereotypes = new String[]{"voidable", "identifier"};
    public static final String[] packageStereotypes = new String[]{"application schema", "bundle", "leaf"};
    public static final String[] depStereotypes = new String[]{"import", "include"};
    public static final String CRLF = "\r\n";
    public static final String allSupportedRules = "iso19136_2007 iso19136_2007_ShapeChange_1.0_Extensions iso19136_2007_NoGmlBaseTypes iso19139_2007 iso19136_2007_INSPIRE_Extensions";
    public static final int XMI10 = 1;
    public static final int EA7 = 2;
    public static final int NONE = 0;
    public static final int ORACLE10 = 2;
    public static final int POSTGIS = 3;
    public static final int GLOBAL = 1;
    public static final int LOCAL = 2;
    public static final int UNKNOWN = -1;
    public static final int FEATURE = 1;
    public static final int CODELIST = 2;
    public static final int ENUMERATION = 3;
    public static final int MIXIN = 4;
    public static final int DATATYPE = 5;
    public static final int GMLOBJECT = 6;
    public static final int BASICTYPE = 7;
    public static final int UNION = 8;
    public static final int UNIONDIRECT = 9;
    public static final int SERVICE = 10;
    public String GML_NS;
    public String xmlNamespaceDefault = "http://www.interactive-instruments.de/please/fix/this/namespace";
    public String xmlNamespaceAbbreviationDefault = "app";
    public String appSchemaVersion = "unknown";
    public String configFile = "./ShapeChangeConfiguration.xml";
    public String gmlVersion = "3.2";
    public boolean roseBugFixDuplicateGlobalDataTypes = true;
    public boolean eaBugFixWrongID = true;
    public boolean eaBugFixPublicPackagesAreMarkedAsPrivate = true;
    public boolean eaIncludeExtentsions = true;
    public boolean argoBugFixMissingDOCTYPE = false;
    protected HashSet<String> fTargets = new HashSet();
    protected HashMap<String, String> fParameters = new HashMap();
    protected HashMap<String, String> fReplace = new HashMap();
    protected HashMap<String, MapEntry> fTypeMap = new HashMap();
    protected HashMap<String, MapEntry> fBaseMap = new HashMap();
    protected HashMap<String, MapEntry> fElementMap = new HashMap();
    protected HashMap<String, MapEntry> fAttributeMap = new HashMap();
    protected HashMap<String, MapEntry> fAttributeGroupMap = new HashMap();
    protected HashMap<String, String> fStereotypeAliases = new HashMap();
    protected HashMap<String, MapEntry> fNamespaces = new HashMap();
    protected HashMap<String, MapEntry> fPackages = new HashMap();
    protected HashMap<String, String> fSchemaLocations = new HashMap();

    protected void addTypeMapEntry(String k1, String k2, String s1, String s2) {
        this.fTypeMap.put(String.valueOf(k1) + "#" + k2, new MapEntry(s1, s2));
    }

    protected void addTypeMapEntry(String k1, String k2, String s1, String s2, String s3) {
        this.fTypeMap.put(String.valueOf(k1) + "#" + k2, new MapEntry(s1, s2, s3));
    }

    protected void addTypeMapEntry(String k1, String k2, String s1, String s2, String s3, String s4) {
        this.fTypeMap.put(String.valueOf(k1) + "#" + k2, new MapEntry(s1, s2, s3, s4));
    }

    public MapEntry typeMapEntry(String k1, String k2) {
        MapEntry me = this.fTypeMap.get(String.valueOf(k1) + "#*");
        if (me == null) {
            me = this.fTypeMap.get(String.valueOf(k1) + "#" + k2);
        }
        return me;
    }

    protected void addBaseMapEntry(String k1, String k2, String s1, String s2) {
        this.fBaseMap.put(String.valueOf(k1) + "#" + k2, new MapEntry(s1, s2));
    }

    protected void addBaseMapEntry(String k1, String k2, String s1, String s2, String s3) {
        this.fBaseMap.put(String.valueOf(k1) + "#" + k2, new MapEntry(s1, s2, s3));
    }

    public MapEntry baseMapEntry(String k1, String k2) {
        MapEntry me = this.fBaseMap.get(String.valueOf(k1) + "#*");
        if (me == null) {
            me = this.fBaseMap.get(String.valueOf(k1) + "#" + k2);
        }
        return me;
    }

    protected void addElementMapEntry(String k1, String k2, String s1, String s2) {
        this.fElementMap.put(String.valueOf(k1) + "#" + k2, new MapEntry(s1, s2));
    }

    protected void addElementMapEntry(String k1, String k2, String s1, String s2, String s3) {
        this.fElementMap.put(String.valueOf(k1) + "#" + k2, new MapEntry(s1, s2, s3));
    }

    public MapEntry elementMapEntry(String k1, String k2) {
        MapEntry me = this.fElementMap.get(String.valueOf(k1) + "#*");
        if (me == null) {
            me = this.fElementMap.get(String.valueOf(k1) + "#" + k2);
        }
        return me;
    }

    protected void addAttributeMapEntry(String k1, String k2, String s1) {
        this.fAttributeMap.put(String.valueOf(k1) + "#" + k2, new MapEntry(s1));
    }

    public MapEntry attributeMapEntry(String k1, String k2) {
        MapEntry me = this.fAttributeMap.get(String.valueOf(k1) + "#*");
        if (me == null) {
            me = this.fAttributeMap.get(String.valueOf(k1) + "#" + k2);
        }
        return me;
    }

    protected void addAttributeGroupMapEntry(String k1, String k2, String s1) {
        this.fAttributeGroupMap.put(String.valueOf(k1) + "#" + k2, new MapEntry(s1));
    }

    public MapEntry attributeGroupMapEntry(String k1, String k2) {
        MapEntry me = this.fAttributeGroupMap.get(String.valueOf(k1) + "#*");
        if (me == null) {
            me = this.fAttributeGroupMap.get(String.valueOf(k1) + "#" + k2);
        }
        return me;
    }

    protected void addTarget(String k1) {
        this.fTargets.add(k1);
    }

    public Vector<String> targets() {
        Vector<String> res = new Vector<String>();
        Iterator<String> i = this.fTargets.iterator();
        while (i.hasNext()) {
            res.add(i.next());
        }
        return res;
    }

    public String parameter(String k1) {
        return this.fParameters.get(k1);
    }

    public String parameter(String t, String k1) {
        return this.fParameters.get(String.valueOf(t) + "::" + k1);
    }

    public void setParameter(String k1, String s1) {
        String s = this.replaceValue(s1);
        if (s != null) {
            this.fParameters.put(k1, s);
        } else {
            this.fParameters.put(k1, s1);
        }
    }

    public void setParameter(String t, String k1, String s1) {
        String s = this.replaceValue(s1);
        if (s != null) {
            this.fParameters.put(String.valueOf(t) + "::" + k1, s);
        } else {
            this.fParameters.put(String.valueOf(t) + "::" + k1, s1);
        }
    }

    public String replaceValue(String k1) {
        return this.fReplace.get(k1);
    }

    public void setReplaceValue(String k1, String s1) {
        this.fReplace.put(k1, s1);
    }

    protected void addStereotypeAlias(String k1, String s1) {
        this.fStereotypeAliases.put(k1, s1);
    }

    public String stereotypeAlias(String k1) {
        return this.fStereotypeAliases.get(k1);
    }

    protected void addNamespace(String k1, String s1, String s2) {
        this.fNamespaces.put(k1, new MapEntry(s1, s2));
    }

    protected void addPackage(String k1, String s1, String s2, String s3, String s4) {
        this.fPackages.put(k1, new MapEntry(s1, s2, s3, s4));
    }

    public void addSchemaLocation(String k1, String s1) {
        this.fSchemaLocations.put(k1, s1);
    }

    protected MapEntry namespace(String k1) {
        MapEntry me = this.fNamespaces.get(k1);
        return me;
    }

    public String fullNamespace(String k1) {
        MapEntry me = this.fNamespaces.get(k1);
        if (me != null) {
            return me.rule;
        }
        return null;
    }

    public String nsOfPackage(String k1) {
        MapEntry me = this.fPackages.get(k1);
        if (me != null) {
            return me.rule;
        }
        return null;
    }

    public String nsabrOfPackage(String k1) {
        MapEntry me = this.fPackages.get(k1);
        if (me != null) {
            return me.p1;
        }
        return null;
    }

    public String xsdOfPackage(String k1) {
        MapEntry me = this.fPackages.get(k1);
        if (me != null) {
            return me.p2;
        }
        return null;
    }

    public String versionOfPackage(String k1) {
        MapEntry me = this.fPackages.get(k1);
        if (me != null) {
            return me.p3;
        }
        return null;
    }

    public String schemaLocationOfNamespace(String k1) {
        return this.fSchemaLocations.get(k1);
    }

    public void loadConfiguration() throws ShapeChangeAbortException {
        DocumentBuilder builder = null;
        ShapeChangeErrorHandler handler = null;
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            factory.setFeature("http://apache.org/xml/features/validation/schema", true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            factory.setXIncludeAware(true);
            factory.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
            builder = factory.newDocumentBuilder();
            handler = new ShapeChangeErrorHandler();
            builder.setErrorHandler(handler);
        }
        catch (FactoryConfigurationError e) {
            System.err.println("Unable to get a document builder factory.");
            throw new ShapeChangeAbortException();
        }
        catch (ParserConfigurationException e) {
            System.err.println("XML Parser was unable to be configured.");
            throw new ShapeChangeAbortException();
        }
        try {
            String loc;
            String ns;
            String nsAbbrev;
            String cls;
            Element e;
            Document document = builder.parse(this.configFile);
            if (handler.errorsFound()) {
                System.err.println("Invalid configuration file.");
                throw new ShapeChangeAbortException();
            }
            NodeList nl = document.getElementsByTagName("parameter");
            int j = 0;
            while (j < nl.getLength()) {
                e = (Element)nl.item(j);
                String key = e.getAttribute("name");
                String val = e.getAttribute("value");
                this.setParameter(key, val);
                ++j;
            }
            nl = document.getElementsByTagName("targetParameter");
            j = 0;
            while (j < nl.getLength()) {
                e = (Element)nl.item(j);
                cls = ((Element)e.getParentNode()).getAttribute("class");
                String key = e.getAttribute("name");
                String val = e.getAttribute("value");
                this.setParameter(cls, key, val);
                ++j;
            }
            nl = document.getElementsByTagName("Target");
            j = 0;
            while (j < nl.getLength()) {
                e = (Element)nl.item(j);
                cls = e.getAttribute("class");
                this.addTarget(cls);
                ++j;
            }
            nl = document.getElementsByTagName("TargetXmlSchema");
            j = 0;
            while (j < nl.getLength()) {
                e = (Element)nl.item(j);
                cls = e.getAttribute("class");
                this.addTarget(cls);
                ++j;
            }
            String s = this.parameter(TargetXmlSchemaClass, "gmlVersion");
            if (s != null) {
                if (s.equals("3.2") || s.equals("3.1") || s.equals("2.1")) {
                    this.gmlVersion = s;
                } else {
                    System.err.println("Unknown value for gmlVersion: " + s);
                }
            }
            nl = document.getElementsByTagName("XsdMapEntry");
            int j2 = 0;
            while (j2 < nl.getLength()) {
                String xmlTypeNilReason;
                String xmlTypeContent;
                e = (Element)nl.item(j2);
                String type = e.getAttribute("type");
                String rules = e.getAttribute("xsdEncodingRules");
                if (rules.equals("*")) {
                    rules = allSupportedRules;
                }
                String[] vv = rules.split("\\s");
                String xmlType = e.getAttribute("xmlType");
                String xmlTypeType = e.getAttribute("xmlTypeType");
                if (xmlTypeType.equals("")) {
                    xmlTypeType = "complex";
                }
                if ((xmlTypeContent = e.getAttribute("xmlTypeContent")).equals("")) {
                    xmlTypeContent = "complex";
                }
                if ((xmlTypeNilReason = e.getAttribute("xmlTypeNilReason")).equals("")) {
                    xmlTypeNilReason = xmlTypeType.equals("simple") ? "false" : "true";
                }
                String xmlElement = e.getAttribute("xmlElement");
                String xmlAttribute = e.getAttribute("xmlAttribute");
                String xmlAttributeGroup = e.getAttribute("xmlAttributeGroup");
                String xmlPropertyType = e.getAttribute("xmlPropertyType");
                int i = 0;
                while (i < vv.length) {
                    if (xmlPropertyType != null) {
                        if (xmlPropertyType.equals("_P_") && xmlElement != null) {
                            this.addTypeMapEntry(type, vv[i], "propertyType", xmlElement);
                        } else if (xmlPropertyType.equals("_MP_") && xmlElement != null) {
                            this.addTypeMapEntry(type, vv[i], "metadataPropertyType", xmlElement);
                        } else {
                            this.addTypeMapEntry(type, vv[i], "direct", xmlPropertyType, xmlTypeContent, xmlTypeNilReason);
                        }
                    }
                    if (xmlElement != null) {
                        this.addElementMapEntry(type, vv[i], "direct", xmlElement);
                    }
                    if (xmlType != null) {
                        this.addBaseMapEntry(type, vv[i], "direct", xmlType, String.valueOf(xmlTypeType) + "/" + xmlTypeContent);
                    }
                    if (xmlAttribute != null) {
                        this.addAttributeMapEntry(type, vv[i], xmlAttribute);
                    }
                    if (xmlAttributeGroup != null) {
                        this.addAttributeGroupMapEntry(type, vv[i], xmlAttributeGroup);
                    }
                    ++i;
                }
                ++j2;
            }
            nl = document.getElementsByTagName("XmlNamespace");
            j2 = 0;
            while (j2 < nl.getLength()) {
                e = (Element)nl.item(j2);
                nsAbbrev = e.getAttribute("nsabr");
                ns = e.getAttribute("ns");
                loc = e.getAttribute("location");
                this.addNamespace(nsAbbrev, ns, loc);
                this.addSchemaLocation(ns, loc);
                ++j2;
            }
            nl = document.getElementsByTagName("PackageInfo");
            j2 = 0;
            while (j2 < nl.getLength()) {
                e = (Element)nl.item(j2);
                String nam = e.getAttribute("packageName");
                nsAbbrev = e.getAttribute("nsabr");
                ns = e.getAttribute("ns");
                loc = e.getAttribute("xsdDocument");
                String v = e.getAttribute("version");
                this.addPackage(nam, ns, nsAbbrev, loc, v);
                ++j2;
            }
            nl = document.getElementsByTagName("StereotypeAlias");
            j2 = 0;
            while (j2 < nl.getLength()) {
                e = (Element)nl.item(j2);
                String wkn = e.getAttribute("wellknown");
                String alias = e.getAttribute("alias");
                this.addStereotypeAlias(alias, wkn);
                ++j2;
            }
        }
        catch (SAXException e) {
            String m = e.getMessage();
            if (m != null) {
                System.err.println(m);
            } else {
                e.printStackTrace(System.err);
            }
        }
        catch (IOException e) {
            String m = e.getMessage();
            if (m != null) {
                System.err.println(m);
            } else {
                e.printStackTrace(System.err);
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                System.err.println(m);
            }
            Exception se = e;
            if (e instanceof SAXException) {
                se = ((SAXException)e).getException();
            }
            if (se != null) {
                se.printStackTrace(System.err);
            }
            e.printStackTrace(System.err);
        }
        MapEntry nsme = this.namespace("gml");
        if (nsme == null) {
            System.err.println("The namespace with abbreviation 'gml' must be specified in the configuration file.");
            throw new ShapeChangeAbortException();
        }
        this.GML_NS = nsme.rule;
    }

    public String normalizeStereotype(String stereotype) {
        String s = this.stereotypeAlias(stereotype.trim());
        if (s != null) {
            return s;
        }
        return stereotype;
    }

    public Options() {
        this.setParameter("reportLevel", "WARNING");
        this.setParameter("appSchemaName", "");
        this.setParameter("publicOnly", "true");
        this.setParameter("inputFile", "./fixme.xml");
        this.setParameter("inputModelType", "XMI10");
        this.setParameter("logFile", "./ShapeChangeResult.xml");
        this.setParameter("representTaggedValues", "");
        this.setParameter("outputDirectory", ".");
        this.setParameter(TargetXmlSchemaClass, "defaultEncodingRule", ISO19136_2007_SHAPECHANGE_1_0);
        this.setParameter(TargetXmlSchemaClass, "gmlVersion", "3.2");
    }
}

