/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model;

import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.InfoImpl;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import java.util.HashSet;
import java.util.Iterator;

public abstract class ClassInfoImpl
extends InfoImpl
implements ClassInfo {
    protected int category = -1;
    protected int processed = 0;
    protected boolean processedRestrictions = false;

    public String nsabr() {
        PackageInfo pi = this.pkg();
        if (pi != null) {
            return pi.xmlns();
        }
        return null;
    }

    public String ns() {
        PackageInfo pi = this.pkg();
        if (pi != null) {
            return pi.targetNamespace();
        }
        return null;
    }

    public String encodingRule(String platform) {
        PackageInfo pi;
        String s = this.taggedValue(String.valueOf(platform) + "EncodingRule");
        if (s == null && (s = (pi = this.pkg()) != null ? pi.encodingRule(platform) : this.options().parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "defaultEncodingRule")) == null) {
            s = "iso19136_2007";
        }
        return s;
    }

    public String xmlSchemaType() {
        return this.taggedValue("xmlSchemaType");
    }

    public boolean includeByValuePropertyType() {
        String s = this.taggedValue("byValuePropertyType");
        return s != null && s.toLowerCase().equals("true");
    }

    public boolean includePropertyType() {
        String s = this.taggedValue("noPropertyType");
        return s == null || !s.toLowerCase().equals("true");
    }

    public boolean isCollection() {
        String s = this.taggedValue("isCollection");
        return s != null && s.toLowerCase().equals("true");
    }

    public boolean asDictionary() {
        String s = this.taggedValue("asDictionary");
        return s != null && s.toLowerCase().equals("true");
    }

    public boolean asGroup() {
        String s = this.taggedValue("gmlAsGroup");
        return s != null && s.toLowerCase().equals("true");
    }

    public boolean noGMLType() {
        String s = this.taggedValue("noGMLType");
        if (s != null && s.toLowerCase().equals("true")) {
            return true;
        }
        if (s != null && s.toLowerCase().equals("false")) {
            return false;
        }
        return this.options().parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "noGMLtypeDefault").equals("true");
    }

    public void establishCategory() throws ShapeChangeAbortException {
        String s = this.stereotype().toLowerCase();
        if (s.equals("enumeration")) {
            this.category = 3;
        } else if (s.equals("codelist")) {
            this.category = 2;
        } else if (s.equals("datatype")) {
            this.category = 5;
        } else if (s.equals("union")) {
            this.category = 8;
        } else if (s.equals("interface")) {
            this.category = 4;
        } else if (s.equals("basictype")) {
            this.category = 7;
        } else if (s.equals("featuretype")) {
            this.category = 1;
        } else if (s.equals("objecttype") || s.equals("")) {
            this.category = 6;
        } else {
            if (!s.equals("type")) {
                this.result().addFatalError(11, this.name(), this.stereotype());
                throw new ShapeChangeAbortException();
            }
            this.category = this.isAbstract() ? 4 : 6;
        }
    }

    public int category() {
        return this.category;
    }

    public void category(int c) {
        this.category = c;
    }

    public void fixIfCategoryIsUnknown() {
        if (this.category() == -1 && this.supertypes() != null) {
            if (this.isAbstract() && this.checkSupertypes(4)) {
                this.category(4);
                this.result().addDebug(10003, this.name(), "4", "--TRUE--");
            } else if (this.checkSupertypes(6)) {
                this.category(6);
                this.result().addDebug(10003, this.name(), "6", "--TRUE--");
            } else if (this.checkSupertypes(1)) {
                this.category(1);
            } else if (this.checkSupertypes(5)) {
                this.category(5);
            } else {
                this.result().addWarning(104, this.name());
            }
        }
    }

    public void identifyBasicTypes() {
        if ((this.category == 5 || this.category == 6 || this.category == 4) && this.checkForBasicType(this.encodingRule("xsd"))) {
            this.category = 7;
            this.result().addDebug(String.valueOf(this.qname()) + " (" + this.category + ") is a basic type.");
        }
    }

    public boolean inSchema(PackageInfo pi) {
        String ns1 = null;
        String ns2 = null;
        PackageInfo pi2 = this.pkg();
        if (pi2 != null) {
            ns1 = pi2.targetNamespace();
        }
        if (pi != null) {
            ns2 = pi.targetNamespace();
        }
        if (ns1 == null || ns2 == null) {
            return false;
        }
        return ns1.equals(ns2);
    }

    public String qname() {
        PackageInfo pi = this.pkg();
        if (pi != null) {
            return String.valueOf(pi.xmlns()) + ":" + this.name();
        }
        return this.name();
    }

    public boolean processed(int t) {
        return (this.processed & t) == t;
    }

    public void processed(int t, boolean p) {
        this.processed = p ? (this.processed |= t) : (this.processed &= ~t);
    }

    public boolean checkSupertypes(int cat) {
        HashSet<String> ts = this.supertypes();
        if (ts == null) {
            this.result().addDebug(10003, this.name(), "" + cat, "TRUE");
            return true;
        }
        boolean res = true;
        Iterator<String> i = ts.iterator();
        while (i.hasNext()) {
            ClassInfo cix = this.model().classById(i.next());
            if (cix == null) continue;
            if (cix.category() == -1) {
                res = res && cix.checkSupertypes(cat);
            } else if (cix.category() != 4 && cix.category() != cat) {
                res = false;
            }
            if (res) continue;
            this.result().addDebug(10003, this.name(), "" + cat, "FALSE");
            return res;
        }
        if (res) {
            this.result().addDebug(10003, this.name(), "" + cat, "TRUE");
        } else {
            this.result().addDebug(10003, this.name(), "" + cat, "FALSE");
        }
        return res;
    }

    public boolean checkForBasicType(String rule) {
        if (this.category() == 7) {
            return true;
        }
        MapEntry me = this.options().baseMapEntry(this.name(), rule);
        if (me != null && !me.p2.equals("complex/complex")) {
            this.category(7);
            return true;
        }
        HashSet<String> ts = this.supertypes();
        if (ts == null) {
            return false;
        }
        Iterator<String> i = ts.iterator();
        while (i.hasNext()) {
            ClassInfo cix = this.model().classById(i.next());
            if (cix == null || !cix.checkForBasicType(rule)) continue;
            this.category(7);
            return true;
        }
        return false;
    }

    protected void checkOverloading(ClassInfo cicurr) {
        HashSet<String> st;
        if (cicurr == null) {
            return;
        }
        this.result().addDebug(10004, this.name(), cicurr.name());
        if (cicurr != this && (cicurr.category() == 1 || cicurr.category() == 6 || cicurr.category() == 4 || cicurr.category() == 5 || cicurr.category() == 8 && !cicurr.asGroup())) {
            for (PropertyInfo aicurr : cicurr.properties().values()) {
                for (PropertyInfo ai : this.properties().values()) {
                    if (aicurr == null || ai == null || !ai.name().equals(aicurr.name())) continue;
                    if (ai.cardinality().minOccurs < aicurr.cardinality().minOccurs) {
                        this.result().addError(105, ai.name(), this.name(), cicurr.name());
                    }
                    if (ai.cardinality().maxOccurs > aicurr.cardinality().maxOccurs) {
                        this.result().addError(106, ai.name(), this.name(), cicurr.name());
                    }
                    ai.restriction(true);
                    this.result().addInfo(1002, ai.name(), this.name(), cicurr.name());
                }
            }
        }
        if ((st = cicurr.supertypes()) != null) {
            Iterator<String> i = st.iterator();
            while (i.hasNext()) {
                this.checkOverloading(this.model().classById(i.next()));
            }
        }
    }

    public void identifyRestrictions() {
        if (this.processedRestrictions) {
            return;
        }
        if (this.category() == 1 || this.category() == 6 || this.category() == 5 || this.category() == 8 && !this.asGroup()) {
            this.checkOverloading(this);
        }
        this.processedRestrictions = true;
    }
}

