<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- Profilkennung -->
		<xsl:variable name="p1" select="//adv:profilkennung"/>
		<!-- Antragsnummer: nicht optional -->
		<xsl:variable name="p2" select="//adv:antragsnummer"/>
		<!-- Koordinatenreferenzsystem: optional -->
		<xsl:variable name="p4" select="//adv:koordinatenreferenzsystem"/>
		<!-- Punktart: nicht optional -->
		<xsl:variable name="filter" select="//ogc:Filter"/> 		
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art><xsl:value-of select="//adv:art"/></art>
			<xsl:if test="count($p4)=1">
				<koordinatenreferenzsystem>
					<xsl:value-of select="$p4"/>
				</koordinatenreferenzsystem>
			</xsl:if>
			<anforderungsmerkmale>
				<!-- Vergl. Punktkennungen selektieren über Punktart und Antragsnummer -->
				<wfs:Query typeName="AX_PunktkennungVergleichend">		
					<ogc:Filter>
						<ogc:And>
							<!-- Filter aus node set ohne Root <ogc:Filter> -->
							<xsl:copy-of select="$filter/*"/>
							<!-- endgueltige Punktkennung muss definiert sein -->
							<ogc:Not>
								<ogc:PropertyIsNull>
									<ogc:PropertyName>endgueltigePunktkennung</ogc:PropertyName>
								</ogc:PropertyIsNull>
							</ogc:Not>
							<ogc:PropertyIsNull>
								<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
							</ogc:PropertyIsNull>
						</ogc:And>
					</ogc:Filter>					
				</wfs:Query>
				<!-- Besorge ausserdem alle Bundesländer, Gemeinden und Katasterämter mit deren Anschrift
					 zur Befüllung des AX_K_AUSGKOPF_Standard. Am einfachsten kann hier der Kopf dadurch gefüllt werden, 
					 indem der erzeugenden Komponente entsprechende Informationen hinterlegt werden.
				     Hinweis: Dies ist natürlich keine realistische Vorgehensweise bei Produktionsdatenbeständen. 
					 Das Ziel dieser Dokumentation liegt in der Beschreibung der formalen Regeln bei der Ableitung
				     der Standardausgaben - nicht in der Vorgabe einer algorithmischen Umsetzung dieser. -->
				<wfs:Query typeName="AX_Gemeinde"/>
				<wfs:Query typeName="AX_Bundesland"/>
				<wfs:Query typeName="AX_Dienststelle">
					<XlinkPropertyPath>hat/AX_Anschrift</XlinkPropertyPath>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>stellenart</ogc:PropertyName>
							<ogc:Literal>1100</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</wfs:Query>
			</anforderungsmerkmale>
			<profilkennung>
				<xsl:value-of select="$p1"/>
			</profilkennung>
			<antragsnummer>
				<xsl:value-of select="$p2"/>
			</antragsnummer>
			<folgeverarbeitung>
				<AX_FOLGEVA>
					<datenformat>1000</datenformat>
				</AX_FOLGEVA>
			</folgeverarbeitung>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
