<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
	xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" 	
	xmlns:gml="http://www.opengis.net/gml/3.2" 
	xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" 
	xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" 
	xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="p1" select="//adv:profilkennung"/>
		<xsl:variable name="p2" select="//adv:antragsnummer"/>
		<xsl:variable name="p3" select="//ogc:Literal"/>
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
				<wfs:Query typeName="AX_Flurstueck">
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>flurstueckskennzeichen</ogc:PropertyName>
							<ogc:Literal><xsl:value-of select="$p3"/></ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</wfs:Query>
				<!-- Besorge ausserdem die Gemarkung des angeforderten Flurstücks und Katasterämter mit deren Anschrift. -->
				<!-- Implementierungen sollten ggf. Zwischenschritte zur Optimierung bilden, wenn ansonsten die Menge der benutzten Objekte (hier z.B. AX_Dienststelle) ausufert. -->
				<wfs:Query typeName="AX_Gemarkung">
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>schluesselGesamt</ogc:PropertyName>
							<ogc:Literal><xsl:value-of select="substring($p3,1,6)"/></ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Dienststelle">
					<XlinkPropertyPath>hat</XlinkPropertyPath>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>stellenart</ogc:PropertyName>
							<ogc:Literal>1100</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</wfs:Query>
			</anforderungsmerkmale>
		        <profilkennung><xsl:value-of select="$p1"/></profilkennung>
			<antragsnummer><xsl:value-of select="$p2"/></antragsnummer>			
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
