<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0"
		xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc"
		xmlns:gml="http://www.opengis.net/gml/3.2">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="p1" select="//adv:profilkennung"/>
		<xsl:variable name="p2" select="//adv:antragsnummer"/>
		<xsl:choose>
		<xsl:when test="//adv:art='0600'"><!-- Grundstücksnachweis hat zwei Einstiegsparameter. 20.12.2007 -->
		<xsl:variable name="p3" select="//wfs:Query[@typeName='AX_Buchungsblatt']/ogc:Filter/ogc:PropertyIsEqualTo/ogc:Literal"/><!-- 20.12.2007 Gezielte Belegung von $p3 ist durch mehrere ogc:Literal notwendig! -->
		</xsl:when>
		<xsl:otherwise>
		<xsl:variable name="p3" select="//ogc:literal"/>
		</xsl:otherwise>
		</xsl:choose>		
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
				<wfs:Query typeName="AX_Flurstueck">
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>istGebucht/AX_Buchungsstelle/istBestandteilVon/AX_Buchungsblatt/buchungsblattkennzeichen</ogc:PropertyName>
							<ogc:Literal>
								<xsl:value-of select="$p3"/>
							</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</wfs:Query>
				<!-- Besorge ausserdem alle Objekte der weiteren Objektarten. Hinweis: Dies ist natürlich keine realistische Vorgehensweise
				bei Produktionsdatenbeständen. Das Ziel dieser Dokumentation liegt in der Beschreibung der formalen Regeln bei der Ableitung
				der Standardausgaben - nicht in der Vorgabe einer algorithmischen Umsetzung dieser. -->
				<wfs:Query typeName="AX_Gemarkung"/>
				<wfs:Query typeName="AX_Dienststelle"/>
				<wfs:Query typeName="AX_Gemeinde"/>
				<wfs:Query typeName="AX_KreisRegion"/>
				<wfs:Query typeName="AX_Regierungsbezirk"/>
				<wfs:Query typeName="AX_KommunalesGebiet"/>
				<wfs:Query typeName="AX_LagebezeichnungOhneHausnummer"/>
				<wfs:Query typeName="AX_LagebezeichnungMitHausnummer"/>
				<wfs:Query typeName="AX_LagebezeichnungKatalogeintrag"/>
			</anforderungsmerkmale>
			<profilkennung>
				<xsl:value-of select="$p1"/>
			</profilkennung>
			<antragsnummer>
				<xsl:value-of select="$p2"/>
			</antragsnummer>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
