/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ProcessMode;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessConfiguration {
    private String className;
    private ProcessMode processMode = ProcessMode.ENABLED;
    Map<String, String> parameters = null;
    Map<String, ProcessRuleSet> ruleSets = null;
    Map<String, ProcessMapEntry> mapEntries = null;

    public ProcessConfiguration(String className, ProcessMode processMode, Map<String, String> parameters, Map<String, ProcessRuleSet> ruleSets, Map<String, ProcessMapEntry> mapEntries) {
        this.className = className;
        this.processMode = processMode;
        this.parameters = parameters;
        this.ruleSets = ruleSets;
        this.mapEntries = mapEntries;
    }

    public String getClassName() {
        return this.className;
    }

    public ProcessMode getProcessMode() {
        return this.processMode;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getParameterValue(String parameterName) {
        return this.parameters.get(parameterName);
    }

    public String[] getListParameterValue(String parameterName) {
        String p = this.parameters.get(parameterName);
        if (p == null) {
            return null;
        }
        String[] values = p.split(",");
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
        }
        return values;
    }

    public Map<String, ProcessRuleSet> getRuleSets() {
        return this.ruleSets;
    }

    public Map<String, ProcessMapEntry> getMapEntries() {
        return this.mapEntries;
    }

    public boolean hasMappingForType(String typeName) {
        if (this.mapEntries == null) {
            return false;
        }
        return this.mapEntries.containsKey(typeName);
    }

    public boolean hasParameter(String paramName) {
        if (paramName == null || paramName.trim().length() == 0) {
            return false;
        }
        return this.parameters.containsKey(paramName.trim());
    }

    public ProcessMapEntry getMappingForType(String typeName) {
        if (this.mapEntries == null) {
            return null;
        }
        return this.mapEntries.get(typeName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ProcessConfiguration:\r\n");
        sb.append("\tclass name: " + this.className + "\r\n");
        sb.append("\tprocess mode " + (Object)((Object)this.processMode) + "\r\n");
        sb.append("\tparameters: ");
        if (this.parameters == null || this.parameters.isEmpty()) {
            sb.append("none\r\n");
        } else {
            sb.append("\r\n");
            for (String key : this.parameters.keySet()) {
                sb.append("\t\t(" + key + " | " + this.parameters.get(key) + ")\r\n");
            }
        }
        sb.append("\trule sets: ");
        if (this.ruleSets == null || this.ruleSets.isEmpty()) {
            sb.append("none\r\n");
        } else {
            sb.append("\r\n");
            for (String key : this.ruleSets.keySet()) {
                String ext = this.ruleSets.get(key).getExtendedRuleSetName();
                if (ext == null) {
                    ext = "<none>";
                }
                sb.append("\t\t(name: " + this.ruleSets.get(key).getName() + " | extends: " + ext + " | rules: ");
                Set<String> rules = this.ruleSets.get(key).getAdditionalRules();
                if (rules == null || rules.isEmpty()) {
                    sb.append("<none>");
                } else {
                    Iterator<String> rulesIterator = rules.iterator();
                    sb.append(rulesIterator.next());
                    while (rulesIterator.hasNext()) {
                        sb.append("," + rulesIterator.next());
                    }
                }
                sb.append(")\r\n");
            }
        }
        sb.append("\tmap entries: ");
        if (this.mapEntries == null || this.mapEntries.isEmpty()) {
            sb.append("none\r\n");
        } else {
            sb.append("\r\n");
            for (ProcessMapEntry mapEntry : this.mapEntries.values()) {
                sb.append("\t\tmap entry:\r\n");
                sb.append("\t\t\ttype: '" + mapEntry.getType() + "'\r\n");
                sb.append("\t\t\trule: '" + mapEntry.getRule() + "'\r\n");
                if (mapEntry.getTargetType() == null) {
                    sb.append("\t\t\ttargetType: <none>\r\n");
                } else {
                    sb.append("\t\t\ttargetType: '" + mapEntry.getTargetType() + "'\r\n");
                }
                if (mapEntry.getParam() == null) {
                    sb.append("\t\t\tparam: <none>\r\n");
                    continue;
                }
                sb.append("\t\t\tparam: '" + mapEntry.getParam() + "'\r\n");
            }
        }
        return sb.toString();
    }
}

