/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMode;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.SingleTarget;
import de.interactive_instruments.ShapeChange.Target.Target;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import de.interactive_instruments.ShapeChange.UI.StatusBoard;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.xml.sax.SAXException;

public class Converter {
    public static final int STATUS_TARGET_INITSTART = 201;
    public static final int STATUS_TARGET_PROCESS = 202;
    public static final int STATUS_TARGET_WRITE = 203;
    protected ShapeChangeResult result = null;
    protected Options options = null;
    protected Target target = null;

    public Converter(Options o, ShapeChangeResult r) {
        this.options = o;
        this.result = r;
        this.target = null;
    }

    public void convert() throws ShapeChangeAbortException {
        Model m = this.getModel();
        this.convert(m);
        if (m != null) {
            m.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(Model model) {
        try {
            if (model == null) {
                this.result.addFatalError(null, 14);
                throw new ShapeChangeAbortException();
            }
            model.postprocessAfterLoadingAndValidate();
            List<TransformerConfiguration> transformers = this.options.getTransformerConfigurations();
            Model transformerInput = model;
            Model transformerOutput = model;
            if (transformers != null) {
                for (TransformerConfiguration trfConfig : transformers) {
                    Class<?> theClass;
                    Transformer transformer;
                    if (trfConfig.getProcessMode() == ProcessMode.DISABLED || (transformer = (Transformer)(theClass = Class.forName(trfConfig.getClassName())).newInstance()) == null) continue;
                    transformerInput = transformerOutput = transformer.process(transformerInput, this.options, trfConfig, this.result);
                }
            }
            model = transformerOutput;
            this.resetSingleTargets();
            String appSchemaName = this.options.parameter("appSchemaName");
            PackageInfo[] schemaArr = this.schemas(model, appSchemaName);
            for (int pidx = 0; pidx < schemaArr.length; ++pidx) {
                PackageInfo pi = schemaArr[pidx];
                if (pi == null || this.options.skipSchema(null, pi)) continue;
                String name = pi.name();
                String ns = pi.targetNamespace();
                this.result.addInfo(null, 1012, name, ns);
                Vector<String> targets = this.options.targets();
                for (String classname : targets) {
                    String tmode = this.options.targetMode(classname);
                    if (tmode.equals("disabled")) continue;
                    Class<?> theClass = Class.forName(classname);
                    this.target = (Target)theClass.newInstance();
                    if (this.target == null || this.options.skipSchema(this.target, pi)) continue;
                    StatusBoard.getStatusBoard().statusChanged(201);
                    this.target.initialise(pi, model, this.options, this.result, tmode.equals("diagnostics-only"));
                    StatusBoard.getStatusBoard().statusChanged(202);
                    ClassInfo[] classArr = this.classes(model, pi);
                    for (int cidx = 0; cidx < classArr.length; ++cidx) {
                        ClassInfo k = classArr[cidx];
                        this.target.process(k);
                    }
                    StatusBoard.getStatusBoard().statusChanged(203);
                    this.target.write();
                    StatusBoard.getStatusBoard().statusChanged(0);
                }
                this.target = null;
            }
            Vector<String> targets = this.options.targets();
            for (String classname : targets) {
                String tmode;
                SingleTarget starget;
                Class<?> theClass = Class.forName(classname);
                boolean isSingleTarget = false;
                for (Class<?> intfc : theClass.getInterfaces()) {
                    String in = intfc.getName();
                    if (!in.equals("de.interactive_instruments.ShapeChange.Target.SingleTarget")) continue;
                    isSingleTarget = true;
                    break;
                }
                if (!isSingleTarget || (starget = (SingleTarget)theClass.newInstance()) == null || (tmode = this.options.targetMode(classname)).equals("disabled")) continue;
                starget.writeAll(this.result);
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            Exception se = e;
            if (e instanceof SAXException) {
                se = ((SAXException)e).getException();
            }
            if (se != null) {
                se.printStackTrace(System.err);
            } else {
                e.printStackTrace(System.err);
            }
        }
        finally {
            this.result.toFile(this.options.parameter("logFile"));
            this.target = null;
        }
    }

    private ClassInfo[] classes(Model model, PackageInfo pi) throws NoSuchMethodException, SecurityException {
        HashSet<ClassInfo> classes = model.classes(pi);
        String sortedOpt = this.options.parameter(this.target.getClass().getName(), "sortedOutput");
        if (sortedOpt == null) {
            sortedOpt = this.options.parameter("sortedOutput");
        }
        ClassInfo[] classArr = new ClassInfo[classes.size()];
        classes.toArray(classArr);
        if (sortedOpt != null && !"false".equalsIgnoreCase(sortedOpt)) {
            String compField;
            Class[] paramTypes = null;
            Object[] pargs = null;
            if ("true".equalsIgnoreCase(sortedOpt)) {
                compField = "name";
            } else if (sortedOpt.startsWith("taggedValue=")) {
                compField = "taggedValue";
                String parg = sortedOpt.split("=")[1];
                paramTypes = new Class[]{String.class};
                pargs = new Object[]{parg};
            } else {
                compField = sortedOpt;
            }
            try {
                ClassInfo.class.getMethod(compField, paramTypes);
            }
            catch (NoSuchMethodException e) {
                this.result.addError(null, 165, sortedOpt, this.target.getClass().getName());
                return classArr;
            }
            final Method compMeth = ClassInfo.class.getMethod(compField, paramTypes);
            final Object[] compMethArgs = pargs;
            Arrays.sort(classArr, new Comparator<ClassInfo>(){

                @Override
                public int compare(ClassInfo ci1, ClassInfo ci2) {
                    try {
                        if (compMeth.getName().equals("taggedValue")) {
                            String s1 = ci1.taggedValue((String)compMethArgs[0]);
                            String s2 = ci2.taggedValue((String)compMethArgs[0]);
                            if (s1 == null) {
                                s1 = ci1.name();
                            }
                            if (s2 == null) {
                                s2 = ci2.name();
                            }
                            return s1.compareTo(s2);
                        }
                        return ((String)compMeth.invoke((Object)ci1, new Object[0])).compareTo((String)compMeth.invoke((Object)ci2, new Object[0]));
                    }
                    catch (Exception e) {
                        String m = e.getMessage();
                        if (m != null) {
                            Converter.this.result.addError(m);
                        }
                        return 0;
                    }
                }
            });
        }
        return classArr;
    }

    private PackageInfo[] schemas(Model model, String appSchemaName) throws ShapeChangeAbortException {
        HashSet<PackageInfo> schemas = model.schemas(appSchemaName);
        if (schemas.isEmpty()) {
            if (appSchemaName.equals("")) {
                this.result.addFatalError(null, 12);
            } else {
                this.result.addFatalError(null, 13, appSchemaName);
            }
            throw new ShapeChangeAbortException();
        }
        PackageInfo[] schemaArr = new PackageInfo[schemas.size()];
        schemas.toArray(schemaArr);
        if (this.options.sortedSchemaOutput || "true".equalsIgnoreCase(this.options.parameter("sortedSchemaOutput"))) {
            Arrays.sort(schemaArr, new Comparator<PackageInfo>(){

                @Override
                public int compare(PackageInfo pi1, PackageInfo pi2) {
                    return pi1.name().compareTo(pi2.name());
                }
            });
        }
        return schemaArr;
    }

    private void resetSingleTargets() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Vector<String> targets = this.options.targets();
        for (String classname : targets) {
            SingleTarget starget;
            String tmode;
            Class<?> theClass = Class.forName(classname);
            this.target = (Target)theClass.newInstance();
            if (this.target == null || (tmode = this.options.targetMode(classname)).equals("disabled")) continue;
            boolean isSingleTarget = false;
            for (Class<?> intfc : theClass.getInterfaces()) {
                String in = intfc.getName();
                if (!in.equals("de.interactive_instruments.ShapeChange.Target.SingleTarget")) continue;
                isSingleTarget = true;
                break;
            }
            if (!isSingleTarget || (starget = (SingleTarget)theClass.newInstance()) == null) continue;
            starget.reset();
        }
    }

    public int getCurrentTargetID() {
        if (this.target == null) {
            return 0;
        }
        return this.target.getTargetID();
    }

    private Model getModel() throws ShapeChangeAbortException {
        Class<?> theClass;
        String transformer;
        String imt = this.options.parameter("inputModelType");
        String mdl = this.options.parameter("inputFile");
        if (imt.equalsIgnoreCase("ea7")) {
            imt = "de.interactive_instruments.ShapeChange.Model.EA.EADocument";
        } else if (imt.equalsIgnoreCase("xmi10")) {
            imt = "de.interactive_instruments.ShapeChange.Model.Xmi10.Xmi10Document";
        } else if (imt.equalsIgnoreCase("gsip")) {
            imt = "us.mitre.ShapeChange.Model.GSIP.GSIPDocument";
        }
        if (imt.equals("de.interactive_instruments.ShapeChange.Model.EA.EADocument") && (transformer = this.options.parameter("transformer")) != null && transformer.length() > 0) {
            try {
                theClass = Class.forName(transformer);
                de.interactive_instruments.ShapeChange.Model.Transformer t = (de.interactive_instruments.ShapeChange.Model.Transformer)theClass.newInstance();
                t.initialise(this.options, this.result, mdl);
                t.transform();
                t.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ShapeChangeAbortException();
            }
        }
        Model m = null;
        try {
            theClass = Class.forName(imt);
            if (theClass == null) {
                this.result.addFatalError(null, 17, imt);
                throw new ShapeChangeAbortException();
            }
            m = (Model)theClass.newInstance();
            if (m == null) {
                this.result.addFatalError(null, 17, imt);
                throw new ShapeChangeAbortException();
            }
            m.initialise(this.result, this.options, mdl);
        }
        catch (ClassNotFoundException e) {
            this.result.addFatalError(null, 17, imt);
            throw new ShapeChangeAbortException();
        }
        catch (InstantiationException e) {
            this.result.addFatalError(null, 19, imt);
            throw new ShapeChangeAbortException();
        }
        catch (IllegalAccessException e) {
            this.result.addFatalError(null, 20, imt);
            throw new ShapeChangeAbortException();
        }
        return m;
    }
}

