/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Ocl;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Ocl.MessageCollection;
import de.interactive_instruments.ShapeChange.Ocl.OclNode;
import de.interactive_instruments.ShapeChange.Ocl.SourceReference;
import de.interactive_instruments.ShapeChange.Ocl.TempParser;
import de.interactive_instruments.ShapeChange.Ocl.Token;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedList;

public abstract class TempNode {
    protected SourceReference[] sourceReferences = null;

    SourceReference[] getSourceReferences() {
        return this.sourceReferences;
    }

    void addSourceReference(SourceReference sourceRef) {
        if (this.sourceReferences == null) {
            this.sourceReferences = new SourceReference[1];
            this.sourceReferences[0] = sourceRef;
        } else {
            this.sourceReferences = sourceRef.merge(this.sourceReferences, true);
        }
    }

    void addSourceReference(Token token) {
        SourceReference sr = token.getSourceReference();
        if (sr != null) {
            this.addSourceReference(sr);
        }
    }

    void addSourceReference(TempNode tn) {
        if (tn.sourceReferences == null) {
            return;
        }
        if (this.sourceReferences == null) {
            this.sourceReferences = new SourceReference[0];
        }
        this.sourceReferences = SourceReference.merge(this.sourceReferences, tn.sourceReferences, true);
    }

    abstract void debugPrint(PrintWriter var1);

    abstract OclNode connectToModel(TempParser var1, Model var2, OclNode.Declaration var3);

    static class Arguments
    extends TempNode {
        TempNode[] declarations;
        TempNode[] expressions;

        Arguments(TempNode[] declarations, TempNode[] expressions) {
            int i;
            this.declarations = declarations;
            this.expressions = expressions;
            if (declarations != null) {
                i = 0;
                while (i < declarations.length) {
                    this.addSourceReference(declarations[i]);
                    ++i;
                }
            }
            if (expressions != null) {
                i = 0;
                while (i < expressions.length) {
                    this.addSourceReference(expressions[i]);
                    ++i;
                }
            }
        }

        OclNode connectToModel(TempParser p, Model model, OclNode.Declaration varctx) {
            return null;
        }

        void debugPrint(PrintWriter stream) {
            int i;
            stream.print("(");
            if (this.declarations != null && this.declarations.length > 0) {
                i = 0;
                while (i < this.declarations.length) {
                    if (i > 0) {
                        stream.print(",");
                    }
                    this.declarations[i].debugPrint(stream);
                    ++i;
                }
                stream.print("|");
            }
            i = 0;
            while (i < this.expressions.length) {
                if (i > 0) {
                    stream.print(",");
                }
                this.expressions[i].debugPrint(stream);
                ++i;
            }
            stream.print(")");
        }
    }

    static class CurrentDateTime {
        CurrentDateTime() {
        }

        public String toString() {
            return "CurrentDateTime";
        }
    }

    static class DateTime
    extends GregorianCalendar {
        DateTime() {
        }

        public String toString() {
            return this.getTime().toString();
        }
    }

    static class Declaration
    extends TempNode {
        String name;
        TempNode typename;
        TempNode initializer;

        Declaration(String name, TempNode typename, TempNode initializer) {
            this.name = name;
            this.typename = typename;
            this.initializer = initializer;
            if (typename != null) {
                this.addSourceReference(typename);
            }
            if (initializer != null) {
                this.addSourceReference(initializer);
            }
        }

        OclNode connectToModelWithType(TempParser p, Model model, OclNode.Declaration varctx, OclNode.DataType type) {
            return null;
        }

        OclNode connectToModel(TempParser p, Model model, OclNode.Declaration varctx) {
            return null;
        }

        void debugPrint(PrintWriter stream) {
            stream.print("Declare[");
            stream.print(this.name);
            if (this.typename != null) {
                stream.print(":");
                this.typename.debugPrint(stream);
            }
            if (this.initializer != null) {
                stream.print("=");
                this.initializer.debugPrint(stream);
            }
            stream.print("]");
        }
    }

    public static class Expression
    extends TempNode {
        Token.Type expressionType;
        String expressionName;
        TempNode expression;

        Expression(Token.Type type, String name, TempNode expr) {
            this.expressionType = type;
            this.expressionName = name;
            this.expression = expr;
        }

        OclNode connectToModel(TempParser p, Model model, OclNode.Declaration varctx) {
            return null;
        }

        public void debugPrint(PrintWriter stream) {
            String opsym = Token.getLexicalStringFromType(this.expressionType);
            stream.print(opsym);
            stream.print(": ");
            if (this.expressionName != null) {
                stream.print(this.expressionName);
                stream.print(" ");
            }
            this.expression.debugPrint(stream);
        }
    }

    static class Identifier
    extends TempNode {
        String name;
        TempNode qualification;

        Identifier(TempNode qualification, String name) {
            this.name = name;
            this.qualification = qualification;
            if (qualification != null) {
                this.addSourceReference(qualification);
            }
        }

        String name() {
            String scope = "";
            if (this.qualification != null && this.qualification instanceof Identifier) {
                scope = String.valueOf(((Identifier)this.qualification).name()) + "::";
            }
            return String.valueOf(scope) + this.name;
        }

        boolean isSimpleName() {
            return this.qualification == null;
        }

        ClassInfo classFromQualification(TempParser p, Model model, boolean quiet) {
            if (this.qualification == null) {
                return null;
            }
            if (this.qualification instanceof Identifier) {
                Identifier qualid = (Identifier)this.qualification;
                OclNode cls = qualid.connectAsClassOrPackage(p, model, 1, quiet);
                if (cls == null || !(cls instanceof OclNode.ClassLiteralExp)) {
                    return null;
                }
                return ((OclNode.ClassLiteralExp)cls).umlClass;
            }
            MessageCollection messageCollection = p.getMessageCollection();
            messageCollection.getClass();
            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
            mess.substitute(1, "Qualifier is non-Identifier token.");
            mess.addSourceReferences(this.sourceReferences);
            return null;
        }

        OclNode connectToModel(TempParser p, Model model, OclNode.Declaration varctx) {
            int cat;
            Identifier qual;
            ClassInfo ci;
            if (this.qualification != null && this.qualification instanceof Identifier && (ci = (qual = (Identifier)this.qualification).classFromQualification(p, model, true)) != null && ((cat = ci.category()) == 3 || cat == 2)) {
                PropertyInfo pi = ci.property(this.name);
                if (pi != null) {
                    return new OclNode.EnumerationLiteralExp(pi);
                }
                MessageCollection messageCollection = p.getMessageCollection();
                messageCollection.getClass();
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(33);
                mess.substitute(1, this.name);
                mess.substitute(2, ci.name());
                mess.addSourceReferences(this.sourceReferences);
                return null;
            }
            OclNode ret = this.connectAsClassOrPackage(p, model, 1, false);
            return ret;
        }

        OclNode connectAsClassOrPackage(TempParser p, Model model, int level, boolean quiet) {
            Identifier qual = null;
            OclNode qctx = null;
            if (this.qualification != null) {
                if (this.qualification instanceof Identifier) {
                    qual = (Identifier)this.qualification;
                    qctx = qual.connectAsClassOrPackage(p, model, level + 1, quiet);
                    if (qctx == null) {
                        return null;
                    }
                } else {
                    MessageCollection messageCollection = p.getMessageCollection();
                    messageCollection.getClass();
                    MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
                    mess.substitute(1, "Qualifier is non-Identifier token.");
                    mess.addSourceReferences(this.sourceReferences);
                    return null;
                }
            }
            if (level == 1) {
                ClassInfo ci = null;
                if (qctx == null) {
                    ci = model.classByName(this.name);
                    if (ci == null && !quiet) {
                        MessageCollection messageCollection = p.getMessageCollection();
                        messageCollection.getClass();
                        MessageCollection.Message mess = messageCollection.new MessageCollection.Message(21);
                        mess.substitute(1, this.name);
                        mess.addSourceReferences(this.sourceReferences);
                    }
                } else {
                    OclNode.PackageLiteralExp plit = (OclNode.PackageLiteralExp)qctx;
                    PackageInfo pi = plit.getPackage();
                    HashSet<ClassInfo> cls = model.classes(pi);
                    for (ClassInfo c : cls) {
                        if (!c.name().equals(this.name)) continue;
                        ci = c;
                        break;
                    }
                    if (ci == null || ci.pkg() != pi) {
                        if (!quiet) {
                            MessageCollection messageCollection = p.getMessageCollection();
                            messageCollection.getClass();
                            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(22);
                            mess.substitute(1, this.name);
                            mess.substitute(2, pi.name());
                            mess.addSourceReferences(this.sourceReferences);
                        }
                        ci = null;
                    }
                }
                if (ci != null) {
                    return new OclNode.ClassLiteralExp(ci);
                }
                return null;
            }
            PackageInfo pi = null;
            if (qctx == null) {
                HashSet<PackageInfo> pckseed = model.schemas(null);
                LinkedList<PackageInfo> eval = new LinkedList<PackageInfo>();
                for (PackageInfo pck : pckseed) {
                    eval.add(pck);
                }
                for (PackageInfo cpi : eval) {
                    if (cpi.name().equals(this.name)) {
                        pi = cpi;
                        break;
                    }
                    try {
                        HashSet<PackageInfo> npis = cpi.containedPackages();
                        for (PackageInfo npi : npis) {
                            eval.add(npi);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (pi == null && !quiet) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    messageCollection.getClass();
                    MessageCollection.Message mess = messageCollection.new MessageCollection.Message(23);
                    mess.substitute(1, this.name);
                    mess.addSourceReferences(this.sourceReferences);
                }
            } else {
                OclNode.PackageLiteralExp plit = (OclNode.PackageLiteralExp)qctx;
                PackageInfo pi2 = plit.getPackage();
                try {
                    HashSet<PackageInfo> pks = pi2.containedPackages();
                    for (PackageInfo pk : pks) {
                        if (!pk.name().equals(this.name)) continue;
                        pi = pk;
                        break;
                    }
                }
                catch (Exception pks) {
                    // empty catch block
                }
                if (pi == null && !quiet) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    messageCollection.getClass();
                    MessageCollection.Message mess = messageCollection.new MessageCollection.Message(24);
                    mess.substitute(1, this.name);
                    mess.substitute(2, pi2.name());
                    mess.addSourceReferences(this.sourceReferences);
                }
            }
            if (pi != null) {
                return new OclNode.PackageLiteralExp(pi);
            }
            return null;
        }

        void debugPrint(PrintWriter stream) {
            if (this.qualification != null) {
                this.qualification.debugPrint(stream);
                stream.print("::");
            }
            stream.print(this.name);
        }
    }

    static class IfClause
    extends TempNode {
        TempNode condition;
        TempNode ifPart;
        TempNode elsePart;

        IfClause(TempNode condition, TempNode ifPart, TempNode elsepart) {
            this.condition = condition;
            this.ifPart = ifPart;
            this.elsePart = elsepart;
            this.addSourceReference(condition);
            this.addSourceReference(ifPart);
            this.addSourceReference(this.elsePart);
        }

        OclNode connectToModel(TempParser p, Model model, OclNode.Declaration varctx) {
            OclNode cond_p = this.condition.connectToModel(p, model, varctx);
            OclNode if_p = this.ifPart.connectToModel(p, model, varctx);
            OclNode else_p = this.elsePart.connectToModel(p, model, varctx);
            if (cond_p == null) {
                return null;
            }
            if (if_p == null) {
                return null;
            }
            if (else_p == null) {
                return null;
            }
            if (cond_p.getDataType().builtInType != OclNode.BuiltInType.BOOLEAN) {
                MessageCollection messageCollection = p.getMessageCollection();
                messageCollection.getClass();
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(35);
                mess.addSourceReferences(this.condition.sourceReferences);
                return null;
            }
            OclNode.DataType common = if_p.getDataType().commonSuperType(else_p.getDataType());
            if (common == null) {
                MessageCollection messageCollection = p.getMessageCollection();
                messageCollection.getClass();
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(36);
                mess.substitute(1, if_p.getDataType().name);
                mess.substitute(2, else_p.getDataType().name);
                mess.addSourceReferences(this.sourceReferences);
                return null;
            }
            return new OclNode.IfExp(common, cond_p, if_p, else_p);
        }

        void debugPrint(PrintWriter stream) {
            stream.print("if-then-else[");
            this.condition.debugPrint(stream);
            stream.print(",");
            this.ifPart.debugPrint(stream);
            stream.print(",");
            this.elsePart.debugPrint(stream);
            stream.print("]");
        }
    }

    static class Infix
    extends TempNode {
        Token.Type type;
        TempNode operand1;
        TempNode operand2;

        Infix(Token.Type type, TempNode op1, TempNode op2) {
            this.type = type;
            this.operand1 = op1;
            this.operand2 = op2;
            this.addSourceReference(op1);
            this.addSourceReference(op2);
        }

        OclNode connectToModel(TempParser p, Model model, OclNode.Declaration varctx) {
            OclNode object = this.operand1.connectToModel(p, model, varctx);
            OclNode.DataType objDataType = object.getDataType();
            OclNode result = null;
            block0 : switch (this.type) {
                case DOT: 
                case ARROW: {
                    if (!(this.operand2 instanceof Property)) {
                        MessageCollection messageCollection = p.getMessageCollection();
                        messageCollection.getClass();
                        MessageCollection.Message mess = messageCollection.new MessageCollection.Message(25);
                        mess.substitute(1, Token.getLexicalStringFromType(this.type));
                        mess.addSourceReferences(this.operand2.sourceReferences);
                        return null;
                    }
                    Property property = (Property)this.operand2;
                    ClassInfo ci = objDataType.umlClass;
                    if (ci != null && this.type != Token.Type.ARROW) {
                        result = property.connectAsUmlProperty(p, model, varctx, object, false);
                        break;
                    }
                    result = property.connectAsBuiltInProperty(p, model, varctx, object, this.type == Token.Type.ARROW, false);
                    break;
                }
                default: {
                    OclNode op1 = object;
                    OclNode op2 = this.operand2.connectToModel(p, model, varctx);
                    if (op1 == null || op2 == null) {
                        return null;
                    }
                    OclNode.DataType dt1 = objDataType;
                    OclNode.DataType dt2 = op2.getDataType();
                    OclNode.BuiltInType bit1 = dt1.builtInType;
                    OclNode.BuiltInType bit2 = dt2.builtInType;
                    String name = Token.getLexicalStringFromType(this.type);
                    OclNode.BuiltInDescr[] builtInDescrArray = OclNode.operSymbDescriptors;
                    int n = OclNode.operSymbDescriptors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        OclNode.BuiltInType bidtype;
                        OclNode.BuiltInDescr bid = builtInDescrArray[n2];
                        if (name.equals(bid.name) && (bidtype = bid.applType) != OclNode.BuiltInType.ANY && bidtype == bit1) {
                            int bidnargs = 0;
                            if (bid.arguTypes != null) {
                                bidnargs = bid.arguTypes.length;
                            }
                            if (bidnargs == 1 && bid.arguTypes[0] == bit2) {
                                result = new OclNode.OperationCallExp(op1, false, name, new OclNode[]{op2}, new OclNode.DataType(bid.resType), OclNode.MultiplicityMapping.ONE2ONE, false);
                                break block0;
                            }
                        }
                        ++n2;
                    }
                    break block0;
                }
            }
            return result;
        }

        void debugPrint(PrintWriter stream) {
            String opsym = Token.getLexicalStringFromType(this.type);
            stream.print(opsym);
            stream.print("(");
            this.operand1.debugPrint(stream);
            stream.print(",");
            this.operand2.debugPrint(stream);
            stream.print(")");
        }
    }

    static class Invalid
    extends TempNode {
        Invalid() {
        }

        OclNode connectToModel(TempParser p, Model model, OclNode.Declaration varctx) {
            MessageCollection messageCollection = p.getMessageCollection();
            messageCollection.getClass();
            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
            mess.substitute(1, "Attempt to connect INVALID TempNode to the model.");
            mess.addSourceReferences(this.sourceReferences);
            return null;
        }

        void debugPrint(PrintWriter stream) {
            stream.print("INVALID");
        }
    }

    static class LetClause
    extends TempNode {
        TempNode[] declarations;
        TempNode expression;

        LetClause(TempNode[] declarations, TempNode expression) {
            this.declarations = declarations;
            this.expression = expression;
            int i = 0;
            while (i < declarations.length) {
                this.addSourceReference(declarations[i]);
                ++i;
            }
            this.addSourceReference(expression);
        }

        OclNode connectToModel(TempParser p, Model model, OclNode.Declaration varctx) {
            return null;
        }

        void debugPrint(PrintWriter stream) {
            stream.print("let[");
            int i = 0;
            while (i < this.declarations.length) {
                if (i > 0) {
                    stream.print(",");
                }
                this.declarations[i].debugPrint(stream);
                ++i;
            }
            stream.print(";");
            this.expression.debugPrint(stream);
            stream.print("]");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Literal<T>
    extends TempNode {
        T value;

        Literal(T value) {
            this.value = value;
        }

        T getValue() {
            return this.value;
        }

        @Override
        OclNode connectToModel(TempParser p, Model model, OclNode.Declaration varctx) {
            if (this.value.getClass() == Double.class) {
                return new OclNode.RealLiteralExp((Double)this.value);
            }
            if (this.value.getClass() == Integer.class) {
                return new OclNode.IntegerLiteralExp((Integer)this.value);
            }
            if (this.value.getClass() == String.class) {
                return new OclNode.StringLiteralExp((String)this.value);
            }
            if (this.value.getClass() == Boolean.class) {
                return new OclNode.BooleanLiteralExp((Boolean)this.value);
            }
            if (this.value.getClass() == DateTime.class) {
                return new OclNode.DateTimeLiteralExp((GregorianCalendar)this.value);
            }
            if (this.value.getClass() == CurrentDateTime.class) {
                return new OclNode.DateTimeLiteralExp();
            }
            MessageCollection messageCollection = p.getMessageCollection();
            messageCollection.getClass();
            MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
            String name = this.value.getClass().getName();
            mess.substitute(1, "Attempt to create a literal of type '" + name + "'.");
            mess.addSourceReferences(this.sourceReferences);
            return null;
        }

        @Override
        void debugPrint(PrintWriter stream) {
            stream.print("L[");
            stream.print(this.value);
            stream.print("]");
        }
    }

    static class Prefix
    extends TempNode {
        Token.Type type;
        TempNode operand;

        Prefix(Token.Type type, TempNode op) {
            this.type = type;
            this.operand = op;
            this.addSourceReference(op);
        }

        OclNode connectToModel(TempParser p, Model model, OclNode.Declaration varctx) {
            OclNode object = this.operand.connectToModel(p, model, varctx);
            if (object == null) {
                return null;
            }
            OclNode.DataType objDataType = object.getDataType();
            OclNode.BuiltInType bit = objDataType.builtInType;
            OclNode.OperationCallExp result = null;
            String name = Token.getLexicalStringFromType(this.type);
            OclNode.BuiltInDescr[] builtInDescrArray = OclNode.operSymbDescriptors;
            int n = OclNode.operSymbDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                OclNode.BuiltInType bidtype;
                OclNode.BuiltInDescr bid = builtInDescrArray[n2];
                if (name.equals(bid.name) && (bidtype = bid.applType) != OclNode.BuiltInType.ANY && bidtype == bit) {
                    int bidnargs = 0;
                    if (bid.arguTypes != null) {
                        bidnargs = bid.arguTypes.length;
                    }
                    if (bidnargs == 0) {
                        result = new OclNode.OperationCallExp(object, false, name, new OclNode[0], new OclNode.DataType(bid.resType), OclNode.MultiplicityMapping.ONE2ONE, false);
                        break;
                    }
                }
                ++n2;
            }
            return result;
        }

        void debugPrint(PrintWriter stream) {
            String opsym = Token.getLexicalStringFromType(this.type);
            stream.print(opsym);
            stream.print("(");
            this.operand.debugPrint(stream);
            stream.print(")");
        }
    }

    static class Property
    extends TempNode {
        TempNode name;
        TempNode arguments;

        Property(TempNode name, TempNode arguments) {
            this.name = name;
            this.arguments = arguments;
            this.addSourceReference(name);
            if (arguments != null) {
                this.addSourceReference(arguments);
            }
        }

        boolean hasSimpleName() {
            if (this.name == null) {
                return false;
            }
            if (!(this.name instanceof Identifier)) {
                return false;
            }
            Identifier id = (Identifier)this.name;
            return id.name == null;
        }

        String name() {
            if (this.name == null) {
                return "(null)";
            }
            if (!(this.name instanceof Identifier)) {
                return "(invalid)";
            }
            Identifier id = (Identifier)this.name;
            return id.name();
        }

        int numberOfArguments() {
            if (this.arguments == null || !(this.arguments instanceof Arguments)) {
                return -1;
            }
            return ((Arguments)this.arguments).expressions.length;
        }

        OclNode connectToModel(TempParser p, Model model, OclNode.Declaration varctx) {
            if (this.name == null || !(this.name instanceof Identifier)) {
                MessageCollection messageCollection = p.getMessageCollection();
                messageCollection.getClass();
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
                mess.substitute(1, "Property is named by non-Identifier token.");
                mess.addSourceReferences(this.sourceReferences);
                return null;
            }
            Identifier id = (Identifier)this.name;
            OclNode.Declaration dcl = null;
            if (id.isSimpleName() && this.arguments == null) {
                String name = id.name();
                dcl = varctx;
                while (dcl != null) {
                    if (name.equals(dcl.name)) break;
                    dcl = dcl.nextOuter;
                }
                if (dcl != null) {
                    OclNode.VariableExp var = new OclNode.VariableExp(dcl);
                    return var;
                }
            }
            dcl = varctx;
            while (dcl != null) {
                if (dcl.isImplicit) {
                    OclNode.VariableExp var = new OclNode.VariableExp(dcl);
                    OclNode.DataType type = dcl.getDataType();
                    ClassInfo ci = type.umlClass;
                    OclNode result = null;
                    result = ci != null ? this.connectAsUmlProperty(p, model, varctx, var, true) : this.connectAsBuiltInProperty(p, model, varctx, var, false, true);
                    if (result != null) {
                        return result;
                    }
                }
                dcl = dcl.nextOuter;
            }
            if (this.arguments != null) {
                MessageCollection messageCollection = p.getMessageCollection();
                messageCollection.getClass();
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(32);
                mess.substitute(1, this.name());
                mess.substitute(2, String.valueOf(this.numberOfArguments()));
                mess.addSourceReferences(this.sourceReferences);
                return null;
            }
            OclNode result = id.connectToModel(p, model, varctx);
            if (result != null) {
                MessageCollection messageCollection = p.getMessageCollection();
                messageCollection.getClass();
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(34);
                mess.substitute(1, this.name());
                mess.addSourceReferences(this.sourceReferences);
            }
            return result;
        }

        OclNode connectAsUmlProperty(TempParser p, Model model, OclNode.Declaration varctx, OclNode object, boolean quiet) {
            ClassInfo ci = object.getDataType().umlClass;
            if (ci == null) {
                MessageCollection messageCollection = p.getMessageCollection();
                messageCollection.getClass();
                MessageCollection.Message mess = messageCollection.new MessageCollection.Message(0);
                mess.substitute(1, "connectAsUmlProperty failed due to null object.");
                mess.addSourceReferences(this.sourceReferences);
                return null;
            }
            Identifier id = (Identifier)this.name;
            if (!id.isSimpleName()) {
                ClassInfo qci = id.classFromQualification(p, model, false);
                if (qci == null) {
                    return null;
                }
                ClassInfo c = ci;
                while (c != null && c != ci) {
                    c = c.baseClass();
                }
                if (c == null) {
                    if (!quiet) {
                        MessageCollection messageCollection = p.getMessageCollection();
                        messageCollection.getClass();
                        MessageCollection.Message mess = messageCollection.new MessageCollection.Message(30);
                        mess.substitute(1, this.name());
                        mess.substitute(2, ci.name());
                        mess.addSourceReferences(this.sourceReferences);
                    }
                    return null;
                }
                ci = qci;
            }
            if (this.arguments == null) {
                PropertyInfo pi = ci.property(this.name());
                if (pi != null) {
                    return new OclNode.AttributeCallExp(object, pi, false);
                }
                if (!quiet) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    messageCollection.getClass();
                    MessageCollection.Message mess = messageCollection.new MessageCollection.Message(26);
                    mess.substitute(1, this.name());
                    mess.substitute(2, ci.name());
                    mess.addSourceReferences(id.sourceReferences);
                }
            } else {
                OclNode res = this.connectAsBuiltInProperty(p, model, varctx, object, false, quiet);
                if (res != null) {
                    return res;
                }
            }
            return null;
        }

        OclNode connectAsBuiltInProperty(TempParser p, Model model, OclNode.Declaration varctx, OclNode object, boolean arrow, boolean quiet) {
            MessageCollection.Message mess;
            Object bidtype;
            OclNode.DataType type = object.getDataType();
            OclNode.BuiltInType bit = type.builtInType;
            String typename = type.name;
            Identifier id = (Identifier)this.name;
            String name = id.name();
            if (this.arguments == null) {
                if (!quiet) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    messageCollection.getClass();
                    MessageCollection.Message mess2 = messageCollection.new MessageCollection.Message(26);
                    mess2.substitute(1, name);
                    mess2.substitute(2, typename);
                    mess2.addSourceReferences(id.sourceReferences);
                }
                return null;
            }
            Arguments args = (Arguments)this.arguments;
            int nargs = args.expressions.length;
            ArrayList<OclNode.BuiltInDescr> bids = new ArrayList<OclNode.BuiltInDescr>(1);
            int itersFound = 0;
            OclNode.BuiltInDescr[] builtInDescrArray = OclNode.builtInDescriptors;
            int n = OclNode.builtInDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                OclNode.BuiltInDescr bid = builtInDescrArray[n2];
                if (name.equals(bid.name) && (bidtype = bid.applType) != OclNode.BuiltInType.ANY && bidtype == bit) {
                    int bidnargs = 0;
                    if (bid.arguTypes != null) {
                        bidnargs = bid.arguTypes.length;
                    }
                    if (nargs == bidnargs && arrow == bid.arrow) {
                        bids.add(bid);
                        if (bid.noOfDecls > 0) {
                            ++itersFound;
                        }
                    }
                }
                ++n2;
            }
            if (itersFound > 0 && bids.size() != itersFound) {
                MessageCollection messageCollection = p.getMessageCollection();
                messageCollection.getClass();
                MessageCollection.Message mess3 = messageCollection.new MessageCollection.Message(0);
                mess3.substitute(1, "");
                mess3.addSourceReferences(id.sourceReferences);
                return null;
            }
            ArrayList<OclNode.Declaration> ocldecls = null;
            if (itersFound > 0) {
                ocldecls = new ArrayList<OclNode.Declaration>(1);
                if (args.declarations != null) {
                    bidtype = (Declaration[])args.declarations;
                    int n3 = ((Declaration[])bidtype).length;
                    n = 0;
                    while (n < n3) {
                        OclNode.Declaration newVarctx;
                        Object decl = bidtype[n];
                        OclNode ocldecl = ((Declaration)decl).connectToModelWithType(p, model, varctx, type);
                        if (ocldecl == null) {
                            return null;
                        }
                        varctx = newVarctx = (OclNode.Declaration)ocldecl;
                        ocldecls.add(newVarctx);
                        ++n;
                    }
                } else {
                    OclNode.Declaration defaultVarctx;
                    varctx = defaultVarctx = new OclNode.Declaration(null, type, null, varctx, null, true);
                    ocldecls.add(defaultVarctx);
                }
            }
            OclNode[] oclargs = new OclNode[nargs];
            int i = 0;
            while (i < nargs) {
                OclNode arg = args.expressions[i].connectToModel(p, model, varctx);
                if (arg == null) {
                    return null;
                }
                oclargs[i] = arg;
                ++i;
            }
            OclNode.BuiltInDescr selectedbid = null;
            for (OclNode.BuiltInDescr bid : bids) {
                OclNode.BuiltInType[] bidtypes = bid.arguTypes;
                boolean matched = true;
                int i2 = 0;
                while (i2 < bidtypes.length && !matched) {
                    if (bidtypes[i2] != OclNode.BuiltInType.ANY && bidtypes[i2] != oclargs[i2].getDataType().builtInType) {
                        matched = false;
                    }
                    ++i2;
                }
                if (!matched) continue;
                selectedbid = bid;
                break;
            }
            if (selectedbid == null) {
                if (!quiet) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    messageCollection.getClass();
                    mess = messageCollection.new MessageCollection.Message(27);
                    mess.substitute(1, name);
                    mess.substitute(2, typename);
                    mess.substitute(3, String.valueOf(nargs));
                    mess.addSourceReferences(this.sourceReferences);
                }
                return null;
            }
            if (itersFound > 0 && ocldecls.size() > selectedbid.noOfDecls) {
                if (!quiet) {
                    MessageCollection messageCollection = p.getMessageCollection();
                    messageCollection.getClass();
                    mess = messageCollection.new MessageCollection.Message(31);
                    mess.substitute(1, name);
                    mess.addSourceReferences(this.sourceReferences);
                }
                return null;
            }
            OclNode.OperationCallExp callexp = null;
            if (itersFound > 0) {
                callexp = new OclNode.IterationCallExp(object, name, (OclNode.Declaration[])ocldecls.toArray(), oclargs, type, selectedbid.multMap);
                for (OclNode.Declaration dcl : ocldecls) {
                    dcl.ownerNode = callexp;
                }
            } else {
                callexp = new OclNode.OperationCallExp(object, arrow, name, oclargs, type, selectedbid.multMap, false);
            }
            return callexp;
        }

        void debugPrint(PrintWriter stream) {
            stream.print("P[");
            this.name.debugPrint(stream);
            if (this.arguments != null) {
                this.arguments.debugPrint(stream);
            }
            stream.print("]");
        }
    }
}

