/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Ocl;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.OperationInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Type;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TreeMap;

public abstract class OclNode {
    static final HashMap<String, BuiltInType> iso19103Map = new HashMap();
    static BuiltInDescr[] builtInDescriptors;
    static BuiltInDescr[] operSymbDescriptors;
    protected DataType dataType = null;

    static {
        iso19103Map.put("CharacterString", BuiltInType.STRING);
        iso19103Map.put("Character", BuiltInType.STRING);
        iso19103Map.put("Boolean", BuiltInType.BOOLEAN);
        iso19103Map.put("Number", BuiltInType.REAL);
        iso19103Map.put("Real", BuiltInType.REAL);
        iso19103Map.put("Decimal", BuiltInType.REAL);
        iso19103Map.put("Integer", BuiltInType.INTEGER);
        iso19103Map.put("Date", BuiltInType.DATE);
        iso19103Map.put("DateTime", BuiltInType.DATE);
        builtInDescriptors = new BuiltInDescr[]{new BuiltInDescr("allInstances", BuiltInType.CLASS, null, 0, false, MultiplicityMapping.ONE2MANY, BuiltInType.UMLTYPE), new BuiltInDescr("size", BuiltInType.ANY, null, 0, true, MultiplicityMapping.MANY2ONE, BuiltInType.INTEGER), new BuiltInDescr("isEmpty", BuiltInType.ANY, null, 0, true, MultiplicityMapping.MANY2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("notEmpty", BuiltInType.ANY, null, 0, true, MultiplicityMapping.MANY2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("exists", BuiltInType.ANY, new BuiltInType[]{BuiltInType.BOOLEAN}, 1, true, MultiplicityMapping.MANY2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("size", BuiltInType.STRING, null, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.INTEGER), new BuiltInDescr("substring", BuiltInType.STRING, new BuiltInType[]{BuiltInType.INTEGER, BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.STRING), new BuiltInDescr("concat", BuiltInType.STRING, new BuiltInType[]{BuiltInType.STRING}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.STRING), new BuiltInDescr("oclIsKindOf", BuiltInType.ANY, new BuiltInType[]{BuiltInType.CLASS}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN)};
        operSymbDescriptors = new BuiltInDescr[]{new BuiltInDescr("or", BuiltInType.BOOLEAN, new BuiltInType[]{BuiltInType.BOOLEAN}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("xor", BuiltInType.BOOLEAN, new BuiltInType[]{BuiltInType.BOOLEAN}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("and", BuiltInType.BOOLEAN, new BuiltInType[]{BuiltInType.BOOLEAN}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("implies", BuiltInType.BOOLEAN, new BuiltInType[]{BuiltInType.BOOLEAN}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("not", BuiltInType.BOOLEAN, null, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("-", BuiltInType.INTEGER, null, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.INTEGER), new BuiltInDescr("-", BuiltInType.REAL, null, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("+", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.INTEGER), new BuiltInDescr("+", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("+", BuiltInType.REAL, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("+", BuiltInType.REAL, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("-", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.INTEGER), new BuiltInDescr("-", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("-", BuiltInType.REAL, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("-", BuiltInType.REAL, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("*", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.INTEGER), new BuiltInDescr("*", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("*", BuiltInType.REAL, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("*", BuiltInType.REAL, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("/", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.INTEGER), new BuiltInDescr("/", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("/", BuiltInType.REAL, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("/", BuiltInType.REAL, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.REAL), new BuiltInDescr("=", BuiltInType.ANY, new BuiltInType[]{BuiltInType.ANY}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<>", BuiltInType.ANY, new BuiltInType[]{BuiltInType.ANY}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<", BuiltInType.REAL, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<", BuiltInType.REAL, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">", BuiltInType.REAL, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">", BuiltInType.REAL, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<=", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<=", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<=", BuiltInType.REAL, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<=", BuiltInType.REAL, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">=", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">=", BuiltInType.INTEGER, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">=", BuiltInType.REAL, new BuiltInType[]{BuiltInType.INTEGER}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">=", BuiltInType.REAL, new BuiltInType[]{BuiltInType.REAL}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<", BuiltInType.DATE, new BuiltInType[]{BuiltInType.DATE}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">", BuiltInType.DATE, new BuiltInType[]{BuiltInType.DATE}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr("<=", BuiltInType.DATE, new BuiltInType[]{BuiltInType.DATE}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN), new BuiltInDescr(">=", BuiltInType.DATE, new BuiltInType[]{BuiltInType.DATE}, 0, false, MultiplicityMapping.ONE2ONE, BuiltInType.BOOLEAN)};
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isBuiltInType() {
        return this.dataType.isBuiltIn();
    }

    public static class AttributeCallExp
    extends PropertyCallExp {
        AttributeCallExp(OclNode o, PropertyInfo pi, boolean im) {
            this.object = o;
            Type t = pi.typeInfo();
            ClassInfo ci = pi.model().classById(t.id);
            this.dataType = ci != null ? new DataType(ci) : new DataType(t.name);
            this.selector = new PropertySelector(pi);
            this.isImplicit = im;
            this.multMapping = pi.cardinality().maxOccurs <= 1 ? MultiplicityMapping.ONE2ONE : MultiplicityMapping.ONE2MANY;
        }
    }

    public static class BooleanLiteralExp
    extends LiteralExp {
        public boolean value;

        BooleanLiteralExp(boolean value) {
            this.dataType = new DataType(BuiltInType.BOOLEAN);
            this.value = value;
        }
    }

    public static class BuiltInDescr {
        String name;
        BuiltInType applType;
        BuiltInType[] arguTypes;
        int noOfDecls;
        boolean arrow;
        MultiplicityMapping multMap;
        BuiltInType resType;

        BuiltInDescr(String name, BuiltInType applType, BuiltInType[] arguTypes, int noOfDecls, boolean arrow, MultiplicityMapping multMap, BuiltInType resType) {
            this.name = name;
            this.applType = applType;
            this.arguTypes = arguTypes;
            this.noOfDecls = noOfDecls;
            this.arrow = arrow;
            this.multMap = multMap;
            this.resType = resType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BuiltInType {
        REAL,
        INTEGER,
        STRING,
        BOOLEAN,
        DATE,
        CLASS,
        ENUMERATION,
        PACKAGE,
        ANY,
        INVALID,
        VOID,
        UMLTYPE;


        String oclName() {
            String s = this.name();
            return String.valueOf(s.substring(0, 1)) + s.substring(1).toLowerCase();
        }
    }

    public static class ClassLiteralExp
    extends LiteralExp {
        public ClassInfo umlClass;

        ClassLiteralExp(ClassInfo ci) {
            this.dataType = new DataType(BuiltInType.CLASS);
            this.umlClass = ci;
        }
    }

    public static class DataType {
        public String name = null;
        public BuiltInType builtInType = BuiltInType.UMLTYPE;
        public ClassInfo umlClass = null;

        public DataType(ClassInfo ci) {
            BuiltInType bi;
            this.name = ci.name();
            this.umlClass = ci;
            int cat = ci.category();
            if (cat == 2 || cat == 3) {
                this.builtInType = BuiltInType.ENUMERATION;
            }
            if ((bi = iso19103Map.get(this.name)) != null) {
                this.builtInType = bi;
            }
        }

        public DataType(BuiltInType bit) {
            this.name = bit.oclName();
            this.umlClass = null;
            this.builtInType = bit;
        }

        public DataType(String name) {
            BuiltInType bi;
            this.name = name;
            this.umlClass = null;
            BuiltInType[] builtInTypeArray = BuiltInType.values();
            int n = builtInTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                bi = builtInTypeArray[n2];
                if (bi.oclName().equals(name)) {
                    this.builtInType = bi;
                    break;
                }
                ++n2;
            }
            bi = iso19103Map.get(name);
            if (bi != null) {
                this.builtInType = bi;
            }
        }

        public boolean isBuiltIn() {
            return this.builtInType != BuiltInType.UMLTYPE && this.builtInType != BuiltInType.ENUMERATION;
        }

        public DataType commonSuperType(DataType type) {
            if (this.isBuiltIn()) {
                if (!type.isBuiltIn()) {
                    return null;
                }
                BuiltInType bit1 = this.builtInType;
                BuiltInType bit2 = type.builtInType;
                if (bit1 == bit2) {
                    return this;
                }
                if (bit1 == BuiltInType.INTEGER) {
                    bit1 = BuiltInType.REAL;
                }
                if (bit2 == BuiltInType.INTEGER) {
                    bit2 = BuiltInType.REAL;
                }
                if (bit1 == bit2) {
                    return new DataType(BuiltInType.REAL);
                }
                return null;
            }
            if (type.isBuiltIn()) {
                return null;
            }
            BuiltInType bit1 = this.builtInType;
            BuiltInType bit2 = type.builtInType;
            if (bit1 != bit2) {
                return null;
            }
            if (this.umlClass == type.umlClass) {
                return this;
            }
            ClassInfo sci = null;
            ClassInfo ci1 = this.umlClass;
            block0: while (ci1 != null) {
                ClassInfo ci2 = type.umlClass;
                while (ci2 != null) {
                    if (ci1 == ci2) {
                        sci = ci1;
                        break block0;
                    }
                    ci2 = ci2.baseClass();
                }
                ci1 = ci1.baseClass();
            }
            if (sci == null) {
                return null;
            }
            return new DataType(sci);
        }
    }

    public static class DateTimeLiteralExp
    extends LiteralExp {
        public boolean current;
        public GregorianCalendar dateTime = null;

        DateTimeLiteralExp() {
            this.dataType = new DataType(BuiltInType.DATE);
            this.current = true;
        }

        DateTimeLiteralExp(GregorianCalendar date) {
            this.dataType = new DataType(BuiltInType.DATE);
            this.current = false;
            this.dateTime = date;
        }
    }

    public static class Declaration
    extends OclNode {
        public String name = null;
        public OclNode initialValue = null;
        public Declaration nextOuter = null;
        public OclNode ownerNode = null;
        public boolean isImplicit = false;

        public Declaration(String name, DataType dt, OclNode ival, Declaration declCtx, OclNode owner, boolean impl) {
            this.name = name != null ? name : "(noname)";
            this.dataType = dt;
            this.initialValue = ival;
            this.nextOuter = declCtx;
            this.ownerNode = owner;
            this.isImplicit = impl;
        }
    }

    public static class EnumerationLiteralExp
    extends LiteralExp {
        public PropertyInfo umlProperty;

        EnumerationLiteralExp(PropertyInfo pi) {
            this.dataType = new DataType(pi.inClass());
            this.umlProperty = pi;
        }
    }

    public static class IfExp
    extends OclNode {
        public OclNode condition;
        public OclNode ifExpression;
        public OclNode elseExpression;

        IfExp(DataType type, OclNode c, OclNode i, OclNode e) {
            this.dataType = type;
            this.condition = c;
            this.ifExpression = i;
            this.elseExpression = e;
        }
    }

    public static class IntegerLiteralExp
    extends LiteralExp {
        public int value;

        IntegerLiteralExp(int value) {
            this.dataType = new DataType(BuiltInType.INTEGER);
            this.value = value;
        }
    }

    public static class IterationCallExp
    extends OperationCallExp {
        protected Declaration[] declarations = null;

        IterationCallExp(OclNode o, String name, Declaration[] decls, OclNode[] args, DataType type, MultiplicityMapping mm) {
            super(o, true, name, args, type, mm, false);
            this.selector.category = PropertyCategory.ITEROPER;
            this.declarations = decls;
        }
    }

    public static abstract class LiteralExp
    extends OclNode {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MultiplicityMapping {
        ONE2ONE,
        ONE2MANY,
        MANY2ONE;

    }

    public static class OperationCallExp
    extends PropertyCallExp {
        protected OclNode[] arguments = null;

        OperationCallExp(OclNode o, OperationInfo oi, OclNode[] args, boolean im) {
            this.object = o;
            TreeMap<Integer, String> pnames = oi.parameterNames();
            TreeMap<Integer, String> ptypes = oi.parameterTypes();
            String tname = null;
            int i = 0;
            while (i < pnames.size()) {
                if (pnames.get(i).equals("__RETURN__")) {
                    tname = ptypes.get(i);
                }
                ++i;
            }
            ClassInfo ci = null;
            if (tname != null) {
                ci = oi.model().classByName(tname);
            } else {
                tname = "Void";
            }
            this.dataType = ci != null ? new DataType(ci) : new DataType(tname);
            this.selector = new PropertySelector(oi);
            this.isImplicit = im;
            this.multMapping = MultiplicityMapping.ONE2ONE;
            this.arguments = args;
        }

        OperationCallExp(OclNode o, boolean setLevel, String name, OclNode[] args, DataType type, MultiplicityMapping mm, boolean imp) {
            this.object = o;
            this.dataType = type;
            this.selector = o instanceof ClassLiteralExp ? new PropertySelector(PropertyCategory.CLASSOPER, name) : (setLevel ? new PropertySelector(PropertyCategory.SETOPER, name) : (o.isBuiltInType() ? new PropertySelector(PropertyCategory.BASEOPER, name) : new PropertySelector(PropertyCategory.UMLADDOPER, name)));
            this.multMapping = mm;
            this.isImplicit = imp;
            this.arguments = args;
        }
    }

    public static class PackageLiteralExp
    extends LiteralExp {
        public PackageInfo umlPackage;

        PackageLiteralExp(PackageInfo pi) {
            this.dataType = new DataType(BuiltInType.PACKAGE);
            this.umlPackage = pi;
        }

        PackageInfo getPackage() {
            return this.umlPackage;
        }
    }

    public static abstract class PropertyCallExp
    extends OclNode {
        protected OclNode object;
        protected PropertySelector selector;
        MultiplicityMapping multMapping;
        protected boolean isImplicit = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyCategory {
        UMLPROPERTY,
        UMLOPERATION,
        UMLADDOPER,
        BASEOPER,
        SETOPER,
        ITEROPER,
        CLASSOPER,
        INVALID;

    }

    public static class PropertySelector {
        public PropertyCategory category = PropertyCategory.INVALID;
        public String name = null;
        public Info modelProperty = null;

        PropertySelector(PropertyInfo pi) {
            this.category = PropertyCategory.UMLPROPERTY;
            this.modelProperty = pi;
            this.name = pi.name();
        }

        PropertySelector(OperationInfo oi) {
            this.category = PropertyCategory.UMLOPERATION;
            this.modelProperty = oi;
            this.name = oi.name();
        }

        PropertySelector(PropertyCategory pc, String name) {
            this.category = pc;
            this.name = name;
        }
    }

    public static class RealLiteralExp
    extends LiteralExp {
        public double value;

        RealLiteralExp(double value) {
            this.dataType = new DataType(BuiltInType.REAL);
            this.value = value;
        }
    }

    public static class StringLiteralExp
    extends LiteralExp {
        public String value;

        StringLiteralExp(String value) {
            this.dataType = new DataType(BuiltInType.STRING);
            this.value = value;
        }
    }

    public static class VariableExp
    extends OclNode {
        public OclNode declaration = null;

        public VariableExp(Declaration decl) {
            this.dataType = decl.dataType;
            this.declaration = decl;
        }
    }
}

