/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.SAXException;

public class Converter {
    protected ShapeChangeResult result = null;
    protected Options options = null;

    public Converter(Options o, ShapeChangeResult r) {
        this.options = o;
        this.result = r;
    }

    public void convert(Model model) {
        try {
            try {
                String appSchemaName;
                HashSet<PackageInfo> schemas;
                if (model == null) {
                    this.result.addFatalError(14);
                    throw new ShapeChangeAbortException();
                }
                if (!model.isValidated()) {
                    model.validate();
                }
                if ((schemas = model.schemas(appSchemaName = this.options.parameter("appSchemaName"))).isEmpty()) {
                    if (appSchemaName.equals("")) {
                        this.result.addFatalError(12);
                    } else {
                        this.result.addFatalError(13, appSchemaName);
                    }
                    throw new ShapeChangeAbortException();
                }
                for (PackageInfo pi : schemas) {
                    if (pi == null) continue;
                    Vector<String> targets = this.options.targets();
                    Iterator<String> j = targets.iterator();
                    while (j.hasNext()) {
                        Class<?> theClass = Class.forName(j.next());
                        Target target = (Target)theClass.newInstance();
                        if (target == null) continue;
                        target.initialise(pi, model, this.options, this.result);
                        Iterator<ClassInfo> k = model.classes(pi).iterator();
                        while (k.hasNext()) {
                            target.process(k.next());
                        }
                        target.write();
                    }
                }
            }
            catch (Exception e) {
                String m = e.getMessage();
                if (m != null) {
                    this.result.addError(m);
                }
                Exception se = e;
                if (e instanceof SAXException) {
                    se = ((SAXException)e).getException();
                }
                if (se != null) {
                    se.printStackTrace(System.err);
                } else {
                    e.printStackTrace(System.err);
                }
                this.result.toFile(this.options.parameter("logFile"));
            }
        }
        finally {
            this.result.toFile(this.options.parameter("logFile"));
        }
    }
}

