<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0"
		xmlns:ext="http://www.jclark.com/xt/java/de.adv-online.AAA"
		xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc"
		xmlns:gml="http://www.opengis.net/gml/3.2">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:variable name="anlassart"     select="//adv:art"/> 		
	<xsl:variable name="antragsnummer" select="//adv:antragsnummer"/>
	<!-- =========================================================== -->
	<xsl:template name="summiereFlurstuecksflaechen">
		<xsl:param name="bwrts"/>
		<xsl:param name="flurstuecke"/>
		<xsl:choose>
			<xsl:when test="$bwrts">
				<xsl:variable name="rec_res">
					<xsl:call-template name="summiereFlurstuecksflaechen">
						<xsl:with-param name="bwrts" select="$bwrts"/>
						<xsl:with-param name="flurstuecke" select="$flurstuecke[position()>1]"/>
					</xsl:call-template>
				</xsl:variable>
				<!-- Flächenermittlung vom ersten Flurstück -->
				<xsl:variable name="flur" select="$flurstuecke[1]"/>
				<!-- Korrekturfaktor bestimmen -->
				<xsl:variable name="korrekturfaktor">
					<xsl:choose>
						<xsl:when test="function-available('ext:berechneFlaeche')">
							<xsl:value-of select="$flur/adv:amtlicheflaeche div ext:berechneFlaeche($flur/adv:position)"/>
						</xsl:when>
						<xsl:otherwise>1.0</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<!-- Flächenermittlung vom Rest -->
				<xsl:variable name="res">
					<xsl:call-template name="summiereTeilflaechen">
						<!-- alle Flurstücke der Gemarkung -->
						<xsl:with-param name="tn" select="$bwrts"/>
						<xsl:with-param name="flurstuecksflaeche" select="$flur/adv:position"/>
						<xsl:with-param name="korrekturfaktor" select="$korrekturfaktor"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="number($res) + $rec_res"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="0"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>	
	<!-- =========================================================== -->
	<xsl:template name="flaecheOBGGD_Landwirt">
		<!-- Landwirtschaftliche Nutzung differenzieren nach Bodenschätzung -->
		<xsl:param name="schluessel"/>
		<xsl:param name="klass"/>
		<xsl:param name="bwrts"/>
		<xsl:param name="boden"/>
		<!-- nur wenn Bewertungsflächen und Bodenschätzungen vorhanden -->
		<xsl:if test="count($bwrts)>0 and count($boden)>0">
			<flaecheOBGGD>
				<AX_K_BEWFL>
					<gebiet><xsl:value-of select="$schluessel"/></gebiet>
					<!-- sinnvoller wäre eine Entschluesselung für die Ausgabe -->
					<klassifizierungOBG>
							<xsl:value-of select="$klass"/><!-- Hier bitte bei den Template-Aufrufen jew. langschriftlichen Text gemäß der bei AX_Statistik_Gemarkung an gleicher Stelle vorhandenen Zuordnung für die Ausgabe verwenden, wenn AX_K_BEWFL.klassifizierungOBG durch Revision 'Enumeration' als Datentyp hat. -->
					</klassifizierungOBG>
					<!-- Bodenschätzungen ermitteln, die die Bewertungsflächen schneiden -->
					<xsl:variable name="boden1">
						<xsl:for-each select="$bwrts">
							<xsl:variable name="position" select="./adv:posoiton"/>
							<xsl:copy-of select="$boden[ext:intersects(adv:position,$position)]"/>
						</xsl:for-each>
					</xsl:variable>
					<!-- Summierung über ermittelte Bodenschätzungen -->
					<flaeche>
						<xsl:call-template name="summiereFlurstuecksflaechen">
							<xsl:with-param name="bwrts" select="$boden1"/>
							<xsl:with-param name="flurstuecke" select="document('E1.xml')//AX_Flurstueck[adv:gemeindezugehoerigkeit = $schluessel]"/>
						</xsl:call-template>
					</flaeche>
				</AX_K_BEWFL>
			</flaecheOBGGD>
		</xsl:if>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template name="flaecheOBGGD">
		<xsl:param name="schluessel"/>
		<xsl:param name="klass"/>
		<xsl:param name="bwrts"/>
		<!-- nur wenn Bewertungsflächen vorhanden -->
		<xsl:if test="count($bwrts)>0">
			<flaecheOBGGD>
				<AX_K_BEWFL>
					<gebiet><xsl:value-of select="$schluessel"/></gebiet>
					<klassifizierungOBG><xsl:value-of select="$klass"/></klassifizierungOBG><!-- Hier bitte bei den Template-Aufrufen jew. langschriftlichen Text gemäß der bei AX_Statistik_Gemarkung an gleicher Stelle vorhandenen Zuordnung für die Ausgabe verwenden, wenn AX_K_BEWFL.klassifizierungOBG durch Revision 'Enumeration' als Datentyp hat. -->
					<flaeche>
						<xsl:call-template name="summiereFlurstuecksflaechen">
							<xsl:with-param name="bwrts" select="$bwrts"/>
							<xsl:with-param name="flurstuecke" select="document('E1.xml')//AX_Flurstueck[adv:gemeindezugehoerigkeit = $schluessel]"/>
						</xsl:call-template>
					</flaeche>
				</AX_K_BEWFL>
			</flaecheOBGGD>
		</xsl:if>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template name="flaechensummeHGrGD">
		<xsl:param name="schluessel"/>
		<xsl:param name="klass"/>
		<xsl:param name="obggk"/>
		<!-- nur wenn Werte vorhanden -->
		<xsl:if test="count($obggk)>0">
			<flaechensummeHGrGD>
				<AX_K_BEWGR>
					<gebiet><xsl:value-of select="$schluessel"/></gebiet>
					<klassifizierungGr><xsl:value-of select="$klass"/></klassifizierungGr><!-- Hier bitte bei den Template-Aufrufen jew. langschriftlichen Text gemäß der bei AX_Statistik_Gemarkung an gleicher Stelle vorhandenen Zuordnung für die Ausgabe verwenden, wenn AX_K_BEWGR.klassifizierungGr durch Revision 'Enumeration' als Datentyp hat. -->
					<!-- Summierung über Einzelflaechen -->
					<flaeche><xsl:value-of select="sum(adv:flaeche)"/></flaeche>
				</AX_K_BEWGR>
			</flaechensummeHGrGD>
		</xsl:if>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template name="naechsteSumme">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<!-- über alle Gemeinden: jede Gemeinde hat ein eigenes Ergebnisdokument 'E2_Gemeinde_<Schlüssel>.xml' -->
		<!-- Hinweis: Summenbildung über die Gemarkungen ist z.B. für Bayern nicht richtig, daher Bildung über Flurstücke -->
		<xsl:for-each select="document('E1.xml')//AX_KommunalesGebiet">
			<!-- Sortierung der Ausgabe nach Schlüssel -->
			<xsl:sort select="adv:schluesselGesamt"/>
			<!-- Schlüssel und Gemeinde vermerken -->
			<xsl:variable name="schluessel" select="adv:schluesselGesamt"/>
			<xsl:variable name="gemeinde"   select="."/>
			
			<!-- flaecheOBGGD -->
			<xsl:variable name="flaecheOBGGD">
				<!-- Landwirtschaftliche Nutzung differenzieren über Bodenschätzung -->
				<xsl:call-template name="flaecheOBGGD_Landwirt">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2111"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
					<xsl:with-param name="boden" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='1000' and (count(adv:sonstigeAngaben)=0 or not contains('2100,2200,2300,2400,2500',adv:sonstigeAngaben))]"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD_Landwirt">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2112"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
					<xsl:with-param name="boden" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='2000' and (count(adv:sonstigeAngaben)=0 or not contains('2100,2200,2300,2400,2500',adv:sonstigeAngaben))]"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD_Landwirt">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2113"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
					<xsl:with-param name="boden" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='1000' and adv:sonstigeAngaben='2400']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD_Landwirt">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2114"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
					<xsl:with-param name="boden" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='3000' and (count(adv:sonstigeAngaben)=0 or not contains('2100,2200,2300,2400,2500',adv:sonstigeAngaben))]"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD_Landwirt">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2115"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
					<xsl:with-param name="boden" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='4000' and (count(adv:sonstigeAngaben)=0 or not contains('2100,2200,2300,2400,2500',adv:sonstigeAngaben))]"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD_Landwirt">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2116"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
					<xsl:with-param name="boden" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='3000' and adv:sonstigeAngaben='2500']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD_Landwirt">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2117"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
					<xsl:with-param name="boden" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='3000' and adv:sonstigeAngaben='2100']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD_Landwirt">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2118"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
					<xsl:with-param name="boden" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='3000' and adv:sonstigeAngaben='2200']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD_Landwirt">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2119"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2110']"/>
					<xsl:with-param name="boden" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bodenschaetzung[adv:kulturart='3000' and adv:sonstigeAngaben='2300']"/>
				</xsl:call-template>
				<!-- sonstiges nicht weiter differenzieren -->
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2120"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2120']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2130"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2130']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2410"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2410']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2420"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2420']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2430"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2430']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2440"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2440']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2450"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2450']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2200"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2200']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2099"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2899']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2300"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2300']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2310"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2310']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2320"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2320']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2330"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2330']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2340"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2340']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2350"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2350']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2360"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2360']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2370"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2370']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2380"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2380']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2390"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2390']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2510"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2510']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2520"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2520']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2530"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2530']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2800"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2800']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2610"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2610']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2620"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2620']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2630"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2630']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2640"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2640']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2650"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2650']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2700"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2700']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2710"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2710']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2720"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2720']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2730"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Bewertung[adv:klassifizierung='2730']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1100"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1100']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1110"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1110']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1120"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1120']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1130"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1130']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1140"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1140']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1150"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1150']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1160"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1160']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1170"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1170']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1180"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1180']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1190"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_KlassifizierungNachStrassenrecht[adv:artDerFestlegung='1190']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1300"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_KlassifizierungNachWasserrecht[adv:artDerFestlegung='1300']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1310"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_KlassifizierungNachWasserrecht[adv:artDerFestlegung='1310']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1320"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_KlassifizierungNachWasserrecht[adv:artDerFestlegung='1320']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1330"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_KlassifizierungNachWasserrecht[adv:artDerFestlegung='1330']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1340"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_KlassifizierungNachWasserrecht[adv:artDerFestlegung='1340']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="3900"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Fortsrecht[adv:artDerFestlegung='3900']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="3910"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Fortsrecht[adv:artDerFestlegung='3910']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="3920"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Fortsrecht[adv:artDerFestlegung='3920']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="3930"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Fortsrecht[adv:artDerFestlegung='3930']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="3940"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Fortsrecht[adv:artDerFestlegung='3940']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="3950"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Fortsrecht[adv:artDerFestlegung='3950']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="3940"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Fortsrecht[adv:artDerFestlegung='3940']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="3950"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Fortsrecht[adv:artDerFestlegung='3950']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="3960"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Fortsrecht[adv:artDerFestlegung='3960']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="3970"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Fortsrecht[adv:artDerFestlegung='3970']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="3980"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Fortsrecht[adv:artDerFestlegung='3980']"/>
				</xsl:call-template>
				<xsl:call-template name="flaecheOBGGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="3980"/>
					<xsl:with-param name="bwrts" select="document('E2_Gemeinde_{$schluessel}.xml')/AX_Fortsrecht[adv:artDerFestlegung='3990']"/>
				</xsl:call-template>
			</xsl:variable>
			<!-- Ausgabe sortiert nach Klassifizierung -->
			<xsl:for-each select="flaecheOBGGD">
				<xsl:sort select="adv:klassifizierungOBG"/>
				<xsl:copy-of select="."/>
			</xsl:for-each>
			
			<!-- flaechensummeHGrGD: Aggregation über flaecheOBGGD -->
			<xsl:variable name="flaechensummeHGrGD">
				<xsl:call-template name="flaechensummeHGrGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2100"/>
					<xsl:with-param name="OBGGD" select="$flaecheOBGGD/flaecheOBGGD[contains('2111,2112,2113,2114,2115,2116,2117,2118,2119,2120,2130',adv:AX_K_BEWFL/adv:klassifizierungOBG)]"/>
				</xsl:call-template>
				<xsl:call-template name="flaechensummeHGrGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2200"/>
					<xsl:with-param name="OBGGD" select="$flaecheOBGGD/flaecheOBGGD[adv:AX_K_BEWFL/adv:klassifizierungOBG='2200']"/>
				</xsl:call-template>
				<xsl:call-template name="flaechensummeHGrGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2300"/>
					<xsl:with-param name="OBGGD" select="$flaecheOBGGD/flaecheOBGGD[substring(adv:AX_K_BEWFL/adv:klassifizierungOBG,1,2)='23']"/>
				</xsl:call-template>
				<xsl:call-template name="flaechensummeHGrGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2400"/>
					<xsl:with-param name="OBGGD" select="$flaecheOBGGD/flaecheOBGGD[substring(adv:AX_K_BEWFL/adv:klassifizierungOBG,1,2)='24']"/>
				</xsl:call-template>
				<xsl:call-template name="flaechensummeHGrGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2500"/>
					<xsl:with-param name="OBGGD" select="$flaecheOBGGD/flaecheOBGGD[substring(adv:AX_K_BEWFL/adv:klassifizierungOBG,1,2)='25']"/>
				</xsl:call-template>
				<xsl:call-template name="flaechensummeHGrGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2600"/>
					<xsl:with-param name="OBGGD" select="$flaecheOBGGD/flaecheOBGGD[substring(adv:AX_K_BEWFL/adv:klassifizierungOBG,1,2)='26' or substring(adv:AX_K_BEWFL/adv:klassifizierungOBG,1,2)='27']"/>
				</xsl:call-template>
				<xsl:call-template name="flaechensummeHGrGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2800"/>
					<xsl:with-param name="OBGGD" select="$flaecheOBGGD/flaecheOBGGD[adv:AX_K_BEWFL/adv:klassifizierungOBG='2800']"/>
				</xsl:call-template>
				<xsl:call-template name="flaechensummeHGrGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="2900"/>
					<xsl:with-param name="OBGGD" select="$flaecheOBGGD/flaecheOBGGD[adv:AX_K_BEWFL/adv:klassifizierungOBG='2099']"/>
				</xsl:call-template>
				<xsl:call-template name="flaechensummeHGrGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1100"/>
					<xsl:with-param name="OBGGD" select="$flaecheOBGGD/flaecheOBGGD[substring(adv:AX_K_BEWFL/adv:klassifizierungOBG,1,2)='11']"/>
				</xsl:call-template>
				<xsl:call-template name="flaechensummeHGrGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1300"/>
					<xsl:with-param name="OBGGD" select="$flaecheOBGGD/flaecheOBGGD[substring(adv:AX_K_BEWFL/adv:klassifizierungOBG,1,2)='13']"/>
				</xsl:call-template>
				<xsl:call-template name="flaechensummeHGrGD">
					<xsl:with-param name="schluessel" select="$schluessel"/>
					<xsl:with-param name="klass" select="1400"/>
					<xsl:with-param name="OBGGD" select="$flaecheOBGGD/flaecheOBGGD[substring(adv:AX_K_BEWFL/adv:klassifizierungOBG,1,2)='14']"/>
				</xsl:call-template>
			</xsl:variable>
			<!-- Ausgabe sortiert nach Klassifizierung -->
			<xsl:for-each select="flaechensummeHGrGD">
				<xsl:sort select="adv:klassifizierungGR"/>
				<xsl:copy-of select="."/>
			</xsl:for-each>
				
			<!-- flaecheKlasseGD: Summierung über flaechensummeHGrGD -->
			<flaecheKlasseGD>
				<AX_K_FLASU>
					<gebiet><xsl:value-of select="$schluessel"/></gebiet>
					<!-- Summierung über Einzelflaechen -->
					<flaeche><xsl:value-of select="sum($flaechensummeHGrGD//adv:flaeche)"/></flaeche>
				</AX_K_FLASU>
			</flaecheKlasseGD>

			<!-- gesamtFlaecheGD -->
			<gesamtFlaecheGD>
				<AX_K_FLASU>
					<gebiet><xsl:value-of select="$schluessel"/></gebiet>
					<flaeche><xsl:value-of select="$gemeinde/adv:amtlicheFlaeche"/></flaeche>
				</AX_K_FLASU>
			</gesamtFlaecheGD>

		</xsl:for-each>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<xsl:choose>
			<xsl:when test="$anlassart = '2210'">
				<!-- nur Gemarkungsstatistik: somit hat der vorhergehende Schritt das Endergebnis ermittelt -->
				<xsl:copy-of select="document('A3_Statistik_Gemarkung.xml)/."/>
			</xsl:when>
			<xsl:otherwise>
				<!-- sonst: Muss die vorhergehende Statistik (Gemarkungsstatistik) gelöscht werden? -->
				<xsl:variable name="clear">
					<xsl:choose>
						<xsl:when test="$anlassart = '2221' or $anlassart = '2231' or $anlassart = '2241' or $anlassart = '2251'">
							<!-- komplette Statistik: Gemarkungsstatistik nicht löschen -->
							<xsl:value-of select="''"/>
						</xsl:when>
						<xsl:otherwise>
							<!-- nur höchste Statistik: Gemarkungsstatistik löschen -->
							<xsl:value-of select="'flaecheOBGGK,flaechensummeHGrGK,flaechenKlasseGK,anzahlFlurstueckeGK'"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<AX_StatistikDerFlaechenNachDemBewertungsgesetz xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:ext="http://www.jclark.com/xt/java/de.adv-online.AAA" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
					<!-- Teile vom vorhergehenden Ergebnis kopieren, ggf. Gemarkungsstatistik löschen -->
					<xsl:for-each select="document('A3_Statistik_Gemarkung.xml)/*/*">
						<xsl:if test="not(contains($clear,name(.)))">
							<xsl:copy-of select="."/>
						</xsl:if>
					</xsl:for-each>
					<!-- Gemeindestatistik bilden -->
					<xsl:call-template name="naechsteSumme"/>
				</AX_StatistikDerFlaechenNachDemBewertungsgesetz>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
