<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<!-- Profilkennung -->
	<xsl:variable name="profilkennung" select="//adv:profilkennung"/>
	<!-- Antragsnummer -->
	<xsl:variable name="antragsnummer" select="//adv:antragsnummer"/>
	<!-- =========================================================== -->
	<!-- Gebaeude: AX_Gebaeude oder AX_Turm -->
	<xsl:variable name="gebaeude">
		<xsl:choose>
			<xsl:when test="count(document('E1.xml')//adv:AX_Gebaeude)=1">
				<xsl:value-of select="document('E1.xml')//adv:AX_Gebaeude"/>
			</xsl:when>
			<xsl:when test="count(document('E1.xml')//adv:AX_Turm)=1">
				<xsl:value-of select="document('E1.xml')//adv:AX_Turm"/>
			</xsl:when>
		</xsl:choose>
	</xsl:variable>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
				<!-- Flurstuecke selektieren auf denen das Gebaeude steht-->
				<wfs:Query typeName="AX_Flurstueck">
					<ogc:Filter>
						<ogc:And>
							<!-- basierend auf AX_K_Gebaeude_Query.xslt -->
							<xsl:choose>
								<xsl:when test="count($gebaeude/adv:position/*/*)>1">
									<!--  Auf Ebene des zweiten Sternchens findet sich entweder ein patches oder 1..n surfaceMember. --> 
									<ogc:Or>
										<xsl:for-each select="$gebaeude/adv:position/*">
											<ogc:Intersects>
												<ogc:PropertyName>position</ogc:PropertyName> 
												<xsl:copy-of select="." /> 
											</ogc:Intersects>
										</xsl:for-each>
									</ogc:Or>
								</xsl:when>
								<xsl:otherwise>
									<ogc:Intersects>
										<ogc:PropertyName>position</ogc:PropertyName> 
										<xsl:copy-of select="$gebaeude/adv:position"/> 
									</ogc:Intersects>
								</xsl:otherwise>
							</xsl:choose>
							<!-- zeitliche Betrachtung -->
							<ogc:PropertyIsNull>
								<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
							</ogc:PropertyIsNull>
  						</ogc:And>
					</ogc:Filter>
				</wfs:Query>
				<!-- Baubloecke selektieren auf denen das Gebaeude steht-->
				<wfs:Query typeName="AX_Baublock">
					<ogc:Filter>
						<ogc:And>
							<!-- basierend auf AX_K_Gebaeude_Query.xslt -->
							<xsl:choose>
								<xsl:when test="count($gebaeude/adv:position/*/*)>1">
									<!--  Auf Ebene des zweiten Sternchens findet sich entweder ein patches oder 1..n surfaceMember. --> 
									<ogc:Or>
										<xsl:for-each select="$gebaeude/adv:position/*">
											<ogc:Intersects>
												<ogc:PropertyName>position</ogc:PropertyName> 
												<xsl:copy-of select="." /> 
											</ogc:Intersects>
										</xsl:for-each>
									</ogc:Or>
								</xsl:when>
								<xsl:otherwise>
									<ogc:Intersects>
										<ogc:PropertyName>position</ogc:PropertyName> 
										<xsl:copy-of select="$gebaeude/adv:position"/> 
									</ogc:Intersects>
								</xsl:otherwise>
							</xsl:choose>
							<!-- zeitliche Betrachtung -->
							<ogc:PropertyIsNull>
								<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
							</ogc:PropertyIsNull>
  						</ogc:And>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_Gemarkung" /> 
				<!--  Bitte nicht alle selektieren sondern ggf. mit einem Zwischenschritt durch Auswertung der Informationen des/der Flurstueckskennzeichen/s gezielt zugreifen. -->
			</anforderungsmerkmale>
			<profilkennung>
				<xsl:value-of select="$profilkennung"/>
			</profilkennung>
			<antragsnummer>
				<xsl:value-of select="$antragsnummer"/>
			</antragsnummer>
			<folgeverarbeitung>
				<AX_FOLGEVA>
					<datenformat>1000</datenformat>
				</AX_FOLGEVA>
			</folgeverarbeitung>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
