<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
	xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0"
	xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc"
	xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="p1" select="document('AX_Benutzungsauftrag.xml')//adv:profilkennung"/>
		<xsl:variable name="p2" select="document('AX_Benutzungsauftrag.xml')//adv:antragsnummer"/>
		<xsl:variable name="p3" select="document('AX_Benutzungsauftrag.xml')//ogc:Literal"/>
		<xsl:variable name="p4" select="document('E1.xml')//adv:AX_Flurstueck/adv:position/*"/><!-- Hier Bezug auf E1.xml geschaffen (vorher stand nur //adv:AX_Flurstueck/adv:position/*) -->
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
				<wfs:Query typeName="AX_Flurstueck">
					<XlinkPropertyPath>gehoertAnteiligZu/AX_Flurstueck/zeigtAuf</XlinkPropertyPath><!-- Nur falls $p3 das Flst.kennz. des herrschenden Flst. enthält, wird hiermit das dienende mitsamt LBEZoHnr gegriffen. Dienende haben keine LBEZmHnr.-->
					<XlinkPropertyPath>zeigtAuf</XlinkPropertyPath><!-- Falls $p3 das Flst.kennz. des herrschenden oder des dienenden Flst. enthält, werden hiermit die passenden LBEZoHnr gegriffen. -->
					<XlinkPropertyPath>weistAuf</XlinkPropertyPath><!-- Falls $p3 das Flst.kennz. des herrschenden Flst. enthält, werden hiermit die passenden LBEZmHNr gegriffen. -->
					<ogc:Filter>
						<ogc:Or>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>flurstueckskennzeichen</ogc:PropertyName>
								<ogc:Literal><xsl:value-of select="$p3"/></ogc:Literal>
							</ogc:PropertyIsEqualTo>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>gehoertAnteiligZu/AX_Flurstueck/flurstueckskennzeichen</ogc:PropertyName><!-- Hiermit wird erreicht, daß -falls $p3 ein dienendes ist- die herrschenden mit selektiert werden. -->
								<ogc:Literal><xsl:value-of select="$p3"/></ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:Or>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_BesondereFlurstuecksgrenze">
					<ogc:Filter>
						<ogc:And>
							<ogc:Intersects>
								<ogc:PropertyName>position</ogc:PropertyName>
								<xsl:copy-of select="$p4"/><!-- Hier statt value-of copy-of -->
							</ogc:Intersects>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>artDerFlurstuecksgrenze</ogc:PropertyName>
								<ogc:Literal>1000</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:And>
					</ogc:Filter>
				</wfs:Query>
				<wfs:Query typeName="AX_KommunalesGebiet">
					<ogc:Filter>
						<ogc:Intersects>
							<ogc:PropertyName>position</ogc:PropertyName>
							<xsl:copy-of select="$p4"/><!-- Hier statt value-of copy-of -->
						</ogc:Intersects>
					</ogc:Filter>
				</wfs:Query>
				<!-- Besorge ausserdem alle Objekte der weiteren Objektarten. Hinweis: Dies ist natürlich keine realistische Vorgehensweise
				bei Produktionsdatenbeständen. Das Ziel dieser Dokumentation liegt in der Beschreibung der formalen Regeln bei der Ableitung
				der Standardausgaben - nicht in der Vorgabe einer algorithmischen Umsetzung dieser. -->
				<wfs:Query typeName="AX_Gemarkung"/><!-- Bitte nicht alle selektieren sondern ggf. mit einem Zwischenschritt durch Auswertung der Informationen des/der Flurstückskennzeichen/s gezielt zugreifen. -->
				<wfs:Query typeName="AX_Gemeinde"/><!-- Bitte nicht alle selektieren sondern ggf. mit einem Zwischenschritt durch Auswertung der Informationen aus AX_KommunalesGebiet gezielt zugreifen. -->
				<wfs:Query typeName="AX_KreisRegion"/><!-- Bitte nicht alle selektieren sondern ggf. mit einem Zwischenschritt durch Auswertung der Informationen aus AX_KommunalesGebiet gezielt zugreifen. -->
				<wfs:Query typeName="AX_Regierungsbezirk"/><!-- Bitte nicht alle selektieren sondern ggf. mit einem Zwischenschritt durch Auswertung der Informationen aus AX_KommunalesGebiet gezielt zugreifen. -->
				<wfs:Query typeName="AX_LagebezeichnungKatalogeintrag"/><!-- Hier die zu den im Zusammenhang der Selektion des/der Flst. gefundenen LBEZ passenden Katalogeinträge selektieren, keinesfalls jedoch alle. -->
			</anforderungsmerkmale>
			<profilkennung><xsl:value-of select="$p1"/></profilkennung>
			<antragsnummer><xsl:value-of select="$p2"/></antragsnummer>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
