<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0"
	xmlns:gml="http://www.opengis.net/gml/3.2">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Flurstuecksnachweis xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
			<antragsnummer><xsl:value-of select="//adv:antragsnummer"/></antragsnummer>
			<erfolgreich>true</erfolgreich>
			<erlaeuterung/>
			<allgemeineAngaben>
				<AX_K_Benutzungsergebnis>
					<folgeverarbeitung>
						<AX_FOLGEVA>
							<datenformat>1000</datenformat>
						</AX_FOLGEVA>
					</folgeverarbeitung>
					<xsl:apply-templates select="//adv:empfaenger" mode="copy-it"/>
				</AX_K_Benutzungsergebnis>
			</allgemeineAngaben>
			<ausgabekopf>
				<xsl:apply-templates select="document('AX_K_AUSGKOPF_Standard.xml')//adv:AX_K_AUSGKOPF_Standard" mode="copy-it"/>
			</ausgabekopf>
			<xsl:variable name="flurstueck" select="document('E1.xml')//adv:AX_Flurstueck"/>
			<xsl:variable name="land" select="$flurstueck/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:land"/>
			<xsl:variable name="gemnr" select="$flurstueck/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:gemarkungsnummer"/>
			<xsl:variable name="gemarkung" select="document('E1.xml')//adv:AX_Gemarkung[adv:schluesselGesamt=concat($land,$gemnr)]"/>
			<kopf>
				<AX_Kopf_Flurstueck>
					<gemarkungsname><xsl:value-of select="$gemarkung/adv:bezeichnung"/></gemarkungsname>
					<xsl:apply-templates select="$flurstueck/adv:flurstuecksnummer" mode="copy-it"/>
					<xsl:if test="count($flurstueck/adv:flurnummer)=1">
						<xsl:apply-templates select="$flurstueck/adv:flurnummer" mode="copy-it"/>
					</xsl:if>
				</AX_Kopf_Flurstueck>
			</kopf>
			<flurstueck>
				<xsl:apply-templates select="document('AX_K_FLURSTUECK1.xml')//adv:AX_K_FLURSTUECK1" mode="copy-it"/>
			</flurstueck>
			<xsl:call-template name="AX_K_GEBAEUDE__alle">
				<xsl:with-param name="flurstueck" select="document('E1.xml')//adv:AX_Flurstueck"/>
			</xsl:call-template>
			<xsl:for-each select="document('AX_K_BUCHUNGSANGABEN.xml')//adv:AX_K_BUCHUNGSANGABEN">
				<buchung>
					<xsl:apply-templates select="." mode="copy-it"/>
				</buchung>
			</xsl:for-each>
		</AX_Flurstuecksnachweis>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
