/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Transformation.Flattening;

import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericConstraint;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPackageInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ProcessMapEntry;
import de.interactive_instruments.ShapeChange.ProcessRuleSet;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Transformation.Transformer;
import de.interactive_instruments.ShapeChange.TransformerConfiguration;
import de.interactive_instruments.ShapeChange.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flattener
implements Transformer,
MessageSource {
    public static final String TRANSFORMER_NAMESPACE_SUFFIX_PARAMETER = "targetNamespaceSuffix";
    public static final String TRANSFORMER_REMOVE_TYPE_PARAMETER = "removeType";
    public static final String TRANSFORMER_LOWER_CASE_ALIAS_FOR_PROPERTIES = "lowerCaseAliasForProperties";
    public static final String TRANSFORMER_ALIAS_FOR_ENUMERATION_VALUES = "aliasForEnumerationValues";
    public static final String TRANSFORMER_REMOVE_PROPERTY_NAME_AND_ALIAS_COMPONENT = "removePropertyNameAndAliasComponent";

    @Override
    public Model process(Model model, Options options, TransformerConfiguration trfConfig, ShapeChangeResult result) throws ShapeChangeAbortException {
        Set<GenericPackageInfo> appSchemas;
        String targetNamespaceSuffix;
        Map<String, ProcessRuleSet> ruleSets = trfConfig.getRuleSets();
        HashSet<String> rules = new HashSet<String>();
        if (!ruleSets.isEmpty()) {
            for (ProcessRuleSet ruleSet : ruleSets.values()) {
                if (ruleSet.getAdditionalRules() == null) continue;
                rules.addAll(ruleSet.getAdditionalRules());
            }
        }
        GenericModel genModel = new GenericModel(model);
        if (rules.isEmpty()) {
            return genModel;
        }
        if (trfConfig.hasParameter(TRANSFORMER_NAMESPACE_SUFFIX_PARAMETER) && (targetNamespaceSuffix = trfConfig.getParameterValue(TRANSFORMER_NAMESPACE_SUFFIX_PARAMETER)) != null && targetNamespaceSuffix.trim().length() != 0 && (appSchemas = genModel.getAppSchemaPackages()) != null) {
            for (GenericPackageInfo appSchema : appSchemas) {
                String targetNamespace = appSchema.targetNamespace();
                if (targetNamespace.endsWith(targetNamespaceSuffix)) continue;
                for (GenericPackageInfo pi : appSchema.getAllPackages(new HashSet<GenericPackageInfo>())) {
                    if (!pi.targetNamespace().equals(targetNamespace)) continue;
                    pi.setTargetNamespace(targetNamespace + targetNamespaceSuffix);
                }
            }
        }
        if (rules.contains("rule-trf-all-removeType")) {
            this.applyRuleRemoveType(genModel, trfConfig);
        }
        if (rules.contains("rule-trf-prop-flatten-ONINAs")) {
            this.applyRuleONINAs(genModel, trfConfig);
        }
        if (rules.contains("rule-trf-prop-optionality")) {
            this.applyRuleOptionality(genModel, trfConfig);
        }
        if (rules.contains("rule-trf-cls-flatten-inheritance")) {
            this.applyRuleInheritance(genModel, trfConfig);
        }
        if (rules.contains("rule-trf-prop-flatten-multiplicity")) {
            this.applyRuleMultiplicity(genModel, trfConfig);
        }
        if (rules.contains("rule-trf-prop-flatten-types")) {
            this.applyRuleFlattenTypes(genModel, trfConfig);
        }
        if (rules.contains("rule-trf-all-flatten-name")) {
            this.applyRuleAllFlattenName(genModel, trfConfig);
        }
        if (rules.contains("rule-trf-all-flatten-constraints")) {
            this.applyRuleClsFlattenConstraints(genModel, trfConfig);
        }
        if (rules.contains("rule-trf-prop-remove-name-and-alias-component")) {
            this.applyRulePropFlattenRemoveNameAndAliasComponent(genModel, trfConfig);
        }
        if (rules.contains("rule-trf-prop-flatten-homogeneousgeometries")) {
            this.applyRulePropFlattenHomogeneousGeometries(genModel, trfConfig);
        }
        return genModel;
    }

    private void applyRulePropFlattenRemoveNameAndAliasComponent(GenericModel genModel, TransformerConfiguration trfConfig) {
        String[] propNameAliasComponentsToRemove = trfConfig.getListParameterValue(TRANSFORMER_REMOVE_PROPERTY_NAME_AND_ALIAS_COMPONENT);
        if (propNameAliasComponentsToRemove == null || propNameAliasComponentsToRemove.length == 0) {
            return;
        }
        for (GenericPropertyInfo genPi : genModel.getGenProperties().values()) {
            for (String compToRemove : propNameAliasComponentsToRemove) {
                genPi.setName(genPi.name().replaceAll(compToRemove, ""));
                if (genPi.aliasName() == null || genPi.aliasName().length() <= 0) continue;
                genPi.setAliasName(genPi.aliasName().replaceAll(compToRemove, ""));
            }
        }
    }

    private void applyRuleRemoveType(GenericModel genModel, TransformerConfiguration trfConfig) {
        String[] typesToRemove = trfConfig.getListParameterValue(TRANSFORMER_REMOVE_TYPE_PARAMETER);
        if (typesToRemove == null || typesToRemove.length == 0) {
            return;
        }
        for (String typeToRemove : typesToRemove) {
            GenericClassInfo ciToRemove = (GenericClassInfo)genModel.classByName(typeToRemove);
            genModel.remove(ciToRemove);
        }
    }

    private void applyRulePropFlattenHomogeneousGeometries(GenericModel genModel, TransformerConfiguration trfConfig) {
        HashSet<GenericClassInfo> featuretypesToAdd = new HashSet<GenericClassInfo>();
        HashSet<GenericClassInfo> featuretypesToRemove = new HashSet<GenericClassInfo>();
        for (GenericClassInfo genCi : genModel.getGenClasses().values()) {
            HashMap propMapByGeomTypeName = new HashMap();
            HashMap propInfoSetsByGeomProperty = new HashMap();
            if (genCi.category() != 1) continue;
            for (PropertyInfo pi : genCi.properties().values()) {
                String piTypeName = pi.typeInfo().name;
                if (!piTypeName.startsWith("GM_")) continue;
                propInfoSetsByGeomProperty.put((GenericPropertyInfo)pi, new HashSet());
                if (propMapByGeomTypeName.containsKey(piTypeName)) {
                    ((Set)propMapByGeomTypeName.get(piTypeName)).add((GenericPropertyInfo)pi);
                    continue;
                }
                HashSet<GenericPropertyInfo> propInfoSetForGeomTypeName = new HashSet<GenericPropertyInfo>();
                propInfoSetForGeomTypeName.add((GenericPropertyInfo)pi);
                propMapByGeomTypeName.put(piTypeName, propInfoSetForGeomTypeName);
            }
            for (GenericPropertyInfo geomTypeProp : propInfoSetsByGeomProperty.keySet()) {
                if (!geomTypeProp.name().contains(".")) continue;
                String prefix = geomTypeProp.name().substring(0, geomTypeProp.name().lastIndexOf("."));
                for (PropertyInfo pi : genCi.properties().values()) {
                    if (!pi.name().startsWith(prefix) || pi.name() == geomTypeProp.name()) continue;
                    ((Set)propInfoSetsByGeomProperty.get(geomTypeProp)).add((GenericPropertyInfo)pi);
                }
            }
            for (String geomType : propMapByGeomTypeName.keySet()) {
                if (!trfConfig.hasMappingForType(geomType)) continue;
                ProcessMapEntry mapEntry = trfConfig.getMappingForType(geomType);
                if (!mapEntry.hasTargetType() || !mapEntry.hasParam()) {
                    for (GenericPropertyInfo geomTypeProperty : (Set)propMapByGeomTypeName.get(geomType)) {
                        for (GenericPropertyInfo relatedProp : (Set)propInfoSetsByGeomProperty.get(geomTypeProperty)) {
                            genCi.remove(relatedProp);
                            genModel.remove(relatedProp);
                        }
                        genCi.remove(geomTypeProperty);
                        genModel.remove(geomTypeProperty);
                    }
                    continue;
                }
                GenericClassInfo featureCopy = genCi.createCopy(genCi.id() + mapEntry.getParam(), genCi.name() + mapEntry.getParam(), 1);
                if (genCi.aliasName() != null && genCi.aliasName().trim().length() > 0) {
                    featureCopy.setAliasName(genCi.aliasName() + mapEntry.getParam());
                } else {
                    featureCopy.setAliasName(genCi.name() + mapEntry.getParam());
                }
                for (String geomTypeToRemove : propMapByGeomTypeName.keySet()) {
                    if (geomTypeToRemove.equals(geomType)) continue;
                    for (GenericPropertyInfo geomTypePropertyToRemove : (Set)propMapByGeomTypeName.get(geomTypeToRemove)) {
                        for (GenericPropertyInfo relatedPropToRemove : (Set)propInfoSetsByGeomProperty.get(geomTypePropertyToRemove)) {
                            featureCopy.removeByStructuredNumber(relatedPropToRemove.sequenceNumber());
                        }
                        featureCopy.removeByStructuredNumber(geomTypePropertyToRemove.sequenceNumber());
                    }
                }
                for (PropertyInfo piFromFeatureCopy : featureCopy.properties().values()) {
                    Type typeOfPi = piFromFeatureCopy.typeInfo();
                    if (!typeOfPi.name.equals(geomType) || mapEntry.getTargetType().equals(typeOfPi.name)) continue;
                    ClassInfo targetTypeCi = genModel.classByName(mapEntry.getTargetType());
                    typeOfPi.id = targetTypeCi.id();
                    typeOfPi.name = targetTypeCi.name();
                }
                featuretypesToAdd.add(featureCopy);
                featuretypesToRemove.add(genCi);
            }
        }
        for (GenericClassInfo featureCopy : featuretypesToAdd) {
            genModel.addClass(featureCopy);
        }
        for (GenericClassInfo copiedFeature : featuretypesToRemove) {
            genModel.remove(copiedFeature);
        }
    }

    private void applyRuleClsFlattenConstraints(GenericModel genModel, TransformerConfiguration trfConfig) {
        GenericConstraint genCon;
        String textUpdate;
        String text;
        HashSet<GenericConstraint> updateConstraints;
        Vector<Constraint> newConstraints;
        for (GenericClassInfo genCi : genModel.getGenClasses().values()) {
            Vector<Constraint> classConstraints = genCi.constraints();
            newConstraints = new Vector<Constraint>();
            if (classConstraints != null && classConstraints.size() != 0) {
                updateConstraints = new HashSet<GenericConstraint>();
                for (Constraint origCon : classConstraints) {
                    text = origCon.text();
                    if (text == null || !text.contains("/*")) continue;
                    textUpdate = text.replaceAll("/\\*|\\*/[\\w|\\W]*", "");
                    genCon = new GenericConstraint(origCon.contextModelElmt(), origCon.contextModelElmtType(), origCon.name(), origCon.status(), textUpdate);
                    updateConstraints.add(genCon);
                }
                if (updateConstraints.size() > 0) {
                    newConstraints.addAll(updateConstraints);
                }
            }
            genCi.setConstraints(newConstraints);
        }
        for (GenericPropertyInfo genPi : genModel.getGenProperties().values()) {
            Vector<Constraint> propConstraints = genPi.constraints();
            newConstraints = new Vector();
            if (propConstraints != null && propConstraints.size() != 0) {
                updateConstraints = new HashSet();
                for (Constraint origCon : propConstraints) {
                    text = origCon.text();
                    if (text == null || !text.contains("/*")) continue;
                    textUpdate = text.substring(text.indexOf("/*"), text.indexOf("*/") + 2);
                    genCon = new GenericConstraint(origCon.contextModelElmt(), origCon.contextModelElmtType(), origCon.name(), origCon.status(), textUpdate);
                    updateConstraints.add(genCon);
                }
                if (updateConstraints.size() > 0) {
                    newConstraints.addAll(updateConstraints);
                }
            }
            genPi.setConstraints(newConstraints);
        }
    }

    private void applyRuleAllFlattenName(GenericModel genModel, TransformerConfiguration trfConfig) {
        String paramValue;
        String paramValue2;
        boolean lowerCaseAliasForProperties = false;
        if (trfConfig.hasParameter(TRANSFORMER_LOWER_CASE_ALIAS_FOR_PROPERTIES) && (paramValue2 = trfConfig.getParameterValue(TRANSFORMER_LOWER_CASE_ALIAS_FOR_PROPERTIES)) != null) {
            lowerCaseAliasForProperties = Boolean.parseBoolean(paramValue2);
        }
        boolean aliasForEnumerationValues = true;
        if (trfConfig.hasParameter(TRANSFORMER_ALIAS_FOR_ENUMERATION_VALUES) && (paramValue = trfConfig.getParameterValue(TRANSFORMER_ALIAS_FOR_ENUMERATION_VALUES)) != null) {
            aliasForEnumerationValues = Boolean.parseBoolean(paramValue);
        }
        for (GenericClassInfo genCi : genModel.getGenClasses().values()) {
            if (genCi.aliasName() == null || genCi.aliasName().trim().length() <= 0) continue;
            String name = genCi.name();
            String alias = genCi.aliasName().trim();
            if (genCi.hasSupertypes()) {
                for (String supertype : genCi.supertypes()) {
                    GenericClassInfo genCiSupertype = (GenericClassInfo)genModel.classById(supertype);
                    genCiSupertype.updateSubtypeName(name, alias);
                }
            }
            if (genCi.hasSubtypes()) {
                for (String subtype : genCi.subtypes()) {
                    ((GenericClassInfo)genModel.classById(subtype)).updateSupertypeName(name, alias);
                }
            }
            genModel.updateClassName(name, alias);
            for (GenericPropertyInfo genPi : genModel.getGenProperties().values()) {
                if (!genPi.typeInfo().name.equals(name)) continue;
                genPi.typeInfo().name = alias;
            }
            genCi.setName(alias);
            genCi.setAliasName(name);
        }
        for (GenericPropertyInfo genPi : genModel.getGenProperties().values()) {
            if (genPi.aliasName() == null || genPi.aliasName().trim().length() <= 0 || genPi.inClass().category() == 3 && !aliasForEnumerationValues) continue;
            String alias = genPi.aliasName().trim();
            String name = genPi.name();
            if (lowerCaseAliasForProperties) {
                alias = alias.toLowerCase(Locale.ENGLISH);
            }
            genPi.setName(alias);
            genPi.setAliasName(name);
        }
    }

    private void applyRuleFlattenTypes(GenericModel genModel, TransformerConfiguration trfConfig) {
        ShapeChangeResult result = genModel.result();
        HashMap<String, GenericClassInfo> typesToProcessByName = new HashMap<String, GenericClassInfo>();
        for (GenericPropertyInfo genPi : genModel.getGenProperties().values()) {
            int categoryOfInClass = genPi.inClass().category();
            if (categoryOfInClass != 1 && categoryOfInClass != 6 && categoryOfInClass != 6 && categoryOfInClass != 8 && categoryOfInClass != 5) continue;
            Type type = genPi.typeInfo();
            ClassInfo typeCi = genModel.classById(type.id);
            if (typeCi == null) {
                ShapeChangeResult.MessageContext mc = result.addError(this, 131, genPi.inClass().name() + "." + genPi.name(), type.name);
                if (mc == null) continue;
                mc.addDetail(this, 400, "Property", genPi.fullName());
                continue;
            }
            if (typeCi.category() != 5 && typeCi.category() != 6 && typeCi.category() != 6 && typeCi.category() != 8) continue;
            if (trfConfig.hasMappingForType(type.name)) {
                ClassInfo targetCi = genModel.classByName(trfConfig.getMappingForType(type.name).getTargetType());
                type.id = targetCi.id();
                type.name = targetCi.name();
                continue;
            }
            if (!genModel.isInAppSchema(typeCi)) continue;
            typesToProcessByName.put(typeCi.name(), (GenericClassInfo)typeCi);
        }
        for (GenericClassInfo typeToProcess : typesToProcessByName.values()) {
            boolean omitWhenFlattened = false;
            String tvOmitWhenFlattened = typeToProcess.taggedValue("omitWhenFlattened");
            if (tvOmitWhenFlattened != null && tvOmitWhenFlattened.trim().equalsIgnoreCase("true")) {
                omitWhenFlattened = true;
            }
            String separator = ".";
            if (typeToProcess.category() == 8) {
                separator = "-";
            }
            for (GenericClassInfo genCi : genModel.getGenClasses().values()) {
                int categoryOfClass = genCi.category();
                if (categoryOfClass != 1 && categoryOfClass != 6 && categoryOfClass != 6 && categoryOfClass != 8 && categoryOfClass != 5) continue;
                ArrayList<GenericPropertyInfo> propsToAdd = new ArrayList<GenericPropertyInfo>();
                HashSet<GenericPropertyInfo> propsToRemove = new HashSet<GenericPropertyInfo>();
                for (PropertyInfo pi : genCi.properties().values()) {
                    if (!pi.isNavigable()) continue;
                    GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
                    Type type = genPi.typeInfo();
                    if (!typeToProcess.name().equals(type.name)) continue;
                    propsToRemove.add(genPi);
                    int seqNumIndex = 1;
                    for (PropertyInfo typePi : typeToProcess.properties().values()) {
                        GenericPropertyInfo typeGPi = (GenericPropertyInfo)typePi;
                        GenericPropertyInfo copy = typeGPi.createCopy(pi.id() + "." + typeGPi.name());
                        if (copy.documentation() == null || copy.documentation().trim().length() == 0) {
                            copy.setDocumentation(genPi.documentation());
                        }
                        String piName = pi.name();
                        String piAlias = pi.aliasName();
                        String typeGPiName = typeGPi.name();
                        String typeGPiAlias = typeGPi.aliasName();
                        String newAlias = null;
                        String newName = omitWhenFlattened ? (piName.contains(".") ? piName.substring(0, piName.lastIndexOf(".")) + separator + typeGPiName : typeGPiName) : piName + separator + typeGPiName;
                        copy.setName(newName);
                        if (piAlias != null && piAlias.trim().length() > 0) {
                            if (typeGPiAlias != null && typeGPiAlias.trim().length() > 0) {
                                newAlias = omitWhenFlattened ? (piAlias.contains(".") ? piAlias.substring(0, piAlias.lastIndexOf(".")) + separator + typeGPiAlias : typeGPiAlias) : piAlias + separator + typeGPiAlias;
                                copy.setAliasName(newAlias);
                            } else {
                                newAlias = omitWhenFlattened ? (piAlias.contains(".") ? piAlias.substring(0, piAlias.lastIndexOf(".")) + separator + typeGPiName : typeGPiName) : piAlias + separator + typeGPiName;
                                copy.setAliasName(newAlias);
                            }
                        } else if (typeGPiAlias != null && typeGPiAlias.trim().length() > 0) {
                            newAlias = omitWhenFlattened ? (piName.contains(".") ? piName.substring(0, piName.lastIndexOf(".")) + separator + typeGPiAlias : typeGPiAlias) : piName + separator + typeGPiAlias;
                            copy.setAliasName(newAlias);
                        } else {
                            newAlias = omitWhenFlattened ? (piName.contains(".") ? piName.substring(0, piName.lastIndexOf(".")) + separator + typeGPiName : typeGPiName) : piName + separator + typeGPiName;
                            copy.setAliasName(newAlias);
                        }
                        copy.setInClass(genCi);
                        copy.setSequenceNumber(pi.sequenceNumber().createCopyWithSuffix(seqNumIndex));
                        ++seqNumIndex;
                        int minOccurs = typeToProcess.category() == 8 ? 0 : (pi.cardinality().minOccurs < typeGPi.cardinality().minOccurs ? pi.cardinality().minOccurs : typeGPi.cardinality().minOccurs);
                        int piMaxOccurs = pi.cardinality().maxOccurs;
                        int typeGPiMaxOccurs = typeGPi.cardinality().maxOccurs;
                        int maxOccurs = 0;
                        maxOccurs = piMaxOccurs == Integer.MAX_VALUE || typeGPiMaxOccurs == Integer.MAX_VALUE ? Integer.MAX_VALUE : piMaxOccurs * typeGPiMaxOccurs;
                        copy.setCardinality(new Multiplicity(minOccurs, maxOccurs));
                        propsToAdd.add(copy);
                    }
                    genCi.addConstraints(typeToProcess.constraints());
                }
                for (GenericPropertyInfo propToAdd : propsToAdd) {
                    genModel.add(propToAdd, propToAdd.inClass());
                }
                for (GenericPropertyInfo propToRemove : propsToRemove) {
                    ((GenericClassInfo)propToRemove.inClass()).remove(propToRemove);
                    genModel.remove(propToRemove);
                }
            }
        }
        genModel.removeByClassCategory(5);
        genModel.removeByClassCategory(6);
        genModel.removeByClassCategory(6);
        genModel.removeByClassCategory(8);
    }

    private void applyRuleMultiplicity(GenericModel genModel, TransformerConfiguration trfConfig) {
        ShapeChangeResult result = genModel.result();
        int maxOccursGlobal = 3;
        String maxOccParam = trfConfig.getParameterValue("maxOccurs");
        if (maxOccParam != null && maxOccParam.trim().length() > 0 && (maxOccursGlobal = Integer.parseInt(maxOccParam)) < 1) {
            result.addWarning("maxOccurs parameter configured to be " + maxOccursGlobal + " - using default value 3");
            maxOccursGlobal = 3;
        }
        for (GenericClassInfo genCi : genModel.getGenClasses().values()) {
            TreeMap<StructuredNumber, PropertyInfo> properties = genCi.properties();
            if (properties == null || properties.isEmpty()) continue;
            ArrayList<GenericPropertyInfo> propsToAdd = new ArrayList<GenericPropertyInfo>();
            ArrayList<GenericPropertyInfo> propsToRemove = new ArrayList<GenericPropertyInfo>();
            for (PropertyInfo pi : properties.values()) {
                GenericPropertyInfo genPi = (GenericPropertyInfo)pi;
                if (genPi.cardinality().maxOccurs <= 1) continue;
                int maxOccurs = maxOccursGlobal;
                String piMaxOccTaggedValue = genPi.taggedValue("maxOccurs");
                if (piMaxOccTaggedValue != null && piMaxOccTaggedValue.trim().length() > 0) {
                    int piMaxOcc = Integer.parseInt(piMaxOccTaggedValue);
                    if (piMaxOcc < 1) {
                        result.addWarning("maxOccurs tagged value for property " + pi.name() + " in class " + genCi.name() + " was set to " + piMaxOcc + " - using global value: " + maxOccursGlobal);
                    } else {
                        maxOccurs = piMaxOcc;
                    }
                }
                StructuredNumber genPiSeqNum = genPi.sequenceNumber();
                for (int i = 1; i <= maxOccurs; ++i) {
                    GenericPropertyInfo copy = genPi.createCopy(genPi.id() + i);
                    copy.setName(genPi.name() + "_" + i);
                    if (genPi.aliasName() != null && genPi.aliasName().trim().length() > 0) {
                        copy.setAliasName(genPi.aliasName() + "_" + i);
                    }
                    Multiplicity card = new Multiplicity();
                    card.minOccurs = genPi.cardinality().minOccurs;
                    card.maxOccurs = 1;
                    copy.setCardinality(card);
                    copy.setSequenceNumber(genPiSeqNum.createCopyWithSuffix(i));
                    propsToAdd.add(copy);
                    propsToRemove.add(genPi);
                }
            }
            for (GenericPropertyInfo piToAdd : propsToAdd) {
                genModel.add(piToAdd, genCi);
            }
            for (GenericPropertyInfo piToRemove : propsToRemove) {
                genCi.remove(piToRemove);
                genModel.remove(piToRemove);
            }
        }
    }

    private void applyRuleInheritance(GenericModel genModel, TransformerConfiguration trfConfig) {
        Map<String, GenericClassInfo> genClasses = genModel.getGenClasses();
        HashMap<String, GenericClassInfo> genSuperclassesById = new HashMap<String, GenericClassInfo>();
        HashMap<String, GenericClassInfo> genLeafclassesById = new HashMap<String, GenericClassInfo>();
        HashMap<String, GenericClassInfo> genSuperclassUnionsByName = new HashMap<String, GenericClassInfo>();
        for (GenericClassInfo genCls : genClasses.values()) {
            if (genCls.subtypes() != null && genCls.subtypes().size() > 0) {
                genSuperclassesById.put(genCls.id(), genCls);
                continue;
            }
            if (genCls.supertypes() == null || genCls.supertypes().size() <= 0) continue;
            boolean allSupertypesOutsideAppSchema = true;
            for (String supertypeId : genCls.supertypes()) {
                if (!genModel.isInAppSchema(genModel.classById(supertypeId))) continue;
                allSupertypesOutsideAppSchema = false;
                break;
            }
            if (allSupertypesOutsideAppSchema) continue;
            genLeafclassesById.put(genCls.id(), genCls);
        }
        HashSet<String> idsOfUnprocessedSupertypes = new HashSet<String>();
        for (String superclassId : genSuperclassesById.keySet()) {
            idsOfUnprocessedSupertypes.add(superclassId);
        }
        while (!idsOfUnprocessedSupertypes.isEmpty()) {
            for (String idOfgenSuperclass : genSuperclassesById.keySet()) {
                GenericClassInfo superclass = (GenericClassInfo)genSuperclassesById.get(idOfgenSuperclass);
                HashSet<String> supertypesOfSuperclass = superclass.supertypes();
                if (supertypesOfSuperclass == null || supertypesOfSuperclass.size() == 0) {
                    this.copyContentToSubtypes(genModel, superclass);
                    idsOfUnprocessedSupertypes.remove(idOfgenSuperclass);
                    continue;
                }
                boolean noRelevantSupertypes = true;
                for (String supertypeId : supertypesOfSuperclass) {
                    if (!genModel.isInAppSchema(genModel.classById(supertypeId)) || !idsOfUnprocessedSupertypes.contains(supertypeId)) continue;
                    noRelevantSupertypes = false;
                    break;
                }
                if (!noRelevantSupertypes) continue;
                this.copyContentToSubtypes(genModel, superclass);
                idsOfUnprocessedSupertypes.remove(idOfgenSuperclass);
            }
        }
        for (GenericClassInfo genSuperclass : genSuperclassesById.values()) {
            GenericClassInfo genSuperclassUnion = new GenericClassInfo(genModel, genSuperclass.id() + "_union", genSuperclass.name() + "Union", 8);
            if (genSuperclass.aliasName() != null && genSuperclass.aliasName().trim().length() > 0) {
                genSuperclassUnion.setAliasName(genSuperclass.aliasName() + "_U");
            } else {
                genSuperclassUnion.setAliasName(genSuperclass.name() + "Union");
            }
            genSuperclassUnion.setStereotype("union");
            genSuperclassUnion.setPkg(genSuperclass.pkg());
            ((GenericPackageInfo)genSuperclassUnion.pkg()).addClass(genSuperclassUnion);
            HashSet<GenericClassInfo> subclasses = this.getAllSubclasses(genSuperclass);
            int seqNumIndex = 1;
            for (GenericClassInfo genCiSub : subclasses) {
                if (genCiSub.isAbstract()) continue;
                GenericPropertyInfo genSuperClassUnionProp = new GenericPropertyInfo(genModel, genSuperclassUnion.id() + "_choice" + seqNumIndex, this.toLowerCase(genCiSub.name()), genCiSub.category());
                if (genCiSub.aliasName() != null && genCiSub.aliasName().trim().length() > 0) {
                    genSuperClassUnionProp.setAliasName(this.toLowerCase(genCiSub.aliasName()));
                } else {
                    genSuperClassUnionProp.setAliasName(this.toLowerCase(genCiSub.name()));
                }
                genSuperClassUnionProp.setStereotype("property");
                genSuperClassUnionProp.setSequenceNumber(new StructuredNumber("" + seqNumIndex));
                Type propType = new Type();
                propType.id = genCiSub.id();
                propType.name = genCiSub.name();
                genSuperClassUnionProp.setTypeInfo(propType);
                HashMap<String, String> taggedValues = new HashMap<String, String>();
                taggedValues.put("gmlImplementedByNilReason", "false");
                taggedValues.put("inlineOrByReference", "inlineOrByReference");
                taggedValues.put("isMetadata", "false");
                taggedValues.put("maxOccurs", "");
                taggedValues.put("modified", "");
                taggedValues.put("name", "");
                taggedValues.put("physicalQuantity", "");
                taggedValues.put("profiles", "");
                taggedValues.put("recommendedMeasure", "");
                taggedValues.put("securityClassification", "");
                taggedValues.put("sequenceNumber", "" + seqNumIndex);
                taggedValues.put("xsdEncodingRule", "");
                genSuperClassUnionProp.setTaggedValues(taggedValues);
                genSuperClassUnionProp.setInClass(genSuperclassUnion);
                genSuperclassUnion.addProperty(genSuperClassUnionProp, GenericModel.PropertyCopyDuplicatBehaviorIndicator.ADD);
                ++seqNumIndex;
            }
            genSuperclassUnionsByName.put(genSuperclassUnion.name(), genSuperclassUnion);
            genModel.addClass(genSuperclassUnion);
        }
        for (GenericPropertyInfo genPi : genModel.getGenProperties().values()) {
            Type type = genPi.typeInfo();
            if (!genSuperclassesById.containsKey(type.id)) continue;
            genPi.setCategoryOfValue(8);
            type.name = type.name + "Union";
            type.id = ((GenericClassInfo)genSuperclassUnionsByName.get(type.name)).id();
        }
        for (GenericClassInfo leafCi : genLeafclassesById.values()) {
            leafCi.setBaseClass(null);
            leafCi.setSupertypes(new HashSet<String>());
        }
        for (GenericClassInfo superclass : genSuperclassesById.values()) {
            if (superclass.isAbstract()) {
                genModel.remove(superclass);
                continue;
            }
            superclass.setBaseClass(null);
            superclass.setSupertypes(new HashSet<String>());
            superclass.setSubtypes(new HashSet<String>());
        }
    }

    private String toLowerCase(String s) {
        if (s == null) {
            return null;
        }
        String c = "" + Character.toLowerCase(s.charAt(0));
        if (s.length() == 1) {
            return c;
        }
        return c + s.substring(1, s.length());
    }

    private HashSet<GenericClassInfo> getAllSubclasses(GenericClassInfo genCi) {
        if (genCi.subtypes() == null || genCi.subtypes().isEmpty()) {
            return null;
        }
        HashSet<GenericClassInfo> subtypes = new HashSet<GenericClassInfo>();
        for (String subtypeId : genCi.subtypes()) {
            GenericClassInfo subtype = (GenericClassInfo)genCi.model().classById(subtypeId);
            subtypes.add(subtype);
            HashSet<GenericClassInfo> subsubtypes = this.getAllSubclasses(subtype);
            if (subsubtypes == null) continue;
            subtypes.addAll(subsubtypes);
        }
        return subtypes;
    }

    private void copyContentToSubtypes(GenericModel genModel, GenericClassInfo genCi) {
        HashSet<String> subtypeIds = genCi.subtypes();
        if (subtypeIds == null || subtypeIds.isEmpty()) {
            return;
        }
        for (String subtypeId : subtypeIds) {
            GenericClassInfo subtype = (GenericClassInfo)genCi.model().classById(subtypeId);
            genModel.copyClassContent(genCi, subtype, GenericModel.PropertyCopyPositionIndicator.PROPERTY_COPY_TOP, GenericModel.PropertyCopyDuplicatBehaviorIndicator.IGNORE);
        }
    }

    private void applyRuleOptionality(GenericModel genModel, TransformerConfiguration trfConfig) {
        ShapeChangeResult result = genModel.result();
        String[] typesToEnforceOptionality = trfConfig.getListParameterValue("enforceOptionality");
        if (typesToEnforceOptionality == null) {
            result.addWarning("No type information given via configuration parameter 'enforceOptionality'.");
            return;
        }
        HashSet<String> typeSet = new HashSet<String>(Arrays.asList(typesToEnforceOptionality));
        for (GenericPropertyInfo genPi : genModel.getGenProperties().values()) {
            if (!typeSet.contains(genPi.typeInfo().name)) continue;
            genPi.cardinality().minOccurs = 0;
        }
    }

    private void applyRuleONINAs(GenericModel model, TransformerConfiguration trfConfig) {
        Options options = model.options();
        HashSet<PackageInfo> appSchemas = model.schemas(options.parameter("appSchemaName"));
        if (appSchemas == null || appSchemas.size() == 0) {
            return;
        }
        for (PackageInfo appSchema : appSchemas) {
            boolean booleanReasonProcessed = false;
            GenericClassInfo booleanWithOninaCi = null;
            Type booleanWithOninaType = null;
            HashSet<ClassInfo> appSchemaClasses = model.classes(appSchema);
            if (appSchemaClasses == null || appSchemaClasses.size() == 0) continue;
            HashMap<String, Type> reasonTypeIdToValueType = new HashMap<String, Type>();
            HashMap<String, GenericClassInfo> reasonUnionsByName = new HashMap<String, GenericClassInfo>();
            HashSet<String> reasonTypeValueTypeNames = new HashSet<String>();
            for (ClassInfo ci : appSchemaClasses) {
                if (!ci.name().endsWith("Reason")) continue;
                reasonUnionsByName.put(ci.name(), (GenericClassInfo)ci);
                if (!ci.name().equals("BooleanReason") || booleanWithOninaCi != null) continue;
                booleanWithOninaCi = new GenericClassInfo(model, ci.id() + "_ONINARep", "BooleanWithONINA", 3);
                booleanWithOninaCi.setAliasName("");
                booleanWithOninaCi.setDocumentation("");
                HashMap<String, String> taggedValues = new HashMap<String, String>();
                taggedValues.put("modified", "");
                taggedValues.put("xsdEncodingRule", ci.taggedValue("xsdEncodingRule"));
                booleanWithOninaCi.setTaggedValues(taggedValues);
                booleanWithOninaCi.setXmlSchemaType(null);
                booleanWithOninaCi.setIncludePropertyType(ci.includePropertyType());
                booleanWithOninaCi.setIncludeByValuePropertyType(ci.includeByValuePropertyType());
                booleanWithOninaCi.setIsCollection(false);
                booleanWithOninaCi.setAsDictionary(false);
                booleanWithOninaCi.setAsGroup(false);
                booleanWithOninaCi.setAsCharacterString(false);
                booleanWithOninaCi.setHasNilReason(false);
                booleanWithOninaCi.setPkg(ci.pkg());
                ((GenericPackageInfo)ci.pkg()).addClass(booleanWithOninaCi);
                booleanWithOninaCi.setIsAbstract(false);
                booleanWithOninaCi.setIsLeaf(false);
                booleanWithOninaCi.setAssocInfo(null);
                booleanWithOninaCi.setSupertypes(new HashSet<String>());
                booleanWithOninaCi.setSubtypes(null);
                booleanWithOninaCi.setBaseClass(null);
                booleanWithOninaCi.setProperties(ci.properties());
                TreeMap<StructuredNumber, PropertyInfo> properties = new TreeMap<StructuredNumber, PropertyInfo>();
                StructuredNumber s1 = new StructuredNumber("1");
                GenericPropertyInfo falseEnumProp = this.createEnumerationProperty(model, "false", "1000", booleanWithOninaCi, s1);
                falseEnumProp.setDocumentation("-- Definition --\r\nFalse");
                properties.put(s1, falseEnumProp);
                StructuredNumber s2 = new StructuredNumber("2");
                GenericPropertyInfo trueEnumProp = this.createEnumerationProperty(model, "true", "1001", booleanWithOninaCi, s2);
                trueEnumProp.setDocumentation("-- Definition --\r\nTrue");
                properties.put(s2, trueEnumProp);
                StructuredNumber s3 = new StructuredNumber("3");
                GenericPropertyInfo noInfoProp = this.createEnumerationProperty(model, "noInformation", "-999999", booleanWithOninaCi, s3);
                noInfoProp.setDocumentation("-- Definition --\r\nNo Information");
                properties.put(s3, noInfoProp);
                booleanWithOninaCi.setProperties(properties);
                booleanWithOninaCi.setConstraints(new Vector<Constraint>());
                booleanWithOninaCi.setSuppressed(false);
                booleanWithOninaCi.setAsDictionaryGml33(false);
                model.addClass(booleanWithOninaCi);
                booleanWithOninaType = new Type();
                booleanWithOninaType.id = booleanWithOninaCi.id();
                booleanWithOninaType.name = booleanWithOninaCi.name();
            }
            if (reasonUnionsByName.isEmpty() && !booleanReasonProcessed) continue;
            for (GenericClassInfo reasonUnionCi : reasonUnionsByName.values()) {
                PropertyInfo valueP = reasonUnionCi.property("value");
                if (valueP == null) continue;
                Type valuePType = valueP.typeInfo();
                if (valuePType.name.equalsIgnoreCase("Boolean")) {
                    reasonTypeIdToValueType.put(reasonUnionCi.id(), booleanWithOninaType);
                    continue;
                }
                reasonTypeIdToValueType.put(reasonUnionCi.id(), valuePType);
                reasonTypeValueTypeNames.add(valuePType.name);
            }
            for (String typeName : reasonTypeValueTypeNames) {
                ClassInfo ci = model.classByName(typeName);
                if (ci.category() != 3) continue;
                GenericClassInfo genCi = (GenericClassInfo)ci;
                int maxSequenceNumber = Integer.MIN_VALUE;
                Set<StructuredNumber> enumSeqNumbers = genCi.properties().keySet();
                for (StructuredNumber strucNum : enumSeqNumbers) {
                    if (strucNum.components[0] <= maxSequenceNumber) continue;
                    maxSequenceNumber = strucNum.components[0];
                }
                StructuredNumber snNoInformation = new StructuredNumber(++maxSequenceNumber);
                GenericPropertyInfo noInfoProp = this.createEnumerationProperty(model, "noInformation", "-999999", genCi, snNoInformation);
                noInfoProp.setDocumentation("-- Definition --\r\nNo Information");
                model.add(noInfoProp, genCi);
                StructuredNumber snNotApplicable = new StructuredNumber(++maxSequenceNumber);
                GenericPropertyInfo notApplicProp = this.createEnumerationProperty(model, "notApplicable", "998", genCi, snNotApplicable);
                notApplicProp.setDocumentation("-- Definition --\r\nNot Applicable");
                model.add(notApplicProp, genCi);
                StructuredNumber snOther = new StructuredNumber(++maxSequenceNumber);
                GenericPropertyInfo otherProp = this.createEnumerationProperty(model, "other", "999", genCi, snOther);
                otherProp.setDocumentation("-- Definition --\r\nOther");
                model.add(otherProp, genCi);
            }
            for (ClassInfo ci : appSchemaClasses) {
                Collection<PropertyInfo> ciProperties = ci.properties().values();
                if (ciProperties == null || ciProperties.size() == 0) continue;
                for (PropertyInfo pi : ciProperties) {
                    String propTypeId = pi.typeInfo().id;
                    if (!reasonTypeIdToValueType.containsKey(propTypeId)) continue;
                    ((GenericPropertyInfo)pi).setTypeInfo((Type)reasonTypeIdToValueType.get(propTypeId));
                }
            }
            model.remove(reasonUnionsByName.values());
        }
    }

    private GenericPropertyInfo createEnumerationProperty(GenericModel model, String enumName, String enumAlias, ClassInfo ci, StructuredNumber strucNum) {
        GenericPropertyInfo enumPi = new GenericPropertyInfo(model, ci.id() + "_" + enumName, enumName, -1);
        if (enumAlias != null && enumAlias.trim().length() > 0) {
            enumPi.setAliasName(enumAlias);
        } else {
            enumPi.setAliasName(enumName);
        }
        enumPi.setDocumentation("");
        enumPi.setStereotype(null);
        HashMap<String, String> taggedValues = new HashMap<String, String>();
        taggedValues.put("name", "");
        taggedValues.put("profiles", "");
        enumPi.setTaggedValues(taggedValues);
        enumPi.setDerived(false);
        enumPi.setAttribute(true);
        Type enumPiType = new Type();
        enumPiType.id = model.classByName("CharacterString").id();
        enumPiType.name = "CharacterString";
        enumPi.setTypeInfo(enumPiType);
        enumPi.setNavigable(false);
        enumPi.setOrdered(false);
        enumPi.setComposition(false);
        enumPi.setAggregation(false);
        Multiplicity mult = new Multiplicity();
        mult.maxOccurs = 1;
        mult.minOccurs = 1;
        enumPi.setCardinality(mult);
        enumPi.setInitialValue(null);
        enumPi.setInlineOrByReference("inlineOrByReference");
        enumPi.setDefaultCodeSpace("");
        enumPi.setMetadata(false);
        enumPi.setReverseProperty(null);
        enumPi.setInClass(ci);
        enumPi.setSequenceNumber(strucNum);
        enumPi.setImplementedByNilReason(false);
        enumPi.setVoidable(false);
        enumPi.setConstraints(new Vector<Constraint>());
        enumPi.setAssociation(null);
        enumPi.setRestriction(false);
        enumPi.setNilReasonAllowed(false);
        return enumPi;
    }

    @Override
    public String message(int mnr) {
        switch (mnr) {
            case 131: {
                return "(Flattener.java) The type '$2$' of property '$1$' was not found.";
            }
            case 400: {
                return "(Flattener.java) Context: $1$ '$2$'";
            }
        }
        return null;
    }
}

