/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Target.XmlSchema;

import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.MessageSource;
import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.SchematronConstraintNode;
import de.interactive_instruments.ShapeChange.Target.XmlSchema.SchematronSchema;
import de.interactive_instruments.ShapeChange.Type;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsdDocument
implements MessageSource {
    protected Document document = null;
    protected Element root = null;
    protected Comment hook = null;
    protected Options options = null;
    public ShapeChangeResult result = null;
    protected Model model = null;
    protected String name = null;
    protected Vector<String> includes = new Vector();
    protected Vector<String> imports = new Vector();
    protected boolean printed = false;
    protected String targetNamespace = null;
    protected String outputDirectory;
    protected String okstraKeyValuePropertyType;
    protected String okstraKeyValueBaseType;
    protected String okstraObjectRefType;
    protected String okstraPrefix;
    protected String okstra;

    public XsdDocument(PackageInfo pi, Model m, Options o, ShapeChangeResult r, String n) throws ShapeChangeAbortException, ParserConfigurationException {
        String s;
        this.options = o;
        this.result = r;
        this.model = m;
        this.name = n;
        this.outputDirectory = this.options.parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "outputDirectory");
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter("outputDirectory");
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter(".");
        }
        this.okstraKeyValuePropertyType = (s = this.options.parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "okstraKeyValuePropertyType")) != null ? s : "okstra-basis:KeyValuePropertyType";
        s = this.options.parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "okstraKeyValueBaseType");
        this.okstraKeyValueBaseType = s != null ? s : "gml:AbstractFeatureType";
        s = this.options.parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "okstraObjectRefType");
        this.okstraObjectRefType = s != null ? s : "okstra-basis:ObjectRefType";
        this.okstraPrefix = this.okstraKeyValuePropertyType.split(":")[0];
        s = this.options.parameter("de.interactive_instruments.ShapeChange.Target.XmlSchema.XmlSchema", "okstra");
        this.okstra = s != null ? s : "false";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.document = db.newDocument();
        this.root = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "schema");
        this.document.appendChild(this.root);
        this.addAttribute(this.root, "xmlns", "http://www.w3.org/2001/XMLSchema");
        this.addAttribute(this.root, "elementFormDefault", "qualified");
        this.addAttribute(this.root, "version", pi.version());
        this.targetNamespace = pi.targetNamespace();
        this.addAttribute(this.root, "targetNamespace", this.targetNamespace);
        this.addAttribute(this.root, "xmlns:" + pi.xmlns(), this.targetNamespace);
        this.addStandardAnnotation(this.root, pi);
        this.hook = this.addHook(this.root);
    }

    protected void addAttribute(Element e, String name, String value) {
        Attr att = this.document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    protected Comment addHook(Element e) {
        Comment e1 = this.document.createComment("XML Schema document created by ShapeChange - http://shapechange.net/");
        e.appendChild(e1);
        return e1;
    }

    protected void addStandardAnnotation(Element e, Info info) {
        String txt;
        Element e1 = null;
        if (!info.matches("rule-xsd-all-no-documentation") && (txt = info.documentation()) != null) {
            txt = txt.trim();
            txt = txt.replaceAll("\r\n", "\n");
            if (!(txt = txt.replaceAll("\r", "\n")).isEmpty()) {
                e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "documentation");
                e1.appendChild(this.document.createTextNode(txt));
            }
        }
        Element e2 = null;
        if (info instanceof PackageInfo) {
            String profile;
            PackageInfo pi = (PackageInfo)info;
            if (info.matches("rule-xsd-pkg-gmlProfileSchema") && this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && (profile = pi.gmlProfileSchema()) != null && !profile.trim().isEmpty()) {
                if (e2 == null) {
                    e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                }
                Element e0 = this.document.createElementNS(this.options.GML_NS, "gmlProfileSchema");
                e2.appendChild(e0);
                e0.appendChild(this.document.createTextNode(profile));
            }
        }
        if (info instanceof PropertyInfo) {
            Element e3;
            PropertyInfo propi = (PropertyInfo)info;
            ClassInfo ci = this.model.classById(propi.typeInfo().id);
            if (ci != null) {
                if (info.matches("rule-xsd-prop-targetElement") && this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && (propi.inlineOrByReference().equals("byreference") || ci.category() == 12 && ci.matches("rule-xsd-cls-okstra-fid"))) {
                    if (e2 == null) {
                        e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                    }
                    e3 = this.document.createElementNS(this.options.GML_NS, "targetElement");
                    e2.appendChild(e3);
                    e3.appendChild(this.document.createTextNode(ci.qname()));
                }
                if (ci.matches("rule-xsd-cls-codelist-asDictionaryGml33") && ci.asDictionaryGml33()) {
                    if (e2 == null) {
                        e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                    }
                    e3 = this.document.createElementNS(Options.GMLEXR_NS, "targetCodeList");
                    e2.appendChild(e3);
                    e3.appendChild(this.document.createTextNode(ci.name()));
                    this.addImport("gmlexr", Options.GMLEXR_NS);
                }
            }
            if (info.matches("rule-xsd-prop-reverseProperty") && this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && propi.reverseProperty() != null && propi.reverseProperty().isNavigable()) {
                if (e2 == null) {
                    e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                }
                e3 = this.document.createElementNS(this.options.GML_NS, "reversePropertyName");
                e2.appendChild(e3);
                e3.appendChild(this.document.createTextNode(propi.reverseProperty().qname()));
            }
            if (info.matches("rule-xsd-prop-defaultCodeSpace") && !propi.defaultCodeSpace().isEmpty() && this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                if (e2 == null) {
                    e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                }
                e3 = this.document.createElementNS(this.options.GML_NS, "defaultCodeSpace");
                e2.appendChild(e3);
                e3.appendChild(this.document.createTextNode(propi.defaultCodeSpace()));
            }
        }
        if (info.matches("rule-xsd-all-tagged-values")) {
            HashMap<String, String> taggedValues = info.taggedValues(this.options.parameter("representTaggedValues"));
            for (Map.Entry<String, String> entry : taggedValues.entrySet()) {
                String s = entry.getValue();
                if (s.trim().length() <= 0) continue;
                if (e2 == null) {
                    e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                }
                Element e3 = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/AppInfo", "taggedValue");
                this.addAttribute(e3, "tag", entry.getKey());
                e3.appendChild(this.document.createTextNode(s));
                e2.appendChild(e3);
                this.addImport("sc", "http://www.interactive-instruments.de/ShapeChange/AppInfo");
            }
        }
        if (e1 != null || e2 != null) {
            Element e0 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
            if (e1 != null) {
                e0.appendChild(e1);
            }
            if (e2 != null) {
                e0.appendChild(e2);
            }
            e.appendChild(e0);
        }
    }

    private boolean classHasObjectType(ClassInfo ci) {
        int cat = ci.category();
        return cat == 5 || cat == 8 && !ci.asGroup() || cat == 1 || cat == 6 || cat == 12 && ci.matches("rule-xsd-cls-okstra-fid");
    }

    private boolean classHasObjectElement(ClassInfo ci) {
        int cat = ci.category();
        if (ci.matches("rule-xsd-cls-enum-object-element") && (cat == 3 || cat == 2)) {
            return true;
        }
        return this.classHasObjectType(ci);
    }

    private boolean classHasIdentity(ClassInfo ci) {
        int cat = ci.category();
        return cat == 4 || cat == 1 || cat == 6 || cat == 12 && ci.matches("rule-xsd-cls-okstra-fid");
    }

    private String addImport(String qname) {
        this.result.addDebug(null, 10022, qname);
        String s = qname.trim();
        if (s.isEmpty()) {
            return null;
        }
        int idx = s.indexOf(":");
        if (idx > 0) {
            String nsabr = s.substring(0, idx);
            this.addImport(nsabr, this.options.fullNamespace(nsabr));
        }
        return s;
    }

    protected String mapBaseType(ClassInfo ci) {
        String s = null;
        MapEntry me = this.options.baseMapEntry(ci.name(), ci.encodingRule("xsd"));
        if (me == null) {
            if (this.classHasObjectType(ci)) {
                s = this.typeName(ci, true);
            } else {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 117, ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            }
        } else {
            s = this.addImport(me.p1);
        }
        return s;
    }

    protected String mapElement(ClassInfo ci) {
        if (ci == null) {
            return null;
        }
        String s = null;
        MapEntry me = this.options.elementMapEntry(ci.name(), ci.encodingRule("xsd"));
        if (me == null) {
            if (this.classHasObjectElement(ci)) {
                s = this.elementName(ci, true);
            } else {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 119, ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            }
        } else {
            s = this.addImport(me.p1);
        }
        return s;
    }

    private String elementName(ClassInfo ci, boolean qualified) {
        if (ci != null) {
            if (ci.pkg() == null || ci.pkg().xmlns() == null) {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 132, ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            } else {
                if (ci.matches("rule-xsd-all-naming-19139")) {
                    if (ci.isAbstract()) {
                        return (qualified ? ci.pkg().xmlns() : "") + ":Abstract" + ci.name();
                    }
                    return qualified ? ci.qname() : ci.name();
                }
                if (ci.matches("rule-xsd-all-naming-gml") || ci.matches("rule-xsd-all-naming-swe")) {
                    return qualified ? ci.qname() : ci.name();
                }
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 154, "object element", ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            }
        }
        return null;
    }

    private String typeName(ClassInfo ci, boolean qualified) {
        if (ci != null) {
            if (ci.pkg() == null || ci.pkg().xmlns() == null) {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 132, ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            } else {
                if (ci.matches("rule-xsd-all-naming-19139")) {
                    if (ci.category() == 2) {
                        return qualified ? "gco:CodeListValue_Type" : "CodeListValue_Type";
                    }
                    if (ci.isAbstract()) {
                        return (qualified ? ci.pkg().xmlns() : "") + ":Abstract" + ci.name() + "_Type";
                    }
                    return (qualified ? ci.qname() : ci.name()) + "_Type";
                }
                if (ci.matches("rule-xsd-all-naming-gml") || ci.matches("rule-xsd-all-naming-swe")) {
                    return (qualified ? ci.qname() : ci.name()) + "Type";
                }
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 154, "type", ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            }
        }
        return null;
    }

    private String propertyTypeName(ClassInfo ci, boolean qualified) {
        if (ci != null) {
            if (ci.pkg() == null || ci.pkg().xmlns() == null) {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 132, ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            } else {
                if (ci.matches("rule-xsd-all-naming-19139")) {
                    if (ci.isAbstract()) {
                        return (qualified ? ci.pkg().xmlns() : "") + ":Abstract" + ci.name() + "_PropertyType";
                    }
                    return (qualified ? ci.qname() : ci.name()) + "_PropertyType";
                }
                if (ci.matches("rule-xsd-all-naming-gml") || ci.matches("rule-xsd-all-naming-swe")) {
                    return (qualified ? ci.qname() : ci.name()) + "PropertyType";
                }
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 154, "property type", ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            }
        }
        return null;
    }

    private String defaultSubstitutionGroup(ClassInfo ci) {
        int cat = ci.category();
        if (ci.matches("rule-xsd-cls-no-gml-types")) {
            return null;
        }
        if (ci.matches("rule-xsd-all-naming-gml")) {
            this.addImport("gml", this.options.fullNamespace("gml"));
            if (cat == 6) {
                if (this.options.GML_NS.equals("http://www.opengis.net/gml")) {
                    return "gml:_Feature";
                }
                if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                    return "gml:AbstractGML";
                }
            } else if (cat == 5 || cat == 8) {
                if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                    return "gml:AbstractObject";
                }
                if (this.options.GML_NS.equals("http://www.opengis.net/gml")) {
                    return "gml:_Object";
                }
            } else if (cat == 1) {
                if (this.options.GML_NS.equals("http://www.opengis.net/gml")) {
                    return "gml:_Feature";
                }
                if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                    return "gml:AbstractFeature";
                }
            }
        } else if (ci.matches("rule-xsd-all-naming-swe")) {
            this.addImport("swe", this.options.fullNamespace("swe"));
            if (cat == 6) {
                return "swe:AbstractSWE";
            }
        } else if (ci.matches("rule-xsd-all-naming-19139")) {
            this.addImport("gco", this.options.fullNamespace("gco"));
            if (cat == 2 || cat == 3) {
                return "gco:CharacterString";
            }
            return "gco:AbstractObject";
        }
        return null;
    }

    private String defaultBaseType(ClassInfo ci) {
        int cat = ci.category();
        if (ci.matches("rule-xsd-cls-no-gml-types")) {
            return null;
        }
        if (ci.matches("rule-xsd-all-naming-gml")) {
            this.addImport("gml", this.options.fullNamespace("gml"));
            if (cat == 6) {
                if (this.options.GML_NS.equals("http://www.opengis.net/gml")) {
                    return "gml:AbstractFeatureType";
                }
                if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                    return "gml:AbstractGMLType";
                }
            } else if (cat == 1) {
                if (this.options.GML_NS.equals("http://www.opengis.net/gml")) {
                    return "gml:AbstractFeatureType";
                }
                if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                    return "gml:AbstractFeatureType";
                }
            }
        } else if (ci.matches("rule-xsd-all-naming-swe")) {
            this.addImport("swe", this.options.fullNamespace("swe"));
            if (cat == 6) {
                return "swe:AbstractSWEType";
            }
        } else if (ci.matches("rule-xsd-all-naming-19139")) {
            this.addImport("gco", this.options.fullNamespace("gco"));
            return "gco:AbstractObject_Type";
        }
        return null;
    }

    public void pObjectElement(ClassInfo ci, ClassInfo cibase) {
        String s;
        if (ci.pkg() == null || ci.pkg().xmlns() == null) {
            ShapeChangeResult.MessageContext mc = this.result.addError(null, 132, ci.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
            return;
        }
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        this.document.getDocumentElement().appendChild(e4);
        this.addAttribute(e4, "name", this.elementName(ci, false));
        this.addAttribute(e4, "type", this.typeName(ci, true));
        if (ci.isAbstract()) {
            this.addAttribute(e4, "abstract", "true");
        }
        if (cibase == null) {
            String s2 = this.defaultSubstitutionGroup(ci);
            if (s2 != null) {
                this.addAttribute(e4, "substitutionGroup", s2);
            }
        } else if (this.classHasObjectElement(cibase) && (s = this.mapElement(cibase)) != null) {
            this.addAttribute(e4, "substitutionGroup", s);
            this.addImport(cibase.pkg().xmlns(), cibase.pkg().targetNamespace());
        }
        this.addStandardAnnotation(e4, ci);
    }

    public Element pComplexType(ClassInfo ci, ClassInfo cibase, SchematronSchema schDoc) {
        ShapeChangeResult.MessageContext mc;
        Element e3;
        int cat = ci.category();
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", this.typeName(ci, false));
        if (ci.isAbstract()) {
            this.addAttribute(e1, "abstract", "true");
        }
        if (cibase == null && (cat == 5 || cat == 8) && ci.matches("rule-xsd-all-naming-gml")) {
            e3 = e1;
        } else {
            String s = null;
            if (cibase == null) {
                s = this.defaultBaseType(ci);
            } else {
                s = this.mapBaseType(cibase);
                if (s == null) {
                    this.result.addError(null, 158);
                    s = "fixme:fixme";
                }
                this.addImport(cibase.pkg().xmlns(), cibase.pkg().targetNamespace());
            }
            if (s != null) {
                Element e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
                e1.appendChild(e2);
                e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                e2.appendChild(e3);
                this.addAttribute(e3, "base", s);
            } else if (cibase != null) {
                mc = this.result.addError(null, 121, cibase == null ? "<unknown>" : cibase.name(), this.typeName(ci, false));
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci == null ? "<unknown>" : ci.fullName());
                }
                e3 = e1;
            } else {
                e3 = e1;
            }
        }
        Element ret = null;
        if (cat == 8 && ci.matches("rule-xsd-cls-union-as-choice")) {
            ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice");
        } else if (ci.matches("rule-xsd-cls-sequence")) {
            ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
            if (ci.matches("rule-xsd-cls-mixin-classes")) {
                this.addMixinProperties(ci, ret, schDoc);
            } else if (ci.matches("rule-xsd-cls-mixin-classes-as-group")) {
                this.addGroupReferences(ci, ret);
            }
        } else {
            mc = this.result.addError(null, 155, ci.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
            ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
        }
        e3.appendChild(ret);
        return ret;
    }

    public void pValueTypeGroup(ClassInfo ci) {
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "group");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", ci.name());
        this.addStandardAnnotation(e1, ci);
        Element e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice");
        e1.appendChild(e2);
        for (PropertyInfo propi : ci.properties().values()) {
            ShapeChangeResult.MessageContext mc;
            ClassInfo vci = this.model.classById(propi.typeInfo().id);
            if (vci != null) {
                if (this.classHasObjectElement(vci)) {
                    String s = this.mapElement(vci);
                    if (s != null) {
                        Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
                        e2.appendChild(e3);
                        this.addAttribute(e3, "ref", s);
                        this.addImport(vci.pkg().xmlns(), vci.pkg().targetNamespace());
                        continue;
                    }
                    ShapeChangeResult.MessageContext mc2 = this.result.addError(null, 166, vci.name(), ci.name());
                    if (mc2 == null) continue;
                    mc2.addDetail(null, 400, "Property", propi.fullName());
                    continue;
                }
                mc = this.result.addError(null, 166, vci.name(), ci.name());
                if (mc == null) continue;
                mc.addDetail(null, 400, "Property", propi.fullName());
                continue;
            }
            mc = this.result.addError(null, 131, propi.name(), propi.typeInfo().name);
            if (mc == null) continue;
            mc.addDetail(null, 400, "Property", propi.fullName());
        }
    }

    public Element pGroup(ClassInfo ci, ClassInfo cibase) {
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "group");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", ci.name() + "Group");
        this.addStandardAnnotation(e1, ci);
        Element ret = null;
        if (ci.category() == 8 && ci.matches("rule-xsd-cls-union-as-choice")) {
            ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice");
        } else if (ci.category() == 8 && ci.matches("rule-xsd-cls-union-as-group-property-type")) {
            ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice");
        } else if (ci.matches("rule-xsd-cls-sequence")) {
            ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
            if (ci.matches("rule-xsd-cls-mixin-classes-as-group")) {
                this.addGroupReferences(ci, ret);
            }
        } else {
            ShapeChangeResult.MessageContext mc = this.result.addError(null, 155, ci.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
            ret = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
        }
        e1.appendChild(ret);
        return ret;
    }

    private void addGroupReferences(ClassInfo ci, Element e) {
        HashSet<String> st = ci.supertypes();
        if (st != null && ci.matches("rule-xsd-cls-mixin-classes-as-group")) {
            for (String sid : st) {
                ClassInfo cix = this.model.classById(sid);
                if (cix == null || cix.category() != 4 && (!cix.matches("rule-xsd-cls-no-abstract-classes") || !cix.isAbstract())) continue;
                Element eg = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "group");
                e.appendChild(eg);
                this.addAttribute(eg, "ref", cix.qname() + "Group");
                this.addGroupReferences(cix, e);
            }
        }
    }

    private void addMixinProperties(ClassInfo ci, Element e, SchematronSchema schDoc) {
        HashSet<String> st = ci.supertypes();
        if (st != null && ci.matches("rule-xsd-cls-mixin-classes")) {
            for (String sid : st) {
                ClassInfo cix = this.model.classById(sid);
                if (cix == null || cix.category() != 4 && (!cix.matches("rule-xsd-cls-no-abstract-classes") || !cix.isAbstract())) continue;
                this.processLocalProperties(cix, e, schDoc);
                this.addMixinProperties(cix, e, schDoc);
            }
        }
    }

    private void addElements(Element e, HashSet<ClassInfo> v) {
        ClassInfo[] clArr = new ClassInfo[v.size()];
        v.toArray(clArr);
        Arrays.sort(clArr, new Comparator<ClassInfo>(){

            @Override
            public int compare(ClassInfo ci1, ClassInfo ci2) {
                return ci1.name().compareTo(ci2.name());
            }
        });
        for (int cidx = 0; cidx < clArr.length; ++cidx) {
            ClassInfo ci = clArr[cidx];
            String s = this.mapElement(ci);
            if (s == null) continue;
            Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            e.appendChild(e3);
            this.addAttribute(e3, "ref", s);
            this.addImport(ci.pkg().xmlns(), ci.pkg().targetNamespace());
        }
    }

    private HashSet<ClassInfo> subtypes(ClassInfo ci) {
        HashSet<ClassInfo> res = new HashSet<ClassInfo>();
        if (ci.subtypes() != null) {
            Iterator<String> i = ci.subtypes().iterator();
            while (i.hasNext()) {
                ClassInfo cix = this.model.classById(i.next());
                if (cix != null && (cix.category() == 4 || cix.matches("rule-xsd-cls-no-abstract-classes") && cix.isAbstract())) {
                    res.addAll(this.subtypes(cix));
                    continue;
                }
                res.add(cix);
            }
        }
        return res;
    }

    public void pPropertyTypeWithSubtypes(ClassInfo ci) {
        if (ci.matches("rule-xsd-cls-noPropertyType") && !ci.includePropertyType()) {
            return;
        }
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", this.propertyTypeName(ci, false));
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice");
        e1.appendChild(e4);
        this.addAttribute(e4, "minOccurs", "0");
        this.addElements(e4, this.subtypes(ci));
        e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
        e1.appendChild(e4);
        if (ci.matches("rule-xsd-cls-no-gml-types")) {
            this.addAttribute(e4, "ref", "xlink:simpleAttrs");
            this.addImport("xlink", this.options.fullNamespace("xlink"));
        } else {
            this.addAttribute(e4, "ref", "gml:AssociationAttributeGroup");
            this.addImport("gml", this.options.fullNamespace("gml"));
            if (this.options.GML_NS.equals("http://www.opengis.net/gml/GML3.2")) {
                e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                e1.appendChild(e4);
                this.addAttribute(e4, "ref", "gml:OwnershipAttributeGroup");
            }
        }
    }

    public void pPropertyTypes(ClassInfo ci) {
        if (ci.matches("rule-xsd-cls-noPropertyType") && !ci.includePropertyType()) {
            return;
        }
        boolean rnobase = ci.matches("rule-xsd-cls-no-gml-types");
        boolean rgml = ci.matches("rule-xsd-cls-standard-gml-property-types");
        boolean r19139 = ci.matches("rule-xsd-cls-standard-19139-property-types");
        boolean rswe = ci.matches("rule-xsd-cls-standard-swe-property-types");
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", this.propertyTypeName(ci, false));
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
        e1.appendChild(e4);
        Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        e4.appendChild(e3);
        String s = this.elementName(ci, true);
        if (s != null) {
            this.addAttribute(e3, "ref", s);
        }
        if (rgml && !rnobase) {
            if (this.classHasIdentity(ci)) {
                this.addAttribute(e4, "minOccurs", "0");
                e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                e1.appendChild(e3);
                this.addAttribute(e3, "ref", "gml:AssociationAttributeGroup");
                this.addImport("gml", this.options.fullNamespace("gml"));
                if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                    e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                    e1.appendChild(e3);
                    this.addAttribute(e3, "ref", "gml:OwnershipAttributeGroup");
                }
            }
        } else if (rswe) {
            if (this.classHasIdentity(ci)) {
                this.addAttribute(e4, "minOccurs", "0");
                e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                e1.appendChild(e3);
                this.addAttribute(e3, "ref", "swe:AssociationAttributeGroup");
                this.addImport("swe", this.options.fullNamespace("swe"));
            }
        } else if (r19139) {
            this.addAttribute(e4, "minOccurs", "0");
            int cat = ci.category();
            if (cat != 2 && cat != 3) {
                e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                this.addAttribute(e3, "ref", "gco:ObjectReference");
                e1.appendChild(e3);
            }
            this.addImport("gco", this.options.fullNamespace("gco"));
            e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
            e1.appendChild(e3);
            this.addAttribute(e3, "ref", "gco:nilReason");
        } else {
            this.addAttribute(e4, "minOccurs", "0");
            e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
            e1.appendChild(e3);
            this.addAttribute(e3, "ref", "xlink:simpleAttrs");
            this.addImport("xlink", this.options.fullNamespace("xlink"));
        }
        if (ci.matches("rule-xsd-cls-byValuePropertyType") && this.classHasIdentity(ci) && ci.includeByValuePropertyType()) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
            this.document.getDocumentElement().appendChild(e1);
            this.addAttribute(e1, "name", ci.name() + "PropertyByValueType");
            e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
            e1.appendChild(e4);
            e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            e4.appendChild(e3);
            if (ci.pkg() == null || ci.pkg().xmlns() == null) {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 132, ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            } else {
                this.addAttribute(e3, "ref", ci.qname());
            }
        }
    }

    public void pPropertyTypeWithGroup(ClassInfo ci) {
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", this.propertyTypeName(ci, false));
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
        e1.appendChild(e4);
        this.addAttribute(e4, "minOccurs", "0");
        this.addElements(e4, this.subtypes(ci));
        Element e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "group");
        e4.appendChild(e5);
        this.addAttribute(e5, "ref", ci.qname());
        this.addAttribute(e4, "minOccurs", "0");
        e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
        e1.appendChild(e5);
        this.addAttribute(e5, "ref", "swe:AssociationAttributeGroup");
        this.addImport("swe", this.options.fullNamespace("swe"));
    }

    public void pOKSTRAKEYPropertyType(ClassInfo ci) {
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", ci.name() + "PropertyType");
        Element e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
        e1.appendChild(e2);
        Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
        this.addAttribute(e3, "base", this.okstraKeyValuePropertyType);
        this.addImport(this.okstraPrefix, this.options.fullNamespace(this.okstraPrefix));
        e2.appendChild(e3);
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
        e3.appendChild(e4);
        Element e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        this.addAttribute(e5, "ref", ci.qname());
        this.addAttribute(e5, "minOccurs", "0");
        e4.appendChild(e5);
        e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        this.addAttribute(e5, "name", ci.name());
        this.document.getDocumentElement().appendChild(e5);
        Element e6 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        e5.appendChild(e6);
        Element e7 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
        e6.appendChild(e7);
        Element e8 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
        this.addAttribute(e8, "base", this.okstraKeyValueBaseType);
        e7.appendChild(e8);
        Element e9 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
        e8.appendChild(e9);
        Element e10 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        e9.appendChild(e10);
        this.addAttribute(e10, "name", "Kennung");
        this.addAttribute(e10, "type", "string");
        e10 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
        e9.appendChild(e10);
        this.addAttribute(e10, "name", "Langtext");
        this.addAttribute(e10, "type", "string");
    }

    private Element pAnonymousBasicType(ClassInfo ci) {
        Element e1 = null;
        String id = ci.id();
        if (id != null) {
            String base = ci.taggedValue("base");
            String length = ci.taggedValue("length");
            if (length == null) {
                length = ci.taggedValue("maxLength");
            }
            String pattern = ci.taggedValue("pattern");
            String min = ci.taggedValue("rangeMinimum");
            String max = ci.taggedValue("rangeMaximum");
            String typecontent = "simple/simple";
            if (base == null && ci.supertypes() != null) {
                Iterator<String> i = ci.supertypes().iterator();
                while (i.hasNext()) {
                    ClassInfo cix = this.model.classById(i.next());
                    if (cix == null) continue;
                    MapEntry me = this.options.baseMapEntry(cix.name(), ci.encodingRule("xsd"));
                    if (me != null) {
                        base = me.p1;
                        typecontent = me.p2;
                    }
                    if (base != null) continue;
                    base = cix.qname() + "Type";
                }
            }
            if (base != null) {
                Element e5;
                Element e3;
                Element e4;
                if (typecontent.equals("complex/simple")) {
                    e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                    this.addStandardAnnotation(e1, ci);
                    e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleContent");
                    e1.appendChild(e4);
                    e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                    e4.appendChild(e3);
                } else if (typecontent.equals("simple/simple")) {
                    e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
                    this.addStandardAnnotation(e1, ci);
                    e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                    e1.appendChild(e3);
                } else {
                    e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                    this.addStandardAnnotation(e1, ci);
                    e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
                    e1.appendChild(e4);
                    e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                    e4.appendChild(e3);
                }
                this.addAttribute(e3, "base", base);
                if (this.facetSupported("totalDigits", base) && length != null) {
                    e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "totalDigits");
                    e3.appendChild(e5);
                    this.addAttribute(e5, "value", length);
                }
                if (this.facetSupported("maxLength", base) && length != null) {
                    e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "maxLength");
                    e3.appendChild(e5);
                    this.addAttribute(e5, "value", length);
                }
                if (this.facetSupported("pattern", base) && pattern != null) {
                    e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "pattern");
                    e3.appendChild(e5);
                    this.addAttribute(e5, "value", pattern);
                }
                if (this.facetSupported("minInclusive", base) && min != null) {
                    e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "minInclusive");
                    e3.appendChild(e5);
                    this.addAttribute(e5, "value", min);
                }
                if (this.facetSupported("maxInclusive", base) && max != null) {
                    e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "maxInclusive");
                    e3.appendChild(e5);
                    this.addAttribute(e5, "value", max);
                }
            } else {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 122, ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            }
        } else {
            ShapeChangeResult.MessageContext mc = this.result.addError(null, 123, ci.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
        }
        return e1;
    }

    private boolean facetSupported(String facet, String base) {
        if (facet.equals("minInclusive") || facet.equals("maxInclusive") || facet.equals("minExclusive") || facet.equals("maxExclusive")) {
            if (base.equals("integer")) {
                return true;
            }
            if (base.equals("positiveInteger")) {
                return true;
            }
            if (base.equals("negativeInteger")) {
                return true;
            }
            if (base.equals("nonNegativeInteger")) {
                return true;
            }
            if (base.equals("nonPositiveInteger")) {
                return true;
            }
            if (base.equals("long")) {
                return true;
            }
            if (base.equals("unsignedLong")) {
                return true;
            }
            if (base.equals("int")) {
                return true;
            }
            if (base.equals("unsignedInt")) {
                return true;
            }
            if (base.equals("short")) {
                return true;
            }
            if (base.equals("unsignedShort")) {
                return true;
            }
            if (base.equals("byte")) {
                return true;
            }
            if (base.equals("unsignedByte")) {
                return true;
            }
            if (base.equals("decimal")) {
                return true;
            }
            if (base.equals("float")) {
                return true;
            }
            if (base.equals("double")) {
                return true;
            }
            if (base.equals("duration")) {
                return true;
            }
            if (base.equals("dateTime")) {
                return true;
            }
            if (base.equals("date")) {
                return true;
            }
            if (base.equals("time")) {
                return true;
            }
            if (base.equals("gYear")) {
                return true;
            }
            if (base.equals("gYearMonth")) {
                return true;
            }
            if (base.equals("gMonth")) {
                return true;
            }
            if (base.equals("gMonthDay")) {
                return true;
            }
            if (base.equals("gDay")) {
                return true;
            }
        }
        if (facet.equals("totalDigits")) {
            if (base.equals("integer")) {
                return true;
            }
            if (base.equals("positiveInteger")) {
                return true;
            }
            if (base.equals("negativeInteger")) {
                return true;
            }
            if (base.equals("nonNegativeInteger")) {
                return true;
            }
            if (base.equals("nonPositiveInteger")) {
                return true;
            }
            if (base.equals("long")) {
                return true;
            }
            if (base.equals("unsignedLong")) {
                return true;
            }
            if (base.equals("int")) {
                return true;
            }
            if (base.equals("unsignedInt")) {
                return true;
            }
            if (base.equals("short")) {
                return true;
            }
            if (base.equals("unsignedShort")) {
                return true;
            }
            if (base.equals("byte")) {
                return true;
            }
            if (base.equals("unsignedByte")) {
                return true;
            }
            if (base.equals("decimal")) {
                return true;
            }
        }
        if (facet.equals("maxLength")) {
            if (base.equals("string")) {
                return true;
            }
            if (base.equals("normalizedString")) {
                return true;
            }
            if (base.equals("token")) {
                return true;
            }
            if (base.equals("base64Binary")) {
                return true;
            }
            if (base.equals("hexBinary")) {
                return true;
            }
            if (base.equals("Name")) {
                return true;
            }
            if (base.equals("QName")) {
                return true;
            }
            if (base.equals("NCName")) {
                return true;
            }
            if (base.equals("anyURI")) {
                return true;
            }
            if (base.equals("language")) {
                return true;
            }
            if (base.equals("ID")) {
                return true;
            }
            if (base.equals("IDREF")) {
                return true;
            }
            if (base.equals("IDREFS")) {
                return true;
            }
            if (base.equals("ENTITY")) {
                return true;
            }
            if (base.equals("ENTITIES")) {
                return true;
            }
            if (base.equals("NOTATION")) {
                return true;
            }
            if (base.equals("NMTOKEN")) {
                return true;
            }
            if (base.equals("NMTOKENS")) {
                return true;
            }
        }
        if (facet.equals("pattern")) {
            return true;
        }
        return base.contains(":");
    }

    public void pGlobalBasicType(ClassInfo ci) {
        Element e1 = this.pAnonymousBasicType(ci);
        if (e1 != null) {
            this.document.getDocumentElement().appendChild(e1);
            this.addAttribute(e1, "name", this.typeName(ci, false));
        } else {
            ShapeChangeResult.MessageContext mc = this.result.addError(null, 124, this.typeName(ci, false));
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
        }
    }

    private Element pAnonymousEnumeration(ClassInfo ci) {
        int cat;
        ClassInfo nci;
        HashSet<String> sids;
        ClassInfo cci;
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
        this.addStandardAnnotation(e1, ci);
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
        e1.appendChild(e4);
        this.addAttribute(e4, "base", "string");
        LinkedList<ClassInfo> classes = new LinkedList<ClassInfo>();
        classes.add(ci);
        LinkedList<ClassInfo> tasks = new LinkedList<ClassInfo>();
        if (ci.matches("rule-xsd-cls-enum-supertypes")) {
            tasks.add(ci);
            while (tasks.size() > 0) {
                cci = (ClassInfo)tasks.removeFirst();
                sids = cci.supertypes();
                if (sids == null) continue;
                for (String id : sids) {
                    nci = this.model.classById(id);
                    if (nci == null || (cat = nci.category()) != 3 && cat != 2) continue;
                    tasks.addLast(nci);
                    classes.addFirst(nci);
                }
            }
        }
        if (ci.matches("rule-xsd-cls-enum-subtypes")) {
            tasks.add(ci);
            while (tasks.size() > 0) {
                cci = (ClassInfo)tasks.removeFirst();
                sids = cci.subtypes();
                if (sids == null) continue;
                for (String id : sids) {
                    nci = this.model.classById(id);
                    if (nci == null || (cat = nci.category()) != 3 && cat != 2) continue;
                    tasks.addLast(nci);
                    classes.addLast(nci);
                }
            }
        }
        for (ClassInfo cci2 : classes) {
            for (PropertyInfo atti : cci2.properties().values()) {
                Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "enumeration");
                e4.appendChild(e3);
                String val = atti.name();
                String doc = atti.documentation().trim();
                if (atti.initialValue() != null) {
                    val = atti.initialValue();
                    if (doc == null || doc.equals("")) {
                        doc = atti.name();
                    }
                }
                this.addAttribute(e3, "value", val);
                this.addStandardAnnotation(e3, atti);
            }
        }
        return e1;
    }

    public void pGlobalEnumeration(ClassInfo ci) {
        Element e1 = this.pAnonymousEnumeration(ci);
        if (e1 != null) {
            this.document.getDocumentElement().appendChild(e1);
            this.addAttribute(e1, "name", this.typeName(ci, false));
        } else {
            ShapeChangeResult.MessageContext mc = this.result.addError(null, 126, this.typeName(ci, false));
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
        }
    }

    public void pGlobalCodeList(ClassInfo ci) {
        Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", this.typeName(ci, false));
        this.addStandardAnnotation(e1, ci);
        Element e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "union");
        e1.appendChild(e4);
        this.addAttribute(e4, "memberTypes", ci.qname() + "EnumerationType " + ci.qname() + "OtherType");
        e1 = this.pAnonymousEnumeration(ci);
        if (e1 != null) {
            this.document.getDocumentElement().appendChild(e1);
            this.addAttribute(e1, "name", ci.name() + "EnumerationType");
        } else {
            ShapeChangeResult.MessageContext mc = this.result.addError(null, 156, ci.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
        }
        e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
        this.document.getDocumentElement().appendChild(e1);
        this.addAttribute(e1, "name", ci.name() + "OtherType");
        e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
        e1.appendChild(e4);
        this.addAttribute(e4, "base", "string");
        Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "pattern");
        e4.appendChild(e3);
        this.addAttribute(e3, "value", "other: \\w{2,}");
    }

    private boolean includeProperty(PropertyInfo pi) {
        return !(!pi.isNavigable() || pi.isRestriction() || pi.matches("rule-xsd-prop-exclude-derived") && pi.isDerived() || pi.matches("rule-xsd-all-notEncoded") && pi.encodingRule("xsd").equalsIgnoreCase("notencoded"));
    }

    public boolean processLocalProperty(ClassInfo ci, PropertyInfo pi, Element sequenceOrChoice, Multiplicity m, SchematronSchema schDoc) {
        if (this.includeProperty(pi)) {
            Element property = this.addProperty(ci, pi, m, schDoc);
            if (property.getLocalName().equals("attribute") || property.getLocalName().equals("attributeGroup")) {
                sequenceOrChoice.getParentNode().appendChild(property);
            } else {
                sequenceOrChoice.appendChild(property);
            }
            return pi.isAggregation() || pi.isComposition();
        }
        return false;
    }

    public boolean processLocalProperties(ClassInfo ci, Element sequenceOrChoice, SchematronSchema schDoc) {
        int res = 0;
        this.result.addDebug(null, 10023, ci.name());
        for (PropertyInfo pi : ci.properties().values()) {
            if (!this.processLocalProperty(ci, pi, sequenceOrChoice, null, schDoc)) continue;
            ++res;
        }
        AssociationInfo ai = ci.isAssocClass();
        if (ai != null && ai.matches("rule-xsd-rel-association-classes")) {
            Multiplicity m = new Multiplicity();
            if (this.processLocalProperty(ci, ai.end1(), sequenceOrChoice, m, schDoc)) {
                ++res;
            }
            if (this.processLocalProperty(ci, ai.end2(), sequenceOrChoice, m, schDoc)) {
                ++res;
            }
        }
        return res == 1;
    }

    private void addMinMaxOccurs(Element e, Multiplicity m) {
        if (m.minOccurs != 1) {
            this.addAttribute(e, "minOccurs", Integer.valueOf(m.minOccurs).toString());
        }
        if (m.maxOccurs == Integer.MAX_VALUE) {
            this.addAttribute(e, "maxOccurs", "unbounded");
        } else if (m.maxOccurs != 1) {
            this.addAttribute(e, "maxOccurs", Integer.valueOf(m.maxOccurs).toString());
        }
    }

    protected Element addProperty(ClassInfo cibase, PropertyInfo pi, Multiplicity m, SchematronSchema schDoc) {
        String[] parts;
        Element e1;
        boolean inAssocClass = true;
        if (m == null) {
            m = pi.cardinality();
            inAssocClass = false;
        }
        ClassInfo ci = this.model.classById(pi.typeInfo().id);
        String asAtt = pi.taggedValue("xsdAsAttribute");
        if (asAtt == null) {
            asAtt = pi.taggedValue("asXMLAttribute");
        }
        String asAttRef = "";
        String asAttGroupRef = "";
        if (ci != null) {
            MapEntry me = this.options.attributeMapEntry(ci.name(), cibase.encodingRule("xsd"));
            if (me != null) {
                asAttRef = me.rule;
            }
            if ((me = this.options.attributeGroupMapEntry(ci.name(), cibase.encodingRule("xsd"))) != null) {
                asAttGroupRef = me.rule;
            }
        }
        if (ci != null && ci.category() == 8 && ci.asGroup() && ci.matches("rule-xsd-cls-union-asGroup")) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "group");
            this.addStandardAnnotation(e1, pi);
            if (ci.pkg() == null || ci.pkg().xmlns() == null) {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 132, ci.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            } else {
                this.addAttribute(e1, "ref", ci.qname() + "Group");
                this.addImport(ci.pkg().xmlns(), ci.pkg().targetNamespace());
            }
            this.addMinMaxOccurs(e1, m);
        } else if (!asAttRef.equals("")) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
            this.addAttribute(e1, "ref", asAttRef);
            int idx = asAttRef.indexOf(":");
            if (idx > 0) {
                String nsabr = asAttRef.substring(0, idx);
                this.addImport(nsabr, this.options.fullNamespace(nsabr));
            }
            if (m.minOccurs == 1) {
                this.addAttribute(e1, "use", "required");
            }
        } else if (!asAttGroupRef.equals("")) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
            this.addAttribute(e1, "ref", asAttGroupRef);
            int idx = asAttGroupRef.indexOf(":");
            if (idx > 0) {
                String nsabr = asAttGroupRef.substring(0, idx);
                this.addImport(nsabr, this.options.fullNamespace(nsabr));
            }
        } else if (pi.matches("rule-xsd-prop-xsdAsAttribute") && asAtt != null && asAtt.equalsIgnoreCase("true") && m.maxOccurs == 1 && !inAssocClass) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
            this.addStandardAnnotation(e1, pi);
            this.addAttribute(e1, "name", pi.name());
            if (m.minOccurs == 1) {
                this.addAttribute(e1, "use", "required");
            }
            this.mapPropertyType(cibase, pi, e1, false, schDoc);
            if (pi.initialValue() != null && !pi.initialValue().isEmpty() && pi.matches("rule-xsd-prop-initialValue")) {
                if (pi.initialValue().indexOf("{frozen}") > 0) {
                    parts = pi.initialValue().split("\\{frozen\\}");
                    this.addAttribute(e1, "fixed", this.stripQuotes(parts[0].trim()));
                } else {
                    this.addAttribute(e1, "default", this.stripQuotes(pi.initialValue()));
                }
            }
        } else if (cibase.matches("rule-xsd-cls-suppress") && cibase.stereotype().equalsIgnoreCase("adeelement")) {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            this.addStandardAnnotation(e1, pi);
            this.addAttribute(e1, "name", pi.name());
            if (ci != null && ci.asCharacterString()) {
                this.addAttribute(e1, "type", "string");
            } else {
                this.mapPropertyType(cibase, pi, e1, inAssocClass, schDoc);
            }
            ClassInfo cis = cibase.unsuppressedSupertype(true);
            if (cis != null) {
                String s = this.mapElement(cis);
                if (s != null) {
                    this.addAttribute(e1, "substitutionGroup", s.replace(":_", ":").replace(":", ":_GenericApplicationPropertyOf"));
                    this.addImport(cis.pkg().xmlns(), cis.pkg().targetNamespace());
                }
            } else {
                ShapeChangeResult.MessageContext mc = this.result.addError(null, 145, cibase.name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", cibase.fullName());
                }
            }
        } else {
            e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            this.addStandardAnnotation(e1, pi);
            this.addAttribute(e1, "name", pi.name());
            if (pi.nilReasonAllowed() && pi.matches("rule-xsd-prop-nilReasonAllowed") || pi.voidable() && pi.matches("rule-xsd-prop-nillable")) {
                this.addAttribute(e1, "nillable", "true");
            }
            if (pi.initialValue() != null && !pi.initialValue().isEmpty() && pi.matches("rule-xsd-prop-initialValue")) {
                if (pi.initialValue().indexOf("{frozen}") > 0) {
                    parts = pi.initialValue().split("\\{frozen\\}");
                    this.addAttribute(e1, "fixed", this.stripQuotes(parts[0].trim()));
                } else {
                    this.addAttribute(e1, "default", this.stripQuotes(pi.initialValue()));
                }
            }
            boolean multiplicityAlreadySet = false;
            if (ci != null && ci.asCharacterString() && ci.matches("rule-xsd-cls-union-asCharacterString")) {
                this.addAttribute(e1, "type", "string");
            } else {
                multiplicityAlreadySet = this.mapPropertyType(cibase, pi, e1, inAssocClass, schDoc);
            }
            if (!multiplicityAlreadySet) {
                if (ci != null && ci.isKindOf("historisches_Objekt") && ci.matches("rule-xsd-cls-okstra-lifecycle")) {
                    m.maxOccurs = Integer.MAX_VALUE;
                }
                this.addMinMaxOccurs(e1, m);
            }
            if (pi.matches("rule-xsd-prop-length-size-pattern") && (pi.taggedValue("length") != null || pi.taggedValue("size") != null && pi.taggedValue("pattern") != null)) {
                Element simpleType = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
                e1.appendChild(simpleType);
                Element restriction = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                this.addAttribute(restriction, "base", "string");
                e1.removeAttribute("type");
                simpleType.appendChild(restriction);
                Element concreteRestriction = null;
                if (pi.taggedValue("length") != null) {
                    concreteRestriction = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "maxLength");
                    this.addAttribute(concreteRestriction, "value", pi.taggedValue("length"));
                } else if (pi.taggedValue("size") != null && pi.taggedValue("pattern") != null) {
                    concreteRestriction = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "pattern");
                    this.addAttribute(concreteRestriction, "value", pi.taggedValue("pattern") + "{" + pi.taggedValue("size") + "}");
                }
                if (concreteRestriction != null) {
                    restriction.appendChild(concreteRestriction);
                }
            }
        }
        return e1;
    }

    protected boolean mapPropertyType(ClassInfo cibase, PropertyInfo propi, Element e, boolean inAssocClass, SchematronSchema schDoc) {
        ShapeChangeResult.MessageContext mc;
        String pName = cibase.name() + "." + propi.name();
        boolean mustBeSimple = e.getLocalName().equals("attribute");
        Element e1 = null;
        Type ti = propi.typeInfo();
        MapEntry me = this.options.typeMapEntry(ti.name, cibase.encodingRule("xsd"));
        if (me != null) {
            if (me.rule.equals("direct")) {
                Element e2;
                String propertyTypeName;
                boolean addNilReason = me.p3 != null && me.p3.equals("false") && (propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable"));
                boolean softtyped = false;
                if (propi.matches("rule-xsd-prop-soft-typed")) {
                    String s = propi.taggedValue("soft-typed");
                    boolean bl = softtyped = s != null && s.equalsIgnoreCase("true");
                }
                if (propi.matches("rule-xsd-prop-att-map-entry") && !mustBeSimple) {
                    String asAttGroupRef;
                    MapEntry mea = this.options.attributeMapEntry(ti.name, cibase.encodingRule("xsd"));
                    String asAttRef = mea != null ? mea.rule : "";
                    MapEntry meag = this.options.attributeGroupMapEntry(ti.name, cibase.encodingRule("xsd"));
                    String string = asAttGroupRef = meag != null ? meag.rule : "";
                    if (!asAttRef.equals("") || !asAttGroupRef.equals("")) {
                        String nsabr;
                        int ix;
                        Element e22;
                        e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                        e.appendChild(e1);
                        if (addNilReason) {
                            e22 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                            e1.appendChild(e22);
                            this.addNilReason(e22);
                        }
                        if (softtyped) {
                            e22 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                            e1.appendChild(e22);
                            this.addName(e22);
                        }
                        if (!asAttRef.equals("")) {
                            e22 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                            this.addAttribute(e22, "ref", asAttRef);
                            ix = asAttRef.indexOf(":");
                            if (ix > 0) {
                                nsabr = asAttRef.substring(0, ix);
                                this.addImport(nsabr, this.options.fullNamespace(nsabr));
                            }
                            e1.appendChild(e22);
                        }
                        if (!asAttGroupRef.equals("")) {
                            e22 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                            this.addAttribute(e22, "ref", asAttGroupRef);
                            ix = asAttGroupRef.indexOf(":");
                            if (ix > 0) {
                                nsabr = asAttGroupRef.substring(0, ix);
                                this.addImport(nsabr, this.options.fullNamespace(nsabr));
                            }
                            e1.appendChild(e22);
                        }
                        return false;
                    }
                }
                if ((propertyTypeName = this.addImport(me.p1)) == null) {
                    this.result.addError(null, 158);
                    propertyTypeName = "fixme:fixme";
                }
                if (propi.matches("rule-xsd-prop-xsdAsAttribute")) {
                    String asAtt = propi.taggedValue("xsdAsAttribute");
                    if (asAtt == null) {
                        asAtt = propi.taggedValue("asXMLAttribute");
                    }
                    if (asAtt != null) {
                        boolean complexContent;
                        boolean bl = complexContent = me.p2 == null || me.p2.equals("complex");
                        if (mustBeSimple && (complexContent || addNilReason || softtyped)) {
                            ShapeChangeResult.MessageContext mc2 = this.result.addError(null, 128, pName);
                            if (mc2 != null) {
                                mc2.addDetail(null, 400, "Property", propi.fullName());
                            }
                            if (complexContent) {
                                return false;
                            }
                            addNilReason = false;
                            softtyped = false;
                        }
                    }
                }
                if (!addNilReason && !softtyped) {
                    this.addAttribute(e, "type", propertyTypeName);
                    return false;
                }
                e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                e.appendChild(e1);
                Element e4 = me.p2 == null || me.p2.equals("complex") ? this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent") : this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleContent");
                e1.appendChild(e4);
                Element e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                e4.appendChild(e3);
                this.addAttribute(e3, "base", propertyTypeName);
                if (addNilReason) {
                    e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                    e3.appendChild(e2);
                    this.addNilReason(e2);
                }
                if (softtyped) {
                    e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                    e3.appendChild(e2);
                    this.addName(e2);
                }
            } else if (me.rule.equals("propertyType")) {
                this.addAnonymousPropertyType(e, propi, me.p1, null, false);
            } else if (me.rule.equals("metadataPropertyType")) {
                this.addAnonymousPropertyType(e, propi, me.p1, null, true);
            }
            return false;
        }
        ClassInfo ci = this.model.classById(ti.id);
        if (ci == null && (ci = this.model.classByName(ti.name)) != null && (mc = this.result.addError(null, 135, pName)) != null) {
            mc.addDetail(null, 400, "Property", propi.fullName());
        }
        if (!propi.isAttribute() && !inAssocClass) {
            AssociationInfo ai = propi.association();
            ClassInfo aci = null;
            if (ai != null) {
                aci = ai.assocClass();
            }
            if (aci != null) {
                ci = aci;
            }
        }
        if (ci == null) {
            mc = this.result.addError(null, 131, pName, ti.name);
            if (mc != null) {
                mc.addDetail(null, 400, "Property", propi.fullName());
            }
            return false;
        }
        if (ci.category() == 9 && ci.matches("rule-xsd-cls-union-direct")) {
            for (PropertyInfo pi2 : ci.properties().values()) {
                if (!pi2.isNavigable() || pi2.isRestriction() || pi2.implementedByNilReason()) continue;
                if (ci.hasNilReason()) {
                    pi2.nilReasonAllowed(true);
                }
                this.addAttribute(e, "nillable", "true");
                this.mapPropertyType(cibase, pi2, e, false, schDoc);
                Multiplicity m1 = propi.cardinality();
                Multiplicity m2 = pi2.cardinality();
                m2.minOccurs = m1.minOccurs;
                this.addMinMaxOccurs(e, m2);
                return true;
            }
            mc = this.result.addError(null, 129, ci.name(), pName);
            if (mc != null) {
                mc.addDetail(null, 400, "Class", ci.fullName());
            }
        }
        if (ci.category() == 11 && ci.matches("rule-xsd-cls-okstra-schluesseltabelle")) {
            this.addAttribute(e, "type", this.propertyTypeName(ci, true));
            this.addImport(ci.pkg().xmlns(), ci.pkg().targetNamespace());
        } else if (ci.category() == 12 && ci.matches("rule-xsd-cls-okstra-fid")) {
            this.addAttribute(e, "type", this.okstraObjectRefType);
            this.addImport(this.okstraPrefix, this.options.fullNamespace(this.okstraPrefix));
        } else if (this.classHasObjectElement(ci)) {
            if (ci.pkg() == null || ci.pkg().xmlns() == null) {
                mc = this.result.addError(null, 141, ci.name(), propi.inClass().name());
                if (mc != null) {
                    mc.addDetail(null, 400, "Class", ci.fullName());
                }
            } else if (ci.matches("rule-xsd-cls-standard-19139-property-types")) {
                this.addAttribute(e, "type", this.propertyTypeName(ci, true));
                this.addImport(ci.pkg().xmlns(), ci.pkg().targetNamespace());
                if (ci.category() == 2) {
                    this.addAssertionForCodelistUri(cibase, propi, ci, schDoc);
                }
            } else if (ci.matches("rule-xsd-cls-standard-gml-property-types") || ci.matches("rule-xsd-cls-standard-swe-property-types")) {
                boolean embedPropertyType = false;
                if (propi.matches("rule-xsd-prop-inlineOrByReference") && propi.inlineOrByReference().equals("byreference")) {
                    embedPropertyType = true;
                } else if (propi.matches("rule-xsd-prop-inlineOrByReference") && propi.inlineOrByReference().equals("inline")) {
                    if (ci.matches("rule-xsd-cls-standard-gml-property-types")) {
                        boolean bl = embedPropertyType = embedPropertyType || this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && (propi.isAggregation() || propi.isComposition() || propi.isMetadata()) && (propi.categoryOfValue() == 6 || propi.categoryOfValue() == 1);
                    }
                    if (ci.matches("rule-xsd-cls-standard-gml-property-types")) {
                        embedPropertyType = embedPropertyType || propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable");
                    }
                    boolean bl = embedPropertyType = embedPropertyType || this.classHasIdentity(ci) && !ci.includeByValuePropertyType() || !this.classHasIdentity(ci) && !ci.includePropertyType();
                    if (!embedPropertyType) {
                        if (this.classHasIdentity(ci)) {
                            this.addAttribute(e, "type", ci.qname() + "PropertyByValueType");
                        } else {
                            this.addAttribute(e, "type", this.propertyTypeName(ci, true));
                        }
                    }
                } else {
                    if (ci.matches("rule-xsd-cls-standard-gml-property-types")) {
                        boolean bl = embedPropertyType = embedPropertyType || this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && (propi.isAggregation() || propi.isComposition() || propi.isMetadata()) && (propi.categoryOfValue() == 6 || propi.categoryOfValue() == 1);
                    }
                    if (ci.matches("rule-xsd-cls-standard-gml-property-types")) {
                        boolean bl = embedPropertyType = embedPropertyType || this.options.GML_NS.equals("http://www.opengis.net/gml") && (propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable"));
                    }
                    if (ci.matches("rule-xsd-cls-standard-gml-property-types")) {
                        embedPropertyType = embedPropertyType || this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && (propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable")) && !this.classHasIdentity(ci);
                    }
                    boolean bl = embedPropertyType = embedPropertyType || !ci.includePropertyType();
                    if (ci.matches("rule-xsd-cls-standard-swe-property-types")) {
                        boolean bl2 = embedPropertyType = embedPropertyType || propi.matches("rule-xsd-prop-soft-typed") && propi.taggedValue("soft-typed") != null && propi.taggedValue("soft-typed").equalsIgnoreCase("true");
                    }
                    if (!embedPropertyType) {
                        this.addAttribute(e, "type", this.propertyTypeName(ci, true));
                    }
                }
                if (embedPropertyType) {
                    this.addAnonymousPropertyType(e, propi, ci.qname(), null, false);
                }
                this.addImport(ci.pkg().xmlns(), ci.pkg().targetNamespace());
            }
        } else if (ci.matches("rule-xsd-cls-mixin-classes") && ci.category() == 4 || ci.matches("rule-xsd-cls-no-abstract-classes") && ci.isAbstract()) {
            this.addAnonymousPropertyType(e, propi, null, this.subtypes(ci), false);
        } else if (ci.matches("rule-xsd-cls-standard-gml-property-types") || ci.matches("rule-xsd-cls-standard-swe-property-types")) {
            Element e3;
            Element e4;
            if (ci.category() == 2 && (ci.matches("rule-xsd-cls-codelist-asDictionary") && ci.asDictionary() || ci.matches("rule-xsd-cls-codelist-asDictionaryGml33") && ci.asDictionaryGml33())) {
                if (ci.matches("rule-xsd-cls-codelist-asDictionaryGml33") && ci.asDictionaryGml33()) {
                    this.addAttribute(e, "type", "gml:ReferenceType");
                    this.addAssertionForCodelistUri(cibase, propi, ci, schDoc);
                } else if (ci.matches("rule-xsd-cls-standard-swe-property-types")) {
                    this.addAttribute(e, "type", "swe:ReferenceType");
                    this.addAssertionForCodelistUri(cibase, propi, ci, schDoc);
                } else {
                    if (!(propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable"))) {
                        this.addAttribute(e, "type", "gml:CodeType");
                    } else {
                        e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                        e.appendChild(e1);
                        e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleContent");
                        e1.appendChild(e4);
                        e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                        e4.appendChild(e3);
                        this.addAttribute(e3, "base", "gml:CodeType");
                        Element e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                        e3.appendChild(e2);
                        this.addNilReason(e2);
                    }
                    this.addAssertionForCodelistUri(cibase, propi, ci, schDoc);
                }
                if (propi.isMetadata() && (mc = this.result.addWarning(null, 1009, pName)) != null) {
                    mc.addDetail(null, 400, "Property", propi.fullName());
                }
                if (ci.matches("rule-xsd-cls-standard-swe-property-types")) {
                    this.addImport("swe", this.options.fullNamespace("swe"));
                } else {
                    this.addImport("gml", this.options.fullNamespace("gml"));
                }
            } else if (ci.category() == 2 || ci.category() == 3 && !ci.matches("rule-xsd-cls-local-enumeration") || ci.matches("rule-xsd-cls-basictype") && ci.category() == 7 && !ci.matches("rule-xsd-cls-local-basictype")) {
                if (ci.pkg() == null || ci.pkg().xmlns() == null) {
                    mc = this.result.addError(null, 141, ci.name(), propi.inClass().name());
                    if (mc != null) {
                        mc.addDetail(null, 400, "Class", ci.fullName());
                    }
                } else if (!(propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable"))) {
                    this.addAttribute(e, "type", ci.qname() + "Type");
                } else {
                    e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                    e.appendChild(e1);
                    e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleContent");
                    e1.appendChild(e4);
                    e3 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                    e4.appendChild(e3);
                    this.addAttribute(e3, "base", ci.qname() + "Type");
                    Element e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
                    e3.appendChild(e2);
                    this.addNilReason(e2);
                }
                if (propi.isMetadata() && (mc = this.result.addWarning(null, 1009, pName)) != null) {
                    mc.addDetail(null, 400, "Property", propi.fullName());
                }
            } else if (ci.category() == 3 && ci.matches("rule-xsd-cls-local-enumeration")) {
                e1 = this.pAnonymousEnumeration(ci);
                e.appendChild(e1);
                if ((propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable")) && (mc = this.result.addWarning(null, 1010, pName, "enumeration")) != null) {
                    mc.addDetail(null, 400, "Property", propi.fullName());
                }
                if (propi.isMetadata() && (mc = this.result.addWarning(null, 1009, pName)) != null) {
                    mc.addDetail(null, 400, "Property", propi.fullName());
                }
            } else if (ci.matches("rule-xsd-cls-basictype") && ci.category() == 7 && ci.matches("rule-xsd-cls-local-basictype")) {
                e1 = this.pAnonymousBasicType(ci);
                e.appendChild(e1);
                if ((propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable")) && (mc = this.result.addWarning(null, 1010, pName, "basic type")) != null) {
                    mc.addDetail(null, 400, "Property", propi.fullName());
                }
                if (propi.isMetadata() && (mc = this.result.addWarning(null, 1009, pName)) != null) {
                    mc.addDetail(null, 400, "Property", propi.fullName());
                }
            } else {
                mc = this.result.addError(null, 130, pName);
                if (mc != null) {
                    mc.addDetail(null, 400, "Property", propi.fullName());
                }
            }
        } else {
            mc = this.result.addError(null, 130, pName);
            if (mc != null) {
                mc.addDetail(null, 400, "Property", propi.fullName());
            }
        }
        return false;
    }

    private void addAssertionForCodelistUri(ClassInfo cibase, PropertyInfo propi, ClassInfo ci, SchematronSchema schDoc) {
        if (schDoc != null && cibase.matches("rule-xsd-cls-codelist-constraints")) {
            String s = ci.taggedValue("codeList");
            if (s == null || s.isEmpty()) {
                s = ci.taggedValue("vocabulary");
            }
            if (ci.matches("rule-xsd-cls-standard-19139-property-types")) {
                String s2;
                SchematronConstraintNode.XpathFragment xpath;
                if (s != null && !s.isEmpty()) {
                    xpath = new SchematronConstraintNode.XpathFragment(0, propi.qname() + "/*/@codeList='" + s + "'");
                    schDoc.addAssertion(cibase, xpath, "Code list is '" + s + "'");
                }
                if ((s2 = ci.taggedValue("codeListValuePattern")) == null || s2.isEmpty()) {
                    s2 = "{codeList}/{value}";
                }
                s2 = "concat('" + s2.replace("{codeList}", s).replace("{value}", "',*/@codeListValue)");
                xpath = new SchematronConstraintNode.XpathFragment(0, "(not contains('" + s2 + "', '#') and document('" + s2 + "')) or (contains('" + s2 + "', '#') and document(substring-before('" + s2 + "','#'))/id(substring-after('" + s2 + "','#')))");
                schDoc.addAssertion(cibase, xpath, "Code list value exists");
                s = ci.taggedValue("codeListRepresentation");
                if (s == null || s.isEmpty() || s.equalsIgnoreCase("application/gml+xml;version=3.2")) {
                    xpath = new SchematronConstraintNode.XpathFragment(0, "(not contains('" + s2 + "', '#') and document('" + s2 + "')/gml:Definition) or (contains('" + s2 + "', '#') and document(substring-before('" + s2 + "','#'))/id(substring-after('" + s2 + "','#'))[local-name()='Definiton' and namespace-uri()='http://www.opengis.net/gml/3.2'])");
                    schDoc.addAssertion(cibase, xpath, "Code list dictionary is represented using GML 3.2");
                } else if (s.equalsIgnoreCase("application/rdf+xml")) {
                    xpath = new SchematronConstraintNode.XpathFragment(0, "(not contains('" + s2 + "', '#') and document('" + s2 + "')/skos:Concept) or (contains('" + s2 + "', '#') and document(substring-before('" + s2 + "','#'))/id(substring-after('" + s2 + "','#'))[local-name()='Concept' and namespace-uri()='http://www.w3.org/2004/02/skos/core#'])");
                    schDoc.addAssertion(cibase, xpath, "Code list dictionary is represented using SKOS");
                }
            } else if (ci.matches("rule-xsd-cls-codelist-asDictionaryGml33") && ci.asDictionaryGml33()) {
                SchematronConstraintNode.XpathFragment xpath;
                if (s != null && !s.isEmpty()) {
                    xpath = new SchematronConstraintNode.XpathFragment(0, "starts-with(" + propi.qname() + "/@xlink:href,'" + s + "')");
                    schDoc.addAssertion(cibase, xpath, "Code list value URI starts with '" + s + "'");
                }
                xpath = new SchematronConstraintNode.XpathFragment(0, "(not contains(" + propi.qname() + "/@xlink:href, '#') and document(" + propi.qname() + "/@xlink:href)) or (contains(" + propi.qname() + "/@xlink:href, '#') and document(substring-before(" + propi.qname() + "/@xlink:href,'#'))/id(substring-after(" + propi.qname() + "/@xlink:href,'#')))");
                schDoc.addAssertion(cibase, xpath, "Code list value exists");
                s = ci.taggedValue("codeListRepresentation");
                if (s == null || s.isEmpty() || s.equalsIgnoreCase("application/gml+xml;version=3.2")) {
                    xpath = new SchematronConstraintNode.XpathFragment(0, "(not contains(" + propi.qname() + "/@xlink:href, '#') and document(" + propi.qname() + "/@xlink:href)/gml:Definition) or (contains(" + propi.qname() + "/@xlink:href, '#') and document(substring-before(" + propi.qname() + "/@xlink:href,'#'))/id(substring-after(" + propi.qname() + "/@xlink:href,'#'))[local-name()='Definiton' and namespace-uri()='http://www.opengis.net/gml/3.2'])");
                    schDoc.addAssertion(cibase, xpath, "Code list dictionary is represented using GML 3.2");
                } else if (s.equalsIgnoreCase("application/rdf+xml")) {
                    xpath = new SchematronConstraintNode.XpathFragment(0, "(not contains(" + propi.qname() + "/@xlink:href, '#') and document(" + propi.qname() + "/@xlink:href)/skos:Concept) or (contains(" + propi.qname() + "/@xlink:href, '#') and document(substring-before(" + propi.qname() + "/@xlink:href,'#'))/id(substring-after(" + propi.qname() + "/@xlink:href,'#'))[local-name()='Concept' and namespace-uri()='http://www.w3.org/2004/02/skos/core#'])");
                    schDoc.addAssertion(cibase, xpath, "Code list dictionary is represented using SKOS");
                }
            } else if (ci.matches("rule-xsd-cls-codelist-asDictionaryGml") && ci.asDictionary() && s != null && !s.isEmpty()) {
                SchematronConstraintNode.XpathFragment xpath = new SchematronConstraintNode.XpathFragment(0, propi.qname() + "/@codeSpace='" + s + "'");
                schDoc.addAssertion(cibase, xpath, "Code space is '" + s + "'");
                String s2 = ci.taggedValue("codeListValuePattern");
                if (s2 == null || s2.isEmpty()) {
                    s2 = "{codeList}/{value}";
                }
                s2 = "concat('" + s2.replace("{codeList}", s).replace("{value}", "',.)");
                xpath = new SchematronConstraintNode.XpathFragment(0, "(not contains('" + s2 + "', '#') and document('" + s2 + "')) or (contains('" + s2 + "', '#') and document(substring-before('" + s2 + "','#'))/id(substring-after('" + s2 + "','#')))");
                schDoc.addAssertion(cibase, xpath, "Code list value exists");
                s = ci.taggedValue("codeListRepresentation");
                if (s == null || s.isEmpty() || s.equalsIgnoreCase("application/gml+xml;version=3.2")) {
                    xpath = new SchematronConstraintNode.XpathFragment(0, "(not contains('" + s2 + "', '#') and document('" + s2 + "')/gml:Definition) or (contains('" + s2 + "', '#') and document(substring-before('" + s2 + "','#'))/id(substring-after('" + s2 + "','#'))[local-name()='Definiton' and namespace-uri()='http://www.opengis.net/gml/3.2'])");
                    schDoc.addAssertion(cibase, xpath, "Code list dictionary is represented using GML 3.2");
                } else if (s.equalsIgnoreCase("application/rdf+xml")) {
                    xpath = new SchematronConstraintNode.XpathFragment(0, "(not contains('" + s2 + "', '#') and document('" + s2 + "')/skos:Concept) or (contains('" + s2 + "', '#') and document(substring-before('" + s2 + "','#'))/id(substring-after('" + s2 + "','#'))[local-name()='Concept' and namespace-uri()='http://www.w3.org/2004/02/skos/core#'])");
                    schDoc.addAssertion(cibase, xpath, "Code list dictionary is represented using SKOS");
                }
            }
        }
    }

    private void addNilReason(Element e) {
        this.addAttribute(e, "name", "nilReason");
        if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
            this.addAttribute(e, "type", "gml:NilReasonType");
        } else if (this.options.GML_NS.equals("http://www.opengis.net/gml")) {
            this.addAttribute(e, "type", "gml:NullType");
        }
        this.addImport("gml", this.options.fullNamespace("gml"));
    }

    private void addName(Element e) {
        this.addAttribute(e, "name", "name");
        this.addAttribute(e, "type", "NCName");
        this.addAttribute(e, "use", "required");
    }

    private void addAnonymousPropertyType(Element e, PropertyInfo propi, String targetElement, HashSet<ClassInfo> types, boolean valueIsMetadata) {
        String s;
        Element e4;
        Element sequenceOrChoice;
        Element typeOrExtension;
        Element e2;
        ClassInfo cibase = propi.inClass();
        if (cibase == null) {
            ShapeChangeResult.MessageContext mc = this.result.addError(null, 157, propi.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Property", propi.fullName());
            }
            return;
        }
        if (propi.matches("rule-xsd-prop-inlineOrByReference") && propi.inlineOrByReference().equals("byreference")) {
            if (cibase.matches("rule-xsd-cls-no-gml-types")) {
                Element e1 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
                e.appendChild(e1);
                Element e42 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
                e1.appendChild(e42);
                e42 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
                e1.appendChild(e42);
                this.addAttribute(e42, "ref", "xlink:simpleAttrs");
                this.addImport("xlink", this.options.fullNamespace("xlink"));
                return;
            }
            if (cibase.matches("rule-xsd-cls-standard-swe-property-types")) {
                this.addAttribute(e, "type", "swe:ReferenceType");
                this.addImport("swe", this.options.fullNamespace("swe"));
                return;
            }
            if (this.options.GML_NS.equals("http://www.opengis.net/gml")) {
                this.addAttribute(e, "type", "gml:ReferenceType");
                this.addImport("gml", this.options.fullNamespace("gml"));
                return;
            }
            if (!(!this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") || propi.isMetadata() || valueIsMetadata || propi.isAggregation() || propi.isComposition())) {
                this.addAttribute(e, "type", "gml:ReferenceType");
                this.addImport("gml", this.options.fullNamespace("gml"));
                return;
            }
        }
        Element type = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexType");
        e.appendChild(type);
        if ((propi.isMetadata() || valueIsMetadata) && this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && cibase.matches("rule-xsd-cls-standard-gml-property-types")) {
            e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
            type.appendChild(e2);
            typeOrExtension = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
            e2.appendChild(typeOrExtension);
            this.addAttribute(typeOrExtension, "base", "gml:AbstractMetadataPropertyType");
        } else if ((propi.isAggregation() || propi.isComposition()) && (propi.categoryOfValue() == 6 || propi.categoryOfValue() == 1) && this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && cibase.matches("rule-xsd-cls-standard-gml-property-types") && !cibase.matches("rule-xsd-cls-no-gml-types")) {
            e2 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "complexContent");
            type.appendChild(e2);
            typeOrExtension = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
            e2.appendChild(typeOrExtension);
            this.addAttribute(typeOrExtension, "base", "gml:AbstractMemberType");
        } else {
            typeOrExtension = type;
        }
        if (propi.matches("rule-xsd-prop-inlineOrByReference") && propi.inlineOrByReference().equals("byreference")) {
            sequenceOrChoice = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
            typeOrExtension.appendChild(sequenceOrChoice);
        } else if (types != null) {
            sequenceOrChoice = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "choice");
            typeOrExtension.appendChild(sequenceOrChoice);
            this.addElements(sequenceOrChoice, types);
        } else if (targetElement != null) {
            sequenceOrChoice = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "sequence");
            typeOrExtension.appendChild(sequenceOrChoice);
            Element e5 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "element");
            sequenceOrChoice.appendChild(e5);
            this.addAttribute(e5, "ref", targetElement);
            int idx = targetElement.indexOf(":");
            if (idx > 0) {
                String nsabr = targetElement.substring(0, idx);
                this.addImport(nsabr, this.options.fullNamespace(nsabr));
            }
        } else {
            ShapeChangeResult.MessageContext mc = this.result.addError(null, 116, propi.name());
            if (mc != null) {
                mc.addDetail(null, 400, "Property", propi.fullName());
            }
            return;
        }
        boolean nilReasonAdded = false;
        ClassInfo cit = this.model.classById(propi.typeInfo().id);
        if (propi.matches("rule-xsd-prop-inlineOrByReference") && !propi.inlineOrByReference().equals("inline") || !propi.matches("rule-xsd-prop-inlineOrByReference") && cit != null && this.classHasIdentity(cit)) {
            if (!propi.inlineOrByReference().equals("byreference")) {
                this.addAttribute(sequenceOrChoice, "minOccurs", "0");
            }
            e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
            typeOrExtension.appendChild(e4);
            if (cibase.matches("rule-xsd-cls-no-gml-types")) {
                this.addAttribute(e4, "ref", "xlink:simpleAttrs");
            } else if (cibase.matches("rule-xsd-cls-standard-swe-property-types")) {
                this.addAttribute(e4, "ref", "swe:AssociationAttributeGroup");
            } else {
                this.addAttribute(e4, "ref", "gml:AssociationAttributeGroup");
                if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                    nilReasonAdded = true;
                }
            }
        }
        if (!propi.isMetadata() && !valueIsMetadata && !propi.isAggregation() && !propi.isComposition() && this.options.GML_NS.equals("http://www.opengis.net/gml/3.2") && cit != null && this.classHasIdentity(cit) && cibase.matches("rule-xsd-cls-standard-gml-property-types")) {
            e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attributeGroup");
            typeOrExtension.appendChild(e4);
            this.addAttribute(e4, "ref", "gml:OwnershipAttributeGroup");
        }
        if ((propi.nilReasonAllowed() || propi.voidable() && propi.matches("rule-xsd-prop-nillable")) && !nilReasonAdded) {
            e4 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
            typeOrExtension.appendChild(e4);
            this.addAttribute(e4, "name", "nilReason");
            if (this.options.GML_NS.equals("http://www.opengis.net/gml/3.2")) {
                this.addAttribute(e4, "type", "gml:NilReasonType");
            } else if (this.options.GML_NS.equals("http://www.opengis.net/gml")) {
                this.addAttribute(e4, "type", "gml:NullType");
            }
        }
        if (propi.matches("rule-xsd-prop-soft-typed") && (s = propi.taggedValue("soft-typed")) != null && s.equalsIgnoreCase("true")) {
            Element e43 = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "attribute");
            typeOrExtension.appendChild(e43);
            this.addName(e43);
        }
        if (cibase.matches("rule-xsd-cls-no-gml-types")) {
            this.addImport("xlink", this.options.fullNamespace("xlink"));
        } else if (cibase.matches("rule-xsd-cls-standard-swe-property-types")) {
            this.addImport("swe", this.options.fullNamespace("swe"));
        } else {
            this.addImport("gml", this.options.fullNamespace("gml"));
        }
    }

    private String stripQuotes(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block3: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    continue block3;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public void addInclude(XsdDocument xsd) {
        if (xsd == this) {
            return;
        }
        boolean found = false;
        for (String f : this.includes) {
            if (!f.equals(xsd.name)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.includes.add(xsd.name);
        }
    }

    public void addImport(String nsabr, String ns) {
        if (ns == null || ns.equals(this.targetNamespace)) {
            return;
        }
        boolean found = false;
        for (String nsx : this.imports) {
            if (!nsx.equals(ns)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.imports.add(ns);
            this.result.addDebug(null, 10021, ns);
            if (nsabr != null) {
                this.addAttribute(this.root, "xmlns:" + nsabr, ns);
            }
        }
    }

    public void printFile(Properties outputFormat) throws Exception {
        Element e;
        if (this.printed) {
            return;
        }
        Collections.sort(this.includes);
        Iterator<String> i = this.includes.iterator();
        while (i.hasNext()) {
            e = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "include");
            this.addAttribute(e, "schemaLocation", i.next());
            this.root.insertBefore(e, this.hook);
        }
        Collections.sort(this.imports);
        Iterator<String> i2 = this.imports.iterator();
        while (i2.hasNext()) {
            e = this.document.createElementNS("http://www.w3.org/2001/XMLSchema", "import");
            String s = i2.next();
            this.addAttribute(e, "namespace", s);
            String loc = this.options.schemaLocationOfNamespace(s);
            if (loc != null) {
                this.addAttribute(e, "schemaLocation", loc);
            }
            this.root.insertBefore(e, this.hook);
        }
        File outputDirectoryFile = new File(this.outputDirectory);
        boolean exi = outputDirectoryFile.exists();
        if (!exi) {
            outputDirectoryFile.mkdirs();
            exi = outputDirectoryFile.exists();
        }
        boolean dir = outputDirectoryFile.isDirectory();
        boolean wrt = outputDirectoryFile.canWrite();
        boolean rea = outputDirectoryFile.canRead();
        if (!(exi && dir && wrt && rea)) {
            this.result.addFatalError(this, 12, this.outputDirectory);
            throw new ShapeChangeAbortException();
        }
        FileOutputStream fout = new FileOutputStream(this.outputDirectory + "/" + this.name);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        OutputStreamWriter outputXML = new OutputStreamWriter((OutputStream)bout, outputFormat.getProperty("encoding"));
        Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
        serializer.setWriter((Writer)outputXML);
        serializer.asDOMSerializer().serialize((Node)this.document);
        outputXML.close();
        this.printed = true;
    }

    public boolean printed() {
        return this.printed;
    }

    @Override
    public String message(int mnr) {
        String mess = this.messageText(mnr);
        if (mess == null) {
            return null;
        }
        String prefix = "";
        if (mess.startsWith("??")) {
            prefix = "??";
            mess = mess.substring(2);
        }
        return prefix + "XML Schema Target: " + mess;
    }

    protected String messageText(int mnr) {
        switch (mnr) {
            case 12: {
                return "Directory named '$1$' does not exist or is not accessible.";
            }
        }
        return null;
    }
}

