/*
 * Decompiled with CFR 0.152.
 */
package de.adv_online.aaa.modellarttool;

import de.adv_online.aaa.modellarttool.ModellartRep;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target.Target;
import java.io.FileNotFoundException;
import java.io.FileReader;

public class Modellart
implements Target {
    public static final int TARGET_AAA_Modellarttool = 404;
    public static final int STATUS_WRITE_3AM = 31;
    public static final int STATUS_WRITE_MODEL = 32;
    public static final int STATUS_CLEAN_MODEL = 33;
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private String outputDirectory = null;
    private ModellartRep theMArt = null;
    private String quelle = null;
    private String ziel = null;
    private boolean error = false;

    public int getTargetID() {
        return 404;
    }

    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r, boolean diagOnly) throws ShapeChangeAbortException {
        String s;
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        String mart = "FIXME";
        if (!this.options.gmlVersion.equals("3.2")) {
            this.result.addError(null, 110, this.pi.name());
            return;
        }
        this.outputDirectory = this.options.parameter(this.getClass().getName(), "Verzeichnis");
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter("directory");
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.options.parameter(".");
        }
        if ((s = this.options.parameter(this.getClass().getName(), "Modellart")) != null) {
            mart = s.trim();
        }
        if ((s = this.options.parameter(this.getClass().getName(), "Quelle")) != null) {
            this.quelle = s.trim();
        }
        if ((s = this.options.parameter(this.getClass().getName(), "Ziel")) != null) {
            this.ziel = s.trim();
        }
        if (this.ziel == null) {
            this.result.addError("Der Parameter 'Ziel' fehlt. Die Ausf\u00fchrung des Modellarttools wird abgebrochen");
            this.error = true;
        } else if (this.quelle == null) {
            this.result.addError("Der Parameter 'Quelle' fehlt. Die Ausf\u00fchrung des Modellarttools wird abgebrochen");
            this.error = true;
        } else if (this.quelle.equals("Datei")) {
            try {
                this.theMArt = new ModellartRep(p, m, o, r, new FileReader(this.outputDirectory + "/" + mart + ".3am"));
            }
            catch (FileNotFoundException e) {
                this.result.addError("Die 3am-Datei wurde nicht gefunden. Die Ausf\u00fchrung des Modellarttools wird abgebrochen");
                this.error = true;
            }
        } else if (this.quelle.equals("Modell")) {
            this.theMArt = new ModellartRep(p, m, o, r, mart);
        } else {
            this.result.addError("Der Parameter 'Quelle' hat den unbekannten Wert '" + this.quelle + "'. Die Ausf\u00fchrung des Modellarttools wird abgebrochen");
            this.error = true;
        }
    }

    public void process(ClassInfo ci) {
    }

    public void write() {
        if (this.error) {
            return;
        }
        if (this.ziel.equals("DateiModell")) {
            this.theMArt.writeToFile(this.outputDirectory + "/" + this.theMArt.name() + "__export.3am");
            this.theMArt.writeToModel();
            this.result.addResult(this.getTargetID(), this.outputDirectory, this.theMArt.name() + "__export.3am", this.options.parameter(this.getClass().getName(), "modellarten"));
        } else if (this.ziel.equals("Modell")) {
            this.theMArt.writeToModel();
        } else if (this.ziel.equals("Datei")) {
            this.theMArt.writeToFile(this.outputDirectory + "/" + this.theMArt.name() + "__export.3am");
            this.result.addResult(this.getTargetID(), this.outputDirectory, this.theMArt.name() + "__export.3am", this.options.parameter(this.getClass().getName(), "modellarten"));
        } else if (this.ziel.equals("Ohne")) {
            this.theMArt.clearInModel();
        } else {
            this.result.addError("Der Parameter 'Ziel' hat den unbekannten Wert '" + this.ziel + "'. Die Ausf\u00fchrung des Modellarttools wird abgebrochen");
            this.error = true;
        }
    }
}

