/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.MapEntry;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeErrorHandler;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Options {
    protected static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    protected static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    protected static final String SCRS_NS = "http://www.interactive-instruments.de/ShapeChange/Result";
    protected static final String SCAI_NS = "http://www.interactive-instruments.de/ShapeChange/AppInfo";
    protected static final String SCHEMATRON_NS = "http://purl.oclc.org/dsdl/schematron";
    protected static final String DEF_NS = "http://www.interactive-instruments.de/ShapeChange/Definitions/0.4";
    protected static final String ISO19136_2007 = "iso19136_2007";
    protected static final String ISO19139_2007 = "iso19139_2007";
    protected static final String ISO19136_2007_SHAPECHANGE_1_0 = "iso19136_2007";
    protected static final String ISO19136_2007_NO_GML = "iso19136_2007_NoGmlBaseTypes";
    protected static final String NOT_ENCODED = "notEncoded";
    protected static final String CRLF = "\r\n";
    protected static final String allSupportedRules = "iso19136_2007 iso19136_2007_ShapeChange_1.0_Extensions iso19136_2007_NoGmlBaseTypes iso19139_2007";
    protected static final int GLOBAL = 1;
    protected static final int LOCAL = 2;
    protected static final int UNKNOWN = -1;
    protected static final int FEATURE = 1;
    protected static final int CODELIST = 2;
    protected static final int ENUMERATION = 3;
    protected static final int MIXIN = 4;
    protected static final int DATATYPE = 5;
    protected static final int GMLOBJECT = 6;
    protected static final int BASICTYPE = 7;
    protected static final int UNION = 8;
    protected static final int UNIONDIRECT = 9;
    protected static final int SERVICE = 10;
    protected String GML_NS;
    public String gmlVersion = "3.2";
    public String dirName = ".";
    public String dirURI = ".";
    public String configFile = "./ShapeChangeConfiguration.xml";
    public String reportLevel = "WARNING";
    public String xmlNamespaceDefault = "http://www.interactoive-instruments.de/please/fix/this/namespace";
    public String xmlNamespaceAbbreviationDefault = "app";
    public String appSchemaVersion = "unknown";
    public boolean schematron = true;
    public boolean publicOnly = true;
    public String appSchemaName = "";
    public boolean includeDocumentation = true;
    public boolean supportSequenceSetEtc = true;
    public String representTaggedValues = "";
    public String representStereotypes = "";
    public int enumStyle = 1;
    public int basicTypeStyle = 1;
    public boolean restrictProperties = false;
    protected String metadataStyle = "NONE";
    protected String definitions = "NONE";
    protected String namingAuthority = "UNKNOWN";
    protected boolean noGMLtypeDefault = false;
    protected boolean supportWSDL = false;
    protected boolean useSequenceNumbers = true;
    protected boolean supportProfiles = false;
    protected boolean roseBugFixDuplicateGlobalDataTypes = true;
    protected boolean eaBugFixWrongID = true;
    protected boolean eaBugFixPublicPackagesAreMarkedAsPrivate = true;
    protected boolean eaIncludeExtentsions = true;
    protected boolean argoBugFixMissingDOCTYPE = false;
    protected HashMap<String, MapEntry> fTypeMap = new HashMap();
    protected HashMap<String, MapEntry> fBaseMap = new HashMap();
    protected HashMap<String, MapEntry> fElementMap = new HashMap();
    protected HashMap<String, String> fStereotypeAliases = new HashMap();
    protected HashMap<String, MapEntry> fNamespaces = new HashMap();
    protected HashMap<String, String> fSchemaLocations = new HashMap();

    protected void addTypeMapEntry(String k1, String k2, String s1, String s2) {
        this.fTypeMap.put(String.valueOf(k1) + "#" + k2, new MapEntry(s1, s2));
    }

    protected void addTypeMapEntry(String k1, String k2, String s1, String s2, String s3) {
        this.fTypeMap.put(String.valueOf(k1) + "#" + k2, new MapEntry(s1, s2, s3));
    }

    protected MapEntry typeMapEntry(String k1, String k2) {
        MapEntry me = this.fTypeMap.get(String.valueOf(k1) + "#*");
        if (me == null) {
            me = this.fTypeMap.get(String.valueOf(k1) + "#" + k2);
        }
        return me;
    }

    protected void addBaseMapEntry(String k1, String k2, String s1, String s2) {
        this.fBaseMap.put(String.valueOf(k1) + "#" + k2, new MapEntry(s1, s2));
    }

    protected void addBaseMapEntry(String k1, String k2, String s1, String s2, String s3) {
        this.fBaseMap.put(String.valueOf(k1) + "#" + k2, new MapEntry(s1, s2, s3));
    }

    protected MapEntry baseMapEntry(String k1, String k2) {
        MapEntry me = this.fBaseMap.get(String.valueOf(k1) + "#*");
        if (me == null) {
            me = this.fBaseMap.get(String.valueOf(k1) + "#" + k2);
        }
        return me;
    }

    protected void addElementMapEntry(String k1, String k2, String s1, String s2) {
        this.fElementMap.put(String.valueOf(k1) + "#" + k2, new MapEntry(s1, s2));
    }

    protected void addElementMapEntry(String k1, String k2, String s1, String s2, String s3) {
        this.fElementMap.put(String.valueOf(k1) + "#" + k2, new MapEntry(s1, s2, s3));
    }

    protected MapEntry elementMapEntry(String k1, String k2) {
        MapEntry me = this.fElementMap.get(String.valueOf(k1) + "#*");
        if (me == null) {
            me = this.fElementMap.get(String.valueOf(k1) + "#" + k2);
        }
        return me;
    }

    protected void addStereotypeAlias(String k1, String s1) {
        this.fStereotypeAliases.put(k1, s1);
    }

    protected String stereotypeAlias(String k1) {
        return this.fStereotypeAliases.get(k1);
    }

    protected void addNamespace(String k1, String s1, String s2) {
        this.fNamespaces.put(k1, new MapEntry(s1, s2));
    }

    protected void addSchemaLocation(String k1, String s1) {
        this.fSchemaLocations.put(k1, s1);
    }

    protected MapEntry namespace(String k1) {
        MapEntry me = this.fNamespaces.get(k1);
        return me;
    }

    protected String fullNamespace(String k1) {
        MapEntry me = this.fNamespaces.get(k1);
        if (me != null) {
            return me.rule;
        }
        return null;
    }

    protected String schemaLocationOfNamespace(String k1) {
        return this.fSchemaLocations.get(k1);
    }

    protected void loadConfiguration() throws ShapeChangeAbortException {
        DocumentBuilder builder = null;
        ShapeChangeErrorHandler handler = null;
        try {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            factory.setFeature("http://apache.org/xml/features/validation/schema", true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            factory.setXIncludeAware(true);
            factory.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
            builder = factory.newDocumentBuilder();
            handler = new ShapeChangeErrorHandler();
            builder.setErrorHandler(handler);
        }
        catch (FactoryConfigurationError e) {
            System.err.println("Unable to get a document builder factory.");
            throw new ShapeChangeAbortException();
        }
        catch (ParserConfigurationException e) {
            System.err.println("XML Parser was unable to be configured.");
            throw new ShapeChangeAbortException();
        }
        try {
            Element e;
            Document document = builder.parse(this.configFile);
            if (handler.errorsFound()) {
                System.err.println("Invalid configuration file.");
                throw new ShapeChangeAbortException();
            }
            NodeList nl = document.getElementsByTagName("MapEntry");
            int j = 0;
            while (j < nl.getLength()) {
                String xmlTypeContent;
                e = (Element)nl.item(j);
                String type = e.getAttribute("type");
                String rules = e.getAttribute("xsdEncodingRules");
                if (rules.equals("*")) {
                    rules = allSupportedRules;
                }
                String[] vv = rules.split("\\s");
                String xmlType = e.getAttribute("xmlType");
                String xmlTypeType = e.getAttribute("xmlTypeType");
                if (xmlTypeType.equals("")) {
                    xmlTypeType = "complex";
                }
                if ((xmlTypeContent = e.getAttribute("xmlTypeContent")).equals("")) {
                    xmlTypeContent = "complex";
                }
                String xmlElement = e.getAttribute("xmlElement");
                String xmlPropertyType = e.getAttribute("xmlPropertyType");
                int i = 0;
                while (i < vv.length) {
                    if (xmlPropertyType != null) {
                        if (xmlPropertyType.equals("_P_") && xmlElement != null) {
                            this.addTypeMapEntry(type, vv[i], "propertyType", xmlElement);
                        } else if (xmlPropertyType.equals("_MP_") && xmlElement != null) {
                            this.addTypeMapEntry(type, vv[i], "metadataPropertyType", xmlElement);
                        } else {
                            this.addTypeMapEntry(type, vv[i], "direct", xmlPropertyType);
                        }
                    }
                    if (xmlElement != null) {
                        this.addElementMapEntry(type, vv[i], "direct", xmlElement);
                    }
                    if (xmlType != null) {
                        this.addBaseMapEntry(type, vv[i], "direct", xmlType, String.valueOf(xmlTypeType) + "/" + xmlTypeContent);
                    }
                    ++i;
                }
                ++j;
            }
            nl = document.getElementsByTagName("Namespace");
            j = 0;
            while (j < nl.getLength()) {
                e = (Element)nl.item(j);
                String nsAbbrev = e.getAttribute("nsabr");
                String ns = e.getAttribute("ns");
                String loc = e.getAttribute("location");
                this.addNamespace(nsAbbrev, ns, loc);
                this.addSchemaLocation(ns, loc);
                ++j;
            }
            nl = document.getElementsByTagName("StereotypeAlias");
            j = 0;
            while (j < nl.getLength()) {
                e = (Element)nl.item(j);
                String wkn = e.getAttribute("wellknown");
                String alias = e.getAttribute("alias");
                this.addStereotypeAlias(alias, wkn);
                ++j;
            }
        }
        catch (SAXException e) {
            String m = e.getMessage();
            if (m != null) {
                System.err.println(m);
            } else {
                e.printStackTrace(System.err);
            }
        }
        catch (IOException e) {
            String m = e.getMessage();
            if (m != null) {
                System.err.println(m);
            } else {
                e.printStackTrace(System.err);
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                System.err.println(m);
            }
            Exception se = e;
            if (e instanceof SAXException) {
                se = ((SAXException)e).getException();
            }
            if (se != null) {
                se.printStackTrace(System.err);
            }
            e.printStackTrace(System.err);
        }
        MapEntry nsme = this.namespace("gml");
        if (nsme == null) {
            System.err.println("The namespace with abbreviation 'gml' must be specified in the configuration file.");
            throw new ShapeChangeAbortException();
        }
        this.GML_NS = nsme.rule;
    }
}

