<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<!-- Profilkennung -->
	<xsl:variable name="profilkennung" select="//adv:profilkennung"/>
	<!-- Antragsnummer -->
	<xsl:variable name="antragsnummer" select="//adv:antragsnummer"/>
	<!-- Filterpfad -->
	<xsl:variable name="filterpfad">
		<xsl:choose>
			<xsl:when test="//wfs:Query/@typeName='AX_LagebezeichnungMitHausnummer'">
				<xsl:value-of select="'adv:zeigtAuf/adv:AX_LagebezeichnungMitHausnummer/'"/>
			</xsl:when>
			<xsl:when test="//wfs:Query/@typeName='AX_LagebezeichnungMitPseudonummer'">
				<xsl:value-of select="'adv:hat/adv:AX_LagebezeichnungMitPseudonummer/'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:variable>
	<!-- =========================================================== -->
	<!-- Filterpfad-Templates -->
	<!--   PropertyName um Filterpfad ergänzen -->
	<xsl:template match="ogc:PropertyName" mode="Filterpfad">
		<xsl:copy>
			<xsl:value-of select="concat($filterpfad,.)"/>
		</xsl:copy>
	</xsl:template>
	<!--   Rest kopieren -->
	<xsl:template match="*" mode="Filterpfad">
		<xsl:copy>
			<!-- auch die Attribute -->
			<xsl:for-each select="@*">
				<xsl:copy/>
			</xsl:for-each>
			<xsl:apply-templates mode="Filterpfad"/>
		</xsl:copy>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
				<!-- Gebäude selektieren: dazu Lagebezeichnung und Nutzung -->
				<wfs:Query typeName="AX_Gebaeude">		
					<adv:XlinkPropertyPath><xsl:value-of select="$filterpfad"/>adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:verschluesselt/adv:AX_VerschluesselteLagebezeichnung</adv:XlinkPropertyPath>
					<ogc:Filter>
						<ogc:And>
							<!-- Filter aus Benutzungsauftrag um Filterpfad ergänzen -->
							<xsl:apply-templates select="//ogc:Filter/*" mode="Filterpfad"/>
							<!-- zeitliche Betrachtung -->
							<ogc:PropertyIsNull>
								<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
							</ogc:PropertyIsNull>
						</ogc:And>
					</ogc:Filter>					
				</wfs:Query>
				<!-- Türme selektieren: dazu Lagebezeichnung -->
				<wfs:Query typeName="AX_Turm">		
					<adv:XlinkPropertyPath><xsl:value-of select="$filterpfad"/>adv:lagebezeichnung/adv:AX_Lagebezeichnung/adv:verschluesselt/adv:AX_VerschluesselteLagebezeichnung</adv:XlinkPropertyPath>
					<ogc:Filter>
						<ogc:And>
							<!-- Filter aus Benutzungsauftrag um Filterpfad ergänzen -->
							<xsl:apply-templates select="//ogc:Filter/*" mode="Filterpfad"/>
							<!-- zeitliche Betrachtung -->
							<ogc:PropertyIsNull>
								<ogc:PropertyName>lebenszeitintervall/AA_Lebenzeitintervall/endet</ogc:PropertyName>
							</ogc:PropertyIsNull>
						</ogc:And>
					</ogc:Filter>					
				</wfs:Query>
				<!-- Besorge ausserdem alle Bundesländer, Gemeinden und Katasterämter mit deren Anschrift
					 über die unter der Gebäudegeometrie liegenden Flurstücke.
				     Hinweis: Dies ist natürlich keine realistische Vorgehensweise bei Produktionsdatenbeständen. 
					 Das Ziel dieser Dokumentation liegt in der Beschreibung der formalen Regeln bei der Ableitung
				     der Standardausgaben - nicht in der Vorgabe einer algorithmischen Umsetzung dieser. -->
				<!-- Über die Gebäudegeometrie kommt man an das darunterliegende Flst. kommt und damit an die Gemarkung+Dienststelle Katasteramt usw. -->
				<wfs:Query typeName="AX_Gemeinde"/>
				<wfs:Query typeName="AX_Bundesland"/>
				<wfs:Query typeName="AX_Dienststelle">
					<XlinkPropertyPath>hat/AX_Anschrift</XlinkPropertyPath>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>stellenart</ogc:PropertyName>
							<ogc:Literal>1100</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</wfs:Query>
			</anforderungsmerkmale>
			<profilkennung>
				<xsl:value-of select="$profilkennung"/>
			</profilkennung>
			<antragsnummer>
				<xsl:value-of select="$antragsnummer"/>
			</antragsnummer>
			<folgeverarbeitung>
				<AX_FOLGEVA>
					<datenformat>1000</datenformat>
				</AX_FOLGEVA>
			</folgeverarbeitung>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
