/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.ClassInfo;
import de.interactive_instruments.ShapeChange.Model;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.PackageInfo;
import de.interactive_instruments.ShapeChange.PropertyInfo;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.Target;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class Definitions
implements Target {
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private boolean printed = false;
    private Document document = null;
    private final HashMap<String, Document> documentMap = new HashMap();
    private Element root = null;

    @Override
    public void initialise(PackageInfo p, Model m, Options o, ShapeChangeResult r) throws ShapeChangeAbortException {
        Element e1;
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        this.result.addDebug("Generating GML dictionaries with definitions for application schema " + this.pi.name() + "...");
        this.document = this.createDocument();
        ProcessingInstruction proci = this.document.createProcessingInstruction("xml", "version='1.0' encoding='" + this.model.characterEncoding() + "'");
        this.document.appendChild(proci);
        proci = this.document.createProcessingInstruction("xml-stylesheet", "type='text/xsl' href='./ShapeChangeDefinitions.xsl'");
        this.document.appendChild(proci);
        this.root = this.document.createElementNS("http://www.interactive-instruments.de/ShapeChange/Definitions/0.4", "ApplicationSchemaDefinition");
        this.document.appendChild(this.root);
        this.addAttribute(this.document, this.root, "gml:id", "_");
        this.addAttribute(this.document, this.root, "xmlns:gml", this.options.GML_NS);
        this.addAttribute(this.document, this.root, "xmlns:def", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.4");
        this.addAttribute(this.document, this.root, "xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.addAttribute(this.document, this.root, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.addAttribute(this.document, this.root, "xsi:schemaLocation", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.4 ShapeChangeDefinitions.xsd");
        String s = this.model.taggedValue(this.pi.id(), "documentation");
        if (s != null) {
            e1 = this.document.createElementNS(this.options.GML_NS, "description");
            e1.appendChild(this.document.createTextNode(s));
            this.root.appendChild(e1);
        }
        e1 = this.document.createElementNS(this.options.GML_NS, "identifier");
        e1.appendChild(this.document.createTextNode("urn:x-ogc:def:applicationSchema:" + this.options.namingAuthority + "::" + this.pi.xmlns() + ":" + this.pi.version()));
        this.addAttribute(this.document, e1, "codeSpace", "urn:x-ogc");
        this.root.appendChild(e1);
        e1 = this.document.createElementNS(this.options.GML_NS, "name");
        e1.appendChild(this.document.createTextNode(this.pi.name()));
        this.root.appendChild(e1);
    }

    protected void addAttribute(Document document, Element e, String name, String value) {
        Attr att = document.createAttribute(name);
        att.setValue(value);
        e.setAttributeNode(att);
    }

    protected Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            System.err.println("Bootstrap Error: XML parser was unable to be configured.");
            String m = e.getMessage();
            if (m != null) {
                System.err.println(m);
            }
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Bootstrap Error: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        return document;
    }

    @Override
    public void process(ClassInfo ci) {
        int cat = ci.category();
        if (cat != 1 && cat != 6 && cat != 5 && cat != 7 && cat != 8 && cat != 9) {
            return;
        }
        String t = "featureType";
        if (cat == 6) {
            t = "objectType";
        } else if (cat == 5) {
            t = "dataType";
        } else if (cat == 8 || cat == 9) {
            t = "unionType";
        }
        if (this.options.definitions.equals("SCHEMA")) {
            Element e1 = this.document.createElementNS(this.options.GML_NS, "dictionaryEntry");
            this.root.appendChild(e1);
            Element e2 = this.createTypeDefinition(this.pi, this.document, ci, t);
            e1.appendChild(e2);
        } else if (this.options.definitions.equals("TYPE")) {
            Document cDocument = this.createDocument();
            ProcessingInstruction proci = cDocument.createProcessingInstruction("xml", "version='1.0' encoding='" + this.model.characterEncoding() + "'");
            cDocument.appendChild(proci);
            proci = cDocument.createProcessingInstruction("xml-stylesheet", "type='text/xsl' href='./ShapeChangeDefinitionsType.xsl'");
            cDocument.appendChild(proci);
            Element ec = this.createTypeDefinition(this.pi, cDocument, ci, t);
            cDocument.appendChild(ec);
            this.addAttribute(cDocument, ec, "xmlns:gml", this.options.GML_NS);
            this.addAttribute(cDocument, ec, "xmlns:def", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.4");
            this.addAttribute(cDocument, ec, "xmlns:xlink", "http://www.w3.org/1999/xlink");
            this.addAttribute(cDocument, ec, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.addAttribute(cDocument, ec, "xsi:schemaLocation", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.4 ShapeChangeDefinitions.xsd");
            this.documentMap.put(ci.id(), cDocument);
            Element e1 = this.document.createElementNS(this.options.GML_NS, "dictionaryEntry");
            this.addAttribute(this.document, e1, "xlink:href", "urn:x-ogc:def:" + t + ":" + this.options.namingAuthority + "::" + this.pi.xmlns() + ":" + this.pi.version() + ":" + ci.name());
            this.root.appendChild(e1);
        }
    }

    private Element createTypeDefinition(PackageInfo asi, Document lDocument, ClassInfo ci, String t) {
        Element e2;
        Element e1 = lDocument.createElementNS("http://www.interactive-instruments.de/ShapeChange/Definitions/0.4", "TypeDefinition");
        this.addAttribute(lDocument, e1, "gml:id", ci.id());
        String s = this.model.taggedValue(ci.id(), "documentation");
        if (s != null) {
            e2 = lDocument.createElementNS(this.options.GML_NS, "description");
            e2.appendChild(lDocument.createTextNode(s));
            e1.appendChild(e2);
        }
        e2 = lDocument.createElementNS(this.options.GML_NS, "identifier");
        e2.appendChild(lDocument.createTextNode("urn:x-ogc:def:" + t + ":" + this.options.namingAuthority + "::" + ci.pkg().xmlns() + ":" + ci.pkg().version() + ":" + ci.name()));
        this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.4");
        e1.appendChild(e2);
        s = this.model.taggedValue(ci.id(), "Title");
        if (s != null) {
            e2 = lDocument.createElementNS(this.options.GML_NS, "name");
            this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.4/title");
            e2.appendChild(lDocument.createTextNode(s));
            e1.appendChild(e2);
        }
        if ((s = this.model.taggedValue(ci.id(), "primaryCode")) != null) {
            e2 = lDocument.createElementNS(this.options.GML_NS, "name");
            this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.4/primaryCode");
            e2.appendChild(lDocument.createTextNode(s));
            e1.appendChild(e2);
        }
        if ((s = this.model.taggedValue(ci.id(), "secondaryCode")) != null) {
            e2 = lDocument.createElementNS(this.options.GML_NS, "name");
            this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.4/secondaryCode");
            e2.appendChild(lDocument.createTextNode(s));
            e1.appendChild(e2);
        }
        e2 = lDocument.createElementNS(this.options.GML_NS, "name");
        this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.4/name");
        e2.appendChild(lDocument.createTextNode(ci.name()));
        e1.appendChild(e2);
        for (PropertyInfo propi : ci.properties().values()) {
            if (!propi.isNavigable() || propi.restriction()) continue;
            e2 = lDocument.createElementNS(this.options.GML_NS, "dictionaryEntry");
            e1.appendChild(e2);
            Element e3 = lDocument.createElementNS("http://www.interactive-instruments.de/ShapeChange/Definitions/0.4", "PropertyDefinition");
            this.addAttribute(lDocument, e3, "gml:id", propi.id());
            e2.appendChild(e3);
            s = this.model.taggedValue(propi.id(), "lDocumentation");
            if (s != null) {
                e2 = lDocument.createElementNS(this.options.GML_NS, "description");
                e2.appendChild(lDocument.createTextNode(s));
                e3.appendChild(e2);
            }
            e2 = lDocument.createElementNS(this.options.GML_NS, "identifier");
            e2.appendChild(lDocument.createTextNode("urn:x-ogc:def:propertyType:" + this.options.namingAuthority + "::" + ci.pkg().xmlns() + ":" + ci.pkg().version() + ":" + ci.name() + ":" + propi.name()));
            this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.4");
            e3.appendChild(e2);
            s = this.model.taggedValue(propi.id(), "Title");
            if (s != null) {
                e2 = lDocument.createElementNS(this.options.GML_NS, "name");
                this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.4/title");
                e2.appendChild(lDocument.createTextNode(s));
                e3.appendChild(e2);
            }
            if ((s = this.model.taggedValue(propi.id(), "primaryCode")) != null) {
                e2 = lDocument.createElementNS(this.options.GML_NS, "name");
                this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.4/primaryCode");
                e2.appendChild(lDocument.createTextNode(s));
                e3.appendChild(e2);
            }
            if ((s = this.model.taggedValue(propi.id(), "secondaryCode")) != null) {
                e2 = lDocument.createElementNS(this.options.GML_NS, "name");
                this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.4/secondaryCode");
                e2.appendChild(lDocument.createTextNode(s));
                e3.appendChild(e2);
            }
            e2 = lDocument.createElementNS(this.options.GML_NS, "name");
            this.addAttribute(lDocument, e2, "codeSpace", "http://www.interactive-instruments.de/ShapeChange/Definitions/0.4/name");
            e2.appendChild(lDocument.createTextNode(propi.name()));
            e3.appendChild(e2);
            ClassInfo ei = this.model.classById(propi.typeInfo().id);
            int cate = ei.category();
            if (ei != null && ei.pkg() != null && (cate == 3 || cate == 2)) {
                for (PropertyInfo vi : ei.properties().values()) {
                    e2 = lDocument.createElementNS(this.options.GML_NS, "dictionaryEntry");
                    e3.appendChild(e2);
                    Element e4 = lDocument.createElementNS("http://www.interactive-instruments.de/ShapeChange/Definitions/0.4", "ListedValueDefinition");
                    this.addAttribute(lDocument, e4, "gml:id", String.valueOf(propi.id()) + "_" + vi.id());
                    e2.appendChild(e4);
                    s = this.model.taggedValue(vi.id(), "lDocumentation");
                    if (s != null) {
                        e2 = lDocument.createElementNS(this.options.GML_NS, "description");
                        e2.appendChild(lDocument.createTextNode(s));
                        e4.appendChild(e2);
                    }
                    e2 = lDocument.createElementNS(this.options.GML_NS, "identifier");
                    if (vi.initialValue() != null) {
                        e2.appendChild(lDocument.createTextNode("urn:x-ogc:def:propertyType:" + this.options.namingAuthority + "::" + ci.pkg().xmlns() + ":" + ci.pkg().version() + ":" + ci.name() + ":" + propi.name() + ":" + vi.initialValue()));
                    } else {
                        e2.appendChild(lDocument.createTextNode("urn:x-ogc:def:propertyType:" + this.options.namingAuthority + "::" + ci.pkg().xmlns() + ":" + ci.pkg().version() + ":" + ci.name() + ":" + propi.name() + ":" + vi.name()));
                    }
                    this.addAttribute(lDocument, e2, "codeSpace", "urn:x-ogc");
                    e4.appendChild(e2);
                    e2 = lDocument.createElementNS(this.options.GML_NS, "name");
                    e2.appendChild(lDocument.createTextNode(vi.name()));
                    e4.appendChild(e2);
                }
            }
            Multiplicity m = propi.cardinality();
            e2 = lDocument.createElementNS("http://www.interactive-instruments.de/ShapeChange/Definitions/0.4", "cardinality");
            if (m.minOccurs == m.maxOccurs) {
                e2.appendChild(lDocument.createTextNode(String.valueOf(m.minOccurs)));
            } else if (m.maxOccurs == Integer.MAX_VALUE || m.maxOccurs == -1) {
                e2.appendChild(lDocument.createTextNode(String.valueOf(m.minOccurs) + "..*"));
            } else {
                e2.appendChild(lDocument.createTextNode(String.valueOf(m.minOccurs) + ".." + m.maxOccurs));
            }
            e3.appendChild(e2);
            if (ei != null && ei.pkg() != null && ei.inSchema(asi) && (cate == 1 || cate == 6 || cate == 5 || cate == 7 || cate == 8 || cate == 9)) {
                e2 = lDocument.createElementNS("http://www.interactive-instruments.de/ShapeChange/Definitions/0.4", "valueTypeRef");
                String t0 = "featureType";
                if (cate == 6) {
                    t0 = "objectType";
                } else if (cate == 5 || cate == 7) {
                    t0 = "dataType";
                } else if (cate == 8 || cate == 9) {
                    t0 = "unionType";
                }
                this.addAttribute(lDocument, e2, "xlink:href", "urn:x-ogc:def:" + t0 + ":" + this.options.namingAuthority + "::" + ei.pkg().xmlns() + ":" + ei.pkg().version() + ":" + ei.name());
            } else {
                e2 = lDocument.createElementNS("http://www.interactive-instruments.de/ShapeChange/Definitions/0.4", "valueTypeName");
                e2.appendChild(lDocument.createTextNode(propi.typeInfo().name));
            }
            e3.appendChild(e2);
            e2 = lDocument.createElementNS("http://www.interactive-instruments.de/ShapeChange/Definitions/0.4", "type");
            if (propi.isAttribute()) {
                e2.appendChild(lDocument.createTextNode("attribute"));
            } else {
                e2.appendChild(lDocument.createTextNode("associationRole"));
            }
            e3.appendChild(e2);
        }
        e2 = lDocument.createElementNS("http://www.interactive-instruments.de/ShapeChange/Definitions/0.4", "classification");
        e2.appendChild(lDocument.createTextNode(t));
        e1.appendChild(e2);
        if (ci.supertypes() != null) {
            Iterator<String> k = ci.supertypes().iterator();
            while (k.hasNext()) {
                ClassInfo ei = this.model.classById(k.next());
                int cate = ei.category();
                if (ei != null && ei.pkg() != null && ei.inSchema(asi) && (cate == 1 || cate == 6 || cate == 5 || cate == 7)) {
                    e2 = lDocument.createElementNS("http://www.interactive-instruments.de/ShapeChange/Definitions/0.4", "supertypeRef");
                    String t0 = "featureType";
                    if (cate == 6) {
                        t0 = "objectType";
                    } else if (cate == 5 || cate == 7) {
                        t0 = "dataType";
                    }
                    this.addAttribute(lDocument, e2, "xlink:href", "urn:x-ogc:def:" + t0 + ":" + this.options.namingAuthority + "::" + ei.pkg().xmlns() + ":" + ei.pkg().version() + ":" + ei.name());
                } else {
                    e2 = lDocument.createElementNS("http://www.interactive-instruments.de/ShapeChange/Definitions/0.4", "supertypeName");
                    e2.appendChild(lDocument.createTextNode(ei.name()));
                }
                e1.appendChild(e2);
            }
        }
        String[] tags = this.options.representTaggedValues.split("\\,");
        int i = 0;
        while (i < tags.length) {
            s = this.model.taggedValue(ci.id(), tags[i].trim());
            if (s != null && !tags[i].trim().equals("primaryCode") && !tags[i].trim().equals("secondaryCode")) {
                e2 = lDocument.createElementNS("http://www.interactive-instruments.de/ShapeChange/Definitions/0.4", "taggedValue");
                this.addAttribute(lDocument, e2, "tag", tags[i].trim());
                e2.appendChild(lDocument.createTextNode(s));
                e1.appendChild(e2);
            }
            ++i;
        }
        return e1;
    }

    @Override
    public int type() {
        return 2;
    }

    @Override
    public void write() {
        if (this.printed) {
            return;
        }
        Properties outputFormat = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        outputFormat.setProperty("indent", "yes");
        outputFormat.setProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        outputFormat.setProperty("encoding", this.model.characterEncoding());
        try {
            File file = new File(String.valueOf(this.options.dirName) + "/index." + this.pi.xmlns() + ".definitions.xml");
            FileWriter outputXML = new FileWriter(file);
            Serializer serializer = SerializerFactory.getSerializer((Properties)outputFormat);
            serializer.setWriter((Writer)outputXML);
            serializer.asDOMSerializer().serialize((Node)this.document);
            outputXML.close();
            if (this.options.definitions.equals("TYPE")) {
                for (ClassInfo ci : this.model.classes(this.pi)) {
                    Document cDocument = this.documentMap.get(ci.id());
                    if (cDocument == null) continue;
                    outputXML = new FileWriter(String.valueOf(this.options.dirName) + "/" + ci.name() + ".definitions.xml");
                    serializer.setWriter((Writer)outputXML);
                    serializer.asDOMSerializer().serialize((Node)cDocument);
                    outputXML.close();
                }
            }
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
        this.printed = true;
    }
}

