<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="html" encoding="iso-8859-1"/>
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master page-width="21cm" page-height="29.7cm" master-name="NArt" margin-top="10mm" margin-bottom="5mm" margin-right="10mm" margin-left="25mm">
					<fo:region-body margin-bottom="20mm" margin-top="40mm"/>
					<fo:region-before region-name="xsl-region-before" extent="40mm"/>
					<fo:region-after region-name="xsl-region-after" extent="15mm"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="A4">
					<fo:repeatable-page-master-reference master-reference="NArt"/>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="xsl-region-before">
					<fo:block height="15mm" text-align="start" font-size="12pt" font-family="serif" border-style="solid" border-after-width="0.5pt" padding="2mm">
						<fo:table table-layout="fixed" inline-progression-dimension.optimum="1pt">
							<fo:table-column column-width="1in" border-style="none"/>
							<fo:table-column border-style="none"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell>
										<fo:block text-align="left">
											<fo:external-graphic height="0.6in" src="logo.bmp"/>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block text-align="center" font-size="8pt" font-weight="bold" line-height="26pt">Arbeitsgemeinschaft der Vermessungsverwaltungen der Lnder der Bundesrepublik Deutschland (AdV)</fo:block>
										<fo:block text-align="center" font-size="14pt" font-weight="bold" line-height="22pt">Nutzungsartenkatalog</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
					<fo:block height="10mm" text-align="start" font-size="10pt" font-family="serif" border-style="solid" border-before-width="0pt" padding="2mm">
						<fo:table table-layout="fixed" inline-progression-dimension.optimum="1pt">
							<fo:table-column border-style="none"/>
							<fo:table-column column-width="40mm" border-style="none"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell>
										<fo:block text-align="start">Version: <xsl:value-of select="FC_FeatureCatalogue/versionNumber"/></fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block text-align="end">Stand: <xsl:value-of select="FC_FeatureCatalogue/versionDate"/></fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="xsl-region-after">
					<fo:block text-align="center" font-size="9pt" font-family="serif" line-height="20pt">&#x2028;<fo:leader/></fo:block>
					<fo:block text-align="center" font-size="9pt" font-family="serif" line-height="20pt">Seite <fo:page-number/>
					</fo:block>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<xsl:for-each select="FC_FeatureCatalogue/AC_FeatureType/nutzungsartkennung|FC_FeatureCatalogue/FC_Value/nutzungsartkennung">
						<xsl:sort select="."/>
						<xsl:apply-templates select="."/>
					</xsl:for-each>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template match="nutzungsartkennung">
		<xsl:variable name="nkn" select="."/>
		<xsl:variable name="nk">
			<xsl:value-of select="$nkn"/>
			<xsl:text> </xsl:text>
			<xsl:choose>
				<xsl:when test="count(following-sibling::nutzungsart)=1">
					<xsl:value-of select="following-sibling::nutzungsart[1]"/>
				</xsl:when>
				<xsl:when test="count(preceding-sibling::label)=1">
					<xsl:value-of select="preceding-sibling::label[1]"/>
				</xsl:when>
				<xsl:otherwise>(Bezeichnung fehlt)</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$nkn mod 1000 = 0">
				<fo:block text-align="start" start-indent="0cm" font-size="9pt" font-family="serif" line-height="16pt"><xsl:value-of select="$nk"/></fo:block>
			</xsl:when>
			<xsl:when test="$nkn mod 100 = 0">
				<fo:block text-align="start" start-indent="1cm" font-size="9pt" font-family="serif" line-height="16pt"><xsl:value-of select="$nk"/></fo:block>
			</xsl:when>
			<xsl:when test="$nkn mod 10 = 0">
				<fo:block text-align="start" start-indent="2cm" font-size="9pt" font-family="serif" line-height="16pt"><xsl:value-of select="$nk"/></fo:block>
			</xsl:when>
			<xsl:otherwise>
				<fo:block text-align="start" start-indent="3cm" font-size="9pt" font-family="serif" line-height="16pt"><xsl:value-of select="$nk"/></fo:block>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
