/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Xmi10;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfoImpl;
import de.interactive_instruments.ShapeChange.Model.Constraint;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.OperationInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Xmi10.OperationInfoXmi10;
import de.interactive_instruments.ShapeChange.Model.Xmi10.PropertyInfoXmi10;
import de.interactive_instruments.ShapeChange.Model.Xmi10.Xmi10Document;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Ocl_OLD.OclConstraint_OLD;
import de.interactive_instruments.ShapeChange.Ocl_OLD.OclParser;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeIgnoreClassException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.UUID;
import java.util.Vector;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfoXmi10
extends ClassInfoImpl
implements ClassInfo {
    protected String id;
    protected Element cla;
    protected Xmi10Document doc;
    protected UUID uuid;
    protected TreeMap<StructuredNumber, PropertyInfo> properties = null;
    protected boolean hasNilReason = false;
    public TreeMap<Integer, OperationInfo> operations;
    private boolean createdConstraints = false;
    private final Vector<Constraint> constraints = new Vector();

    @Override
    public Model model() {
        return this.doc;
    }

    @Override
    public Options options() {
        return this.doc.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.doc.result;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        String[] parts;
        String s = this.doc.textOfProperty(this.cla, "Foundation.Core.ModelElement.name");
        if (s == null) {
            s = this.id();
            this.doc.result.addWarning(100, "class", s);
        } else {
            s = s.trim();
        }
        if (s.indexOf("[") > 0 && (s.endsWith("]") || s.endsWith("}"))) {
            parts = s.split("\\[");
            s = parts[0].trim();
        }
        if (s.indexOf("{") > 0 && s.endsWith("}")) {
            parts = s.split("\\{");
            s = parts[0].trim();
        }
        return s;
    }

    protected Multiplicity roseHiddenCardinality() {
        String s = this.doc.textOfProperty(this.cla, "Foundation.Core.ModelElement.name");
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).indexOf("[") > 0 && s.indexOf("]") > 0) {
            String[] parts = s.split("\\[");
            s = parts[1].trim();
            String[] parts2 = s.split("\\]");
            s = parts2[0].trim();
            return this.doc.cardinalityFromString(s);
        }
        return null;
    }

    protected String roseHiddenLabels() {
        String s = this.doc.textOfProperty(this.cla, "Foundation.Core.ModelElement.name");
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).indexOf("{") > 0 && s.endsWith("}")) {
            String[] parts = s.split("\\{");
            s = parts[1].substring(0, parts[1].length() - 1).trim();
            return s;
        }
        return null;
    }

    @Override
    public boolean isAbstract() {
        return this.doc.attributeOfProperty(this.cla, "Foundation.Core.GeneralizableElement.isAbstract", "xmi.value").equals("true");
    }

    @Override
    public boolean isLeaf() {
        return this.doc.attributeOfProperty(this.cla, "Foundation.Core.GeneralizableElement.isLeaf", "xmi.value").equals("true");
    }

    @Override
    public PackageInfo pkg() {
        PackageInfo pkg;
        String propId = this.doc.idOfProperty(this.cla, "Foundation.Core.ModelElement.namespace");
        if (propId.length() == 0) {
            propId = this.doc.getOwnerIdAsString(this.cla);
        }
        if ((pkg = this.doc.fPackages.get(propId)) == null) {
            this.doc.result.addInfo(1001, this.name(), this.id, propId);
        }
        return pkg;
    }

    @Override
    public String stereotype() {
        String s;
        String stereotype = this.doc.fStereotypes.get(this.id);
        if (stereotype == null) {
            stereotype = "";
        }
        if ((s = this.doc.options.stereotypeAlias(stereotype)) != null) {
            stereotype = s;
        }
        return stereotype;
    }

    @Override
    public String taggedValue(String tag) {
        return this.doc.taggedValue(this.id, tag);
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String[] tags = tagList.split("\\,");
        int i = 0;
        while (i < tags.length) {
            String s = this.taggedValue(tags[i].trim());
            if (s != null) {
                ret.put(tags[i].trim(), s);
            }
            ++i;
        }
        return ret;
    }

    @Override
    public HashSet<String> supertypes() {
        return this.doc.fSupertypes.get(this.id);
    }

    @Override
    public HashSet<String> subtypes() {
        return this.doc.fSubtypes.get(this.id);
    }

    @Override
    public boolean hasNilReason() {
        return this.hasNilReason;
    }

    @Override
    public TreeMap<StructuredNumber, PropertyInfo> properties() {
        return this.properties;
    }

    @Override
    public PropertyInfo property(String name) {
        for (PropertyInfo pi : this.properties.values()) {
            if (pi == null || !pi.name().equals(name)) continue;
            return pi;
        }
        HashSet<String> st = this.supertypes();
        if (st != null) {
            Iterator<String> j = st.iterator();
            while (j.hasNext()) {
                PropertyInfo pi;
                ClassInfo ci = this.doc.classById(j.next());
                if (ci == null || (pi = ci.property(name)) == null) continue;
                return pi;
            }
        }
        return null;
    }

    public ClassInfoXmi10(Xmi10Document d, Element e) throws ShapeChangeAbortException, ShapeChangeIgnoreClassException {
        PropertyInfo piTemp;
        this.cla = e;
        this.doc = d;
        this.id = this.cla.getAttribute("xmi.id");
        this.uuid = UUID.randomUUID();
        if (this.cla.getNodeName().equals("Foundation.Core.DataType")) {
            this.category = this.doc.isOwnerOfEnumeration(this.cla) ? 3 : 5;
        } else if (this.cla.getNodeName().equals("Foundation.Core.Interface")) {
            this.category = 4;
        } else if (this.cla.getNodeName().equals("Foundation.Core.Class")) {
            this.establishCategory();
        } else {
            this.establishCategory();
        }
        this.properties = new TreeMap();
        Vector<String> attids = this.doc.idsOfProperty(this.cla, "Foundation.Core.Classifier.feature");
        attids.addAll(this.doc.idsOfProperty(this.cla, "Foundation.Core.Enumeration.literal"));
        Iterator<String> i = attids.iterator();
        while (i.hasNext()) {
            Element att = this.doc.getElementById(i.next());
            if (!att.getNodeName().equals("Foundation.Core.Attribute") && !att.getNodeName().equals("Foundation.Core.EnumerationLiteral") || !this.doc.visible(att) || !this.doc.notAReference(att)) continue;
            PropertyInfoXmi10 atti = new PropertyInfoXmi10(this.doc, att, true);
            atti.inClass(this);
            piTemp = this.properties.get(atti.sequenceNumber());
            if (piTemp != null) {
                this.doc.result.addError(107, atti.name(), this.name(), piTemp.name());
            }
            this.properties.put(atti.sequenceNumber(), atti);
            if (!atti.implementedByNilReason()) continue;
            this.hasNilReason = true;
        }
        Vector<PropertyInfo> roles = this.doc.fRoles.get(this.id);
        if (roles != null) {
            for (PropertyInfo ri : roles) {
                ((PropertyInfoXmi10)ri).inClass(this);
                piTemp = this.properties.get(ri.sequenceNumber());
                if (piTemp != null) {
                    this.doc.result.addError(107, ri.name(), this.name(), piTemp.name());
                }
                this.properties.put(ri.sequenceNumber(), ri);
                if (!ri.implementedByNilReason()) continue;
                this.hasNilReason = true;
            }
        }
        Vector<String> opids = this.doc.idsOfProperty(this.cla, "Foundation.Core.Classifier.feature");
        this.operations = new TreeMap();
        Iterator<String> i2 = opids.iterator();
        while (i2.hasNext()) {
            Element e1 = this.doc.getElementById(i2.next());
            if (!e1.getNodeName().equals("Foundation.Core.Operation") || !this.doc.visible(e1) || !this.doc.notAReference(e1)) continue;
            OperationInfoXmi10 opi = new OperationInfoXmi10(this.doc, e1);
            this.operations.put(this.doc.globalSequenceNumber++, opi);
        }
        if (this.category == 8 && this.encodingRule("xsd").equals("iso19136_2007_ShapeChange_1.0_Extensions") && this.hasNilReason() && this.properties.size() == 2) {
            this.category = 9;
        }
        this.doc.result.addDebug(10013, "class (" + this.category + ")", this.id, this.name());
    }

    @Override
    public ClassInfo baseClass() {
        int stsize = 0;
        ClassInfo cir = null;
        int cat = this.category();
        if (cat == 1 || cat == 6 || cat == 5 || cat == 4 || cat == 8) {
            HashSet<String> st = this.supertypes();
            if (st != null) {
                for (String sid : st) {
                    ClassInfo cix = this.doc.fClasses.get(sid);
                    if (cix != null) {
                        if (cat == cix.category() && cix.category() != -1 && cix.category() != 4) {
                            ++stsize;
                            cir = cix;
                            continue;
                        }
                        if (cix.category() == 4 || cix.category() == -1) continue;
                        this.doc.result.addError(108, this.name());
                        this.doc.result.addDebug(10003, this.name(), "" + cat, "!FALSE");
                        this.doc.result.addDebug(10003, this.name(), "" + cix.category(), "!TRUE");
                        continue;
                    }
                    ++stsize;
                }
            }
            if (stsize > 1) {
                this.doc.result.addError(109, this.name());
            }
        }
        return cir;
    }

    @Override
    public Vector<Constraint> constraints() {
        if (this.createdConstraints) {
            return this.constraints;
        }
        String tv = this.doc.taggedValue(this.id, "oclExpressions");
        if (tv != null) {
            OclParser parser = new OclParser(this.doc, this.doc.result);
            String[] expList = tv.split("inv:");
            int i = 0;
            while (i < expList.length) {
                OclConstraint_OLD c;
                String s = expList[i].trim();
                if (s != null && !s.equals("") && (c = parser.constraint(s, this)) != null) {
                    this.constraints.add(c);
                }
                ++i;
            }
        }
        this.createdConstraints = true;
        return this.constraints;
    }
}

