<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0"
		xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc"
		xmlns:gml="http://www.opengis.net/gml/3.2">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="../utility.xslt"/>
	<!-- =========================================================== -->
	<xsl:variable name="anlassart"     select="//adv:art"/> 		
	<xsl:variable name="antragsnummer" select="//adv:antragsnummer"/>
	<!-- =========================================================== -->	
	<!-- =========================================================== -->
	<!-- Keys zur Gruppierung über die Funktionswerte auf Regierungsbezirk -->
	<xsl:key name="TNFL_funktionOA"  match="//flaecheTNRBez/AX_K_TNFL_all/funktionOA" use="."/>
	<xsl:key name="TNGR_funktionOA"  match="//flaechensummeOARBez/AX_K_TNGR_all/funktionOA" use="."/>
	<xsl:key name="TNHGR_funktionOA" match="//flaechensummeHGrRBez/AX_K_TNHGR_all/funktionHGr" use="."/>
	<!-- =========================================================== -->
	<!-- Summierung von Flächenwerten für gleichen Funktionswert und Bildung neuer Blöcke -->
	<xsl:template name="flaechensumme">
		<xsl:param name="nodes"/>	
		<xsl:param name="key"/>	
		<xsl:param name="elem1"/>	
		<xsl:param name="elem2"/>	
		<xsl:param name="gebiet"/>	
		<!-- Summenbildung über eindeutige Funktionswerte -->
		<xsl:variable name="unique"> <!-- Hier stand vorher nur: variable name="unique" select="$nodes/adv:funktionOA[count(.|key($key,.)[1]) = 1]" -->
		  	<xsl:choose><!-- Bei AX_K_TNHGR_all funktionHGr, bei AX_K_TNFL_all und AX_K_TNGR_all funktionOA -->
		    	<xsl:when test="$elem2 = 'AX_K_TNFL_all' or $elem2 = 'AX_K_TNGR_all'">
		      		<xsl:copy-of select="$nodes/adv:funktionOA[count(.|key($key,.)[1]) = 1]"/>
		    	</xsl:when>
		    	<xsl:when test="$elem2 = 'AX_K_TNHGR_all'">
		      		<xsl:copy-of select="$nodes/adv:funktionHGr[count(.|key($key,.)[1]) = 1]"/>
		    	</xsl:when>
		  	</xsl:choose>
		</xsl:variable>
		<xsl:for-each select="$unique">
			<xsl:sort select="."/>
			<xsl:element name="$elem1">
				<xsl:element name="$elem2">
					<gebiet>
						<xsl:value-of select="$gebiet"/>
					</gebiet>
					<xsl:choose><!-- Bei AX_K_TNHGR_all funktionHGr, bei AX_K_TNFL_all und AX_K_TNGR_all funktionOA -->
					 	<xsl:when test="$elem2 = 'AX_K_TNFL_all' or $elem2 = 'AX_K_TNGR_all'">
					  		<funktionOA>
								<xsl:value-of select="."/>
					  		</funktionOA>
					 	</xsl:when>
					 	<xsl:when test="$elem2 = 'AX_K_TNHGR_all'">
					  		<funktionHGr>
								<xsl:value-of select="."/>
					  		</funktionHGr>
					 	</xsl:when>
					</xsl:choose>
					<flaeche>
						<xsl:variable name="val" select="."/>
						<xsl:value-of select="sum($nodes/adv:funktionOA[. = $val]/../adv:flaeche)"/>
					</flaeche>
				</xsl:element>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template name="naechsteSumme">	
		<!-- Summenbildung für Bundesland über regierungsbezirk -->
		<xsl:for-each select="document('E1.xml')//adv:AX_Bundesland">
			<xsl:sort select="adv:schluesselGesamt"/>
			<!-- Summenbildungen -->			
			<xsl:variable name="schluessel" select="adv:schluesselGesamt"/>
			<xsl:call-template name="flaechensumme">
				<xsl:with-param name="nodes"  select="//adv:flaecheTNRBez/adv:AX_K_TNFL_all[starts-with(adv:gebiet,$schluessel)]"/>
				<xsl:with-param name="key"    select="'TNFL_funktionOA'"/>
				<xsl:with-param name="elem1"  select="'flaecheTNLand'"/>	
				<xsl:with-param name="elem2"  select="'AX_K_TNFL_all'"/>	
				<xsl:with-param name="gebiet" select="$schluessel"/>	
			</xsl:call-template>
		</xsl:for-each>
		<xsl:for-each select="document('E1.xml')//adv:AX_Bundesland">
			<xsl:sort select="adv:schluesselGesamt"/>
			<!-- Summenbildungen -->			
			<xsl:variable name="schluessel" select="adv:schluesselGesamt"/>
			<xsl:call-template name="flaechensumme">
				<xsl:with-param name="nodes"  select="//adv:flaechensummeOARBez/adv:AX_K_TNGR_all[starts-with(adv:gebiet,$schluessel)]"/>
				<xsl:with-param name="key"    select="'TNGR_funktionOA'"/>
				<xsl:with-param name="elem1"  select="'flaechensummeOALand'"/>	
				<xsl:with-param name="elem2"  select="'AX_K_TNGR_all'"/>	
				<xsl:with-param name="gebiet" select="$schluessel"/>	
			</xsl:call-template>
		</xsl:for-each>
		<xsl:for-each select="document('E1.xml')//adv:AX_Bundesland">
			<xsl:sort select="adv:schluesselGesamt"/>
			<!-- Summenbildungen -->			
			<xsl:variable name="schluessel" select="adv:schluesselGesamt"/>
			<xsl:call-template name="flaechensumme">
				<xsl:with-param name="nodes"  select="//adv:flaechensummeHGrRBez/adv:AX_K_TNHGR_all[starts-with(adv:gebiet,$schluessel)]"/>
				<xsl:with-param name="key"    select="'TNHGR_funktionOA'"/>
				<xsl:with-param name="elem1"  select="'flaechensummeHGrLand'"/>	
				<xsl:with-param name="elem2"  select="'AX_K_TNHGR_all'"/>	
				<xsl:with-param name="gebiet" select="$schluessel"/>	
			</xsl:call-template>
		</xsl:for-each>
		<xsl:for-each select="document('E1.xml')//adv:AX_Bundesland">
			<xsl:sort select="adv:schluesselGesamt"/>
			<!-- Summenbildungen -->			
			<xsl:variable name="schluessel" select="adv:schluesselGesamt"/>
			<gesamtflaecheLand>
				<AX_K_FLASU>
					<gebiet>
						<xsl:value-of select="$schluessel"/>
					</gebiet>
					<flaechensumme>
						<xsl:value-of select="sum(//adv:gesamtflaecheRBez/adv:AX_K_FLASU[starts-with(adv:gebiet,$schluessel)]/adv:flaechensumme)"/>
					</flaechensumme>
				</AX_K_FLASU>
			</gesamtflaecheLand>
		</xsl:for-each>
	</xsl:template>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<xsl:choose>
			<xsl:when test="$anlassart = '2110' or $anlassart = '2120' or $anlassart = '2121' or $anlassart = '2130' or $anlassart = '2131' or $anlassart = '2140' or $anlassart = '2141'">
				<!-- nur Regierungsbezirk-, KreisRegion-, Gemeinde- und/oder Gemarkungsstatistik:  somit hat der vorhergehende Schritt das Endergebnis ermittelt -->
				<xsl:copy-of select="document('A6_Statistik_Regierungsbezirk.xml)/."/>
			</xsl:when>
			<xsl:otherwise>
				<!-- sonst: Muss die vorhergehende Statistik (Regierungsbezirk-Statistik) gelöscht werden? -->
				<xsl:variable name="clear">
					<xsl:choose>
						<xsl:when test="$anlassart = '2151'">
							<!-- komplette Statistik: Regierungsbezirk-Statistik nicht löschen -->
							<xsl:value-of select="''"/>
						</xsl:when>
						<xsl:otherwise>
							<!-- nur höchste Statistik: Regierungsbezirk-Statistik löschen -->
							<xsl:value-of select="'flaecheTNRBez,flaechensummeOARBez,flaechensummeHGrRBez,gesamtflaecheRBez'"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<AX_StatistikDerFlaechenDerTatsaechlichenNutzung_all xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:ext="http://www.jclark.com/xt/java/de.adv-online.AAA" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
					<!-- Teile vom vorhergehenden Ergebnis kopieren, ggf. Regierungsbezirk-Statistik löschen -->
					<xsl:for-each select="document('A6_Statistik_Regierungsbezirk.xml)/*/*">
						<xsl:if test="not(contains($clear,name(.)))">
							<xsl:copy-of select="."/>
						</xsl:if>
					</xsl:for-each>
					<!-- Bundesland-Statistik über Aggregation der Regierungsbezirk-Statistik bilden -->
					<xsl:call-template name="naechsteSumme"/>
				</AX_StatistikDerFlaechenDerTatsaechlichenNutzung_all>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
