/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic;

import de.interactive_instruments.ShapeChange.Model.AssociationInfo;
import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericAssociationInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPackageInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericPropertyInfo;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.ModelImpl;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.StructuredNumber;
import de.interactive_instruments.ShapeChange.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericModel
extends ModelImpl {
    protected Options options = null;
    protected ShapeChangeResult result = null;
    protected String characterEncoding = null;
    protected Model model = null;
    protected Set<String> appSchemaPackageIds = new HashSet<String>();
    protected Map<String, GenericPropertyInfo> genPropertiesById = new HashMap<String, GenericPropertyInfo>();
    protected Map<String, GenericAssociationInfo> genAssociationInfosById = new HashMap<String, GenericAssociationInfo>();
    protected Map<String, GenericClassInfo> genClassInfosById = new HashMap<String, GenericClassInfo>();
    protected Map<String, GenericClassInfo> genClassInfosByName = new HashMap<String, GenericClassInfo>();
    protected Map<String, GenericPackageInfo> genPackageInfosById = new HashMap<String, GenericPackageInfo>();
    protected Map<String, GenericPackageInfo> genAppSchema = new HashMap<String, GenericPackageInfo>();

    public GenericModel(Model model) {
        this.options = model.options();
        this.result = model.result();
        this.model = model;
        this.characterEncoding = model.characterEncoding();
        String appSchemaName = this.options.parameter("appSchemaName");
        HashSet<PackageInfo> schemaArr = model.schemas(appSchemaName);
        for (PackageInfo appSchemaPackage : schemaArr) {
            this.appSchemaPackageIds.add(appSchemaPackage.id());
        }
        for (PackageInfo appSchemaPackage : schemaArr) {
            if (this.options.skipSchema(null, appSchemaPackage)) continue;
            this.genAppSchema.put(appSchemaPackage.name(), this.createGenericPackageInfo(appSchemaPackage, this));
        }
        for (GenericPackageInfo gpi : this.genPackageInfosById.values()) {
            PackageInfo packageInfo = model.packageById(gpi.id());
            HashSet<ClassInfo> packageClassInfos = model.classes(packageInfo);
            for (PackageInfo childPackage : packageInfo.containedPackages()) {
                packageClassInfos.removeAll(model.classes(childPackage));
            }
            HashSet<ClassInfo> genericClassInfos = new HashSet<ClassInfo>();
            for (ClassInfo ci : packageClassInfos) {
                GenericClassInfo genCi = new GenericClassInfo(this, ci.id(), ci.name(), ci.category());
                genCi.setAliasName(ci.aliasName());
                genCi.setDocumentation(ci.documentation());
                genCi.setStereotype(ci.stereotype());
                genCi.setTaggedValues(this.copy(ci.taggedValues()));
                genCi.setXmlSchemaType(ci.xmlSchemaType());
                genCi.setIncludePropertyType(ci.includePropertyType());
                genCi.setIncludeByValuePropertyType(ci.includeByValuePropertyType());
                genCi.setIsCollection(ci.isCollection());
                genCi.setAsDictionary(ci.asDictionary());
                genCi.setAsGroup(ci.asGroup());
                genCi.setAsCharacterString(ci.asCharacterString());
                genCi.setHasNilReason(ci.hasNilReason());
                genCi.setPkg(ci.pkg());
                genCi.setIsAbstract(ci.isAbstract());
                genCi.setIsLeaf(ci.isLeaf());
                genCi.setAssocInfo(ci.isAssocClass());
                genCi.setSupertypes(this.copy(ci.supertypes()));
                genCi.setSubtypes(this.copy(ci.subtypes()));
                genCi.setBaseClass(ci.baseClass());
                genCi.setProperties(ci.properties());
                genCi.setConstraints(ci.constraints());
                genCi.setSuppressed(ci.suppressed());
                genCi.setAsDictionaryGml33(ci.asDictionaryGml33());
                genericClassInfos.add(genCi);
                this.genClassInfosById.put(genCi.id, genCi);
                this.genClassInfosByName.put(genCi.name, genCi);
            }
            gpi.setClasses(genericClassInfos);
        }
        for (GenericClassInfo genCi : this.genClassInfosById.values()) {
            TreeMap<StructuredNumber, PropertyInfo> treeMap = genCi.properties();
            if (treeMap == null) continue;
            for (PropertyInfo pi : treeMap.values()) {
                if (this.genPropertiesById.containsKey(pi.id())) continue;
                GenericPropertyInfo genPi = new GenericPropertyInfo(this, pi.id(), pi.name(), pi.categoryOfValue());
                genPi.setAliasName(pi.aliasName());
                genPi.setDocumentation(pi.documentation());
                genPi.setTaggedValues(this.copy(pi.taggedValues()));
                genPi.setDerived(pi.isDerived());
                genPi.setAttribute(pi.isAttribute());
                genPi.setTypeInfo(pi.typeInfo());
                genPi.setNavigable(pi.isNavigable());
                genPi.setOrdered(pi.isOrdered());
                genPi.setComposition(pi.isComposition());
                genPi.setAggregation(pi.isAggregation());
                Multiplicity mult = pi.cardinality();
                Multiplicity multC = new Multiplicity();
                multC.maxOccurs = mult.maxOccurs;
                multC.minOccurs = mult.minOccurs;
                genPi.setCardinality(multC);
                genPi.setInitialValue(pi.initialValue());
                genPi.setInlineOrByReference(pi.inlineOrByReference());
                genPi.setDefaultCodeSpace(pi.defaultCodeSpace());
                genPi.setMetadata(pi.isMetadata());
                genPi.setReverseProperty(pi.reverseProperty());
                genPi.setInClass(pi.inClass());
                StructuredNumber strucNum = pi.sequenceNumber();
                genPi.setSequenceNumber(this.copy(strucNum));
                genPi.setImplementedByNilReason(pi.implementedByNilReason());
                genPi.setVoidable(pi.voidable());
                genPi.setConstraints(pi.constraints());
                genPi.setAssociation(pi.association());
                genPi.setRestriction(pi.isRestriction());
                genPi.setNilReasonAllowed(pi.nilReasonAllowed());
                this.genPropertiesById.put(genPi.id, genPi);
            }
        }
        HashMap<String, GenericPropertyInfo> additionalPropsFromAssociationEnds = new HashMap<String, GenericPropertyInfo>();
        for (GenericPropertyInfo genericPropertyInfo : this.genPropertiesById.values()) {
            AssociationInfo ai = genericPropertyInfo.association();
            if (ai == null || this.genAssociationInfosById.containsKey(ai.id())) continue;
            GenericAssociationInfo genAi = new GenericAssociationInfo();
            genAi.setOptions(ai.options());
            genAi.setResult(ai.result());
            genAi.setModel(this);
            genAi.setId(ai.id());
            genAi.setName(ai.name());
            genAi.setAliasName(ai.aliasName());
            genAi.setDocumentation(ai.documentation().replaceAll("---", "--"));
            genAi.setStereotype(ai.stereotype());
            genAi.setTaggedValues(this.copy(ai.taggedValues()));
            genAi.setEnd1(ai.end1());
            genAi.setEnd2(ai.end2());
            if (!this.genPropertiesById.containsKey(ai.end1().id()) && !additionalPropsFromAssociationEnds.containsKey(ai.end1().id())) {
                GenericPropertyInfo genEnd1Prop = this.createCopy(ai.end1(), ai.end1().id());
                additionalPropsFromAssociationEnds.put(genEnd1Prop.id(), genEnd1Prop);
            }
            if (!this.genPropertiesById.containsKey(ai.end2().id()) && !additionalPropsFromAssociationEnds.containsKey(ai.end2().id())) {
                GenericPropertyInfo genEnd2Prop = this.createCopy(ai.end2(), ai.end2().id());
                additionalPropsFromAssociationEnds.put(genEnd2Prop.id(), genEnd2Prop);
            }
            genAi.setAssocClass(ai.assocClass());
            this.genAssociationInfosById.put(genAi.id(), genAi);
        }
        for (GenericPropertyInfo genericPropertyInfo : additionalPropsFromAssociationEnds.values()) {
            this.genPropertiesById.put(genericPropertyInfo.id(), genericPropertyInfo);
        }
        for (GenericPackageInfo genericPackageInfo : this.genPackageInfosById.values()) {
            PackageInfo owner = genericPackageInfo.owner();
            genericPackageInfo.setOwner(this.updatePackageInfo(owner));
            PackageInfo rootPackage = genericPackageInfo.rootPackage();
            genericPackageInfo.setRootPackage(this.updatePackageInfo(rootPackage));
            HashSet<PackageInfo> childPi_update = new HashSet<PackageInfo>();
            for (PackageInfo genChild : genericPackageInfo.containedPackages()) {
                childPi_update.add(this.updatePackageInfo(genChild));
            }
            genericPackageInfo.setContainedPackages(childPi_update);
            HashSet<ClassInfo> classes_update = new HashSet<ClassInfo>();
            for (ClassInfo cI : genericPackageInfo.getClasses()) {
                classes_update.add(this.updateClassInfo(cI));
            }
            genericPackageInfo.setClasses(classes_update);
        }
        for (GenericClassInfo genericClassInfo : this.genClassInfosById.values()) {
            PackageInfo pkg = genericClassInfo.pkg();
            genericClassInfo.setPkg(this.updatePackageInfo(pkg));
            AssociationInfo assoClass = genericClassInfo.isAssocClass();
            genericClassInfo.setAssocInfo(this.updateAssociationInfo(assoClass));
            ClassInfo baseClass = genericClassInfo.baseClass();
            genericClassInfo.setBaseClass(this.updateClassInfo(baseClass));
            TreeMap<StructuredNumber, PropertyInfo> properties = genericClassInfo.properties();
            TreeMap<StructuredNumber, PropertyInfo> propertiesC = new TreeMap<StructuredNumber, PropertyInfo>();
            for (StructuredNumber sn : properties.keySet()) {
                PropertyInfo pValue = this.updatePropertyInfo(properties.get(sn));
                propertiesC.put(pValue.sequenceNumber(), pValue);
            }
            genericClassInfo.setProperties(propertiesC);
        }
        for (GenericPropertyInfo genericPropertyInfo : this.genPropertiesById.values()) {
            PropertyInfo reverseProperty = genericPropertyInfo.reverseProperty();
            genericPropertyInfo.setReverseProperty(this.updatePropertyInfo(reverseProperty));
            ClassInfo inClass = genericPropertyInfo.inClass();
            genericPropertyInfo.setInClass(this.updateClassInfo(inClass));
            AssociationInfo association = genericPropertyInfo.association();
            genericPropertyInfo.setAssociation(this.updateAssociationInfo(association));
        }
        for (GenericAssociationInfo genericAssociationInfo : this.genAssociationInfosById.values()) {
            this.updateAssociationInfoContent(genericAssociationInfo);
        }
    }

    private void updateAssociationInfoContent(GenericAssociationInfo gai) {
        PropertyInfo end1 = gai.end1();
        gai.setEnd1(this.updatePropertyInfo(end1));
        PropertyInfo end2 = gai.end2();
        gai.setEnd2(this.updatePropertyInfo(end2));
        ClassInfo assocClass = gai.assocClass();
        gai.setAssocClass(this.updateClassInfo(assocClass));
    }

    private StructuredNumber copy(StructuredNumber strucNum) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strucNum.components.length - 1; ++i) {
            sb.append(strucNum.components[i] + ".");
        }
        sb.append(strucNum.components[strucNum.components.length - 1]);
        StructuredNumber res = new StructuredNumber(sb.toString());
        return res;
    }

    private PackageInfo updatePackageInfo(PackageInfo pIn) {
        if (pIn == null) {
            return null;
        }
        if (this.genPackageInfosById.containsKey(pIn.id())) {
            return this.genPackageInfosById.get(pIn.id());
        }
        return pIn;
    }

    private ClassInfo updateClassInfo(ClassInfo cIn) {
        if (cIn == null) {
            return null;
        }
        if (this.genClassInfosById.containsKey(cIn.id())) {
            return this.genClassInfosById.get(cIn.id());
        }
        return cIn;
    }

    private PropertyInfo updatePropertyInfo(PropertyInfo pIn) {
        if (pIn == null) {
            return null;
        }
        if (this.genPropertiesById.containsKey(pIn.id())) {
            return this.genPropertiesById.get(pIn.id());
        }
        return pIn;
    }

    public void addClass(GenericClassInfo genCi) {
        this.genClassInfosById.put(genCi.id(), genCi);
        this.genClassInfosByName.put(genCi.name(), genCi);
        this.genPackageInfosById.put(genCi.pkg().id(), (GenericPackageInfo)genCi.pkg());
        ((GenericPackageInfo)genCi.pkg()).addClass(genCi);
        if (genCi.isAssocClass() != null) {
            this.genAssociationInfosById.put(genCi.isAssocClass().id(), (GenericAssociationInfo)genCi.isAssocClass());
        }
        if (genCi.properties() != null && genCi.properties().size() > 0) {
            for (PropertyInfo pi : genCi.properties().values()) {
                this.genPropertiesById.put(pi.id(), (GenericPropertyInfo)pi);
            }
        }
    }

    private AssociationInfo updateAssociationInfo(AssociationInfo aIn) {
        if (aIn == null) {
            return null;
        }
        if (this.genAssociationInfosById.containsKey(aIn.id())) {
            return this.genAssociationInfosById.get(aIn.id());
        }
        return aIn;
    }

    private GenericPackageInfo createGenericPackageInfo(PackageInfo pi, GenericModel model) {
        if (this.genPackageInfosById.containsKey(pi.id())) {
            return this.genPackageInfosById.get(pi.id());
        }
        GenericPackageInfo genPi = new GenericPackageInfo();
        genPi.setOptions(pi.options());
        genPi.setResult(pi.result());
        genPi.setModel(model);
        genPi.setId(pi.id());
        genPi.setName(pi.name());
        genPi.setAliasName(pi.aliasName());
        genPi.setDocumentation(pi.documentation().replaceAll("---", "--"));
        genPi.setStereotype(pi.stereotype());
        genPi.setTaggedValues(this.copy(pi.taggedValues()));
        genPi.setTargetNamespace(pi.targetNamespace());
        genPi.setXmlns(pi.xmlns());
        genPi.setXsdDocument(pi.xsdDocument());
        genPi.setGmlProfileSchema(pi.gmlProfileSchema());
        genPi.setVersion(pi.version());
        genPi.setOwner(pi.owner());
        genPi.setSchemaId(pi.schemaId());
        genPi.setRootPackage(pi.rootPackage());
        genPi.setIsAppSchema(pi.isAppSchema());
        genPi.setIsSchema(pi.isSchema());
        HashSet<PackageInfo> genChildPi = new HashSet<PackageInfo>();
        for (PackageInfo childPi : pi.containedPackages()) {
            genChildPi.add(this.createGenericPackageInfo(childPi, this));
        }
        genPi.setContainedPackages(genChildPi);
        genPi.setSupplierIds(this.copy(pi.supplierIds()));
        this.genPackageInfosById.put(genPi.id(), genPi);
        return genPi;
    }

    private HashMap<String, String> copy(HashMap<String, String> hm) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String key : hm.keySet()) {
            res.put(key, hm.get(key));
        }
        return res;
    }

    public boolean isInAppSchema(PackageInfo pi) {
        if (this.appSchemaPackageIds.contains(pi.id())) {
            return true;
        }
        if (pi.owner() != null) {
            return this.isInAppSchema(pi.owner());
        }
        return false;
    }

    public boolean isInAppSchema(ClassInfo ci) {
        return this.isInAppSchema(ci.pkg());
    }

    @Override
    public Options options() {
        return this.options;
    }

    @Override
    public ShapeChangeResult result() {
        return this.result;
    }

    @Override
    public void initialise(ShapeChangeResult r, Options o, String repositoryFileName) throws ShapeChangeAbortException {
        this.result = r;
        this.options = o;
    }

    @Override
    public int type() {
        return 0;
    }

    @Override
    public HashSet<PackageInfo> schemas(String name) {
        HashSet<PackageInfo> res = new HashSet<PackageInfo>();
        for (PackageInfo pi : this.model.schemas(name)) {
            GenericPackageInfo tmp;
            if (!pi.isSchema()) continue;
            if (name != null && !name.equals("")) {
                if (!pi.name().equals(name)) continue;
                tmp = null;
                for (GenericPackageInfo genPi : this.genPackageInfosById.values()) {
                    if (!genPi.name().equals(name)) continue;
                    tmp = genPi;
                    break;
                }
                if (tmp != null) {
                    res.add(tmp);
                    continue;
                }
                res.add(pi);
                continue;
            }
            tmp = null;
            for (GenericPackageInfo genPi : this.genPackageInfosById.values()) {
                if (!genPi.name().equals(pi.name())) continue;
                tmp = genPi;
                break;
            }
            if (tmp != null) {
                res.add(tmp);
                continue;
            }
            res.add(pi);
        }
        return res;
    }

    @Override
    public HashSet<ClassInfo> classes(PackageInfo pi) {
        if (this.genPackageInfosById.containsKey(pi.id())) {
            HashSet<ClassInfo> res = new HashSet<ClassInfo>();
            String tns = pi.targetNamespace();
            return this.addClasses(this.genPackageInfosById.get(pi.id()), tns, res);
        }
        return this.model.classes(pi);
    }

    private HashSet<ClassInfo> addClasses(PackageInfo pi, String tns, HashSet<ClassInfo> res) {
        String ctns = pi.targetNamespace();
        if (!(ctns == null || tns != null && tns.equals(ctns))) {
            return res;
        }
        res.addAll(((GenericPackageInfo)pi).getClasses());
        for (PackageInfo cpi : pi.containedPackages()) {
            res = this.addClasses(cpi, tns, res);
        }
        return res;
    }

    @Override
    public void postprocessAfterLoadingAndValidate() {
    }

    @Override
    public PackageInfo packageById(String id) {
        if (this.genPackageInfosById.containsKey(id)) {
            return this.genPackageInfosById.get(id);
        }
        return this.model.packageById(id);
    }

    @Override
    public ClassInfo classById(String id) {
        if (this.genClassInfosById.containsKey(id)) {
            return this.genClassInfosById.get(id);
        }
        return this.model.classById(id);
    }

    @Override
    public ClassInfo classByName(String name) {
        if (this.genClassInfosByName.containsKey(name)) {
            return this.genClassInfosByName.get(name);
        }
        return this.model.classByName(name);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String characterEncoding() {
        return this.characterEncoding;
    }

    private HashSet<String> copy(HashSet<String> hs) {
        if (hs == null) {
            return null;
        }
        HashSet<String> res = new HashSet<String>();
        for (String s : hs) {
            res.add(s);
        }
        return res;
    }

    public String toString(String indent) {
        StringBuffer sb = new StringBuffer();
        if (this.genAppSchema != null) {
            for (String appSchema : this.genAppSchema.keySet()) {
                sb.append("Application schema: " + appSchema + "\r\n");
            }
        }
        if (this.genAssociationInfosById != null) {
            for (String assocInfoId : this.genAssociationInfosById.keySet()) {
                sb.append("Association Id: " + assocInfoId + "\r\n");
            }
        }
        if (this.genPackageInfosById != null) {
            for (String packageInfoId : this.genPackageInfosById.keySet()) {
                sb.append("Package full name: " + this.genPackageInfosById.get(packageInfoId).fullName() + "\r\n");
            }
        }
        if (this.genClassInfosById != null) {
            for (String classInfoId : this.genClassInfosById.keySet()) {
                sb.append("Class full name: " + this.genClassInfosById.get(classInfoId).fullName() + "\r\n");
            }
        }
        if (this.genAppSchema != null) {
            for (String appSchema : this.genAppSchema.keySet()) {
                sb.append(this.genAppSchema.get(appSchema).toString("  "));
            }
        }
        return sb.toString();
    }

    public void add(GenericPropertyInfo newProperty, ClassInfo classToAddProperty) {
        this.genPropertiesById.put(newProperty.id(), newProperty);
        ((GenericClassInfo)classToAddProperty).addProperty(newProperty, PropertyCopyDuplicatBehaviorIndicator.ADD);
    }

    public void remove(GenericClassInfo ciToRemove) {
        HashSet<String> ciToRemoveSupertypeIds;
        AssociationInfo association;
        if (ciToRemove == null || !this.isInAppSchema(ciToRemove)) {
            return;
        }
        HashSet<PropertyInfo> propsToRemove = new HashSet<PropertyInfo>();
        HashSet<AssociationInfo> associationsToRemove = new HashSet<AssociationInfo>();
        for (PropertyInfo propertyInfo : ciToRemove.properties().values()) {
            propsToRemove.add(propertyInfo);
            association = propertyInfo.association();
            if (association == null) continue;
            if (association.end1() != null && association.end1().isNavigable()) {
                propsToRemove.add(association.end1());
            }
            if (association.end2() != null && association.end2().isNavigable()) {
                propsToRemove.add(association.end2());
            }
            associationsToRemove.add(association);
        }
        for (GenericPropertyInfo genericPropertyInfo : this.genPropertiesById.values()) {
            if (!genericPropertyInfo.typeInfo().name.equals(ciToRemove.name())) continue;
            propsToRemove.add(genericPropertyInfo);
            association = genericPropertyInfo.association();
            if (association == null) continue;
            if (association.end1() != null && association.end1().isNavigable()) {
                propsToRemove.add(association.end1());
            }
            if (association.end2() != null && association.end2().isNavigable()) {
                propsToRemove.add(association.end2());
            }
            associationsToRemove.add(association);
        }
        AssociationInfo association2 = ciToRemove.isAssocClass();
        if (association2 != null) {
            if (association2.end1() != null && association2.end1().isNavigable()) {
                propsToRemove.add(association2.end1());
            }
            if (association2.end2() != null && association2.end2().isNavigable()) {
                propsToRemove.add(association2.end2());
            }
            associationsToRemove.add(association2);
        }
        for (PropertyInfo piToRemove : propsToRemove) {
            GenericPropertyInfo propToRemove = (GenericPropertyInfo)piToRemove;
            this.remove(propToRemove);
            ((GenericClassInfo)propToRemove.inClass()).remove(propToRemove);
        }
        for (AssociationInfo assoToRemove : associationsToRemove) {
            this.remove((GenericAssociationInfo)assoToRemove);
            if (assoToRemove.assocClass() == null || assoToRemove.assocClass() == ciToRemove) continue;
            this.remove((GenericClassInfo)assoToRemove.assocClass());
        }
        HashSet<String> hashSet = ciToRemove.subtypes();
        if (hashSet != null && hashSet.size() > 0) {
            for (String ciToRemoveSubtypeId : hashSet) {
                GenericClassInfo ciToRemoveSubtype = this.genClassInfosById.get(ciToRemoveSubtypeId);
                ciToRemoveSubtype.removeSupertype(ciToRemove.id());
                if (ciToRemoveSubtype.baseClass() == null || !ciToRemoveSubtype.baseClass().id().equals(ciToRemove.id())) continue;
                ciToRemoveSubtype.setBaseClass(null);
            }
        }
        if ((ciToRemoveSupertypeIds = ciToRemove.supertypes()) != null && ciToRemoveSupertypeIds.size() > 0) {
            for (String ciToRemoveSupertypeId : ciToRemoveSupertypeIds) {
                this.genClassInfosById.get(ciToRemoveSupertypeId).removeSubtype(ciToRemove.id());
            }
        }
        ((GenericPackageInfo)ciToRemove.pkg()).remove(ciToRemove);
        this.genClassInfosById.remove(ciToRemove.id());
        this.genClassInfosByName.remove(ciToRemove.name());
    }

    public void remove(Collection<GenericClassInfo> cisToRemove) {
        if (cisToRemove == null || cisToRemove.size() == 0) {
            return;
        }
        for (GenericClassInfo ciToRemove : cisToRemove) {
            this.remove(ciToRemove);
        }
    }

    public Map<String, GenericPropertyInfo> getGenProperties() {
        return this.genPropertiesById;
    }

    public Map<String, GenericClassInfo> getGenClasses() {
        return this.genClassInfosById;
    }

    public void remove(GenericPropertyInfo genPi) {
        if (genPi != null) {
            this.genPropertiesById.remove(genPi.id());
        }
    }

    public void remove(GenericAssociationInfo genAsso) {
        if (genAsso != null) {
            this.genAssociationInfosById.remove(genAsso.id());
        }
    }

    public void updateClassName(String currentName, String newName) {
        if (this.genClassInfosByName.keySet().contains(currentName)) {
            GenericClassInfo tmp = this.genClassInfosByName.get(currentName);
            this.genClassInfosByName.remove(currentName);
            this.genClassInfosByName.put(newName, tmp);
        }
    }

    public void removeByClassCategory(int classCategory) {
        for (GenericClassInfo genCi : this.genClassInfosById.values().toArray(new GenericClassInfo[this.genClassInfosById.values().size()])) {
            if (genCi.category() != classCategory) continue;
            this.remove(genCi);
        }
    }

    public Set<GenericPackageInfo> getAppSchemaPackages() {
        if (this.appSchemaPackageIds == null || this.appSchemaPackageIds.isEmpty()) {
            return null;
        }
        HashSet<GenericPackageInfo> appSchema = new HashSet<GenericPackageInfo>();
        for (String appSchemaId : this.appSchemaPackageIds) {
            appSchema.add(this.genPackageInfosById.get(appSchemaId));
        }
        return appSchema;
    }

    public void copyClassContent(GenericClassInfo fromClass, GenericClassInfo toClass, PropertyCopyPositionIndicator copyPositionIndicator, PropertyCopyDuplicatBehaviorIndicator duplicateHandling) {
        TreeMap<StructuredNumber, PropertyInfo> properties = fromClass.properties();
        if (properties != null && !properties.isEmpty()) {
            ArrayList<GenericPropertyInfo> copiedProps = new ArrayList<GenericPropertyInfo>();
            HashMap<String, GenericPropertyInfo> propsToSkipById = new HashMap<String, GenericPropertyInfo>();
            for (PropertyInfo propI : properties.values()) {
                if (propsToSkipById.containsKey(propI.id())) continue;
                GenericPropertyInfo genProp = (GenericPropertyInfo)propI;
                GenericPropertyInfo copy = genProp.createCopy(genProp.id() + "_copyFrom" + fromClass.name() + "To" + toClass.name());
                copy.setInClass(toClass);
                copiedProps.add(copy);
                this.genPropertiesById.put(copy.id(), copy);
                AssociationInfo ai = copy.association();
                if (ai == null) continue;
                GenericAssociationInfo assoCopy = this.createCopy(ai, ai.id() + "_copyFrom" + fromClass.name() + "To" + toClass.name());
                this.genAssociationInfosById.put(assoCopy.id(), assoCopy);
                copy.setAssociation(assoCopy);
                boolean selfAssociation = false;
                if (ai.end1().inClass() == fromClass && ai.end2().inClass() == fromClass) {
                    selfAssociation = true;
                }
                if (ai.end1().id().equals(genProp.id())) {
                    assoCopy.setEnd1(copy);
                    PropertyInfo origAssoEnd2 = ai.end2();
                    GenericPropertyInfo copyEnd2 = this.createCopy(origAssoEnd2, origAssoEnd2.id() + "_copyFrom" + fromClass.name() + "To" + toClass.name());
                    if (selfAssociation) {
                        copyEnd2.setInClass(toClass);
                    }
                    if (!selfAssociation) {
                        StructuredNumber snCopyEnd2 = copyEnd2.sequenceNumber();
                        copyEnd2.setSequenceNumber(snCopyEnd2.createCopyWithSuffix(1));
                        this.add(copyEnd2, copyEnd2.inClass());
                    } else {
                        propsToSkipById.put(origAssoEnd2.id(), copyEnd2);
                        copiedProps.add(copyEnd2);
                    }
                    assoCopy.setEnd2(copyEnd2);
                    copyEnd2.setAssociation(assoCopy);
                    continue;
                }
                assoCopy.setEnd2(copy);
                PropertyInfo origAssoEnd1 = ai.end1();
                GenericPropertyInfo copyEnd1 = this.createCopy(origAssoEnd1, origAssoEnd1.id() + "_copyFrom" + fromClass.name() + "To" + toClass.name());
                if (selfAssociation) {
                    copyEnd1.setInClass(toClass);
                }
                if (!selfAssociation) {
                    StructuredNumber snCopyEnd1 = copyEnd1.sequenceNumber();
                    copyEnd1.setSequenceNumber(snCopyEnd1.createCopyWithSuffix(1));
                    this.add(copyEnd1, copyEnd1.inClass());
                } else {
                    propsToSkipById.put(origAssoEnd1.id(), copyEnd1);
                    copiedProps.add(copyEnd1);
                }
                assoCopy.setEnd2(copyEnd1);
                copyEnd1.setAssociation(assoCopy);
            }
            switch (copyPositionIndicator) {
                case PROPERTY_COPY_TOP: {
                    toClass.addPropertiesAtTop(copiedProps, duplicateHandling);
                    break;
                }
                case PROPERTY_COPY_INSEQUENCE: {
                    toClass.addPropertiesInSequence(copiedProps, duplicateHandling);
                    break;
                }
                case PROPERTY_COPY_BOTTOM: {
                    toClass.addPropertiesAtBottom(copiedProps, duplicateHandling);
                }
            }
        }
    }

    public GenericAssociationInfo createCopy(AssociationInfo ai, String copyId) {
        GenericAssociationInfo genAi = new GenericAssociationInfo();
        genAi.setOptions(ai.options());
        genAi.setResult(ai.result());
        genAi.setModel(this);
        genAi.setId(copyId);
        genAi.setName(ai.name());
        genAi.setAliasName(ai.aliasName());
        genAi.setDocumentation(ai.documentation().replaceAll("---", "--"));
        genAi.setStereotype(ai.stereotype());
        genAi.setTaggedValues(this.copy(ai.taggedValues()));
        genAi.setEnd1(ai.end1());
        genAi.setEnd2(ai.end2());
        genAi.setAssocClass(ai.assocClass());
        return genAi;
    }

    public GenericPropertyInfo createCopy(PropertyInfo pi, String copyId) {
        GenericPropertyInfo copy = new GenericPropertyInfo(this, copyId, pi.name(), pi.categoryOfValue());
        copy.setAliasName(pi.aliasName());
        copy.setDocumentation(pi.documentation());
        copy.setStereotype(pi.stereotype());
        copy.setTaggedValues((HashMap)pi.taggedValues().clone());
        copy.setDerived(pi.isDerived());
        copy.setAttribute(pi.isAttribute());
        Type t = new Type();
        t.id = pi.typeInfo().id;
        t.name = pi.typeInfo().name;
        copy.setTypeInfo(t);
        copy.setNavigable(pi.isNavigable());
        copy.setOrdered(pi.isOrdered());
        copy.setComposition(pi.isComposition());
        copy.setAggregation(pi.isAggregation());
        copy.setCardinality(new Multiplicity(pi.cardinality().toString()));
        copy.setInitialValue(pi.initialValue());
        copy.setInlineOrByReference(pi.inlineOrByReference());
        copy.setDefaultCodeSpace(pi.defaultCodeSpace());
        copy.setMetadata(pi.isMetadata());
        copy.setReverseProperty(pi.reverseProperty());
        copy.setInClass(pi.inClass());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pi.sequenceNumber().components.length - 1; ++i) {
            sb.append(pi.sequenceNumber().components[i] + ".");
        }
        sb.append(pi.sequenceNumber().components[pi.sequenceNumber().components.length - 1]);
        StructuredNumber res = new StructuredNumber(sb.toString());
        copy.setSequenceNumber(res);
        copy.setImplementedByNilReason(pi.implementedByNilReason());
        copy.setVoidable(pi.voidable());
        copy.setConstraints(pi.constraints());
        copy.setAssociation(pi.association());
        copy.setRestriction(pi.isRestriction());
        copy.setNilReasonAllowed(pi.nilReasonAllowed());
        return copy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyCopyDuplicatBehaviorIndicator {
        IGNORE,
        ADD,
        OVERWRITE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyCopyPositionIndicator {
        PROPERTY_COPY_TOP,
        PROPERTY_COPY_INSEQUENCE,
        PROPERTY_COPY_BOTTOM;

    }
}

