<?xml version="1.0" encoding="UTF-8"?>
<!-- Suchbegriff: -->
<!-- Hier muß eigentlich jeweils das Intial-Benutzungsauftragsdokument selektiert werden, damit die Art der Ausgabe im Standardkopf stimmt. -->

<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
	xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0"
	xmlns:date="http://www.jclark.com/xt/java/java.util.Date"
	xmlns:gml="http://www.opengis.net/gml/3.2">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:include href="utility.xslt"/>
	<!-- ======================= GeoInfoDok 6.0 ==================================== -->
	<xsl:template match="/">
		<xsl:variable name="p1">
			<xsl:choose>
				<xsl:when test="function-available('date:to-string') and function-available('date:new')">
					<xsl:value-of select="date:to-string(date:new())"/>
				</xsl:when>
				<xsl:otherwise>unbekannt</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="p2">
		 	<xsl:call-template name="entschluesseln">
				<xsl:with-param name="codelist">AX_Anlassart_Benutzungsauftrag</xsl:with-param>
				<!-- Hier muß eigentlich jeweils das Intial-Benutzungsauftragsdokument selektiert werden, damit die Art der Ausgabe im Standardkopf stimmt. -->
				<xsl:with-param name="code" select="document('Bestandsnachweis/AX_Benutzungsauftrag.xml')//adv:art"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="p3" select="document('Parameter.xml')//param[@name='Landeswappen']"/>
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<xsl:variable name="land" select="//adv:AX_Flurstueck[1]/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:land"/>
		<xsl:variable name="gemnr" select="//adv:AX_Flurstueck[1]/adv:gemarkung/adv:AX_Gemarkung_Schluessel/adv:gemarkungsnummer"/>
		<xsl:variable name="dstnr" select="//adv:AX_Gemarkung[adv:schluesselGesamt=concat($land,$gemnr)]/adv:istAmtsbezirkVon/adv:AX_Dienststelle_Schluessel/adv:stelle"/>
		<xsl:variable name="stelle" select="//adv:AX_Dienststelle[adv:schluesselGesamt=concat($land,$dstnr)]"/>
		<xsl:variable name="anschrift" select="//adv:AX_Anschrift[@gml:id=substring-after($stelle/adv:hat/@xlink:href,'urn:adv:oid:')]"/>
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_K_AUSGKOPF_Standard xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0">
			<datumDerAusgabe><xsl:value-of select="$p1"/></datumDerAusgabe>
			<dienststelle><xsl:value-of select="$stelle/adv:bezeichnung"/></dienststelle>
			<anschriftDienststelle>
			 <AX_K_ANSCHRIFT>
			 <strasseHausnummer><xsl:value-of select="$anschrift/adv:strasse"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="$anschrift/adv:hausnummer"/>
			</strasseHausnummer>
			<plzOrt><xsl:value-of select="$anschrift/adv:postleitzahlPostzustellung"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="$anschrift/adv:ort_Post"/>
			</plzOrt>
			<xsl:if test="boolean($anschrift/adv:telefon)">
			 <telefon><xsl:value-of select="$anschrift/adv:telefon"/></telefon>
			</xsl:if>
			</AX_K_ANSCHRIFT>
			</anschriftDienststelle>
			<artDerAusgabe><xsl:value-of select="$p2"/></artDerAusgabe>
			<enthaeltEWP>
				<AX_Landeswappen>
					<uri><xsl:value-of select="$p3"/></uri>
				</AX_Landeswappen>
			</enthaeltEWP>
		</AX_K_AUSGKOPF_Standard>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
