<?xml version="1.0" encoding="UTF-8"?>
<!-- Auf GeoInfoDok 6.0 -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0"
		xmlns:gml="http://www.opengis.net/gml/3.2"
		xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc"
		xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs"
		xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<!-- =========================================================== -->
	<xsl:template match="/">
		<xsl:variable name="p1" select="//adv:profilkennung"/>
		<xsl:variable name="p2" select="//adv:antragsnummer"/>
		<xsl:variable name="p3" select="//ogc:Literal"/>
		<!-- +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
		<AX_Benutzungsauftrag xmlns="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:adv="http://www.adv-online.de/namespaces/adv/gid/6.0" xmlns:gml="http://www.opengis.net/gml/3.2" xmlns:ogc="http://www.adv-online.de/namespaces/adv/gid/ogc" xmlns:wfs="http://www.adv-online.de/namespaces/adv/gid/wfs" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.adv-online.de/namespaces/adv/gid/6.0 NAS-Operationen.xsd">
			<empfaenger>
				<AA_Empfaenger>
					<direkt/>
				</AA_Empfaenger>
			</empfaenger>
			<ausgabeform>application/xml</ausgabeform>
			<art>0010</art>
			<anforderungsmerkmale>
				<!-- Selektion der Buchungsstellen des Buchungsblatts, auf dem das Grundstück gebucht ist -->
				<wfs:Query typeName="AX_Buchungsstelle">
				<XlinkPropertyPath>grundstueckBestehtAus/AX_Flurstueck</XlinkPropertyPath><!-- Ergänzt am 20.12.2007. Die auf dem angefragten Buchungsblatt an sich gebuchten Flurstücke werden nachgezogen. -->
				<XlinkPropertyPath>an/AX_Buchungsstelle/grundstueckBestehtAus/AX_Flurstueck</XlinkPropertyPath><!-- Ergänzt am 20.12.2007. Die zugebuchten Anteile zu dem "Hauptgrundstück" werden nachgezogen. -->
				
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>istBestandteilVon/AX_Buchungsblatt/buchungsblattkennzeichen</ogc:PropertyName>
							<ogc:Literal>
								<xsl:value-of select="$p3"/>
							</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
				</wfs:Query>
				<!-- Besorge ausserdem alle Objekte der weiteren Objektarten. Hinweis: Dies ist natürlich keine realistische Vorgehensweise
				bei Produktionsdatenbeständen. Das Ziel dieser Dokumentation liegt in der Beschreibung der formalen Regeln bei der Ableitung
				der Standardausgaben - nicht in der Vorgabe einer algorithmischen Umsetzung dieser. -->
				<wfs:Query typeName="AX_Buchungsblattbezirk"/>
				<wfs:Query typeName="AX_Dienststelle"/>
				<!-- wfs:Query typeName="AX_Flurstueck"/ Am 20.12.2007 auskommentiert aufgrund des direkten Nachziehens betroffener Flurstücke bei der Query oben bzgl. Buchungsstelle.-->
				<wfs:Query typeName="AX_Person"/>
				<wfs:Query typeName="AX_Anschrift"/>
				<wfs:Query typeName="AX_Buchungsblatt"/>
				<wfs:Query typeName="AX_Buchungsstelle"/>
				<wfs:Query typeName="AX_Namensnummer"/>
				<wfs:Query typeName="AX_Gemarkung"/>
				<wfs:Query typeName="AX_Gemeinde"/>
				<wfs:Query typeName="AX_KreisRegion"/>
				<wfs:Query typeName="AX_Regierungsbezirk"/>
				<wfs:Query typeName="AX_KommunalesGebiet"/>
				<wfs:Query typeName="AX_LagebezeichnungOhneHausnummer"/>
				<wfs:Query typeName="AX_LagebezeichnungMitHausnummer"/>
				<wfs:Query typeName="AX_LagebezeichnungMitPseudonummer"/>
				<wfs:Query typeName="AX_LagebezeichnungKatalogeintrag"/>
			</anforderungsmerkmale>
			<profilkennung><xsl:value-of select="$p1"/></profilkennung>
			<antragsnummer><xsl:value-of select="$p2"/></antragsnummer>
		</AX_Benutzungsauftrag>
	</xsl:template>
	<!-- =========================================================== -->
</xsl:stylesheet>
