/*
 * Decompiled with CFR 0.152.
 */
package de.adv_online.aaa.profiltool;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.PackageInfoEA;
import de.interactive_instruments.ShapeChange.Model.EA.PropertyInfoEA;
import de.interactive_instruments.ShapeChange.Model.Info;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PropertyInfo;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;

public class ProfilRep {
    private PackageInfo pi = null;
    private Model model = null;
    private Options options = null;
    private ShapeChangeResult result = null;
    private String modellart = "";
    private String profil = "";
    private boolean gdb = false;
    private static String AAAZielVersion = "6.0.1";
    private boolean set = false;
    private HashSet<ClassInfo> processed = new HashSet();
    private HashSet<ClassInfo> written = new HashSet();
    private HashSet<Info> Members = new HashSet();

    public ProfilRep(PackageInfo p, Model m, Options o, ShapeChangeResult r, String ma, String n, boolean g) {
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        this.modellart = ma;
        this.profil = n;
        this.gdb = g;
        for (ClassInfo ci : this.model.classes(this.pi)) {
            this.SetClass(ci, false);
        }
        this.set = true;
    }

    public ProfilRep(PackageInfo p, Model m, Options o, ShapeChangeResult r, String ma, String n) {
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        this.modellart = ma;
        this.profil = n;
        this.gdb = false;
        for (ClassInfo ci : this.model.classes(this.pi)) {
            this.LoadClass(ci);
        }
        this.set = true;
    }

    private void LoadClass(ClassInfo ci) {
        int cat = ci.category();
        switch (cat) {
            case -1: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (this.processed.contains(ci)) break;
                this.processed.add(ci);
                if (!this.inModel((Info)ci)) break;
                this.Members.add((Info)ci);
                for (String st : ci.supertypes()) {
                    ClassInfo cis = this.model.classById(st);
                    if (cis == null || !cis.inSchema(this.pi) || this.processed.contains(cis)) continue;
                    this.LoadClass(cis);
                }
                for (PropertyInfo propi : ci.properties().values()) {
                    if (!this.inModel((Info)propi)) continue;
                    this.Members.add((Info)propi);
                    PropertyInfo rpropi = propi.reverseProperty();
                    if (rpropi == null) continue;
                    this.Members.add((Info)rpropi);
                }
                break;
            }
            case 2: 
            case 3: {
                if (this.processed.contains(ci)) break;
                this.processed.add(ci);
                if (!this.inModel((Info)ci)) break;
                this.Members.add((Info)ci);
                for (PropertyInfo propi : ci.properties().values()) {
                    if (!this.inModel((Info)propi)) continue;
                    this.Members.add((Info)propi);
                }
                break;
            }
            default: {
                this.result.addWarning("Klasse mit unbekannter Art wurde nicht im Profil verarbeitet: " + ci.name());
            }
        }
    }

    private boolean inModel(Info i) {
        String[] sa;
        String s1 = i.taggedValue("AAA:Profile");
        if (s1 == null || s1.trim().length() == 0) {
            return false;
        }
        for (String s2 : sa = s1.split(",")) {
            if (!s2.equals(this.name())) continue;
            return true;
        }
        return false;
    }

    private void addToModel(Info i) {
        PackageInfoEA iea;
        String[] sa;
        String s1 = i.taggedValue("AAA:Profile");
        if (s1 == null || s1.trim().length() == 0) {
            if (i.getClass().getName().equals("de.interactive_instruments.ShapeChange.Model.EA.PackageInfoEA")) {
                PackageInfoEA iea2 = (PackageInfoEA)i;
                iea2.taggedValue("AAA:Profile", this.name());
            } else if (i.getClass().getName().equals("de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA")) {
                ClassInfoEA iea3 = (ClassInfoEA)i;
                iea3.taggedValue("AAA:Profile", this.name());
            } else if (i.getClass().getName().equals("de.interactive_instruments.ShapeChange.Model.EA.PropertyInfoEA")) {
                PropertyInfoEA iea4 = (PropertyInfoEA)i;
                iea4.taggedValue("AAA:Profile", this.name());
            } else {
                this.result.addInfo("Unsupported Java class: " + i.getClass().getName());
            }
            return;
        }
        for (String s2 : sa = s1.split(",")) {
            if (!s2.equals(this.name())) continue;
            return;
        }
        if (i.getClass().getName().equals("de.interactive_instruments.ShapeChange.Model.EA.PackageInfoEA")) {
            iea = (PackageInfoEA)i;
            iea.taggedValue("AAA:Profile", s1 + "," + this.name());
        } else if (i.getClass().getName().equals("de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA")) {
            iea = (ClassInfoEA)i;
            iea.taggedValue("AAA:Profile", s1 + "," + this.name());
        } else if (i.getClass().getName().equals("de.interactive_instruments.ShapeChange.Model.EA.PropertyInfoEA")) {
            iea = (PropertyInfoEA)i;
            iea.taggedValue("AAA:Profile", s1 + "," + this.name());
        } else {
            this.result.addInfo("Unsupported Java class: " + i.getClass().getName());
        }
    }

    private void removeFromModel(Info i) {
        PackageInfoEA iea;
        String s1 = i.taggedValue("AAA:Profile");
        if (s1 == null || s1.trim().length() == 0) {
            return;
        }
        String[] sa = s1.split(",");
        s1 = "";
        for (String s2 : sa) {
            if (s2.equals(this.name())) continue;
            s1 = s1.length() == 0 ? s2 : s1 + "," + s2;
        }
        if (i.getClass().getName().equals("de.interactive_instruments.ShapeChange.Model.EA.PackageInfoEA")) {
            iea = (PackageInfoEA)i;
            iea.taggedValue("AAA:Profile", s1);
        } else if (i.getClass().getName().equals("de.interactive_instruments.ShapeChange.Model.EA.ClassInfoEA")) {
            iea = (ClassInfoEA)i;
            iea.taggedValue("AAA:Profile", s1);
        } else if (i.getClass().getName().equals("de.interactive_instruments.ShapeChange.Model.EA.PropertyInfoEA")) {
            iea = (PropertyInfoEA)i;
            iea.taggedValue("AAA:Profile", s1);
        } else {
            this.result.addInfo("Unsupported Java class: " + i.getClass().getName());
        }
    }

    public boolean contains(Info i) {
        return this.Members.contains(i);
    }

    private boolean MatchingMA(Info i, boolean g) {
        String malist;
        if (g) {
            malist = i.taggedValue("AAA:Grunddatenbestand");
            if (malist == null) {
                return false;
            }
            if ((malist = malist.trim()).length() == 0) {
                return false;
            }
        } else {
            malist = i.taggedValue("AAA:Modellart");
            if (malist == null) {
                return true;
            }
            if ((malist = malist.trim()).length() == 0) {
                return true;
            }
        }
        for (String ma : malist.split(",")) {
            if (!ma.trim().equals(this.modellart)) continue;
            return true;
        }
        return false;
    }

    private boolean ExportItem(Info i) {
        if (i.name().length() == 0) {
            return false;
        }
        if (!this.MatchingMA(i, false)) {
            return false;
        }
        return !this.gdb || this.MatchingMA(i, true);
    }

    private void SetClass(ClassInfo ci, boolean force) {
        boolean export = force || this.ExportItem((Info)ci);
        int cat = ci.category();
        switch (cat) {
            case -1: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (!export || this.processed.contains(ci)) break;
                this.processed.add(ci);
                this.Members.add((Info)ci);
                for (String st : ci.supertypes()) {
                    ClassInfo cis = this.model.classById(st);
                    if (cis == null || !cis.inSchema(this.pi) || this.processed.contains(cis)) continue;
                    this.SetClass(cis, true);
                }
                for (PropertyInfo propi : ci.properties().values()) {
                    this.SetProperty(propi, false, false);
                }
                break;
            }
            case 2: 
            case 3: {
                if (!export || this.processed.contains(ci)) break;
                this.processed.add(ci);
                this.Members.add((Info)ci);
                for (PropertyInfo propi : ci.properties().values()) {
                    this.SetProperty(propi, false, true);
                }
                break;
            }
            default: {
                this.result.addWarning("Klasse mit unbekannter Art wurde nicht im Profil verarbeitet: " + ci.name());
            }
        }
    }

    private void ClassRequired(String classId) {
        ClassInfo ci = this.model.classById(classId);
        if (ci != null) {
            int cat = ci.category();
            switch (cat) {
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    this.SetClass(ci, true);
                    break;
                }
                default: {
                    this.result.addWarning("Klasse mit unbekannter Art wurde nicht im Profil verarbeitet: " + ci.name());
                }
            }
        }
    }

    private void SetProperty(PropertyInfo propi, boolean force, boolean codedValue) {
        boolean export;
        boolean bl = export = force || this.ExportItem((Info)propi);
        if (!codedValue) {
            export = export || propi.cardinality().minOccurs > 0;
        }
        boolean bl2 = export = export && propi.name().length() > 0;
        if (export) {
            this.Members.add((Info)propi);
            if (!codedValue) {
                PropertyInfo rpropi;
                this.ClassRequired(propi.typeInfo().id);
                if (!propi.isAttribute() && propi.isNavigable() && (rpropi = propi.reverseProperty()) != null) {
                    this.Members.add((Info)rpropi);
                }
            } else if (!this.Members.contains(propi.inClass())) {
                this.Members.add((Info)propi.inClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(String filename) {
        if (!this.set) {
            this.result.addError("Export der Profildatei nicht m\u00f6glich, da das Profil noch nicht definiert ist.");
            return;
        }
        try {
            PrintWriter out = null;
            this.written.clear();
            try {
                out = new PrintWriter(new FileWriter(filename));
                out.println("AFIS-ALKIS-ATKIS-Profildefinition");
                out.println("Version: " + AAAZielVersion);
                out.println("Name: " + this.modellart + "_" + this.profil);
                out.println("#");
                HashSet classes = this.model.classes(this.pi);
                ClassInfo[] classesArr = new ClassInfo[classes.size()];
                classes.toArray(classesArr);
                Arrays.sort(classesArr, new Comparator<ClassInfo>(){

                    @Override
                    public int compare(ClassInfo ci1, ClassInfo ci2) {
                        return ci1.name().compareTo(ci2.name());
                    }
                });
                for (int cidx = 0; cidx < classesArr.length; ++cidx) {
                    ClassInfo k = classesArr[cidx];
                    this.DumpClass(out, k);
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
                this.result.addInfo("Schreiben der Profildatei abgeschlossen.");
            }
        }
        catch (IOException e) {
            this.result.addError("Problem beim Schreiben von Profildatei: " + filename);
            e.printStackTrace();
        }
    }

    private void AddProfileEntry(PrintWriter out, ClassInfo i, boolean included) {
        String s = i.name() + " --- Objektart/Datentyp";
        if (!included) {
            s = "# " + s;
        }
        out.println(s);
        this.result.addDebug(s);
    }

    private void AddProfileEntry(PrintWriter out, PropertyInfo i, boolean included, boolean codedValue) {
        String iv;
        String s = i.inClass().name() + "/";
        s = codedValue ? ((iv = i.initialValue()) != null && iv.trim().length() > 0 ? s + iv.trim() : s + i.name()) : s + i.name();
        int cat = i.inClass().category();
        s = cat == 3 || cat == 2 ? s + " --- Werteart" : (i.isAttribute() ? s + " --- Attributart" : s + " --- Relationsart");
        if (!included) {
            s = "# " + s;
        }
        out.println(s);
        this.result.addDebug(s);
    }

    private void DumpProperty(PrintWriter out, PropertyInfo propi, boolean codedValue) {
        if (propi.name().length() == 0) {
            return;
        }
        if (this.Members.contains(propi)) {
            this.AddProfileEntry(out, propi, true, codedValue);
        } else if (this.MatchingMA((Info)propi, false)) {
            this.AddProfileEntry(out, propi, false, codedValue);
        }
    }

    private void DumpClass(PrintWriter out, ClassInfo ci) {
        int cat = ci.category();
        switch (cat) {
            case -1: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (this.written.contains(ci)) break;
                if (this.Members.contains(ci)) {
                    this.AddProfileEntry(out, ci, true);
                } else if (this.MatchingMA((Info)ci, false)) {
                    this.AddProfileEntry(out, ci, false);
                }
                this.written.add(ci);
                for (PropertyInfo propi : ci.properties().values()) {
                    this.DumpProperty(out, propi, false);
                }
                break;
            }
            case 2: 
            case 3: {
                if (!this.written.contains(ci)) {
                    this.written.add(ci);
                    for (PropertyInfo propi : ci.properties().values()) {
                        this.DumpProperty(out, propi, true);
                    }
                    break;
                }
            }
            default: {
                this.result.addWarning("Klasse mit unbekannter Art wurde nicht im Profil verarbeitet: " + ci.name());
            }
        }
    }

    public void writeToModel() {
        if (!this.set) {
            this.result.addError("\u00dcbernahme des Profils in das Modell nicht m\u00f6glich, da das Profil noch nicht definiert ist.");
            return;
        }
        this.written.clear();
        HashSet classes = this.model.classes(this.pi);
        for (ClassInfo k : classes) {
            this.WriteClassToModel(k);
        }
    }

    private void WritePropertyToModel(PropertyInfo propi) {
        if (propi.name().length() == 0) {
            return;
        }
        if (this.Members.contains(propi)) {
            this.addToModel((Info)propi);
        } else if (this.MatchingMA((Info)propi, false)) {
            this.removeFromModel((Info)propi);
        }
        PropertyInfo rpropi = propi.reverseProperty();
        if (rpropi != null) {
            if (this.Members.contains(rpropi)) {
                this.addToModel((Info)rpropi);
            } else if (this.MatchingMA((Info)rpropi, false)) {
                this.removeFromModel((Info)rpropi);
            }
        }
    }

    private void WriteClassToModel(ClassInfo ci) {
        int cat = ci.category();
        switch (cat) {
            case -1: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (this.written.contains(ci)) break;
                if (this.Members.contains(ci)) {
                    this.addToModel((Info)ci);
                } else if (this.MatchingMA((Info)ci, false)) {
                    this.removeFromModel((Info)ci);
                }
                this.written.add(ci);
                for (PropertyInfo propi : ci.properties().values()) {
                    this.WritePropertyToModel(propi);
                }
                break;
            }
            case 2: 
            case 3: {
                if (!this.written.contains(ci)) {
                    if (this.Members.contains(ci)) {
                        this.addToModel((Info)ci);
                    } else if (this.MatchingMA((Info)ci, false)) {
                        this.removeFromModel((Info)ci);
                    }
                    this.written.add(ci);
                    for (PropertyInfo propi : ci.properties().values()) {
                        this.WritePropertyToModel(propi);
                    }
                    break;
                }
            }
            default: {
                this.result.addWarning("Klasse mit unbekannter Art wurde nicht im Profil verarbeitet: " + ci.name());
            }
        }
    }

    public void clearInModel() {
        HashSet classes = this.model.classes(this.pi);
        for (ClassInfo ci : classes) {
            this.removeFromModel((Info)ci);
            for (PropertyInfo propi : ci.properties().values()) {
                this.removeFromModel((Info)propi);
                PropertyInfo rpropi = propi.reverseProperty();
                if (rpropi == null) continue;
                this.removeFromModel((Info)rpropi);
            }
        }
    }

    public String name() {
        return this.modellart + "_" + this.profil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfilRep(PackageInfo p, Model m, Options o, ShapeChangeResult r, String filename) {
        this.pi = p;
        this.model = m;
        this.options = o;
        this.result = r;
        try {
            BufferedReader input = new BufferedReader(new FileReader(filename));
            try {
                String line = null;
                line = input.readLine();
                if (line == null || !line.trim().contains("AFIS-ALKIS-ATKIS-Profildefinition")) {
                    this.result.addError("Die Profildatei beginnt nicht mit dem erwateten Wert 'AFIS-ALKIS-ATKIS-Profildefinition'. Der Ladevorgang wurde abgebrochen.");
                    input.close();
                    return;
                }
                line = input.readLine();
                if (line == null || !line.trim().startsWith("Version: ")) {
                    this.result.addError("Es wurde keine Version angegeben. Der Ladevorgang wurde abgebrochen.");
                    input.close();
                    return;
                }
                String[] s = line.trim().substring(9);
                if (!s.equals(AAAZielVersion)) {
                    this.result.addError("Die Version " + (String)s + " des Profils passt nicht zur erwarteten Version " + AAAZielVersion + ". Der Ladevorgang wurde abgebrochen.");
                    input.close();
                    return;
                }
                line = input.readLine();
                if (line == null || !line.trim().startsWith("Name: ")) {
                    this.result.addError("Es wurde kein Profilname angegeben. Der Ladevorgang wurde abgebrochen.");
                    input.close();
                    return;
                }
                s = line.trim().substring(6);
                String[] ss = s.split("_", 2);
                this.modellart = ss[0].trim();
                this.profil = ss[1].trim();
                this.gdb = true;
                for (ClassInfo ci : this.model.classes(this.pi)) {
                    this.SetClass(ci, false);
                }
                while ((line = input.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#")) continue;
                    s = line.split(" --- ");
                    if (s.length != 2) {
                        this.result.addError("Zeile mit unerlaubter Syntax: '" + line + "'");
                        continue;
                    }
                    s[0] = s[0].trim();
                    s[1] = s[1].trim();
                    if (s[1].equals("Objektart/Datentyp")) {
                        ClassInfo cix = this.model.classByName(s[0]);
                        if (cix != null && cix.inSchema(this.pi)) {
                            if (this.MatchingMA((Info)cix, false)) {
                                this.SetClass(cix, true);
                                continue;
                            }
                            this.result.addError("Objektart/Datentyp " + s[0] + " kann dem Profil nicht zugeordnet werden, da es kein Bestandteil der betreffenden Modellart ist.");
                            continue;
                        }
                        this.result.addError("Objektart/Datentyp " + s[0] + " kann dem Profil nicht zugeordnet werden, die Klasse wurde nicht im Anwendungsschema gefunden.");
                        continue;
                    }
                    if (!s[1].equals("Attributart") && !s[1].equals("Relationsart") && !s[1].equals("Werteart")) continue;
                    String[] s2 = s[0].split("/", 2);
                    if (s2.length != 2) {
                        this.result.addError("Zeile mit unerlaubter Syntax: '" + line + "'");
                        continue;
                    }
                    s2[0] = s2[0].trim();
                    s2[1] = s2[1].trim();
                    ClassInfo cix = this.model.classByName(s2[0]);
                    if (cix != null && cix.inSchema(this.pi)) {
                        if (this.MatchingMA((Info)cix, false)) {
                            this.SetClass(cix, true);
                            boolean found = false;
                            for (PropertyInfo propi : cix.properties().values()) {
                                String sx1 = propi.name();
                                String sx2 = propi.initialValue();
                                if (sx1 != null && sx1.toLowerCase().equals(s2[1].toLowerCase())) {
                                    this.SetProperty(propi, true, false);
                                    found = true;
                                    break;
                                }
                                if (!s[1].equals("Werteart") || sx2 == null || !sx2.toLowerCase().equals(s2[1].toLowerCase())) continue;
                                this.SetProperty(propi, true, true);
                                found = true;
                                break;
                            }
                            if (found) continue;
                            this.result.addError(s[1] + " " + s2[1] + " zu Objektart/Datentyp " + s2[0] + " kann dem Profil nicht zugeordnet werden, die Eigenschaft wurde nicht im Anwendungsschema gefunden.");
                            continue;
                        }
                        this.result.addError(s[1] + " " + s2[1] + " zu Objektart/Datentyp " + s2[0] + " kann dem Profil nicht zugeordnet werden, da sie kein Bestandteil der betreffenden Modellart ist.");
                        continue;
                    }
                    this.result.addError("Objektart/Datentyp " + s2[0] + " kann dem Profil nicht zugeordnet werden, die Klasse wurde nicht im Anwendungsschema gefunden.");
                }
            }
            finally {
                input.close();
                this.result.addInfo("Laden der Profildatei abgeschlossen.");
                this.set = true;
            }
        }
        catch (IOException e) {
            this.result.addError("Problem beim Lesen von Profildatei: " + filename);
            e.printStackTrace();
        }
    }
}

