/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange.Model.Generic;

import de.interactive_instruments.ShapeChange.Model.ClassInfo;
import de.interactive_instruments.ShapeChange.Model.Generic.GenericModel;
import de.interactive_instruments.ShapeChange.Model.Model;
import de.interactive_instruments.ShapeChange.Model.PackageInfo;
import de.interactive_instruments.ShapeChange.Model.PackageInfoImpl;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPackageInfo
extends PackageInfoImpl {
    protected Options options = null;
    protected ShapeChangeResult result = null;
    protected GenericModel model = null;
    protected String id = null;
    protected String name = null;
    protected String stereotype = null;
    protected HashMap<String, String> taggedValues = null;
    protected String targetNamespace = null;
    protected String xmlns = null;
    protected String xsdDocument = null;
    protected String gmlProfileSchema = null;
    protected String version = null;
    protected PackageInfo owner = null;
    protected String schemaId = null;
    protected PackageInfo rootPackage = null;
    protected boolean isAppSchema = false;
    protected boolean isSchema = false;
    protected HashSet<PackageInfo> childPi = null;
    protected HashSet<String> supplierIds = null;
    protected HashSet<ClassInfo> classes = null;

    @Override
    public String aliasName() {
        return this.aliasName;
    }

    @Override
    public HashSet<PackageInfo> containedPackages() {
        return this.childPi;
    }

    @Override
    public String documentation() {
        return this.documentation;
    }

    public Set<GenericPackageInfo> getAllPackages(Set<GenericPackageInfo> set) {
        if (set == null) {
            return null;
        }
        if (!this.childPi.isEmpty()) {
            for (PackageInfo child : this.childPi) {
                if (!(child instanceof GenericPackageInfo)) continue;
                ((GenericPackageInfo)child).getAllPackages(set);
            }
        }
        set.add(this);
        return set;
    }

    public HashSet<ClassInfo> getClasses() {
        return this.classes;
    }

    @Override
    public String gmlProfileSchema() {
        return this.gmlProfileSchema;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public boolean isAppSchema() {
        return this.isAppSchema;
    }

    @Override
    public boolean isSchema() {
        return this.isSchema;
    }

    @Override
    public Model model() {
        return this.model;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Options options() {
        return this.options;
    }

    @Override
    public PackageInfo owner() {
        return this.owner;
    }

    @Override
    public ShapeChangeResult result() {
        return this.result;
    }

    @Override
    public PackageInfo rootPackage() {
        return this.rootPackage;
    }

    @Override
    public String schemaId() {
        return this.schemaId;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public void setClasses(HashSet<ClassInfo> classes) {
        this.classes = classes;
    }

    public void setContainedPackages(HashSet<PackageInfo> childPi) {
        this.childPi = childPi;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
        this.definition = null;
        this.description = null;
    }

    public void setGmlProfileSchema(String gmlProfileSchema) {
        this.gmlProfileSchema = gmlProfileSchema;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIsAppSchema(boolean isAppSchema) {
        this.isAppSchema = isAppSchema;
    }

    public void setIsSchema(boolean isSchema) {
        this.isSchema = isSchema;
    }

    public void setModel(GenericModel model) {
        this.model = model;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public void setOwner(PackageInfo owner) {
        this.owner = owner;
    }

    public void setResult(ShapeChangeResult result) {
        this.result = result;
    }

    public void setRootPackage(PackageInfo rootPackage) {
        this.rootPackage = rootPackage;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    public void setStereotype(String stereotype) {
        this.stereotype = stereotype;
    }

    public void setSupplierIds(HashSet<String> supplierIds) {
        this.supplierIds = supplierIds;
    }

    public void setTaggedValues(HashMap<String, String> taggedValues) {
        this.taggedValues = taggedValues;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setXmlns(String xmlns) {
        this.xmlns = xmlns;
    }

    public void setXsdDocument(String xsdDocument) {
        this.xsdDocument = xsdDocument;
    }

    @Override
    public String stereotype() {
        return this.stereotype;
    }

    @Override
    public HashSet<String> supplierIds() {
        return this.supplierIds;
    }

    @Override
    public String taggedValue(String tag) {
        return this.taggedValues.get(tag);
    }

    @Override
    public HashMap<String, String> taggedValues() {
        return this.taggedValues;
    }

    @Override
    public HashMap<String, String> taggedValues(String tagList) {
        String[] tags = tagList.split(",");
        HashMap<String, String> res = new HashMap<String, String>(tags.length);
        for (String tag : tags) {
            String t = tag.trim();
            String v = this.taggedValues.get(t);
            if (v == null) continue;
            res.put(t, v);
        }
        return res;
    }

    @Override
    public String targetNamespace() {
        if (this.targetNamespace != null) {
            return this.targetNamespace;
        }
        return this.owner().targetNamespace();
    }

    @Override
    public String version() {
        if (this.version != null) {
            return this.version;
        }
        return this.owner().version();
    }

    @Override
    public String xmlns() {
        if (this.xmlns != null) {
            return this.xmlns;
        }
        return this.owner().xmlns();
    }

    @Override
    public String xsdDocument() {
        return this.xsdDocument;
    }

    public String toString(String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(indent + this.name + "\n");
        if (this.classes != null && this.classes.size() != 0) {
            sb.append(indent + "classes:\n");
            for (ClassInfo ci : this.classes) {
                sb.append(indent + indent + ci.name() + "\n");
            }
        } else {
            sb.append(indent + "<no classes>\n");
        }
        if (this.childPi != null && this.childPi.size() > 0) {
            sb.append(indent + "packages:\n");
            for (PackageInfo pi : this.childPi) {
                if (pi instanceof GenericPackageInfo) {
                    sb.append(((GenericPackageInfo)pi).toString(indent + indent));
                    continue;
                }
                sb.append(indent + indent + pi.name() + "(not a GenericPackageInfo\n");
            }
        } else {
            sb.append(indent + "<no child packages>\n");
        }
        return sb.toString();
    }

    public void addClass(ClassInfo ci) {
        if (ci != null) {
            this.classes.add(ci);
        }
    }

    public void remove(ClassInfo ciToRemove) {
        if (ciToRemove != null) {
            this.classes.remove(ciToRemove);
        }
    }
}

