/*
 * Decompiled with CFR 0.152.
 */
package de.interactive_instruments.ShapeChange;

import de.interactive_instruments.ShapeChange.AssociationInfo;
import de.interactive_instruments.ShapeChange.AssociationInfoXmi10;
import de.interactive_instruments.ShapeChange.ClassInfo;
import de.interactive_instruments.ShapeChange.ClassInfoXmi10;
import de.interactive_instruments.ShapeChange.Model;
import de.interactive_instruments.ShapeChange.Multiplicity;
import de.interactive_instruments.ShapeChange.Options;
import de.interactive_instruments.ShapeChange.PackageInfo;
import de.interactive_instruments.ShapeChange.PackageInfoXmi10;
import de.interactive_instruments.ShapeChange.PropertyInfo;
import de.interactive_instruments.ShapeChange.ShapeChangeAbortException;
import de.interactive_instruments.ShapeChange.ShapeChangeIgnoreClassException;
import de.interactive_instruments.ShapeChange.ShapeChangeResult;
import de.interactive_instruments.ShapeChange.XmlDocument;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Xmi10Document
extends XmlDocument
implements Model {
    public Options options = null;
    protected HashMap<String, String> fTaggedValues = new HashMap();
    protected HashMap<String, String> fStereotypes = new HashMap();
    protected HashMap<String, HashSet<String>> fSupertypes = new HashMap();
    protected HashMap<String, HashSet<String>> fSubtypes = new HashMap();
    protected HashMap<String, Element> fTypes = new HashMap();
    protected HashMap<String, Element> fSchemas = new HashMap();
    protected HashMap<String, AssociationInfo> fAssociations = new HashMap();
    protected HashMap<String, Vector<PropertyInfo>> fRoles = new HashMap();
    protected HashMap<String, PackageInfo> fPackages = new HashMap();
    protected HashMap<String, ClassInfo> fClasses = new HashMap();
    protected HashMap<String, ClassInfo> fClassnames = new HashMap();
    protected HashMap<String, Multiplicity> fClassesRoseHiddenCardinality = new HashMap();
    protected HashMap<String, String> fClassesRoseHiddenLabels = new HashMap();
    protected HashMap<String, UUID> fUUIDs = new HashMap();
    protected int globalSequenceNumber = -2147483647;

    public Xmi10Document(ShapeChangeResult r, Options o, String xmifile) throws ShapeChangeAbortException {
        super(r, xmifile);
        this.options = o;
        this.verify();
        this.cleanupDOM();
        this.initTaggedValuesMap();
        this.initStereotypesMap();
        this.initSubSupertypesMap();
        this.initTypesMap();
        this.initAssociations();
        this.initPackages();
        this.initClasses();
        HashSet<PackageInfo> schemas = this.schemas("");
        for (PackageInfo pi : schemas) {
            this.options.addSchemaLocation(pi.targetNamespace(), pi.xsdDocument());
        }
    }

    protected void verify() throws ShapeChangeAbortException {
        String s;
        Element e;
        NodeList nl = this.document.getElementsByTagName("XMI");
        if (nl.getLength() == 1) {
            e = (Element)nl.item(0);
            s = e.getAttribute("xmi.version");
            if (!s.equals("1.0")) {
                this.result.addFatalError(4, s);
                throw new ShapeChangeAbortException();
            }
        } else {
            this.result.addFatalError(5);
            throw new ShapeChangeAbortException();
        }
        nl = this.document.getElementsByTagName("XMI.metamodel");
        if (nl.getLength() == 1) {
            e = (Element)nl.item(0);
            s = e.getAttribute("xmi.name");
            if (!s.equals("UML")) {
                this.result.addFatalError(6, s);
                throw new ShapeChangeAbortException();
            }
            s = e.getAttribute("xmi.version");
            if (s.equals("1.4")) {
                this.result.addWarning(1000);
            } else if (!s.equals("1.3")) {
                this.result.addFatalError(7, s);
                throw new ShapeChangeAbortException();
            }
        } else {
            this.result.addFatalError(8);
            throw new ShapeChangeAbortException();
        }
    }

    protected void cleanupDOM() {
        if (this.options.eaIncludeExtentsions) {
            return;
        }
        try {
            Node p;
            Node n;
            NodeList elements = this.document.getElementsByTagName("XMI.extensions");
            int j = 0;
            while (j < elements.getLength()) {
                n = elements.item(j);
                p = n.getParentNode();
                n = p.removeChild(n);
                ++j;
            }
            elements = this.document.getElementsByTagName("XMI.difference");
            j = 0;
            while (j < elements.getLength()) {
                n = elements.item(j);
                p = n.getParentNode();
                n = p.removeChild(n);
                ++j;
            }
            this.document.normalize();
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m != null) {
                this.result.addError(m);
            }
            e.printStackTrace(System.err);
        }
    }

    protected String idrefValue(Node n) {
        NodeList nl = n.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n2 = nl.item(i);
            if (n2.getNodeType() == 1) {
                return ((Element)n2).getAttribute("xmi.idref");
            }
            ++i;
        }
        return "";
    }

    protected Element getElementById(String id) {
        return this.document.getElementById(id);
    }

    protected String idOfProperty(Element elmt, String child) {
        NodeList nl1 = elmt.getChildNodes();
        int j = 0;
        while (j < nl1.getLength()) {
            Node n2;
            Node n1 = nl1.item(j);
            if (n1.getNodeType() == 1 && n1.getNodeName().equals(child) && (n2 = n1.getFirstChild()) != null && n2.getNodeType() == 1) {
                String id = ((Element)n2).getAttribute("xmi.id");
                if (id.equals("")) {
                    id = ((Element)n2).getAttribute("xmi.idref");
                }
                return id;
            }
            ++j;
        }
        return "";
    }

    protected Element elementOfProperty(Element elmt, String child) {
        NodeList nl1 = elmt.getChildNodes();
        int j = 0;
        while (j < nl1.getLength()) {
            Node n2;
            Node n1 = nl1.item(j);
            if (n1.getNodeType() == 1 && n1.getNodeName().equals(child) && (n2 = n1.getFirstChild()) != null && n2.getNodeType() == 1) {
                String id = ((Element)n2).getAttribute("xmi.idref");
                if (id.equals("")) {
                    return (Element)n2;
                }
                return this.document.getElementById(id);
            }
            ++j;
        }
        return null;
    }

    protected Vector<String> idsOfProperty(Element elmt, String child) {
        Vector<String> ids = new Vector<String>();
        NodeList nl1 = elmt.getChildNodes();
        int j = 0;
        while (j < nl1.getLength()) {
            Node n1 = nl1.item(j);
            if (n1.getNodeType() == 1) {
                Node n2;
                String name1 = n1.getNodeName();
                if (name1.equals(child)) {
                    NodeList nl2 = n1.getChildNodes();
                    int k = 0;
                    while (k < nl2.getLength()) {
                        Node n22 = nl2.item(k);
                        if (n22.getNodeType() == 1) {
                            String id = ((Element)n22).getAttribute("xmi.id");
                            if (id.equals("")) {
                                id = ((Element)n22).getAttribute("xmi.idref");
                            }
                            ids.add(id);
                        }
                        ++k;
                    }
                } else if (name1.equals("Foundation.Core.Namespace.ownedElement") && (n2 = n1.getFirstChild()) != null) {
                    String name2 = n2.getNodeName();
                    if (name2.equals("Foundation.Core.Primitive")) {
                        ids.addAll(this.idsOfProperty((Element)n2, child));
                    }
                    if (name2.equals("Foundation.Core.Enumeration")) {
                        ids.addAll(this.idsOfProperty((Element)n2, child));
                    }
                }
            }
            ++j;
        }
        return ids;
    }

    protected String textOfProperty(Element e, String property) {
        NodeList nl = e.getChildNodes();
        int j = 0;
        while (j < nl.getLength()) {
            Node n1 = nl.item(j);
            if (n1.getNodeType() == 1) {
                String nam = n1.getNodeName();
                if (nam.equals(property)) {
                    return this.textValue(n1);
                }
                if (nam.equals("Foundation.Core.Namespace.ownedElement")) {
                    Node n2 = n1.getFirstChild();
                    nam = n2.getNodeName();
                    if (nam.equals("Foundation.Core.Primitive")) {
                        return this.textOfProperty((Element)n2, property);
                    }
                    if (nam.equals("Foundation.Core.Enumeration")) {
                        return this.textOfProperty((Element)n2, property);
                    }
                }
            }
            ++j;
        }
        return null;
    }

    protected String attributeOfProperty(Element elmt, String child, String att) {
        NodeList nl1 = elmt.getChildNodes();
        int j = 0;
        while (j < nl1.getLength()) {
            Node n1 = nl1.item(j);
            if (n1.getNodeType() == 1) {
                String name1 = n1.getNodeName();
                if (name1.equals(child)) {
                    return ((Element)n1).getAttribute(att);
                }
                if (name1.equals("Foundation.Core.Namespace.ownedElement")) {
                    Node n2 = n1.getFirstChild();
                    String name2 = n2.getNodeName();
                    if (name2.equals("Foundation.Core.Primitive")) {
                        return this.attributeOfProperty((Element)n2, child, att);
                    }
                    if (name2.equals("Foundation.Core.Enumeration")) {
                        return this.attributeOfProperty((Element)n2, child, att);
                    }
                }
            }
            ++j;
        }
        return "";
    }

    protected Element firstChildElement(Element elmt) {
        NodeList nl1 = elmt.getChildNodes();
        int j = 0;
        while (j < nl1.getLength()) {
            Node n1 = nl1.item(j);
            if (n1.getNodeType() == 1) {
                return (Element)n1;
            }
            ++j;
        }
        return null;
    }

    protected boolean visible(Element e) {
        if (e == null) {
            return false;
        }
        if (this.options.publicOnly && !"public".equals(this.attributeOfProperty(e, "Foundation.Core.ModelElement.visibility", "xmi.value")) && !"".equals(this.attributeOfProperty(e, "Foundation.Core.ModelElement.visibility", "xmi.value"))) {
            return false;
        }
        String stereotype = this.fStereotypes.get(e.getAttribute("xmi.id"));
        return stereotype == null || !stereotype.equals("_ShapeChangeIgnore_");
    }

    @Override
    public String taggedValue(String idref, String tag) {
        String key = String.valueOf(tag) + "###" + idref;
        String res = this.fTaggedValues.get(key);
        if (this.options.eaBugFixWrongID && res == null) {
            if (idref.startsWith("EAID")) {
                res = this.fTaggedValues.get(String.valueOf(tag) + "###EAPK" + idref.substring(4));
            } else if (idref.startsWith("EAPK")) {
                res = this.fTaggedValues.get(String.valueOf(tag) + "###EAID" + idref.substring(4));
            }
        }
        return res;
    }

    protected Vector<String> getOwnerId(Element e) {
        Element owner = (Element)e.getParentNode().getParentNode();
        String id = owner.getAttribute("xmi.id");
        Vector<String> v = new Vector<String>();
        if (id != null) {
            v.add(id);
        }
        return v;
    }

    protected String getOwnerIdAsString(Element e) {
        Element owner = (Element)e.getParentNode().getParentNode();
        String id = owner.getAttribute("xmi.id");
        if (id == null) {
            id = "";
        }
        return id;
    }

    protected boolean notAReference(Element e) {
        return !e.getAttribute("xmi.id").equals("");
    }

    protected boolean isOwnerOfEnumeration(Element elmt) {
        Node n2;
        String name2;
        Node n1 = elmt.getFirstChild();
        String name1 = n1.getNodeName();
        return name1.equals("Foundation.Core.Namespace.ownedElement") && (name2 = (n2 = n1.getFirstChild()).getNodeName()).equals("Foundation.Core.Enumeration");
    }

    protected void initTaggedValuesMap() {
        String[] gmlTags = new String[]{"targetNamespace", "xmlns", "version", "xsdDocument", "gmlProfileSchema", "sequenceNumber", "noPropertyType", "byValuePropertyType", "isCollection", "asDictionary", "inlineOrByReference", "isMetadata", "defaultCodeSpace", "xmlSchemaType", "documentation"};
        String[] shapeChangeTags = new String[]{"xsdEncodingRule", "xsdAsAttribute", "xsdDerivation", "gmlAsGroup", "length", "base", "rangeMinimum", "rangeMaximum", "default", "nilReasonAllowed", "gmlImplementedByNilReason", "noGMLType", "primaryCode", "secondaryCode", "oclExpressions", "schPatterns", "unitMeasure"};
        String[] otherTags = this.options.representTaggedValues.split("\\,");
        NodeList nl1 = this.document.getElementsByTagName("Foundation.Extension_Mechanisms.TaggedValue");
        int j = 0;
        while (j < nl1.getLength()) {
            Node n1 = nl1.item(j);
            NodeList nl2 = n1.getChildNodes();
            String tag = "";
            String value = "";
            String id = "";
            int k = 0;
            while (k < nl2.getLength()) {
                Node n2 = nl2.item(k);
                if (n2.getNodeName() == "Foundation.Extension_Mechanisms.TaggedValue.tag" || n2.getNodeName() == "Foundation.Core.ModelElement.name") {
                    tag = this.textValue(n2);
                }
                if (n2.getNodeName() == "Foundation.Extension_Mechanisms.TaggedValue.value" || n2.getNodeName() == "Foundation.Extension_Mechanisms.TaggedValue.dataValue") {
                    value = this.textValue(n2);
                }
                if (n2.getNodeName() == "Foundation.Extension_Mechanisms.TaggedValue.modelElement") {
                    id = this.idrefValue(n2);
                }
                ++k;
            }
            if (value != null && !value.equals("")) {
                if (id.equals("")) {
                    Element parent = (Element)n1.getParentNode().getParentNode();
                    id = parent.getAttribute("xmi.id");
                }
                if (tag.startsWith("RationalRose$UGAS:")) {
                    tag = tag.substring(18);
                } else if (tag.startsWith("RationalRose$ShapeChange:")) {
                    tag = tag.substring(25);
                } else if (tag.startsWith("RationalRose$")) {
                    tag = tag.substring(13);
                }
                if (tag.equals("xmlNamespace")) {
                    tag = "targetNamespace";
                }
                if (tag.equals("xmlNamespaceAbbreviation")) {
                    tag = "xmlns";
                }
                if (tag.equals("xsdName")) {
                    tag = "xsdDocument";
                }
                if (tag.equals("asGroup")) {
                    tag = "gmlAsGroup";
                }
                if (tag.equals("implementedByNilReason")) {
                    tag = "gmlImplementedByNilReason";
                }
                boolean found = false;
                int i = 0;
                while (i < gmlTags.length) {
                    if (tag.equals(gmlTags[i])) {
                        this.fTaggedValues.put(String.valueOf(tag) + "###" + id, value);
                        this.result.addDebug(10000, tag, id, value);
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    i = 0;
                    while (i < shapeChangeTags.length) {
                        if (tag.equals(shapeChangeTags[i])) {
                            this.fTaggedValues.put(String.valueOf(tag) + "###" + id, value);
                            this.result.addDebug(10000, tag, id, value);
                            found = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (!found) {
                    i = 0;
                    while (i < otherTags.length) {
                        if (tag.equals(otherTags[i].trim())) {
                            this.fTaggedValues.put(String.valueOf(tag) + "###" + id, value);
                            this.result.addDebug(10000, tag, id, value);
                            found = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
            ++j;
        }
    }

    protected void initStereotypesMap() {
        NodeList nl1 = this.document.getElementsByTagName("Foundation.Extension_Mechanisms.Stereotype");
        int j = 0;
        while (j < nl1.getLength()) {
            Element n1 = (Element)nl1.item(j);
            String id2 = n1.getAttribute("xmi.id");
            if (!id2.equals("")) {
                String name = this.textOfProperty(n1, "Foundation.Core.ModelElement.name");
                String baseClass = this.textOfProperty(n1, "Foundation.Extension_Mechanisms.Stereotype.baseClass");
                String s = this.options.stereotypeAlias(name);
                if (s != null) {
                    name = s;
                }
                if (!name.equals("")) {
                    Vector<String> ids;
                    if (baseClass.equals("Class") && (name.toLowerCase().equals("codelist") || name.toLowerCase().equals("enumeration") || name.toLowerCase().equals("datatype") || name.toLowerCase().equals("union") || name.toLowerCase().equals("objecttype") || name.toLowerCase().equals("featuretype") || name.toLowerCase().equals("type") || name.toLowerCase().equals("basictype") || name.toLowerCase().equals("interface")) || baseClass.equals("Association") && name.toLowerCase().equals("disjoint")) {
                        ids = this.idsOfProperty(n1, "Foundation.Extension_Mechanisms.Stereotype.extendedElement");
                        if (ids.size() == 0) {
                            ids = this.getOwnerId(n1);
                        }
                        Iterator<String> i = ids.iterator();
                        while (i.hasNext()) {
                            this.fStereotypes.put(i.next(), name);
                        }
                    } else if ((baseClass.equals("Package") || baseClass.equals("ClassifierRole")) && name.equals("Application Schema")) {
                        ids = this.idsOfProperty(n1, "Foundation.Extension_Mechanisms.Stereotype.extendedElement");
                        if (ids.size() == 0) {
                            ids = this.getOwnerId(n1);
                        }
                        for (String eid : ids) {
                            this.result.addDebug("  ID: " + eid);
                            Element e1 = this.document.getElementById(eid);
                            if (e1 == null) continue;
                            String ename = this.textOfProperty(e1, "Foundation.Core.ModelElement.name");
                            this.result.addDebug("  Package name: " + ename);
                            this.fSchemas.put(ename, e1);
                        }
                    } else if (!(baseClass.equals("Class") && (name.toLowerCase().equals("abstract") || name.toLowerCase().equals("leaf")) || (baseClass.equals("Package") || baseClass.equals("ClassifierRole")) && (name.toLowerCase().equals("application schema") || name.toLowerCase().equals("leaf")) || baseClass.equals("Dependency") && (name.equals("import") || name.equals("include")) || baseClass.toLowerCase().equals("generalization") && name.equals("disjoint"))) {
                        this.result.addWarning("Stereotype <<" + name + ">> not supported for UML model elements of type " + baseClass + ".");
                        ids = this.idsOfProperty(n1, "Foundation.Extension_Mechanisms.Stereotype.extendedElement");
                        for (String id2 : ids) {
                            this.fStereotypes.put(id2, "_ShapeChangeIgnore_");
                            Element e1 = this.document.getElementById(id2);
                            name = e1 != null ? this.textOfProperty(e1, "Foundation.Core.ModelElement.name") : "";
                            if (name == null || name.equals("")) {
                                name = "(unknown)";
                            }
                            this.result.addWarning("The " + baseClass + " '" + name + "' will be ignored.");
                        }
                    }
                }
            }
            ++j;
        }
    }

    protected void initSubSupertypesMap() {
        NodeList nl1 = this.document.getElementsByTagName("Foundation.Core.Generalization");
        int j = 0;
        while (j < nl1.getLength()) {
            Element n1 = (Element)nl1.item(j);
            String id = n1.getAttribute("xmi.id");
            if (this.visible(n1)) {
                String disc = this.textOfProperty(n1, "Foundation.Core.Generalization.discriminator");
                if (disc != null && !disc.equals("")) {
                    this.result.addWarning("The discriminator for the UML generalization with ID " + id + " is not blank. This genralization is ignored.");
                } else {
                    Vector<String> childs = this.idsOfProperty(n1, "Foundation.Core.Generalization.child");
                    Vector<String> parents = this.idsOfProperty(n1, "Foundation.Core.Generalization.parent");
                    Iterator<String> idx = childs.iterator();
                    while (idx.hasNext()) {
                        Iterator<String> jdx = parents.iterator();
                        while (jdx.hasNext()) {
                            String child = idx.next();
                            String parent = jdx.next();
                            if (this.fSubtypes.containsKey(parent)) {
                                ((Set)this.fSubtypes.get(parent)).add(child);
                            } else {
                                HashSet<String> s2 = new HashSet<String>();
                                s2.add(child);
                                this.fSubtypes.put(parent, s2);
                            }
                            if (this.fSupertypes.containsKey(child)) {
                                ((Set)this.fSupertypes.get(child)).add(parent);
                                continue;
                            }
                            HashSet<String> s1 = new HashSet<String>();
                            s1.add(parent);
                            this.fSupertypes.put(child, s1);
                        }
                    }
                }
            }
            ++j;
        }
    }

    protected void initTypesMap() throws ShapeChangeAbortException {
        String tname;
        Element e;
        NodeList nl = this.document.getElementsByTagName("Foundation.Core.DataType");
        int j = 0;
        while (j < nl.getLength()) {
            e = (Element)nl.item(j);
            tname = this.textOfProperty(e, "Foundation.Core.ModelElement.name");
            if (tname != null) {
                this.fTypes.put(tname.trim(), e);
            }
            ++j;
        }
        nl = this.document.getElementsByTagName("Foundation.Core.Class");
        j = 0;
        while (j < nl.getLength()) {
            e = (Element)nl.item(j);
            tname = this.textOfProperty(e, "Foundation.Core.ModelElement.name");
            if (tname != null) {
                this.fTypes.put(tname.trim(), e);
            }
            ++j;
        }
    }

    protected void initAssociations() throws ShapeChangeAbortException {
        NodeList nl1 = this.document.getElementsByTagName("Foundation.Core.Association");
        int j = 0;
        while (j < nl1.getLength()) {
            AssociationInfoXmi10 ai = new AssociationInfoXmi10(this, (Element)nl1.item(j));
            if (ai != null) {
                this.fAssociations.put(ai.id(), ai);
            }
            ++j;
        }
    }

    private void addPackageElements(NodeList nl) throws ShapeChangeAbortException {
        int j = 0;
        while (j < nl.getLength()) {
            Element e = (Element)nl.item(j);
            if ((this.visible(e) || this.options.eaBugFixPublicPackagesAreMarkedAsPrivate) && this.notAReference(e)) {
                PackageInfoXmi10 pi = new PackageInfoXmi10(this, e);
                this.fPackages.put(pi.id(), pi);
            }
            ++j;
        }
    }

    protected void initPackages() throws ShapeChangeAbortException {
        Element root = this.document.getDocumentElement();
        this.addPackageElements(root.getElementsByTagName("Model_Management.Model"));
        this.addPackageElements(root.getElementsByTagName("Model_Management.Package"));
    }

    private void addClassElements(NodeList nl) throws ShapeChangeAbortException {
        int j = 0;
        while (j < nl.getLength()) {
            Element e = (Element)nl.item(j);
            if (this.visible(e) && this.notAReference(e)) {
                try {
                    String rl;
                    ClassInfoXmi10 ci = new ClassInfoXmi10(this, e);
                    this.fClasses.put(ci.id(), ci);
                    Multiplicity rm = ci.roseHiddenCardinality();
                    if (rm != null) {
                        this.fClassesRoseHiddenCardinality.put(ci.id(), rm);
                        this.result.addDebug(" Name: " + ci.name() + ", ID: " + ci.id() + ", hidden cardinality: " + Integer.valueOf(rm.minOccurs).toString() + ".." + Integer.valueOf(rm.maxOccurs).toString());
                    }
                    if ((rl = ci.roseHiddenLabels()) != null) {
                        this.fClassesRoseHiddenLabels.put(ci.id(), rl);
                        this.result.addDebug(" Name: " + ci.name() + ", ID: " + ci.id() + ", hidden labels: " + rl);
                    }
                    if (this.options.roseBugFixDuplicateGlobalDataTypes) {
                        ClassInfo ci2 = this.fClassnames.get(ci.name());
                        if (ci2 != null) {
                            if (ci.id().startsWith("G.")) {
                                this.fClasses.put(ci.id(), ci2);
                                this.result.addDebug("Rose Bug Fix for Duplicate Global Data Types: DataType '" + ci.name() + "' with ID '" + ci.id() + "' replaced by class '" + ci2.name() + "' with ID '" + ci2.id() + "'");
                            }
                            if (ci2.id().startsWith("G.")) {
                                this.fClasses.put(ci2.id(), ci);
                                this.fClassnames.put(ci.name(), ci);
                                this.result.addDebug("Rose Bug Fix for Duplicate Global Data Types: DataType '" + ci2.name() + "' with ID '" + ci2.id() + "' replaced by class '" + ci.name() + "' with ID '" + ci.id() + "'");
                            }
                        } else {
                            this.fClassnames.put(ci.name(), ci);
                        }
                    }
                }
                catch (ShapeChangeIgnoreClassException shapeChangeIgnoreClassException) {
                    // empty catch block
                }
            }
            ++j;
        }
    }

    protected void initClasses() throws ShapeChangeAbortException {
        this.result.addDebug("Processing Classes...");
        Element root = this.document.getDocumentElement();
        this.addClassElements(root.getElementsByTagName("Foundation.Core.Class"));
        this.addClassElements(root.getElementsByTagName("Foundation.Core.Interface"));
        this.addClassElements(root.getElementsByTagName("Foundation.Core.DataType"));
        this.result.addDebug("Fixing Unknowns...");
        for (ClassInfo ci : this.classes(null)) {
            ci.fixIfCategoryIsUnknown();
        }
        this.result.addDebug("Identifying Restrictions...");
        for (ClassInfo ci : this.classes(null)) {
            ((ClassInfoXmi10)ci).identifyRestrictions();
        }
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public HashSet<PackageInfo> schemas(String name) {
        HashSet<PackageInfo> res = new HashSet<PackageInfo>();
        for (PackageInfo pi : this.fPackages.values()) {
            if (!pi.isSchema()) continue;
            if (name != null && !name.equals("")) {
                if (!pi.name().equals(name)) continue;
                res.add(this.fPackages.get(pi.id()));
                continue;
            }
            res.add(this.fPackages.get(pi.id()));
        }
        return res;
    }

    @Override
    public void validate() {
    }

    @Override
    public PackageInfo packageById(String id) {
        return this.fPackages.get(id);
    }

    @Override
    public ClassInfo classById(String id) {
        return this.fClasses.get(id);
    }

    @Override
    public ClassInfo classByName(String nam) {
        return this.fClassnames.get(nam);
    }

    @Override
    public HashSet<ClassInfo> classes(PackageInfo pi) {
        HashSet<ClassInfo> res = new HashSet<ClassInfo>();
        for (Map.Entry<String, ClassInfo> entry : this.fClasses.entrySet()) {
            ClassInfo ci;
            String ky;
            if (this.options.roseBugFixDuplicateGlobalDataTypes && (ky = entry.getKey()).startsWith("G.") || (ci = entry.getValue()) == null) continue;
            if (pi == null) {
                res.add(ci);
                continue;
            }
            if (!ci.inSchema(pi)) continue;
            res.add(ci);
        }
        return res;
    }

    protected Multiplicity cardinalityFromString(String multiplicityRanges) {
        String[] ranges = multiplicityRanges.split(",");
        int minv = Integer.MAX_VALUE;
        int maxv = Integer.MIN_VALUE;
        int i = 0;
        while (i < ranges.length) {
            int upper;
            int lower;
            if (ranges[i].indexOf("..") > 0) {
                String[] minmax = ranges[i].split("\\.\\.", 2);
                lower = Integer.parseInt(minmax[0]);
                if (minmax[1].equals("*") || minmax[1].equals("n") || minmax[1].length() == 0) {
                    upper = Integer.MAX_VALUE;
                } else {
                    try {
                        upper = Integer.parseInt(minmax[1]);
                    }
                    catch (NumberFormatException e) {
                        this.result.addWarning("The multiplicity value of '" + minmax[1] + "' is neither a number nor a known string. '*' is used instead.");
                        upper = Integer.MAX_VALUE;
                    }
                }
            } else if (ranges[i].length() == 0 || ranges[i].equals("*") || ranges[i].equals("n")) {
                lower = 0;
                upper = Integer.MAX_VALUE;
            } else {
                try {
                    upper = lower = Integer.parseInt(ranges[i]);
                }
                catch (NumberFormatException e) {
                    this.result.addWarning("The multiplicity value of '" + ranges[i] + "' is neither a number nor a known string. '*' is used instead.");
                    lower = 0;
                    upper = Integer.MAX_VALUE;
                }
            }
            if (lower < minv && lower >= 0) {
                minv = lower;
            }
            if (upper < 0) {
                maxv = Integer.MAX_VALUE;
            }
            if (upper > maxv) {
                maxv = upper;
            }
            ++i;
        }
        Multiplicity m = new Multiplicity();
        m.minOccurs = minv;
        m.maxOccurs = maxv;
        return m;
    }
}

